/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import dalvik.annotation.optimization.FastNative;
import dalvik.system.VMStack;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import libcore.util.EmptyArray;
import sun.nio.ch.Interruptible;
import sun.reflect.CallerSensitive;

public class Thread
implements Runnable {
    private final Object lock = new Object();
    private volatile long nativePeer;
    boolean started = false;
    private volatile String name;
    private int priority;
    private Thread threadQ;
    private long eetop;
    private boolean single_step;
    private boolean daemon = false;
    private boolean stillborn = false;
    private Runnable target;
    private ThreadGroup group;
    private ClassLoader contextClassLoader;
    private AccessControlContext inheritedAccessControlContext;
    private static int threadInitNumber;
    ThreadLocal.ThreadLocalMap threadLocals = null;
    ThreadLocal.ThreadLocalMap inheritableThreadLocals = null;
    private long stackSize;
    private long nativeParkEventPointer;
    private boolean unparkedBeforeStart;
    private long tid;
    private static long threadSeqNumber;
    private boolean systemDaemon = false;
    private volatile int threadStatus = 0;
    volatile Object parkBlocker;
    private volatile Interruptible blocker;
    private final Object blockerLock = new Object();
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static final StackTraceElement[] EMPTY_STACK_TRACE;
    private static final RuntimePermission SUBCLASS_IMPLEMENTATION_PERMISSION;
    private volatile UncaughtExceptionHandler uncaughtExceptionHandler;
    private static volatile UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    private static volatile UncaughtExceptionHandler uncaughtExceptionPreHandler;
    long threadLocalRandomSeed;
    int threadLocalRandomProbe;
    int threadLocalRandomSecondarySeed;
    private static final int NANOS_PER_MILLI = 1000000;
    private int parkState = 1;

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    private static synchronized long nextThreadID() {
        return ++threadSeqNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockedOn(Interruptible b) {
        Object object = this.blockerLock;
        synchronized (object) {
            this.blocker = b;
        }
    }

    @FastNative
    public static native Thread currentThread();

    public static native void yield();

    public static void sleep(long millis) throws InterruptedException {
        Thread.sleep(millis, 0);
    }

    @FastNative
    private static native void sleep(Object var0, long var1, int var3) throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(long millis, int nanos) throws InterruptedException {
        Object lock;
        if (millis < 0L) {
            throw new IllegalArgumentException("millis < 0: " + millis);
        }
        if (nanos < 0) {
            throw new IllegalArgumentException("nanos < 0: " + nanos);
        }
        if (nanos > 999999) {
            throw new IllegalArgumentException("nanos > 999999: " + nanos);
        }
        if (millis == 0L && nanos == 0) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            return;
        }
        long start = System.nanoTime();
        long duration = millis * 1000000L + (long)nanos;
        Object object = lock = Thread.currentThread().lock;
        synchronized (object) {
            while (true) {
                Thread.sleep(lock, millis, nanos);
                long now = System.nanoTime();
                long elapsed = now - start;
                if (elapsed >= duration) break;
                start = now;
                millis = (duration -= elapsed) / 1000000L;
                nanos = (int)(duration % 1000000L);
            }
        }
    }

    private void init(ThreadGroup g, Runnable target, String name, long stackSize) {
        Thread parent = Thread.currentThread();
        if (g == null) {
            g = parent.getThreadGroup();
        }
        g.addUnstarted();
        this.group = g;
        this.target = target;
        this.priority = parent.getPriority();
        this.daemon = parent.isDaemon();
        this.setName(name);
        this.init2(parent);
        this.stackSize = stackSize;
        this.tid = Thread.nextThreadID();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public Thread() {
        this.init(null, null, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(Runnable target) {
        this.init(null, target, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(ThreadGroup group, Runnable target) {
        this.init(group, target, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(String name) {
        this.init(null, null, name, 0L);
    }

    public Thread(ThreadGroup group, String name) {
        this.init(group, null, name, 0L);
    }

    Thread(ThreadGroup group, String name, int priority, boolean daemon) {
        this.group = group;
        this.group.addUnstarted();
        if (name == null) {
            name = "Thread-" + Thread.nextThreadNum();
        }
        this.name = name;
        this.priority = priority;
        this.daemon = daemon;
        this.init2(Thread.currentThread());
        this.tid = Thread.nextThreadID();
    }

    private void init2(Thread parent) {
        this.contextClassLoader = parent.getContextClassLoader();
        this.inheritedAccessControlContext = AccessController.getContext();
        if (parent.inheritableThreadLocals != null) {
            this.inheritableThreadLocals = ThreadLocal.createInheritedMap(parent.inheritableThreadLocals);
        }
    }

    public Thread(Runnable target, String name) {
        this.init(null, target, name, 0L);
    }

    public Thread(ThreadGroup group, Runnable target, String name) {
        this.init(group, target, name, 0L);
    }

    public Thread(ThreadGroup group, Runnable target, String name, long stackSize) {
        this.init(group, target, name, stackSize);
    }

    public synchronized void start() {
        if (this.threadStatus != 0 || this.started) {
            throw new IllegalThreadStateException();
        }
        this.group.add(this);
        this.started = false;
        try {
            Thread.nativeCreate(this, this.stackSize, this.daemon);
            this.started = true;
        }
        finally {
            try {
                if (!this.started) {
                    this.group.threadStartFailed(this);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private static native void nativeCreate(Thread var0, long var1, boolean var3);

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    private void exit() {
        if (this.group != null) {
            this.group.threadTerminated(this);
            this.group = null;
        }
        this.target = null;
        this.threadLocals = null;
        this.inheritableThreadLocals = null;
        this.inheritedAccessControlContext = null;
        this.blocker = null;
        this.uncaughtExceptionHandler = null;
    }

    @Deprecated
    public final void stop() {
        this.stop(new ThreadDeath());
    }

    @Deprecated
    public final void stop(Throwable obj) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        if (this != Thread.currentThread()) {
            this.checkAccess();
        }
        Object object = this.blockerLock;
        synchronized (object) {
            Interruptible b = this.blocker;
            if (b != null) {
                this.interrupt0();
                b.interrupt(this);
                return;
            }
        }
        this.interrupt0();
    }

    @FastNative
    public static native boolean interrupted();

    @FastNative
    public native boolean isInterrupted();

    @Deprecated
    public void destroy() {
        throw new UnsupportedOperationException();
    }

    public final boolean isAlive() {
        return this.nativePeer != 0L;
    }

    @Deprecated
    public final void suspend() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void resume() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPriority(int newPriority) {
        this.checkAccess();
        if (newPriority > 10 || newPriority < 1) {
            throw new IllegalArgumentException("Priority out of range: " + newPriority);
        }
        ThreadGroup g = this.getThreadGroup();
        if (g != null) {
            if (newPriority > g.getMaxPriority()) {
                newPriority = g.getMaxPriority();
            }
            Thread thread = this;
            synchronized (thread) {
                this.priority = newPriority;
                if (this.isAlive()) {
                    this.setPriority0(newPriority);
                }
            }
        }
    }

    public final int getPriority() {
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setName(String name) {
        this.checkAccess();
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        Thread thread = this;
        synchronized (thread) {
            this.name = name;
            if (this.isAlive()) {
                this.setNativeName(name);
            }
        }
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getThreadGroup() {
        if (this.getState() == State.TERMINATED) {
            return null;
        }
        return this.group;
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public static int enumerate(Thread[] tarray) {
        return Thread.currentThread().getThreadGroup().enumerate(tarray);
    }

    @Deprecated
    public int countStackFrames() {
        return this.getStackTrace().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void join(long millis) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            long base = System.currentTimeMillis();
            long now = 0L;
            if (millis < 0L) {
                throw new IllegalArgumentException("timeout value is negative");
            }
            if (millis == 0L) {
                while (this.isAlive()) {
                    this.lock.wait(0L);
                }
            } else {
                long delay;
                while (this.isAlive() && (delay = millis - now) > 0L) {
                    this.lock.wait(delay);
                    now = System.currentTimeMillis() - base;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void join(long millis, int nanos) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (millis < 0L) {
                throw new IllegalArgumentException("timeout value is negative");
            }
            if (nanos < 0 || nanos > 999999) {
                throw new IllegalArgumentException("nanosecond timeout value out of range");
            }
            if (nanos >= 500000 || nanos != 0 && millis == 0L) {
                ++millis;
            }
            this.join(millis);
        }
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    public final void setDaemon(boolean on) {
        this.checkAccess();
        if (this.isAlive()) {
            throw new IllegalThreadStateException();
        }
        this.daemon = on;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public final void checkAccess() {
    }

    public String toString() {
        ThreadGroup group = this.getThreadGroup();
        if (group != null) {
            return "Thread[" + this.getName() + "," + this.getPriority() + "," + group.getName() + "]";
        }
        return "Thread[" + this.getName() + "," + this.getPriority() + ",]";
    }

    @CallerSensitive
    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public void setContextClassLoader(ClassLoader cl) {
        this.contextClassLoader = cl;
    }

    public static native boolean holdsLock(Object var0);

    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] ste = VMStack.getThreadStackTrace(this);
        return ste != null ? ste : EmptyArray.STACK_TRACE_ELEMENT;
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        HashMap<Thread, StackTraceElement[]> map = new HashMap<Thread, StackTraceElement[]>();
        int count = ThreadGroup.systemThreadGroup.activeCount();
        Thread[] threads = new Thread[count + count / 2];
        count = ThreadGroup.systemThreadGroup.enumerate(threads);
        for (int i = 0; i < count; ++i) {
            map.put(threads[i], threads[i].getStackTrace());
        }
        return map;
    }

    private static boolean isCCLOverridden(Class<?> cl) {
        if (cl == Thread.class) {
            return false;
        }
        Thread.processQueue(Caches.subclassAuditsQueue, Caches.subclassAudits);
        WeakClassKey key = new WeakClassKey(cl, Caches.subclassAuditsQueue);
        Boolean result = (Boolean)Caches.subclassAudits.get(key);
        if (result == null) {
            result = Thread.auditSubclass(cl);
            Caches.subclassAudits.putIfAbsent(key, result);
        }
        return result;
    }

    private static boolean auditSubclass(final Class<?> subcl) {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                for (Class cl = subcl; cl != Thread.class; cl = cl.getSuperclass()) {
                    try {
                        cl.getDeclaredMethod("getContextClassLoader", new Class[0]);
                        return Boolean.TRUE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            Class[] params = new Class[]{ClassLoader.class};
                            cl.getDeclaredMethod("setContextClassLoader", params);
                            return Boolean.TRUE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            continue;
                        }
                    }
                }
                return Boolean.FALSE;
            }
        });
        return result;
    }

    public long getId() {
        return this.tid;
    }

    public State getState() {
        return State.values()[this.nativeGetStatus(this.started)];
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler eh) {
        defaultUncaughtExceptionHandler = eh;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultUncaughtExceptionHandler;
    }

    public static void setUncaughtExceptionPreHandler(UncaughtExceptionHandler eh) {
        uncaughtExceptionPreHandler = eh;
    }

    public static UncaughtExceptionHandler getUncaughtExceptionPreHandler() {
        return uncaughtExceptionPreHandler;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler != null ? this.uncaughtExceptionHandler : this.group;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler eh) {
        this.checkAccess();
        this.uncaughtExceptionHandler = eh;
    }

    public final void dispatchUncaughtException(Throwable e) {
        UncaughtExceptionHandler initialUeh = Thread.getUncaughtExceptionPreHandler();
        if (initialUeh != null) {
            try {
                initialUeh.uncaughtException(this, e);
            }
            catch (Error | RuntimeException throwable) {
                // empty catch block
            }
        }
        this.getUncaughtExceptionHandler().uncaughtException(this, e);
    }

    static void processQueue(ReferenceQueue<Class<?>> queue, ConcurrentMap<? extends WeakReference<Class<?>>, ?> map) {
        Reference<Class<?>> ref;
        while ((ref = queue.poll()) != null) {
            map.remove(ref);
        }
    }

    private native int nativeGetStatus(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unpark$() {
        Object object = this.lock;
        synchronized (object) {
            switch (this.parkState) {
                case 2: {
                    break;
                }
                case 1: {
                    this.parkState = 2;
                    break;
                }
                default: {
                    this.parkState = 1;
                    this.lock.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parkFor$(long nanos) {
        Object object = this.lock;
        synchronized (object) {
            switch (this.parkState) {
                case 2: {
                    this.parkState = 1;
                    break;
                }
                case 1: {
                    long millis = nanos / 1000000L;
                    nanos %= 1000000L;
                    this.parkState = 3;
                    try {
                        this.lock.wait(millis, (int)nanos);
                        break;
                    }
                    catch (InterruptedException ex) {
                        this.interrupt();
                        break;
                    }
                    finally {
                        if (this.parkState == 3) {
                            this.parkState = 1;
                        }
                    }
                }
                default: {
                    throw new AssertionError((Object)"Attempt to repark");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parkUntil$(long time) {
        Object object = this.lock;
        synchronized (object) {
            long currentTime = System.currentTimeMillis();
            if (time <= currentTime) {
                this.parkState = 1;
            } else {
                long delayMillis = time - currentTime;
                long maxValue = 9223372036854L;
                if (delayMillis > maxValue) {
                    delayMillis = maxValue;
                }
                this.parkFor$(delayMillis * 1000000L);
            }
        }
    }

    private native void setPriority0(int var1);

    @FastNative
    private native void interrupt0();

    private native void setNativeName(String var1);

    static {
        EMPTY_STACK_TRACE = new StackTraceElement[0];
        SUBCLASS_IMPLEMENTATION_PERMISSION = new RuntimePermission("enableContextClassLoaderOverride");
        defaultUncaughtExceptionHandler = new hacky_uncaught_exception_handler();
    }

    private static class ParkState {
        private static final int UNPARKED = 1;
        private static final int PREEMPTIVELY_UNPARKED = 2;
        private static final int PARKED = 3;

        private ParkState() {
        }
    }

    static class WeakClassKey
    extends WeakReference<Class<?>> {
        private final int hash;

        WeakClassKey(Class<?> cl, ReferenceQueue<Class<?>> refQueue) {
            super(cl, refQueue);
            this.hash = System.identityHashCode(cl);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WeakClassKey) {
                Object referent = this.get();
                return referent != null && referent == ((WeakClassKey)obj).get();
            }
            return false;
        }
    }

    private static class hacky_uncaught_exception_handler
    implements UncaughtExceptionHandler {
        private hacky_uncaught_exception_handler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            System.out.println("hacky_uncaught_exception_handler: Thread: " + t.getName() + ", Exception: ");
            e.printStackTrace();
            System.exit(10);
        }
    }

    @FunctionalInterface
    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }

    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }

    private static class Caches {
        static final ConcurrentMap<WeakClassKey, Boolean> subclassAudits = new ConcurrentHashMap<WeakClassKey, Boolean>();
        static final ReferenceQueue<Class<?>> subclassAuditsQueue = new ReferenceQueue();

        private Caches() {
        }
    }
}

