/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import android.system.ErrnoException;
import android.system.StructPasswd;
import android.system.StructUtsname;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.VMRuntime;
import dalvik.system.VMStack;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import libcore.icu.ICU;
import libcore.io.Libcore;
import libcore.util.TimeZoneDataFiles;
import sun.misc.VM;
import sun.misc.Version;
import sun.reflect.CallerSensitive;

public final class System {
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static final Object LOCK;
    private static boolean runGC;
    private static boolean justRanFinalization;
    private static volatile Console cons;
    private static final int ARRAYCOPY_SHORT_CHAR_ARRAY_THRESHOLD = 32;
    private static final int ARRAYCOPY_SHORT_BYTE_ARRAY_THRESHOLD = 32;
    private static final int ARRAYCOPY_SHORT_SHORT_ARRAY_THRESHOLD = 32;
    private static final int ARRAYCOPY_SHORT_INT_ARRAY_THRESHOLD = 32;
    private static final int ARRAYCOPY_SHORT_LONG_ARRAY_THRESHOLD = 32;
    private static final int ARRAYCOPY_SHORT_FLOAT_ARRAY_THRESHOLD = 32;
    private static final int ARRAYCOPY_SHORT_DOUBLE_ARRAY_THRESHOLD = 32;
    private static final int ARRAYCOPY_SHORT_BOOLEAN_ARRAY_THRESHOLD = 32;
    private static Properties props;
    private static Properties unchangeableProps;
    private static String lineSeparator;

    private System() {
    }

    public static void setIn(InputStream in) {
        System.setIn0(in);
    }

    public static void setOut(PrintStream out) {
        System.setOut0(out);
    }

    public static void setErr(PrintStream err) {
        System.setErr0(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Console console() {
        if (cons != null) return cons;
        Class<System> clazz = System.class;
        synchronized (System.class) {
            if (cons != null) return cons;
            cons = Console.console();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cons;
        }
    }

    public static Channel inheritedChannel() throws IOException {
        return SelectorProvider.provider().inheritedChannel();
    }

    private static native void setIn0(InputStream var0);

    private static native void setOut0(PrintStream var0);

    private static native void setErr0(PrintStream var0);

    public static void setSecurityManager(SecurityManager s) {
        if (s != null) {
            throw new SecurityException();
        }
    }

    public static SecurityManager getSecurityManager() {
        return null;
    }

    public static native long currentTimeMillis();

    public static native long nanoTime();

    @FastNative
    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    public static void arraycopy(char[] src, int srcPos, char[] dst, int dstPos, int length) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        if (dst == null) {
            throw new NullPointerException("dst == null");
        }
        if (srcPos < 0 || dstPos < 0 || length < 0 || srcPos > src.length - length || dstPos > dst.length - length) {
            throw new ArrayIndexOutOfBoundsException("src.length=" + src.length + " srcPos=" + srcPos + " dst.length=" + dst.length + " dstPos=" + dstPos + " length=" + length);
        }
        if (length <= 32) {
            if (src == dst && srcPos < dstPos && dstPos < srcPos + length) {
                for (int i = length - 1; i >= 0; --i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopyCharUnchecked(src, srcPos, dst, dstPos, length);
        }
    }

    @FastNative
    private static native void arraycopyCharUnchecked(char[] var0, int var1, char[] var2, int var3, int var4);

    public static void arraycopy(byte[] src, int srcPos, byte[] dst, int dstPos, int length) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        if (dst == null) {
            throw new NullPointerException("dst == null");
        }
        if (srcPos < 0 || dstPos < 0 || length < 0 || srcPos > src.length - length || dstPos > dst.length - length) {
            throw new ArrayIndexOutOfBoundsException("src.length=" + src.length + " srcPos=" + srcPos + " dst.length=" + dst.length + " dstPos=" + dstPos + " length=" + length);
        }
        if (length <= 32) {
            if (src == dst && srcPos < dstPos && dstPos < srcPos + length) {
                for (int i = length - 1; i >= 0; --i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopyByteUnchecked(src, srcPos, dst, dstPos, length);
        }
    }

    @FastNative
    private static native void arraycopyByteUnchecked(byte[] var0, int var1, byte[] var2, int var3, int var4);

    public static void arraycopy(short[] src, int srcPos, short[] dst, int dstPos, int length) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        if (dst == null) {
            throw new NullPointerException("dst == null");
        }
        if (srcPos < 0 || dstPos < 0 || length < 0 || srcPos > src.length - length || dstPos > dst.length - length) {
            throw new ArrayIndexOutOfBoundsException("src.length=" + src.length + " srcPos=" + srcPos + " dst.length=" + dst.length + " dstPos=" + dstPos + " length=" + length);
        }
        if (length <= 32) {
            if (src == dst && srcPos < dstPos && dstPos < srcPos + length) {
                for (int i = length - 1; i >= 0; --i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopyShortUnchecked(src, srcPos, dst, dstPos, length);
        }
    }

    @FastNative
    private static native void arraycopyShortUnchecked(short[] var0, int var1, short[] var2, int var3, int var4);

    public static void arraycopy(int[] src, int srcPos, int[] dst, int dstPos, int length) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        if (dst == null) {
            throw new NullPointerException("dst == null");
        }
        if (srcPos < 0 || dstPos < 0 || length < 0 || srcPos > src.length - length || dstPos > dst.length - length) {
            throw new ArrayIndexOutOfBoundsException("src.length=" + src.length + " srcPos=" + srcPos + " dst.length=" + dst.length + " dstPos=" + dstPos + " length=" + length);
        }
        if (length <= 32) {
            if (src == dst && srcPos < dstPos && dstPos < srcPos + length) {
                for (int i = length - 1; i >= 0; --i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopyIntUnchecked(src, srcPos, dst, dstPos, length);
        }
    }

    @FastNative
    private static native void arraycopyIntUnchecked(int[] var0, int var1, int[] var2, int var3, int var4);

    public static void arraycopy(long[] src, int srcPos, long[] dst, int dstPos, int length) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        if (dst == null) {
            throw new NullPointerException("dst == null");
        }
        if (srcPos < 0 || dstPos < 0 || length < 0 || srcPos > src.length - length || dstPos > dst.length - length) {
            throw new ArrayIndexOutOfBoundsException("src.length=" + src.length + " srcPos=" + srcPos + " dst.length=" + dst.length + " dstPos=" + dstPos + " length=" + length);
        }
        if (length <= 32) {
            if (src == dst && srcPos < dstPos && dstPos < srcPos + length) {
                for (int i = length - 1; i >= 0; --i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopyLongUnchecked(src, srcPos, dst, dstPos, length);
        }
    }

    @FastNative
    private static native void arraycopyLongUnchecked(long[] var0, int var1, long[] var2, int var3, int var4);

    public static void arraycopy(float[] src, int srcPos, float[] dst, int dstPos, int length) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        if (dst == null) {
            throw new NullPointerException("dst == null");
        }
        if (srcPos < 0 || dstPos < 0 || length < 0 || srcPos > src.length - length || dstPos > dst.length - length) {
            throw new ArrayIndexOutOfBoundsException("src.length=" + src.length + " srcPos=" + srcPos + " dst.length=" + dst.length + " dstPos=" + dstPos + " length=" + length);
        }
        if (length <= 32) {
            if (src == dst && srcPos < dstPos && dstPos < srcPos + length) {
                for (int i = length - 1; i >= 0; --i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopyFloatUnchecked(src, srcPos, dst, dstPos, length);
        }
    }

    @FastNative
    private static native void arraycopyFloatUnchecked(float[] var0, int var1, float[] var2, int var3, int var4);

    public static void arraycopy(double[] src, int srcPos, double[] dst, int dstPos, int length) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        if (dst == null) {
            throw new NullPointerException("dst == null");
        }
        if (srcPos < 0 || dstPos < 0 || length < 0 || srcPos > src.length - length || dstPos > dst.length - length) {
            throw new ArrayIndexOutOfBoundsException("src.length=" + src.length + " srcPos=" + srcPos + " dst.length=" + dst.length + " dstPos=" + dstPos + " length=" + length);
        }
        if (length <= 32) {
            if (src == dst && srcPos < dstPos && dstPos < srcPos + length) {
                for (int i = length - 1; i >= 0; --i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopyDoubleUnchecked(src, srcPos, dst, dstPos, length);
        }
    }

    @FastNative
    private static native void arraycopyDoubleUnchecked(double[] var0, int var1, double[] var2, int var3, int var4);

    public static void arraycopy(boolean[] src, int srcPos, boolean[] dst, int dstPos, int length) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        if (dst == null) {
            throw new NullPointerException("dst == null");
        }
        if (srcPos < 0 || dstPos < 0 || length < 0 || srcPos > src.length - length || dstPos > dst.length - length) {
            throw new ArrayIndexOutOfBoundsException("src.length=" + src.length + " srcPos=" + srcPos + " dst.length=" + dst.length + " dstPos=" + dstPos + " length=" + length);
        }
        if (length <= 32) {
            if (src == dst && srcPos < dstPos && dstPos < srcPos + length) {
                for (int i = length - 1; i >= 0; --i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopyBooleanUnchecked(src, srcPos, dst, dstPos, length);
        }
    }

    @FastNative
    private static native void arraycopyBooleanUnchecked(boolean[] var0, int var1, boolean[] var2, int var3, int var4);

    public static int identityHashCode(Object x) {
        if (x == null) {
            return 0;
        }
        return Object.identityHashCode(x);
    }

    private static native String[] specialProperties();

    private static void parsePropertyAssignments(Properties p, String[] assignments) {
        for (String assignment : assignments) {
            int split = assignment.indexOf(61);
            String key = assignment.substring(0, split);
            String value = assignment.substring(split + 1);
            p.put(key, value);
        }
    }

    private static Properties initUnchangeableSystemProperties() {
        VMRuntime runtime = VMRuntime.getRuntime();
        Properties p = new Properties();
        p.put("java.boot.class.path", runtime.bootClassPath());
        p.put("java.class.path", runtime.classPath());
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null) {
            javaHome = "/system";
        }
        p.put("java.home", javaHome);
        p.put("java.vm.version", runtime.vmVersion());
        try {
            StructPasswd passwd = Libcore.os.getpwuid(Libcore.os.getuid());
            p.put("user.name", passwd.pw_name);
        }
        catch (ErrnoException exception) {
            throw new AssertionError((Object)exception);
        }
        StructUtsname info = Libcore.os.uname();
        p.put("os.arch", info.machine);
        if (p.get("os.name") != null && !p.get("os.name").equals(info.sysname)) {
            System.logE("Wrong compile-time assumption for os.name: " + p.get("os.name") + " vs " + info.sysname);
            p.put("os.name", info.sysname);
        }
        p.put("os.version", info.release);
        p.put("android.icu.library.version", ICU.getIcuVersion());
        p.put("android.icu.unicode.version", ICU.getUnicodeVersion());
        p.put("android.icu.cldr.version", ICU.getCldrVersion());
        String icuDataPath = TimeZoneDataFiles.generateIcuDataPath();
        p.put("android.icu.impl.ICUBinary.dataPath", icuDataPath);
        System.parsePropertyAssignments(p, System.specialProperties());
        System.parsePropertyAssignments(p, runtime.properties());
        for (String[] pair : AndroidHardcodedSystemProperties.STATIC_PROPERTIES) {
            if (p.containsKey(pair[0])) {
                System.logE("Ignoring command line argument: -D" + pair[0]);
            }
            if (pair[1] == null) {
                p.remove(pair[0]);
                continue;
            }
            p.put(pair[0], pair[1]);
        }
        return p;
    }

    private static Properties initProperties() {
        PropertiesWithNonOverrideableDefaults p = new PropertiesWithNonOverrideableDefaults(unchangeableProps);
        System.setDefaultChangeableProperties(p);
        return p;
    }

    private static Properties setDefaultChangeableProperties(Properties p) {
        if (!unchangeableProps.containsKey("java.io.tmpdir")) {
            p.put("java.io.tmpdir", "/tmp");
        }
        if (!unchangeableProps.containsKey("user.home")) {
            p.put("user.home", "");
        }
        return p;
    }

    public static void setUnchangeableSystemProperty(String key, String value) {
        System.checkKey(key);
        unchangeableProps.put(key, value);
    }

    private static void addLegacyLocaleSystemProperties() {
        String locale = System.getProperty("user.locale", "");
        if (!locale.isEmpty()) {
            Locale l = Locale.forLanguageTag(locale);
            System.setUnchangeableSystemProperty("user.language", l.getLanguage());
            System.setUnchangeableSystemProperty("user.region", l.getCountry());
            System.setUnchangeableSystemProperty("user.variant", l.getVariant());
        } else {
            String language = System.getProperty("user.language", "");
            String region = System.getProperty("user.region", "");
            if (language.isEmpty()) {
                System.setUnchangeableSystemProperty("user.language", "en");
            }
            if (region.isEmpty()) {
                System.setUnchangeableSystemProperty("user.region", "US");
            }
        }
    }

    public static Properties getProperties() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        return props;
    }

    public static String lineSeparator() {
        return lineSeparator;
    }

    public static void setProperties(Properties props) {
        PropertiesWithNonOverrideableDefaults baseProperties = new PropertiesWithNonOverrideableDefaults(unchangeableProps);
        if (props != null) {
            baseProperties.putAll(props);
        } else {
            System.setDefaultChangeableProperties(baseProperties);
        }
        System.props = baseProperties;
    }

    public static String getProperty(String key) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return props.getProperty(key);
    }

    public static String getProperty(String key, String def) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return props.getProperty(key, def);
    }

    public static String setProperty(String key, String value) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
        }
        return (String)props.setProperty(key, value);
    }

    public static String clearProperty(String key) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
        }
        return (String)props.remove(key);
    }

    private static void checkKey(String key) {
        if (key == null) {
            throw new NullPointerException("key can't be null");
        }
        if (key.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
    }

    public static String getenv(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        return Libcore.os.getenv(name);
    }

    public static Map<String, String> getenv() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getenv.*"));
        }
        return ProcessEnvironment.getenv();
    }

    public static void exit(int status) {
        Runtime.getRuntime().exit(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gc() {
        boolean shouldRunGC;
        Object object = LOCK;
        synchronized (object) {
            shouldRunGC = justRanFinalization;
            if (shouldRunGC) {
                justRanFinalization = false;
            } else {
                runGC = true;
            }
        }
        if (shouldRunGC) {
            Runtime.getRuntime().gc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runFinalization() {
        boolean shouldRunGC;
        Object object = LOCK;
        synchronized (object) {
            shouldRunGC = runGC;
            runGC = false;
        }
        if (shouldRunGC) {
            Runtime.getRuntime().gc();
        }
        Runtime.getRuntime().runFinalization();
        object = LOCK;
        synchronized (object) {
            justRanFinalization = true;
        }
    }

    @Deprecated
    public static void runFinalizersOnExit(boolean value) {
        Runtime.runFinalizersOnExit(value);
    }

    @CallerSensitive
    public static void load(String filename) {
        Runtime.getRuntime().load0(VMStack.getStackClass1(), filename);
    }

    @CallerSensitive
    public static void loadLibrary(String libname) {
        Runtime.getRuntime().loadLibrary0(VMStack.getCallingClassLoader(), libname);
    }

    public static native String mapLibraryName(String var0);

    private static PrintStream newPrintStream(FileOutputStream fos, String enc) {
        if (enc != null) {
            try {
                return new PrintStream(new BufferedOutputStream(fos, 128), true, enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new PrintStream(new BufferedOutputStream(fos, 128), true);
    }

    public static void logE(String message) {
        System.log('E', message, null);
    }

    public static void logE(String message, Throwable th) {
        System.log('E', message, th);
    }

    public static void logI(String message) {
        System.log('I', message, null);
    }

    public static void logI(String message, Throwable th) {
        System.log('I', message, th);
    }

    public static void logW(String message) {
        System.log('W', message, null);
    }

    public static void logW(String message, Throwable th) {
        System.log('W', message, th);
    }

    private static native void log(char var0, String var1, Throwable var2);

    static {
        LOCK = new Object();
        cons = null;
        unchangeableProps = System.initUnchangeableSystemProperties();
        props = System.initProperties();
        System.addLegacyLocaleSystemProperties();
        Version.initSystemProperties();
        lineSeparator = props.getProperty("line.separator");
        FileInputStream fdIn = new FileInputStream(FileDescriptor.in);
        FileOutputStream fdOut = new FileOutputStream(FileDescriptor.out);
        FileOutputStream fdErr = new FileOutputStream(FileDescriptor.err);
        in = new BufferedInputStream(fdIn, 128);
        out = System.newPrintStream(fdOut, props.getProperty("sun.stdout.encoding"));
        err = System.newPrintStream(fdErr, props.getProperty("sun.stderr.encoding"));
        VM.initializeOSEnvironment();
        VM.booted();
    }

    static final class PropertiesWithNonOverrideableDefaults
    extends Properties {
        PropertiesWithNonOverrideableDefaults(Properties defaults) {
            super(defaults);
        }

        @Override
        public Object put(Object key, Object value) {
            if (this.defaults.containsKey(key)) {
                System.logE("Ignoring attempt to set property \"" + key + "\" to value \"" + value + "\".");
                return this.defaults.get(key);
            }
            return super.put(key, value);
        }

        @Override
        public Object remove(Object key) {
            if (this.defaults.containsKey(key)) {
                System.logE("Ignoring attempt to remove property \"" + key + "\".");
                return null;
            }
            return super.remove(key);
        }
    }
}

