/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import android.system.OsConstants;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.VMDebug;
import dalvik.system.VMRuntime;
import dalvik.system.VMStack;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import libcore.util.EmptyArray;
import sun.reflect.CallerSensitive;

public class Runtime {
    private static Runtime currentRuntime = new Runtime();
    private List<Thread> shutdownHooks = new ArrayList<Thread>();
    private static boolean finalizeOnExit;
    private boolean shuttingDown;
    private boolean tracingMethods;
    private volatile String[] mLibPaths = null;

    private static native void nativeExit(int var0);

    public static Runtime getRuntime() {
        return currentRuntime;
    }

    private Runtime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exit(int status) {
        Runtime runtime = this;
        synchronized (runtime) {
            if (this.shuttingDown) return;
            this.shuttingDown = true;
            Thread[] threadArray = this.shutdownHooks;
            synchronized (this.shutdownHooks) {
                Thread[] hooks = new Thread[this.shutdownHooks.size()];
                this.shutdownHooks.toArray(hooks);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                for (Thread hook : hooks) {
                    hook.start();
                }
                for (Thread hook : hooks) {
                    try {
                        hook.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (finalizeOnExit) {
                    this.runFinalization();
                }
                Runtime.nativeExit(status);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownHook(Thread hook) {
        if (hook == null) {
            throw new NullPointerException("hook == null");
        }
        if (this.shuttingDown) {
            throw new IllegalStateException("VM already shutting down");
        }
        if (hook.started) {
            throw new IllegalArgumentException("Hook has already been started");
        }
        List<Thread> list = this.shutdownHooks;
        synchronized (list) {
            if (this.shutdownHooks.contains(hook)) {
                throw new IllegalArgumentException("Hook already registered.");
            }
            this.shutdownHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeShutdownHook(Thread hook) {
        if (hook == null) {
            throw new NullPointerException("hook == null");
        }
        if (this.shuttingDown) {
            throw new IllegalStateException("VM already shutting down");
        }
        List<Thread> list = this.shutdownHooks;
        synchronized (list) {
            return this.shutdownHooks.remove(hook);
        }
    }

    public void halt(int status) {
        Runtime.nativeExit(status);
    }

    @Deprecated
    public static void runFinalizersOnExit(boolean value) {
        finalizeOnExit = value;
    }

    public Process exec(String command) throws IOException {
        return this.exec(command, null, null);
    }

    public Process exec(String command, String[] envp) throws IOException {
        return this.exec(command, envp, null);
    }

    public Process exec(String command, String[] envp, File dir) throws IOException {
        if (command.length() == 0) {
            throw new IllegalArgumentException("Empty command");
        }
        StringTokenizer st = new StringTokenizer(command);
        String[] cmdarray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken();
            ++i;
        }
        return this.exec(cmdarray, envp, dir);
    }

    public Process exec(String[] cmdarray) throws IOException {
        return this.exec(cmdarray, null, null);
    }

    public Process exec(String[] cmdarray, String[] envp) throws IOException {
        return this.exec(cmdarray, envp, null);
    }

    public Process exec(String[] cmdarray, String[] envp, File dir) throws IOException {
        return new ProcessBuilder(cmdarray).environment(envp).directory(dir).start();
    }

    public int availableProcessors() {
        return (int)Libcore.os.sysconf(OsConstants._SC_NPROCESSORS_CONF);
    }

    @FastNative
    public native long freeMemory();

    @FastNative
    public native long totalMemory();

    @FastNative
    public native long maxMemory();

    public native void gc();

    private static native void runFinalization0();

    public void runFinalization() {
        VMRuntime.runFinalization(0L);
    }

    public void traceInstructions(boolean on) {
    }

    public void traceMethodCalls(boolean on) {
        if (on != this.tracingMethods) {
            if (on) {
                VMDebug.startMethodTracing();
            } else {
                VMDebug.stopMethodTracing();
            }
            this.tracingMethods = on;
        }
    }

    @CallerSensitive
    public void load(String filename) {
        this.load0(VMStack.getStackClass1(), filename);
    }

    private void checkTargetSdkVersionForLoad(String methodName) {
        int targetSdkVersion = VMRuntime.getRuntime().getTargetSdkVersion();
        if (targetSdkVersion > 24) {
            throw new UnsupportedOperationException(methodName + " is not supported on SDK " + targetSdkVersion);
        }
    }

    void load(String absolutePath, ClassLoader loader) {
        this.checkTargetSdkVersionForLoad("java.lang.Runtime#load(String, ClassLoader)");
        System.logE("java.lang.Runtime#load(String, ClassLoader) is private and will be removed in a future Android release");
        if (absolutePath == null) {
            throw new NullPointerException("absolutePath == null");
        }
        String error = this.doLoad(absolutePath, loader);
        if (error != null) {
            throw new UnsatisfiedLinkError(error);
        }
    }

    synchronized void load0(Class<?> fromClass, String filename) {
        if (!new File(filename).isAbsolute()) {
            throw new UnsatisfiedLinkError("Expecting an absolute path of the library: " + filename);
        }
        if (filename == null) {
            throw new NullPointerException("filename == null");
        }
        String error = this.doLoad(filename, fromClass.getClassLoader());
        if (error != null) {
            throw new UnsatisfiedLinkError(error);
        }
    }

    @CallerSensitive
    public void loadLibrary(String libname) {
        this.loadLibrary0(VMStack.getCallingClassLoader(), libname);
    }

    public void loadLibrary(String libname, ClassLoader classLoader) {
        this.loadLibrary0(classLoader, libname);
    }

    synchronized void loadLibrary0(ClassLoader loader, String libname) {
        if (libname.indexOf(File.separatorChar) != -1) {
            throw new UnsatisfiedLinkError("Directory separator should not appear in library name: " + libname);
        }
        String libraryName = libname;
        if (loader != null) {
            String filename = loader.findLibrary(libraryName);
            if (filename == null) {
                throw new UnsatisfiedLinkError(loader + " couldn't find \"" + System.mapLibraryName(libraryName) + "\"");
            }
            String error = this.doLoad(filename, loader);
            if (error != null) {
                throw new UnsatisfiedLinkError(error);
            }
            return;
        }
        String filename = System.mapLibraryName(libraryName);
        ArrayList<String> candidates = new ArrayList<String>();
        String lastError = null;
        for (String directory : this.getLibPaths()) {
            String candidate = directory + filename;
            candidates.add(candidate);
            if (!IoUtils.canOpenReadOnly(candidate)) continue;
            String error = this.doLoad(candidate, loader);
            if (error == null) {
                return;
            }
            lastError = error;
        }
        if (lastError != null) {
            throw new UnsatisfiedLinkError(lastError);
        }
        throw new UnsatisfiedLinkError("Library " + libraryName + " not found; tried " + candidates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getLibPaths() {
        if (this.mLibPaths == null) {
            Runtime runtime = this;
            synchronized (runtime) {
                if (this.mLibPaths == null) {
                    this.mLibPaths = Runtime.initLibPaths();
                }
            }
        }
        return this.mLibPaths;
    }

    private static String[] initLibPaths() {
        String javaLibraryPath = null;
        String javaBootLibraryPath = System.getProperty("java.boot.library.path");
        javaLibraryPath = javaBootLibraryPath != null ? javaBootLibraryPath + ":" + System.getProperty("java.library.path") : System.getProperty("java.library.path");
        if (javaLibraryPath == null) {
            return EmptyArray.STRING;
        }
        String[] paths = javaLibraryPath.split(":");
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i].endsWith("/")) continue;
            int n = i;
            paths[n] = paths[n] + "/";
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doLoad(String name, ClassLoader loader) {
        String librarySearchPath = null;
        if (loader != null && loader instanceof BaseDexClassLoader) {
            BaseDexClassLoader dexClassLoader = (BaseDexClassLoader)loader;
            librarySearchPath = dexClassLoader.getLdLibraryPath();
        }
        Runtime runtime = this;
        synchronized (runtime) {
            return Runtime.nativeLoad(name, loader);
        }
    }

    private static String nativeLoad(String filename, ClassLoader loader) {
        return Runtime.nativeLoad(filename, loader, null);
    }

    private static native String nativeLoad(String var0, ClassLoader var1, Class<?> var2);

    @Deprecated
    public InputStream getLocalizedInputStream(InputStream in) {
        return in;
    }

    @Deprecated
    public OutputStream getLocalizedOutputStream(OutputStream out) {
        return out;
    }
}

