/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;

final class ProcessImpl {
    private ProcessImpl() {
    }

    private static byte[] toCString(String s) {
        if (s == null) {
            return null;
        }
        byte[] bytes = s.getBytes();
        byte[] result = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        result[result.length - 1] = 0;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Process start(String[] cmdarray, Map<String, String> environment, String dir, ProcessBuilder.Redirect[] redirects, boolean redirectErrorStream) throws IOException {
        assert (cmdarray != null && cmdarray.length > 0);
        byte[][] args = new byte[cmdarray.length - 1][];
        int size = args.length;
        for (int i = 0; i < args.length; ++i) {
            args[i] = cmdarray[i + 1].getBytes();
            size += args[i].length;
        }
        byte[] argBlock = new byte[size];
        int i = 0;
        for (byte[] arg : args) {
            System.arraycopy(arg, 0, argBlock, i, arg.length);
            i += arg.length + 1;
        }
        int[] envc = new int[1];
        byte[] envBlock = ProcessEnvironment.toEnvironmentBlock(environment, envc);
        FileInputStream f0 = null;
        FileOutputStream f1 = null;
        FileOutputStream f2 = null;
        try {
            int[] std_fds;
            if (redirects == null) {
                std_fds = new int[]{-1, -1, -1};
            } else {
                std_fds = new int[3];
                if (redirects[0] == ProcessBuilder.Redirect.PIPE) {
                    std_fds[0] = -1;
                } else if (redirects[0] == ProcessBuilder.Redirect.INHERIT) {
                    std_fds[0] = 0;
                } else {
                    f0 = new FileInputStream(redirects[0].file());
                    std_fds[0] = f0.getFD().getInt$();
                }
                if (redirects[1] == ProcessBuilder.Redirect.PIPE) {
                    std_fds[1] = -1;
                } else if (redirects[1] == ProcessBuilder.Redirect.INHERIT) {
                    std_fds[1] = 1;
                } else {
                    f1 = new FileOutputStream(redirects[1].file(), redirects[1].append());
                    std_fds[1] = f1.getFD().getInt$();
                }
                if (redirects[2] == ProcessBuilder.Redirect.PIPE) {
                    std_fds[2] = -1;
                } else if (redirects[2] == ProcessBuilder.Redirect.INHERIT) {
                    std_fds[2] = 2;
                } else {
                    f2 = new FileOutputStream(redirects[2].file(), redirects[2].append());
                    std_fds[2] = f2.getFD().getInt$();
                }
            }
            UNIXProcess uNIXProcess = new UNIXProcess(ProcessImpl.toCString(cmdarray[0]), argBlock, args.length, envBlock, envc[0], ProcessImpl.toCString(dir), std_fds, redirectErrorStream);
            return uNIXProcess;
        }
        finally {
            try {
                if (f0 != null) {
                    f0.close();
                }
            }
            finally {
                try {
                    if (f1 != null) {
                        f1.close();
                    }
                }
                finally {
                    if (f2 != null) {
                        f2.close();
                    }
                }
            }
        }
    }
}

