/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import dalvik.system.PathClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.misc.CompoundEnumeration;
import sun.reflect.CallerSensitive;

public abstract class ClassLoader {
    public final Map<List<Class<?>>, Class<?>> proxyCache = new HashMap();
    private final ClassLoader parent;
    private final HashMap<String, Package> packages = new HashMap();
    private transient long allocator;
    private transient long classTable;

    private static ClassLoader createSystemClassLoader() {
        String classPath = System.getProperty("java.class.path", ".");
        String librarySearchPath = System.getProperty("java.library.path", "");
        return new PathClassLoader(classPath, librarySearchPath, BootClassLoader.getInstance());
    }

    private static Void checkCreateClassLoader() {
        return null;
    }

    private ClassLoader(Void unused, ClassLoader parent) {
        this.parent = parent;
    }

    protected ClassLoader(ClassLoader parent) {
        this(ClassLoader.checkCreateClassLoader(), parent);
    }

    protected ClassLoader() {
        this(ClassLoader.checkCreateClassLoader(), ClassLoader.getSystemClassLoader());
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.parent != null ? this.parent.loadClass(name, false) : this.findBootstrapClassOrNull(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (c == null) {
                c = this.findClass(name);
            }
        }
        return c;
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    @Deprecated
    protected final Class<?> defineClass(byte[] b, int off, int len) throws ClassFormatError {
        throw new UnsupportedOperationException("can't load this type of class file");
    }

    protected final Class<?> defineClass(String name, byte[] b, int off, int len) throws ClassFormatError {
        throw new UnsupportedOperationException("can't load this type of class file");
    }

    protected final Class<?> defineClass(String name, byte[] b, int off, int len, ProtectionDomain protectionDomain) throws ClassFormatError {
        throw new UnsupportedOperationException("can't load this type of class file");
    }

    protected final Class<?> defineClass(String name, ByteBuffer b, ProtectionDomain protectionDomain) throws ClassFormatError {
        throw new UnsupportedOperationException("can't load this type of class file");
    }

    protected final void resolveClass(Class<?> c) {
    }

    protected final Class<?> findSystemClass(String name) throws ClassNotFoundException {
        return Class.forName(name, false, ClassLoader.getSystemClassLoader());
    }

    private Class<?> findBootstrapClassOrNull(String name) {
        return null;
    }

    protected final Class<?> findLoadedClass(String name) {
        ClassLoader loader = this == BootClassLoader.getInstance() ? null : this;
        return VMClassLoader.findLoadedClass(loader, name);
    }

    protected final void setSigners(Class<?> c, Object[] signers) {
    }

    public URL getResource(String name) {
        URL url = this.parent != null ? this.parent.getResource(name) : ClassLoader.getBootstrapResource(name);
        if (url == null) {
            url = this.findResource(name);
        }
        return url;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[]{this.parent != null ? this.parent.getResources(name) : ClassLoader.getBootstrapResources(name), this.findResources(name)};
        return new CompoundEnumeration<URL>(tmp);
    }

    protected URL findResource(String name) {
        return null;
    }

    protected Enumeration<URL> findResources(String name) throws IOException {
        return Collections.emptyEnumeration();
    }

    @CallerSensitive
    protected static boolean registerAsParallelCapable() {
        return true;
    }

    public static URL getSystemResource(String name) {
        ClassLoader system = ClassLoader.getSystemClassLoader();
        if (system == null) {
            return ClassLoader.getBootstrapResource(name);
        }
        return system.getResource(name);
    }

    public static Enumeration<URL> getSystemResources(String name) throws IOException {
        ClassLoader system = ClassLoader.getSystemClassLoader();
        if (system == null) {
            return ClassLoader.getBootstrapResources(name);
        }
        return system.getResources(name);
    }

    private static URL getBootstrapResource(String name) {
        return null;
    }

    private static Enumeration<URL> getBootstrapResources(String name) throws IOException {
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InputStream getSystemResourceAsStream(String name) {
        URL url = ClassLoader.getSystemResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @CallerSensitive
    public final ClassLoader getParent() {
        return this.parent;
    }

    @CallerSensitive
    public static ClassLoader getSystemClassLoader() {
        return SystemClassLoader.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        HashMap<String, Package> hashMap = this.packages;
        synchronized (hashMap) {
            Package pkg = this.packages.get(name);
            if (pkg != null) {
                throw new IllegalArgumentException(name);
            }
            pkg = new Package(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase, this);
            this.packages.put(name, pkg);
            return pkg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackage(String name) {
        Package pkg;
        HashMap<String, Package> hashMap = this.packages;
        synchronized (hashMap) {
            pkg = this.packages.get(name);
        }
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package[] getPackages() {
        HashMap<String, Package> map;
        HashMap<String, Package> hashMap = this.packages;
        synchronized (hashMap) {
            map = new HashMap<String, Package>(this.packages);
        }
        return map.values().toArray(new Package[map.size()]);
    }

    protected String findLibrary(String libname) {
        return null;
    }

    public void setDefaultAssertionStatus(boolean enabled) {
    }

    public void setPackageAssertionStatus(String packageName, boolean enabled) {
    }

    public void setClassAssertionStatus(String className, boolean enabled) {
    }

    public void clearAssertionStatus() {
    }

    static /* synthetic */ ClassLoader access$000() {
        return ClassLoader.createSystemClassLoader();
    }

    private static class SystemClassLoader {
        public static ClassLoader loader = ClassLoader.access$000();

        private SystemClassLoader() {
        }
    }
}

