/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import dalvik.annotation.optimization.FastNative;
import dalvik.system.ClassExt;
import dalvik.system.VMStack;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import libcore.reflect.GenericSignatureParser;
import libcore.reflect.Types;
import libcore.util.BasicLruCache;
import libcore.util.CollectionUtils;
import libcore.util.EmptyArray;
import sun.reflect.CallerSensitive;

public final class Class<T>
implements Serializable,
GenericDeclaration,
Type,
AnnotatedElement {
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;
    private static final int SYNTHETIC = 4096;
    private static final int FINALIZABLE = Integer.MIN_VALUE;
    private transient ClassLoader classLoader;
    private transient Class<?> componentType;
    private transient Object dexCache;
    private transient ClassExt extData;
    private transient Object[] ifTable;
    private transient String name;
    private transient Class<? super T> superClass;
    private transient Object vtable;
    private transient long iFields;
    private transient long methods;
    private transient long sFields;
    private transient int accessFlags;
    private transient int classFlags;
    private transient int classSize;
    private transient int clinitThreadId;
    private transient int dexClassDefIndex;
    private volatile transient int dexTypeIndex;
    private transient int numReferenceInstanceFields;
    private transient int numReferenceStaticFields;
    private transient int objectSize;
    private transient int objectSizeAllocFastPath;
    private transient int primitiveType;
    private transient int referenceInstanceOffsets;
    private transient int status;
    private transient short copiedMethodsOffset;
    private transient short virtualMethodsOffset;
    private static final long serialVersionUID = 3206093459760846163L;

    private Class() {
    }

    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    public String toGenericString() {
        if (this.isPrimitive()) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        int modifiers = this.getModifiers() & Modifier.classModifiers();
        if (modifiers != 0) {
            sb.append(Modifier.toString(modifiers));
            sb.append(' ');
        }
        if (this.isAnnotation()) {
            sb.append('@');
        }
        if (this.isInterface()) {
            sb.append("interface");
        } else if (this.isEnum()) {
            sb.append("enum");
        } else {
            sb.append("class");
        }
        sb.append(' ');
        sb.append(this.getName());
        TypeVariable<Class<T>>[] typeparms = this.getTypeParameters();
        if (typeparms.length > 0) {
            boolean first = true;
            sb.append('<');
            for (TypeVariable<Class<T>> typeparm : typeparms) {
                if (!first) {
                    sb.append(',');
                }
                sb.append(typeparm.getTypeName());
                first = false;
            }
            sb.append('>');
        }
        return sb.toString();
    }

    @CallerSensitive
    public static Class<?> forName(String className) throws ClassNotFoundException {
        return Class.forName(className, true, VMStack.getCallingClassLoader());
    }

    @CallerSensitive
    public static Class<?> forName(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        Class<?> result;
        if (loader == null) {
            loader = BootClassLoader.getInstance();
        }
        try {
            result = Class.classForName(name, initialize, loader);
        }
        catch (ClassNotFoundException e) {
            Throwable cause = e.getCause();
            if (cause instanceof LinkageError) {
                throw (LinkageError)cause;
            }
            throw e;
        }
        return result;
    }

    @FastNative
    static native Class<?> classForName(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    @FastNative
    public native T newInstance() throws InstantiationException, IllegalAccessException;

    public boolean isInstance(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.isAssignableFrom(obj.getClass());
    }

    public boolean isAssignableFrom(Class<?> cls) {
        if (this == cls) {
            return true;
        }
        if (this == Object.class) {
            return !cls.isPrimitive();
        }
        if (this.isArray()) {
            return cls.isArray() && this.componentType.isAssignableFrom(cls.componentType);
        }
        if (this.isInterface()) {
            Object[] iftable = cls.ifTable;
            if (iftable != null) {
                for (int i = 0; i < iftable.length; i += 2) {
                    if (iftable[i] != this) continue;
                    return true;
                }
            }
            return false;
        }
        if (!cls.isInterface()) {
            cls = cls.superClass;
            while (cls != null) {
                if (cls == this) {
                    return true;
                }
                cls = cls.superClass;
            }
        }
        return false;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isArray() {
        return this.getComponentType() != null;
    }

    public boolean isPrimitive() {
        return (this.primitiveType & 0xFFFF) != 0;
    }

    public boolean isFinalizable() {
        return (this.getModifiers() & Integer.MIN_VALUE) != 0;
    }

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public String getName() {
        String name = this.name;
        if (name == null) {
            this.name = name = this.getNameNative();
        }
        return name;
    }

    @FastNative
    private native String getNameNative();

    public ClassLoader getClassLoader() {
        if (this.isPrimitive()) {
            return null;
        }
        return this.classLoader == null ? BootClassLoader.getInstance() : this.classLoader;
    }

    public synchronized TypeVariable<Class<T>>[] getTypeParameters() {
        String annotationSignature = this.getSignatureAttribute();
        if (annotationSignature == null) {
            return EmptyArray.TYPE_VARIABLE;
        }
        GenericSignatureParser parser = new GenericSignatureParser(this.getClassLoader());
        parser.parseForClass(this, annotationSignature);
        return parser.formalTypeParameters;
    }

    public Class<? super T> getSuperclass() {
        if (this.isInterface()) {
            return null;
        }
        return this.superClass;
    }

    public Type getGenericSuperclass() {
        Type genericSuperclass = this.getSuperclass();
        if (genericSuperclass == null) {
            return null;
        }
        String annotationSignature = this.getSignatureAttribute();
        if (annotationSignature != null) {
            GenericSignatureParser parser = new GenericSignatureParser(this.getClassLoader());
            parser.parseForClass(this, annotationSignature);
            genericSuperclass = parser.superclassType;
        }
        return Types.getType(genericSuperclass);
    }

    public Package getPackage() {
        ClassLoader loader = this.getClassLoader();
        if (loader != null) {
            String packageName = this.getPackageName$();
            return packageName != null ? loader.getPackage(packageName) : null;
        }
        return null;
    }

    public String getPackageName$() {
        String name = this.getName();
        int last = name.lastIndexOf(46);
        return last == -1 ? null : name.substring(0, last);
    }

    public Class<?>[] getInterfaces() {
        if (this.isArray()) {
            return new Class[]{Cloneable.class, Serializable.class};
        }
        Class<?>[] ifaces = this.getInterfacesInternal();
        if (ifaces == null) {
            return EmptyArray.CLASS;
        }
        return ifaces;
    }

    @FastNative
    private native Class<?>[] getInterfacesInternal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type[] getGenericInterfaces() {
        Type[] result;
        BasicLruCache basicLruCache = Caches.genericInterfaces;
        synchronized (basicLruCache) {
            result = (Type[])Caches.genericInterfaces.get(this);
            if (result == null) {
                String annotationSignature = this.getSignatureAttribute();
                if (annotationSignature == null) {
                    result = this.getInterfaces();
                } else {
                    GenericSignatureParser parser = new GenericSignatureParser(this.getClassLoader());
                    parser.parseForClass(this, annotationSignature);
                    result = Types.getTypeArray(parser.interfaceTypes, false);
                }
                Caches.genericInterfaces.put(this, result);
            }
        }
        return result.length == 0 ? result : (Type[])result.clone();
    }

    public Class<?> getComponentType() {
        return this.componentType;
    }

    public int getModifiers() {
        if (this.isArray()) {
            int componentModifiers = this.getComponentType().getModifiers();
            if ((componentModifiers & 0x200) != 0) {
                componentModifiers &= 0xFFFFFDF7;
            }
            return 0x410 | componentModifiers;
        }
        int JAVA_FLAGS_MASK = 65535;
        int modifiers = this.getInnerClassFlags(this.accessFlags & JAVA_FLAGS_MASK);
        return modifiers & JAVA_FLAGS_MASK;
    }

    public Object[] getSigners() {
        return null;
    }

    @FastNative
    private native Method getEnclosingMethodNative();

    public Method getEnclosingMethod() {
        if (this.classNameImpliesTopLevel()) {
            return null;
        }
        return this.getEnclosingMethodNative();
    }

    public Constructor<?> getEnclosingConstructor() {
        if (this.classNameImpliesTopLevel()) {
            return null;
        }
        return this.getEnclosingConstructorNative();
    }

    @FastNative
    private native Constructor<?> getEnclosingConstructorNative();

    private boolean classNameImpliesTopLevel() {
        return !this.getName().contains("$");
    }

    @FastNative
    public native Class<?> getDeclaringClass();

    @FastNative
    public native Class<?> getEnclosingClass();

    public String getSimpleName() {
        if (this.isArray()) {
            return this.getComponentType().getSimpleName() + "[]";
        }
        if (this.isAnonymousClass()) {
            return "";
        }
        if (this.isMemberClass() || this.isLocalClass()) {
            return this.getInnerClassName();
        }
        String simpleName = this.getName();
        int dot = simpleName.lastIndexOf(".");
        if (dot > 0) {
            return simpleName.substring(simpleName.lastIndexOf(".") + 1);
        }
        return simpleName;
    }

    @Override
    public String getTypeName() {
        if (this.isArray()) {
            try {
                Class<?> cl = this;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.getName();
    }

    public String getCanonicalName() {
        if (this.isArray()) {
            String canonicalName = this.getComponentType().getCanonicalName();
            if (canonicalName != null) {
                return canonicalName + "[]";
            }
            return null;
        }
        if (this.isLocalOrAnonymousClass()) {
            return null;
        }
        Class<?> enclosingClass = this.getEnclosingClass();
        if (enclosingClass == null) {
            return this.getName();
        }
        String enclosingName = enclosingClass.getCanonicalName();
        if (enclosingName == null) {
            return null;
        }
        return enclosingName + "." + this.getSimpleName();
    }

    @FastNative
    public native boolean isAnonymousClass();

    public boolean isLocalClass() {
        return (this.getEnclosingMethod() != null || this.getEnclosingConstructor() != null) && !this.isAnonymousClass();
    }

    public boolean isMemberClass() {
        return this.getDeclaringClass() != null;
    }

    private boolean isLocalOrAnonymousClass() {
        return this.isLocalClass() || this.isAnonymousClass();
    }

    @CallerSensitive
    public Class<?>[] getClasses() {
        ArrayList result = new ArrayList();
        Class<T> c = this;
        while (c != null) {
            for (Class<?> member : c.getDeclaredClasses()) {
                if (!Modifier.isPublic(member.getModifiers())) continue;
                result.add(member);
            }
            c = c.superClass;
        }
        return result.toArray(new Class[result.size()]);
    }

    @CallerSensitive
    public Field[] getFields() throws SecurityException {
        ArrayList<Field> fields = new ArrayList<Field>();
        this.getPublicFieldsRecursive(fields);
        return fields.toArray(new Field[fields.size()]);
    }

    private void getPublicFieldsRecursive(List<Field> result) {
        Class<T> c = this;
        while (c != null) {
            Collections.addAll(result, c.getPublicDeclaredFields());
            c = c.superClass;
        }
        Object[] iftable = this.ifTable;
        if (iftable != null) {
            for (int i = 0; i < iftable.length; i += 2) {
                Collections.addAll(result, ((Class)iftable[i]).getPublicDeclaredFields());
            }
        }
    }

    @CallerSensitive
    public Method[] getMethods() throws SecurityException {
        ArrayList<Method> methods = new ArrayList<Method>();
        this.getPublicMethodsInternal(methods);
        CollectionUtils.removeDuplicates(methods, Method.ORDER_BY_SIGNATURE);
        return methods.toArray(new Method[methods.size()]);
    }

    private void getPublicMethodsInternal(List<Method> result) {
        Object[] iftable;
        Collections.addAll(result, this.getDeclaredMethodsUnchecked(true));
        if (!this.isInterface()) {
            Class<T> c = this.superClass;
            while (c != null) {
                Collections.addAll(result, c.getDeclaredMethodsUnchecked(true));
                c = c.superClass;
            }
        }
        if ((iftable = this.ifTable) != null) {
            for (int i = 0; i < iftable.length; i += 2) {
                Class ifc = (Class)iftable[i];
                Collections.addAll(result, ifc.getDeclaredMethodsUnchecked(true));
            }
        }
    }

    @CallerSensitive
    public Constructor<?>[] getConstructors() throws SecurityException {
        return this.getDeclaredConstructorsInternal(true);
    }

    public Field getField(String name) throws NoSuchFieldException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        Field result = this.getPublicFieldRecursive(name);
        if (result == null) {
            throw new NoSuchFieldException(name);
        }
        return result;
    }

    @FastNative
    private native Field getPublicFieldRecursive(String var1);

    @CallerSensitive
    public Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return this.getMethod(name, parameterTypes, true);
    }

    public Constructor<T> getConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return this.getConstructor0(parameterTypes, 0);
    }

    @FastNative
    public native Class<?>[] getDeclaredClasses();

    @FastNative
    public native Field[] getDeclaredFields();

    @FastNative
    public native Field[] getDeclaredFieldsUnchecked(boolean var1);

    public Method[] getDeclaredMethods() throws SecurityException {
        Method[] result;
        for (Method m : result = this.getDeclaredMethodsUnchecked(false)) {
            m.getReturnType();
            m.getParameterTypes();
        }
        return result;
    }

    @FastNative
    public native Method[] getDeclaredMethodsUnchecked(boolean var1);

    public Constructor<?>[] getDeclaredConstructors() throws SecurityException {
        return this.getDeclaredConstructorsInternal(false);
    }

    @FastNative
    private native Constructor<?>[] getDeclaredConstructorsInternal(boolean var1);

    @FastNative
    public native Field getDeclaredField(String var1) throws NoSuchFieldException;

    @FastNative
    private native Field[] getPublicDeclaredFields();

    @CallerSensitive
    public Method getDeclaredMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return this.getMethod(name, parameterTypes, false);
    }

    private Method getMethod(String name, Class<?>[] parameterTypes, boolean recursivePublicMethods) throws NoSuchMethodException {
        Method result;
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (parameterTypes == null) {
            parameterTypes = EmptyArray.CLASS;
        }
        for (Class<?> c : parameterTypes) {
            if (c != null) continue;
            throw new NoSuchMethodException("parameter type is null");
        }
        Method method = result = recursivePublicMethods ? this.getPublicMethodRecursive(name, parameterTypes) : this.getDeclaredMethodInternal(name, parameterTypes);
        if (result == null || recursivePublicMethods && !Modifier.isPublic(result.getAccessFlags())) {
            throw new NoSuchMethodException(name + " " + Arrays.toString(parameterTypes));
        }
        return result;
    }

    private Method getPublicMethodRecursive(String name, Class<?>[] parameterTypes) {
        for (Class<T> c = this; c != null; c = c.getSuperclass()) {
            Method result = c.getDeclaredMethodInternal(name, parameterTypes);
            if (result == null || !Modifier.isPublic(result.getAccessFlags())) continue;
            return result;
        }
        return this.findInterfaceMethod(name, parameterTypes);
    }

    public Method getInstanceMethod(String name, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException {
        for (Class<T> c = this; c != null; c = c.getSuperclass()) {
            Method result = c.getDeclaredMethodInternal(name, parameterTypes);
            if (result == null || Modifier.isStatic(result.getModifiers())) continue;
            return result;
        }
        return this.findInterfaceMethod(name, parameterTypes);
    }

    private Method findInterfaceMethod(String name, Class<?>[] parameterTypes) {
        Object[] iftable = this.ifTable;
        if (iftable != null) {
            for (int i = iftable.length - 2; i >= 0; i -= 2) {
                Class ifc = (Class)iftable[i];
                Method result = ifc.getPublicMethodRecursive(name, parameterTypes);
                if (result == null || !Modifier.isPublic(result.getAccessFlags())) continue;
                return result;
            }
        }
        return null;
    }

    @CallerSensitive
    public Constructor<T> getDeclaredConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return this.getConstructor0(parameterTypes, 1);
    }

    public InputStream getResourceAsStream(String name) {
        name = this.resolveName(name);
        ClassLoader cl = this.getClassLoader();
        if (cl == null) {
            return ClassLoader.getSystemResourceAsStream(name);
        }
        return cl.getResourceAsStream(name);
    }

    public URL getResource(String name) {
        name = this.resolveName(name);
        ClassLoader cl = this.getClassLoader();
        if (cl == null) {
            return ClassLoader.getSystemResource(name);
        }
        return cl.getResource(name);
    }

    public ProtectionDomain getProtectionDomain() {
        return null;
    }

    @FastNative
    static native Class<?> getPrimitiveClass(String var0);

    private String resolveName(String name) {
        if (name == null) {
            return name;
        }
        if (!name.startsWith("/")) {
            Class<?> c = this;
            while (c.isArray()) {
                c = c.getComponentType();
            }
            String baseName = c.getName();
            int index = baseName.lastIndexOf(46);
            if (index != -1) {
                name = baseName.substring(0, index).replace('.', '/') + "/" + name;
            }
        } else {
            name = name.substring(1);
        }
        return name;
    }

    private Constructor<T> getConstructor0(Class<?>[] parameterTypes, int which) throws NoSuchMethodException {
        if (parameterTypes == null) {
            parameterTypes = EmptyArray.CLASS;
        }
        for (Class<?> c : parameterTypes) {
            if (c != null) continue;
            throw new NoSuchMethodException("parameter type is null");
        }
        Constructor<T> result = this.getDeclaredConstructorInternal(parameterTypes);
        if (result == null || which == 0 && !Modifier.isPublic(result.getAccessFlags())) {
            throw new NoSuchMethodException("<init> " + Arrays.toString(parameterTypes));
        }
        return result;
    }

    @FastNative
    private native Constructor<T> getDeclaredConstructorInternal(Class<?>[] var1);

    public boolean desiredAssertionStatus() {
        return false;
    }

    @FastNative
    private native String getInnerClassName();

    @FastNative
    private native int getInnerClassFlags(int var1);

    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0 && this.getSuperclass() == Enum.class;
    }

    public T[] getEnumConstants() {
        T[] values = this.getEnumConstantsShared();
        return values != null ? (Object[])values.clone() : null;
    }

    public T[] getEnumConstantsShared() {
        if (!this.isEnum()) {
            return null;
        }
        return Enum.getSharedConstants((Class)this);
    }

    public T cast(Object obj) {
        if (obj != null && !this.isInstance(obj)) {
            throw new ClassCastException(this.cannotCastMsg(obj));
        }
        return (T)obj;
    }

    private String cannotCastMsg(Object obj) {
        return "Cannot cast " + obj.getClass().getName() + " to " + this.getName();
    }

    public <U> Class<? extends U> asSubclass(Class<U> clazz) {
        if (clazz.isAssignableFrom(this)) {
            return this;
        }
        throw new ClassCastException(this.toString() + " cannot be cast to " + clazz.getName());
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        Objects.requireNonNull(annotationClass);
        A annotation = this.getDeclaredAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        if (super.isDeclaredAnnotationPresent(Inherited.class)) {
            for (Class<T> sup = this.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
                annotation = sup.getDeclaredAnnotation(annotationClass);
                if (annotation == null) continue;
                return annotation;
            }
        }
        return null;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException("annotationClass == null");
        }
        if (this.isDeclaredAnnotationPresent(annotationClass)) {
            return true;
        }
        if (super.isDeclaredAnnotationPresent(Inherited.class)) {
            for (Class<T> sup = this.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
                if (!super.isDeclaredAnnotationPresent(annotationClass)) continue;
                return true;
            }
        }
        return false;
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
        Class<T> superClass;
        Annotation[] annotations = GenericDeclaration.super.getAnnotationsByType(annotationClass);
        if (annotations.length != 0) {
            return annotations;
        }
        if (super.isDeclaredAnnotationPresent(Inherited.class) && (superClass = this.getSuperclass()) != null) {
            return superClass.getAnnotationsByType(annotationClass);
        }
        return (Annotation[])Array.newInstance(annotationClass, 0);
    }

    @Override
    public Annotation[] getAnnotations() {
        HashMap<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation declaredAnnotation : this.getDeclaredAnnotations()) {
            map.put(declaredAnnotation.annotationType(), declaredAnnotation);
        }
        for (Class<T> sup = this.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
            for (Annotation declaredAnnotation : sup.getDeclaredAnnotations()) {
                Class<? extends Annotation> clazz = declaredAnnotation.annotationType();
                if (map.containsKey(clazz) || !super.isDeclaredAnnotationPresent(Inherited.class)) continue;
                map.put(clazz, declaredAnnotation);
            }
        }
        Collection coll = map.values();
        return coll.toArray(new Annotation[coll.size()]);
    }

    @FastNative
    public native <A extends Annotation> A getDeclaredAnnotation(Class<A> var1);

    @Override
    @FastNative
    public native Annotation[] getDeclaredAnnotations();

    @FastNative
    private native boolean isDeclaredAnnotationPresent(Class<? extends Annotation> var1);

    private String getSignatureAttribute() {
        String[] annotation = this.getSignatureAnnotation();
        if (annotation == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (String s : annotation) {
            result.append(s);
        }
        return result.toString();
    }

    @FastNative
    private native String[] getSignatureAnnotation();

    public boolean isProxy() {
        return (this.accessFlags & 0x40000) != 0;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    @FastNative
    private native Method getDeclaredMethodInternal(String var1, Class<?>[] var2);

    private static class Caches {
        private static final BasicLruCache<Class, Type[]> genericInterfaces = new BasicLruCache(8);

        private Caches() {
        }
    }
}

