/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Byte
extends Number
implements Comparable<Byte> {
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class<Byte> TYPE = byte[].class.getComponentType();
    private final byte value;
    public static final int SIZE = 8;
    public static final int BYTES = 1;
    private static final long serialVersionUID = -7183698231559129828L;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] UPPER_CASE_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static String toString(byte b) {
        return Integer.toString(b, 10);
    }

    public static Byte valueOf(byte b) {
        int offset = 128;
        return ByteCache.cache[b + 128];
    }

    public static byte parseByte(String s, int radix) throws NumberFormatException {
        int i = Integer.parseInt(s, radix);
        if (i < -128 || i > 127) {
            throw new NumberFormatException("Value out of range. Value:\"" + s + "\" Radix:" + radix);
        }
        return (byte)i;
    }

    public static byte parseByte(String s) throws NumberFormatException {
        return Byte.parseByte(s, 10);
    }

    public static Byte valueOf(String s, int radix) throws NumberFormatException {
        return Byte.parseByte(s, radix);
    }

    public static Byte valueOf(String s) throws NumberFormatException {
        return Byte.valueOf(s, 10);
    }

    public static Byte decode(String nm) throws NumberFormatException {
        int i = Integer.decode(nm);
        if (i < -128 || i > 127) {
            throw new NumberFormatException("Value " + i + " out of range from input " + nm);
        }
        return (byte)i;
    }

    public Byte(byte value) {
        this.value = value;
    }

    public Byte(String s) throws NumberFormatException {
        this.value = Byte.parseByte(s, 10);
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return Byte.hashCode(this.value);
    }

    public static int hashCode(byte value) {
        return value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Byte) {
            return this.value == (Byte)obj;
        }
        return false;
    }

    @Override
    public int compareTo(Byte anotherByte) {
        return Byte.compare(this.value, anotherByte.value);
    }

    public static int compare(byte x, byte y) {
        return x - y;
    }

    public static int toUnsignedInt(byte x) {
        return x & 0xFF;
    }

    public static long toUnsignedLong(byte x) {
        return (long)x & 0xFFL;
    }

    public static String toHexString(byte b, boolean upperCase) {
        char[] digits = upperCase ? UPPER_CASE_DIGITS : DIGITS;
        char[] buf = new char[]{digits[b >> 4 & 0xF], digits[b & 0xF]};
        return new String(0, 2, buf);
    }

    private static class ByteCache {
        static final Byte[] cache = new Byte[256];

        private ByteCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                ByteCache.cache[i] = new Byte((byte)(i - 128));
            }
        }
    }
}

