/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;

class BootClassLoader
extends ClassLoader {
    private static BootClassLoader instance;

    @FindBugsSuppressWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
    public static synchronized BootClassLoader getInstance() {
        if (instance == null) {
            instance = new BootClassLoader();
        }
        return instance;
    }

    public BootClassLoader() {
        super(null);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return Class.classForName(name, false, null);
    }

    @Override
    protected URL findResource(String name) {
        return VMClassLoader.getResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String resName) throws IOException {
        return Collections.enumeration(VMClassLoader.getResources(resName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Package getPackage(String name) {
        if (name != null && !name.isEmpty()) {
            BootClassLoader bootClassLoader = this;
            synchronized (bootClassLoader) {
                Package pack = super.getPackage(name);
                if (pack == null) {
                    pack = this.definePackage(name, "Unknown", "0.0", "Unknown", "Unknown", "0.0", "Unknown", null);
                }
                return pack;
            }
        }
        return null;
    }

    @Override
    public URL getResource(String resName) {
        return this.findResource(resName);
    }

    @Override
    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(className);
        if (clazz == null) {
            clazz = this.findClass(className);
        }
        return clazz;
    }

    @Override
    public Enumeration<URL> getResources(String resName) throws IOException {
        return this.findResources(resName);
    }
}

