/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import dalvik.system.BlockGuard;
import java.io.ExpiringCache;
import java.io.File;
import java.io.FileSystem;
import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class UnixFileSystem
extends FileSystem {
    private final char slash;
    private final char colon;
    private final String javaHome;
    private ExpiringCache cache = new ExpiringCache();
    private ExpiringCache javaHomePrefixCache = new ExpiringCache();

    public UnixFileSystem() {
        this.slash = AccessController.doPrivileged(new GetPropertyAction("file.separator")).charAt(0);
        this.colon = AccessController.doPrivileged(new GetPropertyAction("path.separator")).charAt(0);
        this.javaHome = AccessController.doPrivileged(new GetPropertyAction("java.home"));
    }

    @Override
    public char getSeparator() {
        return this.slash;
    }

    @Override
    public char getPathSeparator() {
        return this.colon;
    }

    @Override
    public String normalize(String pathname) {
        int n = pathname.length();
        char[] normalized = pathname.toCharArray();
        int index = 0;
        int prevChar = 0;
        for (int i = 0; i < n; ++i) {
            int current = normalized[i];
            if (current != 47 || prevChar != 47) {
                normalized[index++] = current;
            }
            prevChar = current;
        }
        if (prevChar == 47 && n > 1) {
            --index;
        }
        return index != n ? new String(normalized, 0, index) : pathname;
    }

    @Override
    public int prefixLength(String pathname) {
        if (pathname.length() == 0) {
            return 0;
        }
        return pathname.charAt(0) == '/' ? 1 : 0;
    }

    @Override
    public String resolve(String parent, String child) {
        if (child.isEmpty() || child.equals("/")) {
            return parent;
        }
        if (child.charAt(0) == '/') {
            if (parent.equals("/")) {
                return child;
            }
            return parent + child;
        }
        if (parent.equals("/")) {
            return parent + child;
        }
        return parent + '/' + child;
    }

    @Override
    public String getDefaultParent() {
        return "/";
    }

    @Override
    public String fromURIPath(String path) {
        String p = path;
        if (p.endsWith("/") && p.length() > 1) {
            p = p.substring(0, p.length() - 1);
        }
        return p;
    }

    @Override
    public boolean isAbsolute(File f) {
        return f.getPrefixLength() != 0;
    }

    @Override
    public String resolve(File f) {
        if (this.isAbsolute(f)) {
            return f.getPath();
        }
        return this.resolve(System.getProperty("user.dir"), f.getPath());
    }

    @Override
    public String canonicalize(String path) throws IOException {
        if (!useCanonCaches) {
            return this.canonicalize0(path);
        }
        String res = this.cache.get(path);
        if (res == null) {
            String dir = null;
            String resDir = null;
            if (useCanonPrefixCache && (dir = UnixFileSystem.parentOrNull(path)) != null && (resDir = this.javaHomePrefixCache.get(dir)) != null) {
                String filename = path.substring(1 + dir.length());
                res = resDir + this.slash + filename;
                this.cache.put(dir + this.slash + filename, res);
            }
            if (res == null) {
                File f;
                BlockGuard.getThreadPolicy().onReadFromDisk();
                res = this.canonicalize0(path);
                this.cache.put(path, res);
                if (useCanonPrefixCache && dir != null && dir.startsWith(this.javaHome) && (resDir = UnixFileSystem.parentOrNull(res)) != null && resDir.equals(dir) && (f = new File(res)).exists() && !f.isDirectory()) {
                    this.javaHomePrefixCache.put(dir, resDir);
                }
            }
        }
        return res;
    }

    private native String canonicalize0(String var1) throws IOException;

    static String parentOrNull(String path) {
        int last;
        if (path == null) {
            return null;
        }
        char sep = File.separatorChar;
        int adjacentDots = 0;
        int nonDotCount = 0;
        for (int idx = last = path.length() - 1; idx > 0; --idx) {
            char c = path.charAt(idx);
            if (c == '.') {
                if (++adjacentDots < 2) continue;
                return null;
            }
            if (c == sep) {
                if (adjacentDots == 1 && nonDotCount == 0) {
                    return null;
                }
                if (idx == 0 || idx >= last - 1 || path.charAt(idx - 1) == sep) {
                    return null;
                }
                return path.substring(0, idx);
            }
            ++nonDotCount;
            adjacentDots = 0;
        }
        return null;
    }

    private native int getBooleanAttributes0(String var1);

    @Override
    public int getBooleanAttributes(File f) {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        int rv = this.getBooleanAttributes0(f.getPath());
        String name = f.getName();
        boolean hidden = name.length() > 0 && name.charAt(0) == '.';
        return rv | (hidden ? 8 : 0);
    }

    @Override
    public boolean checkAccess(File f, int access) {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.checkAccess0(f, access);
    }

    private native boolean checkAccess0(File var1, int var2);

    @Override
    public long getLastModifiedTime(File f) {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.getLastModifiedTime0(f);
    }

    private native long getLastModifiedTime0(File var1);

    @Override
    public long getLength(File f) {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.getLength0(f);
    }

    private native long getLength0(File var1);

    @Override
    public boolean setPermission(File f, int access, boolean enable, boolean owneronly) {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        return this.setPermission0(f, access, enable, owneronly);
    }

    private native boolean setPermission0(File var1, int var2, boolean var3, boolean var4);

    @Override
    public boolean createFileExclusively(String path) throws IOException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        return this.createFileExclusively0(path);
    }

    private native boolean createFileExclusively0(String var1) throws IOException;

    @Override
    public boolean delete(File f) {
        this.cache.clear();
        this.javaHomePrefixCache.clear();
        BlockGuard.getThreadPolicy().onWriteToDisk();
        return this.delete0(f);
    }

    private native boolean delete0(File var1);

    @Override
    public String[] list(File f) {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.list0(f);
    }

    private native String[] list0(File var1);

    @Override
    public boolean createDirectory(File f) {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        return this.createDirectory0(f);
    }

    private native boolean createDirectory0(File var1);

    @Override
    public boolean rename(File f1, File f2) {
        this.cache.clear();
        this.javaHomePrefixCache.clear();
        BlockGuard.getThreadPolicy().onWriteToDisk();
        return this.rename0(f1, f2);
    }

    private native boolean rename0(File var1, File var2);

    @Override
    public boolean setLastModifiedTime(File f, long time) {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        return this.setLastModifiedTime0(f, time);
    }

    private native boolean setLastModifiedTime0(File var1, long var2);

    @Override
    public boolean setReadOnly(File f) {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        return this.setReadOnly0(f);
    }

    private native boolean setReadOnly0(File var1);

    @Override
    public File[] listRoots() {
        try {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead("/");
            }
            return new File[]{new File("/")};
        }
        catch (SecurityException x) {
            return new File[0];
        }
    }

    @Override
    public long getSpace(File f, int t) {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        return this.getSpace0(f, t);
    }

    private native long getSpace0(File var1, int var2);

    @Override
    public int compare(File f1, File f2) {
        return f1.getPath().compareTo(f2.getPath());
    }

    @Override
    public int hashCode(File f) {
        return f.getPath().hashCode() ^ 0x12D591;
    }

    private static native void initIDs();

    static {
        UnixFileSystem.initIDs();
    }
}

