/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import android.system.ErrnoException;
import android.system.OsConstants;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import libcore.io.IoBridge;
import libcore.io.IoTracker;
import libcore.io.Libcore;
import sun.nio.ch.FileChannelImpl;

public class RandomAccessFile
implements DataOutput,
DataInput,
Closeable {
    private final CloseGuard guard = CloseGuard.get();
    private final byte[] scratch = new byte[8];
    private boolean syncMetadata = false;
    private int mode;
    private FileDescriptor fd;
    private FileChannel channel = null;
    private boolean rw;
    private final String path;
    private Object closeLock = new Object();
    private volatile boolean closed = false;
    private final IoTracker ioTracker = new IoTracker();

    public RandomAccessFile(String name, String mode) throws FileNotFoundException {
        this(name != null ? new File(name) : null, mode);
    }

    public RandomAccessFile(File file, String mode) throws FileNotFoundException {
        String name = file != null ? file.getPath() : null;
        int imode = -1;
        if (mode.equals("r")) {
            imode = OsConstants.O_RDONLY;
        } else if (mode.startsWith("rw")) {
            imode = OsConstants.O_RDWR | OsConstants.O_CREAT;
            this.rw = true;
            if (mode.length() > 2) {
                if (mode.equals("rws")) {
                    this.syncMetadata = true;
                } else {
                    imode = mode.equals("rwd") ? (imode |= OsConstants.O_SYNC) : -1;
                }
            }
        }
        if (imode < 0) {
            throw new IllegalArgumentException("Illegal mode \"" + mode + "\" must be one of \"r\", \"rw\", \"rws\", or \"rwd\"");
        }
        if (name == null) {
            throw new NullPointerException("file == null");
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.path = name;
        this.mode = imode;
        this.fd = IoBridge.open(name, imode);
        if (this.syncMetadata) {
            try {
                this.fd.sync();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.guard.open("close");
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileChannel getChannel() {
        RandomAccessFile randomAccessFile = this;
        synchronized (randomAccessFile) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.fd, this.path, true, this.rw, this);
            }
            return this.channel;
        }
    }

    public int read() throws IOException {
        return this.read(this.scratch, 0, 1) != -1 ? this.scratch[0] & 0xFF : -1;
    }

    private int readBytes(byte[] b, int off, int len) throws IOException {
        this.ioTracker.trackIo(len, IoTracker.Mode.READ);
        return IoBridge.read(this.fd, b, off, len);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.readBytes(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.readBytes(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = this.read(b, off + n, len - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        long len;
        if (n <= 0) {
            return 0;
        }
        long pos = this.getFilePointer();
        long newpos = pos + (long)n;
        if (newpos > (len = this.length())) {
            newpos = len;
        }
        this.seek(newpos);
        return (int)(newpos - pos);
    }

    @Override
    public void write(int b) throws IOException {
        this.scratch[0] = (byte)(b & 0xFF);
        this.write(this.scratch, 0, 1);
    }

    private void writeBytes(byte[] b, int off, int len) throws IOException {
        this.ioTracker.trackIo(len, IoTracker.Mode.WRITE);
        IoBridge.write(this.fd, b, off, len);
        if (this.syncMetadata) {
            this.fd.sync();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    public long getFilePointer() throws IOException {
        try {
            return Libcore.os.lseek(this.fd, 0L, OsConstants.SEEK_CUR);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("offset < 0: " + pos);
        }
        try {
            Libcore.os.lseek(this.fd, pos, OsConstants.SEEK_SET);
            this.ioTracker.reset();
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public long length() throws IOException {
        try {
            return Libcore.os.fstat((FileDescriptor)this.fd).st_size;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public void setLength(long newLength) throws IOException {
        if (newLength < 0L) {
            throw new IllegalArgumentException("newLength < 0");
        }
        try {
            Libcore.os.ftruncate(this.fd, newLength);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
        long filePointer = this.getFilePointer();
        if (filePointer > newLength) {
            this.seek(newLength);
        }
        if (this.syncMetadata) {
            this.fd.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.guard.close();
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
        IoBridge.closeAndSignalBlockedThreads(this.fd);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public final short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    @Override
    public final char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public final int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    @Override
    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)(v >>> 0) & 0xFF);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        int len = s.length();
        byte[] b = new byte[len];
        s.getBytes(0, len, b, 0);
        this.writeBytes(b, 0, len);
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int clen = s.length();
        int blen = 2 * clen;
        byte[] b = new byte[blen];
        char[] c = new char[clen];
        s.getChars(0, clen, c, 0);
        int j = 0;
        for (int i = 0; i < clen; ++i) {
            b[j++] = (byte)(c[i] >>> 8);
            b[j++] = (byte)(c[i] >>> 0);
        }
        this.writeBytes(b, 0, blen);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        DataOutputStream.writeUTF(str, this);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

