/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.lang.reflect.Field;
import sun.reflect.CallerSensitive;

public class ObjectStreamField
implements Comparable<Object> {
    private final String name;
    private final String signature;
    private final Class<?> type;
    private final boolean unshared;
    private final Field field;
    private int offset = 0;

    public ObjectStreamField(String name, Class<?> type) {
        this(name, type, false);
    }

    public ObjectStreamField(String name, Class<?> type, boolean unshared) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.type = type;
        this.unshared = unshared;
        this.signature = ObjectStreamField.getClassSignature(type).intern();
        this.field = null;
    }

    ObjectStreamField(String name, String signature, boolean unshared) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.signature = signature.intern();
        this.unshared = unshared;
        this.field = null;
        switch (signature.charAt(0)) {
            case 'Z': {
                this.type = Boolean.TYPE;
                break;
            }
            case 'B': {
                this.type = Byte.TYPE;
                break;
            }
            case 'C': {
                this.type = Character.TYPE;
                break;
            }
            case 'S': {
                this.type = Short.TYPE;
                break;
            }
            case 'I': {
                this.type = Integer.TYPE;
                break;
            }
            case 'J': {
                this.type = Long.TYPE;
                break;
            }
            case 'F': {
                this.type = Float.TYPE;
                break;
            }
            case 'D': {
                this.type = Double.TYPE;
                break;
            }
            case 'L': 
            case '[': {
                this.type = Object.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal signature");
            }
        }
    }

    ObjectStreamField(Field field, boolean unshared, boolean showType) {
        this.field = field;
        this.unshared = unshared;
        this.name = field.getName();
        Class<?> ftype = field.getType();
        this.type = showType || ftype.isPrimitive() ? ftype : Object.class;
        this.signature = ObjectStreamField.getClassSignature(ftype).intern();
    }

    public String getName() {
        return this.name;
    }

    @CallerSensitive
    public Class<?> getType() {
        return this.type;
    }

    public char getTypeCode() {
        return this.signature.charAt(0);
    }

    public String getTypeString() {
        return this.isPrimitive() ? null : this.signature;
    }

    public int getOffset() {
        return this.offset;
    }

    protected void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean isPrimitive() {
        char tcode = this.signature.charAt(0);
        return tcode != 'L' && tcode != '[';
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    @Override
    public int compareTo(Object obj) {
        ObjectStreamField other = (ObjectStreamField)obj;
        boolean isPrim = this.isPrimitive();
        if (isPrim != other.isPrimitive()) {
            return isPrim ? -1 : 1;
        }
        return this.name.compareTo(other.name);
    }

    public String toString() {
        return this.signature + ' ' + this.name;
    }

    Field getField() {
        return this.field;
    }

    String getSignature() {
        return this.signature;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getClassSignature(Class<?> cl) {
        StringBuilder sbuf = new StringBuilder();
        while (cl.isArray()) {
            sbuf.append('[');
            cl = cl.getComponentType();
        }
        if (cl.isPrimitive()) {
            if (cl == Integer.TYPE) {
                sbuf.append('I');
                return sbuf.toString();
            } else if (cl == Byte.TYPE) {
                sbuf.append('B');
                return sbuf.toString();
            } else if (cl == Long.TYPE) {
                sbuf.append('J');
                return sbuf.toString();
            } else if (cl == Float.TYPE) {
                sbuf.append('F');
                return sbuf.toString();
            } else if (cl == Double.TYPE) {
                sbuf.append('D');
                return sbuf.toString();
            } else if (cl == Short.TYPE) {
                sbuf.append('S');
                return sbuf.toString();
            } else if (cl == Character.TYPE) {
                sbuf.append('C');
                return sbuf.toString();
            } else if (cl == Boolean.TYPE) {
                sbuf.append('Z');
                return sbuf.toString();
            } else {
                if (cl != Void.TYPE) throw new InternalError();
                sbuf.append('V');
            }
            return sbuf.toString();
        } else {
            sbuf.append('L' + cl.getName().replace('.', '/') + ';');
        }
        return sbuf.toString();
    }
}

