/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import libcore.io.IoBridge;
import libcore.io.IoTracker;
import sun.nio.ch.FileChannelImpl;

public class FileOutputStream
extends OutputStream {
    private final FileDescriptor fd;
    private final boolean append;
    private FileChannel channel;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;
    private final String path;
    private final CloseGuard guard = CloseGuard.get();
    private final boolean isFdOwner;
    private final IoTracker tracker = new IoTracker();

    public FileOutputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null, false);
    }

    public FileOutputStream(String name, boolean append) throws FileNotFoundException {
        this(name != null ? new File(name) : null, append);
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean append) throws FileNotFoundException {
        String name = file != null ? file.getPath() : null;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(name);
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.append = append;
        this.path = name;
        this.isFdOwner = true;
        BlockGuard.getThreadPolicy().onWriteToDisk();
        this.open(name, append);
        this.guard.open("close");
    }

    public FileOutputStream(FileDescriptor fdObj) {
        this(fdObj, false);
    }

    public FileOutputStream(FileDescriptor fdObj, boolean isFdOwner) {
        if (fdObj == null) {
            throw new NullPointerException("fdObj == null");
        }
        this.fd = fdObj;
        this.path = null;
        this.append = false;
        this.isFdOwner = isFdOwner;
    }

    private native void open0(String var1, boolean var2) throws FileNotFoundException;

    private void open(String name, boolean append) throws FileNotFoundException {
        this.open0(name, append);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed && len > 0) {
            throw new IOException("Stream Closed");
        }
        this.tracker.trackIo(len);
        IoBridge.write(this.fd, b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.guard.close();
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.isFdOwner) {
            IoBridge.closeAndSignalBlockedThreads(this.fd);
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileOutputStream fileOutputStream = this;
        synchronized (fileOutputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.fd, this.path, false, true, this.append, this);
            }
            return this.channel;
        }
    }

    protected void finalize() throws IOException {
        if (this.guard != null) {
            this.guard.warnIfOpen();
        }
        if (this.fd != null) {
            if (this.fd == FileDescriptor.out || this.fd == FileDescriptor.err) {
                this.flush();
            } else {
                this.close();
            }
        }
    }
}

