/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import libcore.io.IoBridge;
import libcore.io.IoTracker;
import sun.nio.ch.FileChannelImpl;

public class FileInputStream
extends InputStream {
    private final FileDescriptor fd;
    private final String path;
    private FileChannel channel = null;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;
    private final boolean isFdOwner;
    private final CloseGuard guard = CloseGuard.get();
    private final IoTracker tracker = new IoTracker();

    public FileInputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        String name = file != null ? file.getPath() : null;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(name);
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.isFdOwner = true;
        this.path = name;
        BlockGuard.getThreadPolicy().onReadFromDisk();
        this.open(name);
        this.guard.open("close");
    }

    public FileInputStream(FileDescriptor fdObj) {
        this(fdObj, false);
    }

    public FileInputStream(FileDescriptor fdObj, boolean isFdOwner) {
        if (fdObj == null) {
            throw new NullPointerException("fdObj == null");
        }
        this.fd = fdObj;
        this.isFdOwner = isFdOwner;
        this.path = null;
    }

    private native void open0(String var1) throws FileNotFoundException;

    private void open(String name) throws FileNotFoundException {
        this.open0(name);
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        return this.read(b, 0, 1) != -1 ? b[0] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed && len > 0) {
            throw new IOException("Stream Closed");
        }
        this.tracker.trackIo(len);
        return IoBridge.read(this.fd, b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
        try {
            BlockGuard.getThreadPolicy().onReadFromDisk();
            return this.skip0(n);
        }
        catch (UseManualSkipException e) {
            return super.skip(n);
        }
    }

    private native long skip0(long var1) throws IOException, UseManualSkipException;

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
        return this.available0();
    }

    private native int available0() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.guard.close();
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.isFdOwner) {
            IoBridge.closeAndSignalBlockedThreads(this.fd);
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileInputStream fileInputStream = this;
        synchronized (fileInputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.fd, this.path, true, false, this);
            }
            return this.channel;
        }
    }

    protected void finalize() throws IOException {
        if (this.guard != null) {
            this.guard.warnIfOpen();
        }
        if (this.fd != null && this.fd != FileDescriptor.in) {
            this.close();
        }
    }

    private static class UseManualSkipException
    extends Exception {
        private UseManualSkipException() {
        }
    }
}

