/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import java.io.SyncFailedException;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

public final class FileDescriptor {
    private int descriptor;
    public static final FileDescriptor in = FileDescriptor.dupFd(0);
    public static final FileDescriptor out = FileDescriptor.dupFd(1);
    public static final FileDescriptor err = FileDescriptor.dupFd(2);

    public FileDescriptor() {
        this.descriptor = -1;
    }

    private FileDescriptor(int descriptor) {
        this.descriptor = descriptor;
    }

    public boolean valid() {
        return this.descriptor != -1;
    }

    public native void sync() throws SyncFailedException;

    public final int getInt$() {
        return this.descriptor;
    }

    public final void setInt$(int fd) {
        this.descriptor = fd;
    }

    public boolean isSocket$() {
        return FileDescriptor.isSocket(this.descriptor);
    }

    private static FileDescriptor dupFd(int fd) {
        try {
            return new FileDescriptor(Os.fcntlInt(new FileDescriptor(fd), OsConstants.F_DUPFD_CLOEXEC, 0));
        }
        catch (ErrnoException e) {
            throw new RuntimeException(e);
        }
    }

    private static native boolean isSocket(int var0);

    static {
        SharedSecrets.setJavaIOFileDescriptorAccess(new JavaIOFileDescriptorAccess(){

            @Override
            public void set(FileDescriptor obj, int fd) {
                obj.descriptor = fd;
            }

            @Override
            public int get(FileDescriptor obj) {
                return obj.descriptor;
            }

            @Override
            public void setHandle(FileDescriptor obj, long handle) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getHandle(FileDescriptor obj) {
                throw new UnsupportedOperationException();
            }
        });
    }
}

