# apparmor.d - Full set of apparmor profiles
# Copyright (C) 2023-2024 Alexandre Pujol <alexandre@pujol.io>
# SPDX-License-Identifier: GPL-2.0-only

abi <abi/4.0>,

include <tunables/global>

@{name} = {E,e}lement
@{domain} = org.chromium.Chromium
@{lib_dirs} = @{lib}/@{name}
@{config_dirs} = @{user_config_dirs}/@{name}
@{cache_dirs} = @{user_cache_dirs}/@{name}

@{exec_path} = @{bin}/element-desktop
@{att} = /att/element-desktop/
profile element-desktop /{,usr/}bin/element-desktop  flags=(attach_disconnected,attach_disconnected.path=@{att},complain) {
  include <abstractions/attached/base>
  include <abstractions/audio-client>
  include <abstractions/bus/com.canonical.Unity.LauncherEntry>
  include <abstractions/bus/org.kde.StatusNotifierWatcher>
  include <abstractions/common/electron>
  include <abstractions/p11-kit>
  include <abstractions/screensaver>
  include <abstractions/video>

  network inet dgram,
  network inet6 dgram,
  network inet stream,
  network inet6 stream,
  network netlink raw,

  @{exec_path} mr,


  @{bin}/xdg-settings  rpx -> element-desktop//&xdg-settings,
  @{open_path}          px -> child-open-strict,

  /usr/share/webapps/element/{,**} r,

  /etc/webapps/element/{,**} r,

  /dev/tty rw,

  deny / r,
  deny @{HOME}/ r,
  deny @{user_share_dirs}/gvfs-metadata/* r,
  deny /etc/machine-id r,
  deny /var/lib/dbus/machine-id r,

  # Stacked profile: xdg-settings
  include <abstractions/consoles>
  include <abstractions/freedesktop.org>
  @{sh_path}        mr,
  @{bin}/{,e}grep  rix,
  @{bin}/basename  rix,
  @{bin}/cat        ix,
  @{bin}/cut       rix,
  @{bin}/head       ix,
  @{bin}/mkdir      ix,
  @{bin}/mktemp     ix,
  @{bin}/mv         ix,
  @{bin}/readlink   ix,
  @{bin}/realpath  rix,
  @{bin}/rm         ix,
  @{bin}/sed        ix,
  @{bin}/sleep      ix,
  @{bin}/sort       ix,
  @{bin}/touch      ix,
  @{bin}/tr         ix,
  @{bin}/uname      ix,
  @{bin}/wc         ix,
  # To set/get DE information
  @{bin}/gconftool{,-2}       ix,
  @{bin}/kde{,4}-config       ix,
  @{bin}/kwriteconfig{,5,6}   ix,
  @{bin}/qtxdg-mat            ix,
  @{bin}/dbus-send            Cx -> bus,
  @{bin}/kreadconfig{,5}      Px,
  @{bin}/xdg-mime             Px,
  @{bin}/xprop                Px,
  owner @{user_config_dirs}/xfce4/helpers.rc{,.@{rand6}} rw,
  owner @{user_share_dirs}/applications/{,**} rw,
  @{PROC}/version r,
  owner /dev/pts/@{int} rw,
  profile bus flags=(complain) {
    include <abstractions/app/bus>
    include <abstractions/bus-session>
    include if exists <local/xdg-settings_bus>
  }
  include if exists <local/xdg-settings>

  include if exists <local/element-desktop>
}

# vim:syntax=apparmor
