/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.urlassistant.util.InsertCodeHandler;
import com.google.urlassistant.util.StatementFilter;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\u0016\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/google/urlassistant/util/InsertJavaCodeHandler;", "Lcom/google/urlassistant/util/InsertCodeHandler;", "activity", "Lcom/intellij/psi/PsiClass;", "<init>", "(Lcom/intellij/psi/PsiClass;)V", "project", "Lcom/intellij/openapi/project/Project;", "activityOnCreateMethod", "Lcom/intellij/psi/PsiCodeBlock;", "shouldInvoke", "Lcom/google/urlassistant/util/InsertCodeHandler$CodeInsertErrorCode;", "invoke", "", "maybeInsertImportList", "maybeAddStatementsToMethod", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/psi/PsiElement;", "hasImportStatement", "", "importList", "Lcom/intellij/psi/PsiImportList;", "className", "", "getOnCreate", "Companion", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nInsertJavaCodeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsertJavaCodeHandler.kt\ncom/google/urlassistant/util/InsertJavaCodeHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n11158#2:169\n11493#2,3:170\n1#3:173\n*S KotlinDebug\n*F\n+ 1 InsertJavaCodeHandler.kt\ncom/google/urlassistant/util/InsertJavaCodeHandler\n*L\n57#1:169\n57#1:170,3\n*E\n"})
public final class InsertJavaCodeHandler
extends InsertCodeHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiClass activity;
    @NotNull
    private final Project project;
    @Nullable
    private final PsiCodeBlock activityOnCreateMethod;
    @NotNull
    private static final Set<String> ON_CREATE_POSSIBLE_PARAM_TYPES;
    @NotNull
    private static final List<String> STATEMENTS_LIST;

    public InsertJavaCodeHandler(@NotNull PsiClass activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activity = activity;
        Project project = this.activity.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.activityOnCreateMethod = this.getOnCreate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public InsertCodeHandler.CodeInsertErrorCode shouldInvoke() {
        void $this$mapTo$iv$iv;
        if (this.activityOnCreateMethod == null) {
            return InsertCodeHandler.CodeInsertErrorCode.NoOnCreateMethod;
        }
        PsiStatement[] psiStatementArray = this.activityOnCreateMethod.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)psiStatementArray, (String)"getStatements(...)");
        Object[] $this$map$iv = psiStatementArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiStatement psiStatement = (PsiStatement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getText());
        }
        if (((List)destination$iv$iv).containsAll((Collection)STATEMENTS_LIST)) {
            return InsertCodeHandler.CodeInsertErrorCode.AppLinksCodeConflict;
        }
        return InsertCodeHandler.CodeInsertErrorCode.SUCCEED;
    }

    @Override
    public void invoke() {
        if (this.shouldInvoke() != InsertCodeHandler.CodeInsertErrorCode.SUCCEED) {
            return;
        }
        Editor editor = FileEditorManager.getInstance((Project)this.project).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> InsertJavaCodeHandler.invoke$lambda$2(this, editor));
    }

    private final void maybeInsertImportList() {
        PsiFile psiFile = this.activity.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.PsiJavaFile");
        PsiImportList psiImportList = ((PsiJavaFile)psiFile).getImportList();
        if (psiImportList == null) {
            return;
        }
        PsiImportList importList = psiImportList;
        for (String importClass : InsertCodeHandler.Companion.getIMPORT_CLASSES_LIST$url_assistant()) {
            PsiImportStatement[] statements;
            if (ImportUtils.hasOnDemandImportConflict((String)importClass, (PsiElement)((PsiElement)this.activity)) || !ImportUtils.nameCanBeImported((String)importClass, (PsiElement)((PsiElement)this.activity)) || this.hasImportStatement(importList, importClass)) continue;
            String dummyFileName = "_Dummy_" + importClass + "_." + JavaFileType.INSTANCE.getDefaultExtension();
            PsiFile psiFile2 = PsiFileFactory.getInstance((Project)this.project).createFileFromText(dummyFileName, (FileType)JavaFileType.INSTANCE, (CharSequence)("import " + importClass + ";"));
            Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiJavaFile");
            PsiJavaFile aFile = (PsiJavaFile)psiFile2;
            PsiImportList dummyImportList = aFile.getImportList();
            if (dummyImportList == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)dummyImportList.getImportStatements(), (String)"getImportStatements(...)");
            importList.add((PsiElement)statements[0]);
        }
    }

    private final Pair<PsiElement, PsiElement> maybeAddStatementsToMethod() {
        if (this.activityOnCreateMethod == null) {
            return null;
        }
        JVMElementFactory elementFactory = JVMElementFactories.getFactory((Language)((Language)JavaLanguage.INSTANCE), (Project)this.project);
        if (elementFactory == null) {
            elementFactory = (JVMElementFactory)JavaPsiFacade.getElementFactory((Project)this.project);
        }
        JVMElementFactory jVMElementFactory = elementFactory;
        Intrinsics.checkNotNull((Object)jVMElementFactory, (String)"null cannot be cast to non-null type com.intellij.psi.PsiElementFactory");
        elementFactory = (JVMElementFactory)((PsiElementFactory)jVMElementFactory);
        PsiElement endElement = null;
        PsiComment it = ((PsiElementFactory)elementFactory).createCommentFromText("// ATTENTION: This was auto-generated to handle app links.", null);
        boolean bl = false;
        PsiElement beginElement = this.activityOnCreateMethod.add((PsiElement)it);
        for (String statement : STATEMENTS_LIST) {
            PsiStatement myStatement;
            PsiElement element;
            List<PsiStatement> myStatements;
            Intrinsics.checkNotNullExpressionValue(StatementFilter.filterCodeBlock(statement, this.activityOnCreateMethod), (String)"filterCodeBlock(...)");
            if (!myStatements.isEmpty()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((PsiElementFactory)elementFactory).createStatementFromText(statement, null), (String)"createStatementFromText(...)");
            endElement = element = this.activityOnCreateMethod.add((PsiElement)myStatement);
        }
        return Pair.create((Object)beginElement, endElement);
    }

    private final boolean hasImportStatement(PsiImportList importList, String className) {
        String string = className.substring(0, StringsKt.lastIndexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String packageName = string;
        PsiImportStatement singleImport = importList.findSingleClassImportStatement(className);
        PsiImportStatement onDemandImport = importList.findOnDemandImportStatement(packageName);
        return singleImport != null || onDemandImport != null;
    }

    private final PsiCodeBlock getOnCreate() {
        PsiMethod[] psiMethodArray = this.activity.findMethodsByName("onCreate", false);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
        for (PsiMethod psiMethod : psiMethodArray) {
            PsiType[] types;
            Intrinsics.checkNotNullExpressionValue((Object)psiMethod.getSignature(PsiSubstitutor.EMPTY).getParameterTypes(), (String)"getParameterTypes(...)");
            if (types.length != 1 || !ON_CREATE_POSSIBLE_PARAM_TYPES.contains(types[0].getCanonicalText())) continue;
            return psiMethod.getBody();
        }
        return null;
    }

    private static final void invoke$lambda$2$lambda$1(InsertJavaCodeHandler this$0, Editor $editor) {
        Pair<PsiElement, PsiElement> psiElementPair = this$0.maybeAddStatementsToMethod();
        this$0.maybeInsertImportList();
        if (psiElementPair == null) {
            return;
        }
        $editor.getSelectionModel().setSelection(((PsiElement)psiElementPair.first).getTextOffset(), ((PsiElement)psiElementPair.second).getTextRange().getEndOffset());
        $editor.getScrollingModel().scrollTo($editor.offsetToLogicalPosition(((PsiElement)psiElementPair.first).getTextOffset()), ScrollType.CENTER_UP);
    }

    private static final void invoke$lambda$2(InsertJavaCodeHandler this$0, Editor $editor) {
        CommandProcessor.getInstance().executeCommand(this$0.project, () -> InsertJavaCodeHandler.invoke$lambda$2$lambda$1(this$0, $editor), "Add intent filter handling logic", null);
    }

    static {
        Object[] objectArray = new String[]{"android.os.Bundle", "Bundle"};
        ON_CREATE_POSSIBLE_PARAM_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"Intent appLinkIntent = getIntent();", "String appLinkAction = appLinkIntent.getAction();", "Uri appLinkData = appLinkIntent.getData();"};
        STATEMENTS_LIST = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/google/urlassistant/util/InsertJavaCodeHandler$Companion;", "", "<init>", "()V", "ON_CREATE_POSSIBLE_PARAM_TYPES", "", "", "STATEMENTS_LIST", "", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

