/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.urlassistant.util.StatementFilter;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InsertCodeUtils {
    public static void maybeInsertImportList(@NotNull List<String> importClassesList, @NotNull PsiClass activity, @NotNull Project project) {
        for (String importClass : importClassesList) {
            InsertCodeUtils.maybeInsertImportStatement(importClass, activity, project);
        }
    }

    private static boolean maybeInsertImportStatement(@NotNull String className, @NotNull PsiClass activity, @NotNull Project project) {
        PsiImportList importList = ((PsiJavaFile)activity.getContainingFile()).getImportList();
        if (importList == null) {
            return false;
        }
        if (ImportUtils.hasOnDemandImportConflict((String)className, (PsiElement)activity) || !ImportUtils.nameCanBeImported((String)className, (PsiElement)activity) || InsertCodeUtils.hasImportStatement(importList, className)) {
            return false;
        }
        String dummyFileName = "_Dummy_" + className + "_." + JavaFileType.INSTANCE.getDefaultExtension();
        PsiJavaFile aFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText(dummyFileName, (FileType)JavaFileType.INSTANCE, (CharSequence)("import " + className + ";"));
        PsiImportList dummyImportList = aFile.getImportList();
        if (dummyImportList != null) {
            PsiImportStatement[] statements = dummyImportList.getImportStatements();
            PsiImportStatement statement = (PsiImportStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)statements[0]);
            importList.add((PsiElement)statement);
            return true;
        }
        return false;
    }

    @Nullable
    public static Pair<PsiElement, PsiElement> maybeAddStatementsToMethod(@NotNull List<String> statementsList, @NotNull PsiCodeBlock method, @NotNull Project project) {
        PsiElement beginElement = null;
        PsiElement endElement = null;
        JVMElementFactory elementFactory = JVMElementFactories.getFactory((Language)JavaLanguage.INSTANCE, (Project)project);
        if (elementFactory == null) {
            elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        }
        for (String statement : statementsList) {
            PsiElement element = InsertCodeUtils.maybeAddStatementToMethod(statement, method, (PsiElementFactory)elementFactory);
            if (element == null) continue;
            if (beginElement == null) {
                beginElement = element;
            }
            endElement = element;
        }
        return beginElement == null ? null : Pair.create(beginElement, endElement);
    }

    @Nullable
    private static PsiElement maybeAddStatementToMethod(@NotNull String statement, @NotNull PsiCodeBlock body, @NotNull PsiElementFactory factory) {
        List<PsiStatement> myStatements = StatementFilter.filterCodeBlock(statement, body);
        if (myStatements.isEmpty()) {
            PsiStatement myStatement = factory.createStatementFromText(statement, null);
            return body.add((PsiElement)myStatement);
        }
        return null;
    }

    @Nullable
    public static Pair<PsiElement, PsiElement> addCommentsBefore(@NotNull List<String> commentInJava, @NotNull PsiCodeBlock body, @NotNull Project project, @Nullable PsiElement anchor) {
        PsiElement beginElement = null;
        PsiElement endElement = null;
        JVMElementFactory elementFactory = JVMElementFactories.getFactory((Language)JavaLanguage.INSTANCE, (Project)project);
        if (elementFactory == null) {
            elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        }
        for (String text : commentInJava) {
            PsiElement element = body.addBefore((PsiElement)((PsiElementFactory)elementFactory).createCommentFromText(text, null), anchor);
            if (element == null) continue;
            if (beginElement == null) {
                beginElement = element;
            }
            endElement = element;
        }
        return beginElement == null ? null : Pair.create(beginElement, endElement);
    }

    public static boolean hasImportStatement(@NotNull PsiImportList importList, @NotNull String className) {
        String packageName = className.substring(0, className.lastIndexOf(46));
        PsiImportStatement singleImport = importList.findSingleClassImportStatement(className);
        PsiImportStatement onDemandImport = importList.findOnDemandImportStatement(packageName);
        return singleImport != null || onDemandImport != null;
    }

    @Nullable
    public static PsiCodeBlock getMethodBodyByName(@NotNull String name, @NotNull List<String> parametersTypeName, @NotNull PsiClass psiClass) {
        PsiMethod[] psiMethods;
        for (PsiMethod psiMethod : psiMethods = psiClass.findMethodsByName(name, false)) {
            PsiType[] types = psiMethod.getSignature(PsiSubstitutor.EMPTY).getParameterTypes();
            if (types.length != parametersTypeName.size()) continue;
            boolean correctSignature = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i].getCanonicalText().equals(parametersTypeName.get(i))) continue;
                correctSignature = false;
                break;
            }
            if (!correctSignature) continue;
            return psiMethod.getBody();
        }
        return null;
    }
}

