/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.android.annotations.concurrency.UiThread;
import com.google.urlassistant.ui.Accordion;
import com.google.urlassistant.ui.UiUtils;
import com.google.urlassistant.ui.UrlAssistantSidePanel;
import com.google.urlassistant.ui.models.DuplicateIntentFiltersAccordionInfo;
import com.google.urlassistant.ui.models.Explanation;
import com.google.urlassistant.ui.models.ManualIntentFilterFixModel;
import com.google.urlassistant.ui.models.SingleIntentFilterAccordionInfo;
import com.google.urlassistant.util.CaretUtilsKt;
import com.google.urlassistant.util.TextFileSelection;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.google.urlassistant.util.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/google/urlassistant/ui/ManualIntentFilterFix;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "sidePanelParent", "Lcom/google/urlassistant/ui/UrlAssistantSidePanel;", "model", "Lcom/google/urlassistant/ui/models/ManualIntentFilterFixModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/google/urlassistant/ui/UrlAssistantSidePanel;Lcom/google/urlassistant/ui/models/ManualIntentFilterFixModel;)V", "makeAccordionBody", "accordionInfo", "Lcom/google/urlassistant/ui/models/SingleIntentFilterAccordionInfo;", "logEventAndSetCaretPosition", "", "reference", "Lcom/google/urlassistant/util/TextFileSelection;", "validateAndPaint", "dispose", "Companion", "url-assistant"})
public final class ManualIntentFilterFix
extends JPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private static final JBColor ACCORDION_COLOR = JBColor.WHITE;

    public ManualIntentFilterFix(@NotNull Project project, @NotNull UrlAssistantSidePanel sidePanelParent, @NotNull ManualIntentFilterFixModel model2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sidePanelParent, (String)"sidePanelParent");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super(new GridBagLayout());
        this.project = project;
        Disposer.register((Disposable)sidePanelParent, (Disposable)this);
        UsageTrackerUtils.INSTANCE.log(this.project, (Function1<? super AppLinksAssistantEvent.Builder, AppLinksAssistantEvent.Builder>)((Function1)ManualIntentFilterFix::_init_$lambda$0));
        Object object = UiUtils.createConstraintsForRow$default(UiUtils.INSTANCE, 0, 0, 3, null);
        GridBagConstraints gridBagConstraints = object;
        Component component = UiUtils.INSTANCE.createBackButtonRow(sidePanelParent);
        ManualIntentFilterFix manualIntentFilterFix = this;
        boolean bl = false;
        $this$_init__u24lambda_u241.insets = (Insets)JBUI.insetsBottom((int)12);
        Unit unit = Unit.INSTANCE;
        manualIntentFilterFix.add(component, object);
        String string = UrlAssistantBundle.message("manual.fix.explanation", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        object = UiUtils.createConstraintsForRow$default(UiUtils.INSTANCE, 1, 0, 2, null);
        GridBagConstraints $this$_init__u24lambda_u241 = object;
        component = (Component)((Object)new UiUtils.MultilineText(string));
        manualIntentFilterFix = this;
        boolean bl2 = false;
        $this$_init__u24lambda_u2432.insets = (Insets)JBUI.insetsBottom((int)12);
        unit = Unit.INSTANCE;
        manualIntentFilterFix.add(component, object);
        object = ((Iterable)model2.getSingleIntentFilterAccordionInfos()).iterator();
        int $this$_init__u24lambda_u2432 = 0;
        while (object.hasNext()) {
            int i = $this$_init__u24lambda_u2432++;
            final SingleIntentFilterAccordionInfo accordionInfo = (SingleIntentFilterAccordionInfo)object.next();
            Disposable disposable = this;
            JBColor jBColor = ACCORDION_COLOR;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"ACCORDION_COLOR");
            Accordion accordion = new Accordion(disposable, (Color)jBColor, this.makeAccordionBody(accordionInfo), (JLabel)new JBLabel(accordionInfo.getInterpretedUrlPattern()), true, null, 32, null);
            accordion.addListener(this, arg_0 -> ManualIntentFilterFix._init_$lambda$3(this, accordionInfo, arg_0));
            accordion.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.logEventAndSetCaretPosition(accordionInfo.getReference());
                }
            });
            this.add((Component)accordion, UiUtils.createConstraintsForRow$default(UiUtils.INSTANCE, 2 + i, 0, 2, null));
        }
        int gridyAfterSingleIntentFilterAccordions = 2 + model2.getSingleIntentFilterAccordionInfos().size();
        Iterator $this$_init__u24lambda_u2432 = ((Iterable)model2.getDuplicatedIntentFilterAccordionInfos()).iterator();
        int n = 0;
        while ($this$_init__u24lambda_u2432.hasNext()) {
            int accordionIdx = n++;
            DuplicateIntentFiltersAccordionInfo accordionInfo = (DuplicateIntentFiltersAccordionInfo)$this$_init__u24lambda_u2432.next();
            JPanel accordionBody = new JPanel(new GridBagLayout());
            accordionBody.add((Component)((Object)new UiUtils.MultilineText(accordionInfo.getExplanation().getMessage())), UiUtils.createConstraintsForRow$default(UiUtils.INSTANCE, 0, 0, 3, null));
            accordionBody.add((Component)UiUtils.INSTANCE.createLearnMoreHyperlinkRow(accordionInfo.getExplanation().getReferenceLink()), UiUtils.createConstraintsForRow$default(UiUtils.INSTANCE, 1, 0, 2, null));
            Iterator iterator2 = ((Iterable)accordionInfo.getReferences()).iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                int duplicatesIdx = n2++;
                TextFileSelection duplicatedLinkReference = (TextFileSelection)iterator2.next();
                Object[] objectArray = new Object[]{duplicatesIdx + 1};
                JButton linkToDuplicate = UiUtils.INSTANCE.giveLinkStyles(new JButton(UrlAssistantBundle.message("manual.fix.duplicate.link", objectArray)), this);
                linkToDuplicate.addActionListener(arg_0 -> ManualIntentFilterFix._init_$lambda$4(this, duplicatedLinkReference, arg_0));
                accordionBody.add((Component)linkToDuplicate, UiUtils.createConstraintsForRow$default(UiUtils.INSTANCE, 2 + duplicatesIdx, 0, 2, null));
            }
            Disposable disposable = this;
            JBColor jBColor = ACCORDION_COLOR;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"ACCORDION_COLOR");
            Accordion accordion = new Accordion(disposable, (Color)jBColor, accordionBody, (JLabel)new JBLabel(accordionInfo.getInterpretedUrlPattern()), false, null, 48, null);
            accordion.addListener(this, arg_0 -> ManualIntentFilterFix._init_$lambda$5(this, arg_0));
            this.add((Component)accordion, UiUtils.createConstraintsForRow$default(UiUtils.INSTANCE, gridyAfterSingleIntentFilterAccordions + accordionIdx, 0, 2, null));
        }
        int gridyAfterDuplicateIntentFiltersAccordions = gridyAfterSingleIntentFilterAccordions + model2.getDuplicatedIntentFilterAccordionInfos().size();
        this.add((Component)new JPanel(), UiUtils.createConstraintsForExpander$default(UiUtils.INSTANCE, gridyAfterDuplicateIntentFiltersAccordions, 0, 2, null));
    }

    private final JPanel makeAccordionBody(SingleIntentFilterAccordionInfo accordionInfo) {
        JPanel res = new JPanel(new GridBagLayout());
        Iterator iterator2 = ((Iterable)accordionInfo.getExplanations()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            GridBagConstraints gridBagConstraints;
            int i = n++;
            Explanation explanation = (Explanation)iterator2.next();
            JBLabel icon = new JBLabel(StudioIcons.Common.ERROR);
            UiUtils.MultilineText message = new UiUtils.MultilineText(explanation.getMessage());
            int iconTopInset = message.getFontMetrics(this.getFont()).getHeight() - icon.getPreferredSize().height;
            GridBagConstraints gridBagConstraints2 = gridBagConstraints = new GridBagConstraints();
            Component component = (Component)icon;
            JPanel jPanel = res;
            boolean bl = false;
            $this$makeAccordionBody_u24lambda_u246.gridy = 2 * i;
            $this$makeAccordionBody_u24lambda_u246.anchor = 18;
            $this$makeAccordionBody_u24lambda_u246.insets = (Insets)JBUI.insets((int)iconTopInset, (int)5, (int)5, (int)5);
            Unit unit = Unit.INSTANCE;
            jPanel.add(component, gridBagConstraints);
            res.add((Component)((Object)message), UiUtils.INSTANCE.createConstraintsForRow(2 * i, 1));
            res.add((Component)UiUtils.INSTANCE.createLearnMoreHyperlinkRow(explanation.getReferenceLink()), UiUtils.INSTANCE.createConstraintsForRow(2 * i + 1, 1));
        }
        return res;
    }

    private final void logEventAndSetCaretPosition(TextFileSelection reference) {
        UsageTrackerUtils.INSTANCE.log(this.project, (Function1<? super AppLinksAssistantEvent.Builder, AppLinksAssistantEvent.Builder>)((Function1)ManualIntentFilterFix::logEventAndSetCaretPosition$lambda$7));
        CaretUtilsKt.setSelection(this.project, reference);
    }

    private final void validateAndPaint() {
        this.revalidate();
        this.repaint();
    }

    public void dispose() {
    }

    private static final AppLinksAssistantEvent.Builder _init_$lambda$0(AppLinksAssistantEvent.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AppLinksAssistantEvent.Builder builder = it.setEventSource(AppLinksAssistantEvent.EventSource.MANUAL_FIX).setEventState(AppLinksAssistantEvent.EventState.OPENED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventState(...)");
        return builder;
    }

    private static final void _init_$lambda$3(ManualIntentFilterFix this$0, SingleIntentFilterAccordionInfo $accordionInfo, boolean it) {
        this$0.validateAndPaint();
        if (it) {
            this$0.logEventAndSetCaretPosition($accordionInfo.getReference());
        }
    }

    private static final void _init_$lambda$4(ManualIntentFilterFix this$0, TextFileSelection $duplicatedLinkReference, ActionEvent it) {
        this$0.logEventAndSetCaretPosition($duplicatedLinkReference);
    }

    private static final void _init_$lambda$5(ManualIntentFilterFix this$0, boolean it) {
        this$0.validateAndPaint();
    }

    private static final AppLinksAssistantEvent.Builder logEventAndSetCaretPosition$lambda$7(AppLinksAssistantEvent.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AppLinksAssistantEvent.Builder builder = it.setEventSource(AppLinksAssistantEvent.EventSource.MANUAL_FIX_ROW).setEventState(AppLinksAssistantEvent.EventState.OPENED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventState(...)");
        return builder;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/google/urlassistant/ui/ManualIntentFilterFix$Companion;", "", "<init>", "()V", "ACCORDION_COLOR", "Lcom/intellij/ui/JBColor;", "kotlin.jvm.PlatformType", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

