/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.datalayer.feature.listlinks;

import com.google.urlassistant.datalayer.feature.LinkInfoUtilsKt;
import com.google.urlassistant.datalayer.model.LinkType;
import com.google.urlassistant.datalayer.model.intentfilter.ActivityConfig;
import com.google.urlassistant.datalayer.model.intentfilter.IntentFilterConfig;
import com.google.urlassistant.datalayer.model.validation.appchecksummary.AppCheckSummary;
import com.google.urlassistant.datalayer.model.validation.singlelinkdatatagconfig.SingleLinkDataTagConfig;
import com.google.urlassistant.datalayer.model.validation.webchecksummary.webassociationcheck.WebAssociationMeta;
import com.google.urlassistant.datalayer.model.validation.webchecksummary.webassociationcheck.WebCheckSummary;
import java.util.Objects;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b,\b\u0080\b\u0018\u00002\u00020\u0001Bq\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0003\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u00100\u001a\u00020\u00002\b\u00101\u001a\u0004\u0018\u00010\u000eJ\u0013\u00102\u001a\u00020\n2\b\u00103\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00104\u001a\u00020\u0017H\u0016J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\u0005H\u00c6\u0003J\t\u00107\u001a\u00020\u0007H\u00c6\u0003J\u000f\u00108\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u00109\u001a\u00020\fH\u00c6\u0003J\u000b\u0010:\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010;\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\t\u0010<\u001a\u00020\u0012H\u00c6\u0003J\t\u0010=\u001a\u00020\u0014H\u00c6\u0003J\t\u0010>\u001a\u00020\u0003H\u00c6\u0003J\t\u0010?\u001a\u00020\u0017H\u00c6\u0003J\t\u0010@\u001a\u00020\u0017H\u00c6\u0003J\u008b\u0001\u0010A\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00032\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0017H\u00c6\u0001J\t\u0010B\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010!R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001cR\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010.\u00a8\u0006C"}, d2={"Lcom/google/urlassistant/datalayer/feature/listlinks/LinkInfo;", "", "interpretedUrlPattern", "", "singleLinkDataTagConfig", "Lcom/google/urlassistant/datalayer/model/validation/singlelinkdatatagconfig/SingleLinkDataTagConfig;", "linkType", "Lcom/google/urlassistant/datalayer/model/LinkType;", "isUnique", "Lkotlin/Lazy;", "", "appCheckSummary", "Lcom/google/urlassistant/datalayer/model/validation/appchecksummary/AppCheckSummary;", "webCheckSummary", "Lcom/google/urlassistant/datalayer/model/validation/webchecksummary/webassociationcheck/WebCheckSummary;", "webAssociationMeta", "Lcom/google/urlassistant/datalayer/model/validation/webchecksummary/webassociationcheck/WebAssociationMeta;", "activityConfig", "Lcom/google/urlassistant/datalayer/model/intentfilter/ActivityConfig;", "intentFilterConfig", "Lcom/google/urlassistant/datalayer/model/intentfilter/IntentFilterConfig;", "manifestFileLocation", "intentFilterStartOffset", "", "intentFilterEndOffset", "<init>", "(Ljava/lang/String;Lcom/google/urlassistant/datalayer/model/validation/singlelinkdatatagconfig/SingleLinkDataTagConfig;Lcom/google/urlassistant/datalayer/model/LinkType;Lkotlin/Lazy;Lcom/google/urlassistant/datalayer/model/validation/appchecksummary/AppCheckSummary;Lcom/google/urlassistant/datalayer/model/validation/webchecksummary/webassociationcheck/WebCheckSummary;Lcom/google/urlassistant/datalayer/model/validation/webchecksummary/webassociationcheck/WebAssociationMeta;Lcom/google/urlassistant/datalayer/model/intentfilter/ActivityConfig;Lcom/google/urlassistant/datalayer/model/intentfilter/IntentFilterConfig;Ljava/lang/String;II)V", "getInterpretedUrlPattern", "()Ljava/lang/String;", "getSingleLinkDataTagConfig", "()Lcom/google/urlassistant/datalayer/model/validation/singlelinkdatatagconfig/SingleLinkDataTagConfig;", "getLinkType", "()Lcom/google/urlassistant/datalayer/model/LinkType;", "()Lkotlin/Lazy;", "getAppCheckSummary", "()Lcom/google/urlassistant/datalayer/model/validation/appchecksummary/AppCheckSummary;", "getWebCheckSummary", "()Lcom/google/urlassistant/datalayer/model/validation/webchecksummary/webassociationcheck/WebCheckSummary;", "getWebAssociationMeta", "()Lcom/google/urlassistant/datalayer/model/validation/webchecksummary/webassociationcheck/WebAssociationMeta;", "getActivityConfig", "()Lcom/google/urlassistant/datalayer/model/intentfilter/ActivityConfig;", "getIntentFilterConfig", "()Lcom/google/urlassistant/datalayer/model/intentfilter/IntentFilterConfig;", "getManifestFileLocation", "getIntentFilterStartOffset", "()I", "getIntentFilterEndOffset", "withWebSummary", "summary", "equals", "other", "hashCode", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "copy", "toString", "url-assistant"})
public final class LinkInfo {
    @NotNull
    private final String interpretedUrlPattern;
    @NotNull
    private final SingleLinkDataTagConfig singleLinkDataTagConfig;
    @NotNull
    private final LinkType linkType;
    @NotNull
    private final Lazy<Boolean> isUnique;
    @NotNull
    private final AppCheckSummary appCheckSummary;
    @Nullable
    private final WebCheckSummary webCheckSummary;
    @Nullable
    private final WebAssociationMeta webAssociationMeta;
    @NotNull
    private final ActivityConfig activityConfig;
    @NotNull
    private final IntentFilterConfig intentFilterConfig;
    @NotNull
    private final String manifestFileLocation;
    private final int intentFilterStartOffset;
    private final int intentFilterEndOffset;

    public LinkInfo(@NotNull String interpretedUrlPattern, @NotNull SingleLinkDataTagConfig singleLinkDataTagConfig, @NotNull LinkType linkType, @NotNull Lazy<Boolean> isUnique, @NotNull AppCheckSummary appCheckSummary, @Nullable WebCheckSummary webCheckSummary, @Nullable WebAssociationMeta webAssociationMeta, @NotNull ActivityConfig activityConfig, @NotNull IntentFilterConfig intentFilterConfig, @NotNull String manifestFileLocation, int intentFilterStartOffset, int intentFilterEndOffset) {
        Intrinsics.checkNotNullParameter((Object)interpretedUrlPattern, (String)"interpretedUrlPattern");
        Intrinsics.checkNotNullParameter((Object)singleLinkDataTagConfig, (String)"singleLinkDataTagConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)linkType), (String)"linkType");
        Intrinsics.checkNotNullParameter(isUnique, (String)"isUnique");
        Intrinsics.checkNotNullParameter((Object)appCheckSummary, (String)"appCheckSummary");
        Intrinsics.checkNotNullParameter((Object)activityConfig, (String)"activityConfig");
        Intrinsics.checkNotNullParameter((Object)intentFilterConfig, (String)"intentFilterConfig");
        Intrinsics.checkNotNullParameter((Object)manifestFileLocation, (String)"manifestFileLocation");
        this.interpretedUrlPattern = interpretedUrlPattern;
        this.singleLinkDataTagConfig = singleLinkDataTagConfig;
        this.linkType = linkType;
        this.isUnique = isUnique;
        this.appCheckSummary = appCheckSummary;
        this.webCheckSummary = webCheckSummary;
        this.webAssociationMeta = webAssociationMeta;
        this.activityConfig = activityConfig;
        this.intentFilterConfig = intentFilterConfig;
        this.manifestFileLocation = manifestFileLocation;
        this.intentFilterStartOffset = intentFilterStartOffset;
        this.intentFilterEndOffset = intentFilterEndOffset;
    }

    @NotNull
    public final String getInterpretedUrlPattern() {
        return this.interpretedUrlPattern;
    }

    @NotNull
    public final SingleLinkDataTagConfig getSingleLinkDataTagConfig() {
        return this.singleLinkDataTagConfig;
    }

    @NotNull
    public final LinkType getLinkType() {
        return this.linkType;
    }

    @NotNull
    public final Lazy<Boolean> isUnique() {
        return this.isUnique;
    }

    @NotNull
    public final AppCheckSummary getAppCheckSummary() {
        return this.appCheckSummary;
    }

    @Nullable
    public final WebCheckSummary getWebCheckSummary() {
        return this.webCheckSummary;
    }

    @Nullable
    public final WebAssociationMeta getWebAssociationMeta() {
        return this.webAssociationMeta;
    }

    @NotNull
    public final ActivityConfig getActivityConfig() {
        return this.activityConfig;
    }

    @NotNull
    public final IntentFilterConfig getIntentFilterConfig() {
        return this.intentFilterConfig;
    }

    @NotNull
    public final String getManifestFileLocation() {
        return this.manifestFileLocation;
    }

    public final int getIntentFilterStartOffset() {
        return this.intentFilterStartOffset;
    }

    public final int getIntentFilterEndOffset() {
        return this.intentFilterEndOffset;
    }

    @NotNull
    public final LinkInfo withWebSummary(@Nullable WebCheckSummary summary) {
        boolean isWebScheme = LinkInfoUtilsKt.isWebScheme(this.singleLinkDataTagConfig.getScheme());
        return new LinkInfo(this.interpretedUrlPattern, this.singleLinkDataTagConfig, this.linkType, this.isUnique, this.appCheckSummary, isWebScheme ? summary : null, this.webAssociationMeta, this.activityConfig, this.intentFilterConfig, this.manifestFileLocation, this.intentFilterStartOffset, this.intentFilterEndOffset);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof LinkInfo)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.interpretedUrlPattern, (Object)((LinkInfo)other).interpretedUrlPattern) && Intrinsics.areEqual((Object)this.singleLinkDataTagConfig, (Object)((LinkInfo)other).singleLinkDataTagConfig) && this.linkType == ((LinkInfo)other).linkType && ((Boolean)this.isUnique.getValue()).booleanValue() == ((Boolean)((LinkInfo)other).isUnique.getValue()).booleanValue() && Intrinsics.areEqual((Object)this.appCheckSummary, (Object)((LinkInfo)other).appCheckSummary) && Intrinsics.areEqual((Object)this.webCheckSummary, (Object)((LinkInfo)other).webCheckSummary) && Intrinsics.areEqual((Object)this.webAssociationMeta, (Object)((LinkInfo)other).webAssociationMeta) && Intrinsics.areEqual((Object)this.activityConfig, (Object)((LinkInfo)other).activityConfig) && Intrinsics.areEqual((Object)this.intentFilterConfig, (Object)((LinkInfo)other).intentFilterConfig) && Intrinsics.areEqual((Object)this.manifestFileLocation, (Object)((LinkInfo)other).manifestFileLocation) && this.intentFilterStartOffset == ((LinkInfo)other).intentFilterStartOffset && this.intentFilterEndOffset == ((LinkInfo)other).intentFilterEndOffset;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.interpretedUrlPattern, this.singleLinkDataTagConfig, this.linkType, this.appCheckSummary, this.webCheckSummary, this.webAssociationMeta, this.activityConfig, this.intentFilterConfig, this.intentFilterStartOffset, this.intentFilterEndOffset};
        return Objects.hash(objectArray);
    }

    @NotNull
    public final String component1() {
        return this.interpretedUrlPattern;
    }

    @NotNull
    public final SingleLinkDataTagConfig component2() {
        return this.singleLinkDataTagConfig;
    }

    @NotNull
    public final LinkType component3() {
        return this.linkType;
    }

    @NotNull
    public final Lazy<Boolean> component4() {
        return this.isUnique;
    }

    @NotNull
    public final AppCheckSummary component5() {
        return this.appCheckSummary;
    }

    @Nullable
    public final WebCheckSummary component6() {
        return this.webCheckSummary;
    }

    @Nullable
    public final WebAssociationMeta component7() {
        return this.webAssociationMeta;
    }

    @NotNull
    public final ActivityConfig component8() {
        return this.activityConfig;
    }

    @NotNull
    public final IntentFilterConfig component9() {
        return this.intentFilterConfig;
    }

    @NotNull
    public final String component10() {
        return this.manifestFileLocation;
    }

    public final int component11() {
        return this.intentFilterStartOffset;
    }

    public final int component12() {
        return this.intentFilterEndOffset;
    }

    @NotNull
    public final LinkInfo copy(@NotNull String interpretedUrlPattern, @NotNull SingleLinkDataTagConfig singleLinkDataTagConfig, @NotNull LinkType linkType, @NotNull Lazy<Boolean> isUnique, @NotNull AppCheckSummary appCheckSummary, @Nullable WebCheckSummary webCheckSummary, @Nullable WebAssociationMeta webAssociationMeta, @NotNull ActivityConfig activityConfig, @NotNull IntentFilterConfig intentFilterConfig, @NotNull String manifestFileLocation, int intentFilterStartOffset, int intentFilterEndOffset) {
        Intrinsics.checkNotNullParameter((Object)interpretedUrlPattern, (String)"interpretedUrlPattern");
        Intrinsics.checkNotNullParameter((Object)singleLinkDataTagConfig, (String)"singleLinkDataTagConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)linkType), (String)"linkType");
        Intrinsics.checkNotNullParameter(isUnique, (String)"isUnique");
        Intrinsics.checkNotNullParameter((Object)appCheckSummary, (String)"appCheckSummary");
        Intrinsics.checkNotNullParameter((Object)activityConfig, (String)"activityConfig");
        Intrinsics.checkNotNullParameter((Object)intentFilterConfig, (String)"intentFilterConfig");
        Intrinsics.checkNotNullParameter((Object)manifestFileLocation, (String)"manifestFileLocation");
        return new LinkInfo(interpretedUrlPattern, singleLinkDataTagConfig, linkType, isUnique, appCheckSummary, webCheckSummary, webAssociationMeta, activityConfig, intentFilterConfig, manifestFileLocation, intentFilterStartOffset, intentFilterEndOffset);
    }

    public static /* synthetic */ LinkInfo copy$default(LinkInfo linkInfo, String string, SingleLinkDataTagConfig singleLinkDataTagConfig, LinkType linkType, Lazy lazy, AppCheckSummary appCheckSummary, WebCheckSummary webCheckSummary, WebAssociationMeta webAssociationMeta, ActivityConfig activityConfig, IntentFilterConfig intentFilterConfig, String string2, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = linkInfo.interpretedUrlPattern;
        }
        if ((n3 & 2) != 0) {
            singleLinkDataTagConfig = linkInfo.singleLinkDataTagConfig;
        }
        if ((n3 & 4) != 0) {
            linkType = linkInfo.linkType;
        }
        if ((n3 & 8) != 0) {
            lazy = linkInfo.isUnique;
        }
        if ((n3 & 0x10) != 0) {
            appCheckSummary = linkInfo.appCheckSummary;
        }
        if ((n3 & 0x20) != 0) {
            webCheckSummary = linkInfo.webCheckSummary;
        }
        if ((n3 & 0x40) != 0) {
            webAssociationMeta = linkInfo.webAssociationMeta;
        }
        if ((n3 & 0x80) != 0) {
            activityConfig = linkInfo.activityConfig;
        }
        if ((n3 & 0x100) != 0) {
            intentFilterConfig = linkInfo.intentFilterConfig;
        }
        if ((n3 & 0x200) != 0) {
            string2 = linkInfo.manifestFileLocation;
        }
        if ((n3 & 0x400) != 0) {
            n = linkInfo.intentFilterStartOffset;
        }
        if ((n3 & 0x800) != 0) {
            n2 = linkInfo.intentFilterEndOffset;
        }
        return linkInfo.copy(string, singleLinkDataTagConfig, linkType, lazy, appCheckSummary, webCheckSummary, webAssociationMeta, activityConfig, intentFilterConfig, string2, n, n2);
    }

    @NotNull
    public String toString() {
        return "LinkInfo(interpretedUrlPattern=" + this.interpretedUrlPattern + ", singleLinkDataTagConfig=" + this.singleLinkDataTagConfig + ", linkType=" + this.linkType + ", isUnique=" + this.isUnique + ", appCheckSummary=" + this.appCheckSummary + ", webCheckSummary=" + this.webCheckSummary + ", webAssociationMeta=" + this.webAssociationMeta + ", activityConfig=" + this.activityConfig + ", intentFilterConfig=" + this.intentFilterConfig + ", manifestFileLocation=" + this.manifestFileLocation + ", intentFilterStartOffset=" + this.intentFilterStartOffset + ", intentFilterEndOffset=" + this.intentFilterEndOffset + ")";
    }
}

