/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidSdkData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00052\u00020\u0001:\u0002\u0004\u0005B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/android/sdk/StudioAndroidSdkData;", "", "<init>", "()V", "ModuleSdkDataHolder", "Companion", "intellij.android.core"})
public final class StudioAndroidSdkData {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @Nullable
    public static final AndroidSdkData getSdkData(@NotNull AndroidFacet facet) {
        return Companion.getSdkData(facet);
    }

    @JvmStatic
    @NotNull
    public static final AndroidSdkHandler getSdkHolder(@NotNull AndroidFacet facet) {
        return Companion.getSdkHolder(facet);
    }

    @JvmStatic
    @Nullable
    public static final AndroidSdkData getSdkData(@NotNull Project project) {
        return Companion.getSdkData(project);
    }

    @JvmStatic
    @Nullable
    public static final AndroidSdkData getSdkData(@NotNull Sdk sdk) {
        return Companion.getSdkData(sdk);
    }

    @JvmStatic
    @Nullable
    public static final AndroidSdkData getSdkData(@NotNull Module module) {
        return Companion.getSdkData(module);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0017\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0017\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0017\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/android/sdk/StudioAndroidSdkData$Companion;", "", "<init>", "()V", "getSdkData", "Lcom/android/tools/sdk/AndroidSdkData;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getSdkHolder", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "Lorg/jetbrains/annotations/Nullable;", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nStudioAndroidSdkData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StudioAndroidSdkData.kt\norg/jetbrains/android/sdk/StudioAndroidSdkData$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final AndroidSdkData getSdkData(@NotNull AndroidFacet facet) {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            return ModuleSdkDataHolder.Companion.getInstance(facet).getSdkData();
        }

        @JvmStatic
        @NotNull
        public final AndroidSdkHandler getSdkHolder(@NotNull AndroidFacet facet) {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            return ModuleSdkDataHolder.Companion.getInstance(facet).getSdkHandler();
        }

        @JvmStatic
        @Nullable
        public final AndroidSdkData getSdkData(@NotNull Project project) {
            AndroidSdkData androidSdkData;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Sdk sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
            if (sdk != null) {
                Sdk it = sdk;
                boolean bl = false;
                androidSdkData = Companion.getSdkData(it);
            } else {
                androidSdkData = null;
            }
            return androidSdkData;
        }

        @JvmStatic
        @Nullable
        public final AndroidSdkData getSdkData(@NotNull Sdk sdk) {
            AndroidSdkData androidSdkData;
            Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
            String string = sdk.getHomePath();
            if (string != null) {
                String p0 = string;
                boolean bl = false;
                androidSdkData = AndroidSdkData.getSdkData(p0);
            } else {
                androidSdkData = null;
            }
            return androidSdkData;
        }

        @JvmStatic
        @Nullable
        public final AndroidSdkData getSdkData(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.getSdkData(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/android/sdk/StudioAndroidSdkData$ModuleSdkDataHolder;", "Lcom/intellij/openapi/Disposable;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "<init>", "(Lorg/jetbrains/android/facet/AndroidFacet;)V", "myFacet", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "getSdkHandler", "()Lcom/android/sdklib/repository/AndroidSdkHandler;", "sdkData", "Lcom/android/tools/sdk/AndroidSdkData;", "getSdkData", "()Lcom/android/tools/sdk/AndroidSdkData;", "dispose", "", "Companion", "intellij.android.core"})
    private static final class ModuleSdkDataHolder
    implements Disposable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private AndroidFacet myFacet;
        @NotNull
        private final AndroidSdkHandler sdkHandler;
        @Nullable
        private final AndroidSdkData sdkData;
        @NotNull
        private static final Key<ModuleSdkDataHolder> KEY;

        private ModuleSdkDataHolder(AndroidFacet facet) {
            AndroidPlatform platform;
            this.myFacet = facet;
            Disposer.register((Disposable)((Disposable)facet), (Disposable)this);
            Module module = facet.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
            AndroidPlatform androidPlatform = platform = AndroidPlatforms.getInstance(module);
            this.sdkData = androidPlatform != null ? androidPlatform.getSdkData() : null;
            AndroidSdkData androidSdkData = this.sdkData;
            if (androidSdkData == null || (androidSdkData = androidSdkData.getSdkHandler()) == null) {
                AndroidSdkHandler androidSdkHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE), null);
                androidSdkData = androidSdkHandler;
                Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"getInstance(...)");
            }
            this.sdkHandler = androidSdkData;
        }

        @NotNull
        public final AndroidSdkHandler getSdkHandler() {
            return this.sdkHandler;
        }

        @Nullable
        public final AndroidSdkData getSdkData() {
            return this.sdkData;
        }

        public void dispose() {
            AndroidFacet androidFacet = this.myFacet;
            Intrinsics.checkNotNull((Object)androidFacet);
            androidFacet.putUserData(KEY, null);
            this.myFacet = null;
        }

        public /* synthetic */ ModuleSdkDataHolder(AndroidFacet facet, DefaultConstructorMarker $constructor_marker) {
            this(facet);
        }

        static {
            Key key = Key.create((String)ModuleSdkDataHolder.class.getName());
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
            KEY = key;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/android/sdk/StudioAndroidSdkData$ModuleSdkDataHolder$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/android/sdk/StudioAndroidSdkData$ModuleSdkDataHolder;", "getInstance", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "intellij.android.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ModuleSdkDataHolder getInstance(@NotNull AndroidFacet facet) {
                Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
                ModuleSdkDataHolder sdkDataHolder = (ModuleSdkDataHolder)facet.getUserData(KEY);
                if (sdkDataHolder == null) {
                    sdkDataHolder = new ModuleSdkDataHolder(facet, null);
                    facet.putUserData(KEY, (Object)sdkDataHolder);
                }
                return sdkDataHolder;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

