/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExtractStyleDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JTextField myStyleNameField;
    private JPanel myAttributeListWrapper;
    private JBLabel myAttributesLabel;
    private JBLabel myModuleLabel;
    private ModulesComboBox myModuleCombo;
    private JBCheckBox mySearchForStyleApplicationsAfter;
    private final Module myModule;
    private final String myFileName;
    private final List<String> myDirNames;
    private final CheckboxTree myTree;
    private final CheckedTreeNode myRootNode;
    private static final String SEARCH_STYLE_APPLICATIONS_PROPERTY = "AndroidExtractStyleSearchStyleApplications";

    public ExtractStyleDialog(@NotNull Module module, @NotNull String fileName, @Nullable String parentStyleName, @NotNull List<String> dirNames, @NotNull List<XmlAttribute> attributes) {
        super(module.getProject());
        this.setupUI();
        this.myFileName = fileName;
        this.myDirNames = dirNames;
        if (parentStyleName != null && !parentStyleName.isEmpty()) {
            this.myStyleNameField.setText(parentStyleName + ".");
            this.myStyleNameField.selectAll();
        } else {
            String prefix = IdeResourcesUtil.prependResourcePrefix(module, null, ResourceFolderType.VALUES);
            if (prefix != null) {
                this.myStyleNameField.setText(prefix);
            }
        }
        HashSet<Module> modulesSet = new HashSet<Module>();
        modulesSet.add(module);
        for (AndroidFacet depFacet : AndroidDependenciesCache.getAllAndroidDependencies(module, true)) {
            modulesSet.add(depFacet.getModule());
        }
        assert (!modulesSet.isEmpty());
        if (modulesSet.size() == 1) {
            this.myModule = module;
            this.myModuleLabel.setVisible(false);
            this.myModuleCombo.setVisible(false);
        } else {
            this.myModule = null;
            this.myModuleCombo.setModules(modulesSet);
            this.myModuleCombo.setSelectedModule(module);
        }
        this.myRootNode = new CheckedTreeNode(null);
        for (XmlAttribute attribute2 : attributes) {
            this.myRootNode.add((MutableTreeNode)new CheckedTreeNode((Object)attribute2));
        }
        CheckboxTree.CheckboxTreeCellRenderer renderer2 = new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                XmlAttribute attribute2;
                if (value2 instanceof CheckedTreeNode && (attribute2 = (XmlAttribute)((CheckedTreeNode)value2).getUserObject()) != null) {
                    this.getTextRenderer().append(attribute2.getLocalName());
                    this.getTextRenderer().append(" [" + attribute2.getValue() + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        };
        this.myTree = new CheckboxTree(renderer2, this.myRootNode){

            protected void installSpeedSearch() {
                TreeSpeedSearch.installOn((JTree)((Object)this), (boolean)false, (Function)new Function<TreePath, String>(){

                    @Override
                    public String apply(TreePath path) {
                        XmlAttribute attribute2;
                        Object object = path.getLastPathComponent();
                        if (object instanceof CheckedTreeNode && (attribute2 = (XmlAttribute)((CheckedTreeNode)object).getUserObject()) != null) {
                            return attribute2.getLocalName();
                        }
                        return "";
                    }
                });
            }
        };
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        TreeUtil.expandAll((JTree)this.myTree);
        this.myAttributesLabel.setLabelFor((Component)this.myTree);
        ToolbarDecorator decorator2 = ToolbarDecorator.createDecorator((JTree)this.myTree);
        decorator2.setToolbarPosition(ActionToolbarPosition.RIGHT);
        decorator2.setEditAction(null);
        decorator2.disableUpDownActions();
        DumbAwareAction selectAll = new DumbAwareAction("Select All", null, PlatformIcons.SELECT_ALL_ICON){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                ExtractStyleDialog.this.setChecked(true);
            }
        };
        decorator2.addExtraAction((AnAction)selectAll);
        DumbAwareAction unselectAll = new DumbAwareAction("Unselect All", null, PlatformIcons.UNSELECT_ALL_ICON){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                ExtractStyleDialog.this.setChecked(false);
            }
        };
        decorator2.addExtraAction((AnAction)unselectAll);
        this.myAttributeListWrapper.add(decorator2.createPanel());
        String value2 = PropertiesComponent.getInstance().getValue(SEARCH_STYLE_APPLICATIONS_PROPERTY);
        this.mySearchForStyleApplicationsAfter.setSelected(Boolean.parseBoolean(value2));
        this.init();
    }

    private void setChecked(boolean value2) {
        int count = this.myRootNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            ((CheckedTreeNode)this.myRootNode.getChildAt(i)).setChecked(value2);
        }
        this.myTree.repaint();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        super.doOKAction();
        PropertiesComponent.getInstance().setValue(SEARCH_STYLE_APPLICATIONS_PROPERTY, Boolean.toString(this.mySearchForStyleApplicationsAfter.isSelected()));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myStyleNameField;
    }

    protected ValidationInfo doValidate() {
        String styleName = this.getStyleName();
        if (styleName.isEmpty()) {
            return new ValidationInfo("specify style name", (JComponent)this.myStyleNameField);
        }
        if (!IdeResourcesUtil.isCorrectAndroidResourceName(styleName)) {
            return new ValidationInfo("incorrect style name", (JComponent)this.myStyleNameField);
        }
        Module module = this.getChosenModule();
        if (module == null) {
            return new ValidationInfo("specify module", (JComponent)this.myModuleCombo);
        }
        VirtualFile resourceDir = this.getResourceDirectory();
        if (resourceDir == null) {
            return new ValidationInfo("specify a module with resources", (JComponent)this.myModuleCombo);
        }
        return CreateXmlResourceDialog.checkIfResourceAlreadyExists(module.getProject(), resourceDir, this.getStyleName(), null, ResourceType.STYLE, this.myDirNames, this.myFileName);
    }

    @NotNull
    public String getStyleName() {
        return this.myStyleNameField.getText().trim();
    }

    @NotNull
    public List<XmlAttribute> getStyledAttributes() {
        ArrayList<XmlAttribute> attributes = new ArrayList<XmlAttribute>();
        int count = this.myRootNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            CheckedTreeNode treeNode = (CheckedTreeNode)this.myRootNode.getChildAt(i);
            if (!treeNode.isChecked()) continue;
            attributes.add((XmlAttribute)treeNode.getUserObject());
        }
        return attributes;
    }

    @Nullable
    private Module getChosenModule() {
        return this.myModule != null ? this.myModule : this.myModuleCombo.getSelectedModule();
    }

    @Nullable
    public VirtualFile getResourceDirectory() {
        Module module = this.getChosenModule();
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            return null;
        }
        return ResourceFolderManager.getInstance(facet).getPrimaryFolder();
    }

    public boolean isToSearchStyleApplications() {
        return this.mySearchForStyleApplicationsAfter.isSelected();
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Style name:");
        jBLabel1.setDisplayedMnemonic('S');
        jBLabel1.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myStyleNameField = new JTextField();
        this.myPanel.add((Component)this.myStyleNameField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.myAttributeListWrapper = new JPanel();
        this.myAttributeListWrapper.setLayout(new BorderLayout(0, 0));
        this.myPanel.add((Component)this.myAttributeListWrapper, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(-1, 200), null, 0, false));
        this.myAttributesLabel = new JBLabel();
        this.myAttributesLabel.setText("Attributes:");
        this.myAttributesLabel.setDisplayedMnemonic('A');
        this.myAttributesLabel.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)this.myAttributesLabel, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        this.myModuleLabel = new JBLabel();
        this.myModuleLabel.setText("Module:");
        this.myModuleLabel.setDisplayedMnemonic('M');
        this.myModuleLabel.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)this.myModuleLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myModuleCombo = new ModulesComboBox();
        this.myPanel.add((Component)this.myModuleCombo, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.mySearchForStyleApplicationsAfter = new JBCheckBox();
        this.mySearchForStyleApplicationsAfter.setText("Launch 'Use Style Where Possible' refactoring after the style is extracted");
        this.mySearchForStyleApplicationsAfter.setMnemonic('L');
        this.mySearchForStyleApplicationsAfter.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)this.mySearchForStyleApplicationsAfter, new GridConstraints(2, 0, 1, 2, 0, 1, 0, 0, null, null, null, 0, false));
        jBLabel1.setLabelFor((Component)this.myStyleNameField);
        this.myModuleLabel.setLabelFor((Component)this.myModuleCombo);
    }
}

