/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizard;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class GradleSignStep
extends ExportSignedPackageWizardStep {
    @NonNls
    private static final String PROPERTY_APK_PATH = "ExportApk.ApkPath";
    @NonNls
    private static final String PROPERTY_BUNDLE_PATH = "ExportBundle.BundlePath";
    @VisibleForTesting
    @NonNls
    static final String PROPERTY_BUILD_VARIANTS = "ExportApk.BuildVariants";
    private JPanel myContentPanel;
    private TextFieldWithBrowseButton myApkPathField;
    private JBList<String> myBuildVariantsList;
    private final ExportSignedPackageWizard myWizard;
    private final DefaultListModel<String> myBuildVariantsListModel = new DefaultListModel();
    private final Set<String> disabledItems = new HashSet<String>();
    private GradleAndroidModel myAndroidModel;

    public GradleSignStep(@NotNull ExportSignedPackageWizard exportSignedPackageWizard) {
        this.setupUI();
        this.myWizard = exportSignedPackageWizard;
        this.myBuildVariantsList.setModel(this.myBuildVariantsListModel);
        this.myBuildVariantsList.setSelectionModel((ListSelectionModel)new DisabledItemSelectionModel());
        this.myBuildVariantsList.setCellRenderer((ListCellRenderer)new DisabledItemListCellRenderer());
        this.myBuildVariantsList.setEmptyText(AndroidBundle.message("android.apk.sign.gradle.no.variants", new Object[0]));
        ListSpeedSearch.installOn(this.myBuildVariantsList);
        this.myApkPathField.addBrowseFolderListener(this.myWizard.getProject(), FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle("Select APK Destination Folder"));
    }

    public void _init() {
        this._init(GradleAndroidModel.get(this.myWizard.getFacet()));
    }

    @VisibleForTesting
    void _init(GradleAndroidModel androidModel) {
        this.myAndroidModel = androidModel;
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myWizard.getProject());
        this.myBuildVariantsListModel.clear();
        ArrayList<String> buildVariants = new ArrayList<String>();
        if (this.myAndroidModel != null) {
            buildVariants.addAll(this.myAndroidModel.getFilteredVariantNames());
            Collections.sort(buildVariants);
            this.disabledItems.addAll(this.myAndroidModel.getFilteredDebuggableVariants());
        }
        IntArrayList lastSelectedIndices = new IntArrayList(buildVariants.size());
        List cachedVariants = properties.getList(PROPERTY_BUILD_VARIANTS);
        HashSet lastSelectedVariants = cachedVariants == null ? Collections.emptySet() : Sets.newHashSet((Iterable)cachedVariants);
        for (int i = 0; i < buildVariants.size(); ++i) {
            String variant = (String)buildVariants.get(i);
            this.myBuildVariantsListModel.addElement(variant);
            if (!lastSelectedVariants.contains(variant)) continue;
            lastSelectedIndices.add(i);
        }
        this.myBuildVariantsList.setSelectedIndices(lastSelectedIndices.toIntArray());
        String moduleName = this.myAndroidModel.getModuleName();
        ExportSignedPackageWizard.TargetType targetType = this.myWizard.getTargetType();
        this.myApkPathField.setText(FileUtil.toSystemDependentName((String)this.getInitialPath(properties, moduleName, targetType)));
    }

    @Override
    public String getHelpId() {
        return "org.jetbrains.android.studio/publish/app-signing";
    }

    @Override
    protected void commitForNext() throws CommitStepException {
        if (this.myAndroidModel == null) {
            throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.no.model", new Object[0]));
        }
        String apkFolder = this.myApkPathField.getText().stripLeading();
        if (apkFolder.isEmpty()) {
            throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.missing.destination", new Object[]{this.myWizard.getTargetType()}));
        }
        File f = new File(apkFolder);
        if (!f.isDirectory() || !f.canWrite()) {
            throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.invalid.destination", new Object[0]));
        }
        int[] selectedVariantIndices = this.myBuildVariantsList.getSelectedIndices();
        if (this.myBuildVariantsList.isEmpty() || selectedVariantIndices.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.missing.variants", new Object[0]));
        }
        List buildVariants = this.myBuildVariantsList.getSelectedValuesList();
        this.myWizard.setApkPath(apkFolder);
        this.myWizard.setGradleOptions(this.myBuildVariantsList.getSelectedValuesList());
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myWizard.getProject());
        properties.setValue(this.getApkPathPropertyName(this.myAndroidModel.getModuleName(), this.myWizard.getTargetType()), apkFolder);
        properties.setList(PROPERTY_BUILD_VARIANTS, (Collection)buildVariants);
    }

    public JComponent getComponent() {
        return this.myContentPanel;
    }

    @VisibleForTesting
    String getInitialPath(@NotNull PropertiesComponent properties, @NotNull String moduleName, @NotNull ExportSignedPackageWizard.TargetType targetType) {
        String lastApkFolderPath = properties.getValue(this.getApkPathPropertyName(moduleName, targetType));
        if (!Strings.isNullOrEmpty((String)lastApkFolderPath)) {
            return lastApkFolderPath;
        }
        if (this.myAndroidModel == null) {
            return this.myWizard.getProject().getBaseDir().getPath();
        }
        return this.myAndroidModel.getRootDirPath().getPath();
    }

    @VisibleForTesting
    String getApkPathPropertyName(String moduleName, ExportSignedPackageWizard.TargetType targetType) {
        return (targetType.equals((Object)ExportSignedPackageWizard.APK) ? PROPERTY_APK_PATH : PROPERTY_BUNDLE_PATH) + (String)(Strings.isNullOrEmpty((String)moduleName) ? "" : "For" + moduleName);
    }

    private void setupUI() {
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Destination Folder:");
        jBLabel1.setDisplayedMnemonic('D');
        jBLabel1.setDisplayedMnemonicIndex(0);
        this.myContentPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myContentPanel.add((Component)spacer1, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myApkPathField = new TextFieldWithBrowseButton();
        this.myContentPanel.add((Component)this.myApkPathField, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Build Variants:");
        jBLabel2.setDisplayedMnemonic('B');
        jBLabel2.setDisplayedMnemonicIndex(0);
        this.myContentPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        JBScrollPane jBScrollPane1 = new JBScrollPane();
        this.myContentPanel.add((Component)jBScrollPane1, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myBuildVariantsList = new JBList(){

            public String getToolTipText(MouseEvent e) {
                int row = this.locationToIndex(e.getPoint());
                String name2 = this.getModel().getElementAt(row).toString();
                if (GradleSignStep.this.shouldDisableDebuggable() && GradleSignStep.this.disabledItems.contains(name2)) {
                    return "Variant `" + name2 + "` is debuggable so cannot be signed";
                }
                return super.getToolTipText(e);
            }
        };
        jBScrollPane1.setViewportView(this.myBuildVariantsList);
        jBLabel1.setLabelFor((Component)this.myApkPathField);
    }

    private boolean shouldDisableDebuggable() {
        return this.myWizard.getTargetType() == ExportSignedPackageWizard.TargetType.BUNDLE;
    }

    private class DisabledItemSelectionModel
    extends DefaultListSelectionModel {
        private DisabledItemSelectionModel() {
        }

        private boolean isEnabled(int index) {
            return !GradleSignStep.this.disabledItems.contains(GradleSignStep.this.myBuildVariantsListModel.get(index));
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (GradleSignStep.this.shouldDisableDebuggable()) {
                for (int i = index0; i <= index1; ++i) {
                    if (!this.isEnabled(i)) continue;
                    super.setSelectionInterval(i, i);
                }
            } else {
                super.setSelectionInterval(index0, index1);
            }
        }
    }

    private class DisabledItemListCellRenderer
    extends DefaultListCellRenderer {
        private DisabledItemListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, value2, index, isSelected, cellHasFocus);
            if (GradleSignStep.this.shouldDisableDebuggable() && GradleSignStep.this.disabledItems.contains(GradleSignStep.this.myBuildVariantsListModel.get(index))) {
                c.setForeground(Color.GRAY);
            }
            return c;
        }
    }
}

