/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.compiler.artifact.ApkSigningSettingsForm;
import org.jetbrains.android.compiler.artifact.ChooseKeyDialog;
import org.jetbrains.android.compiler.artifact.NewKeyStoreDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ExportSignedPackageUtil {
    private static final Logger LOG = Logger.getInstance(ExportSignedPackageUtil.class);

    private ExportSignedPackageUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static @Unmodifiable List<String> loadExistingKeys(@NotNull ApkSigningSettingsForm form) {
        String errorPrefix = "Cannot load key store: ";
        InputStream is = null;
        try {
            is = new FileInputStream(new File(form.getKeyStorePathField().getText().trim()));
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(is, form.getKeyStorePasswordField().getPassword());
            List list = ContainerUtil.toList(keyStore.aliases());
            return list;
        }
        catch (KeyStoreException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (FileNotFoundException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (CertificateException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (NoSuchAlgorithmException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (IOException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
    }

    public static void initSigningSettingsForm(final @NotNull Project project, final @NotNull ApkSigningSettingsForm form) {
        form.getLoadKeyStoreButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String defaultPath = form.getKeyStorePathField().getText().trim();
                VirtualFile defaultFile = LocalFileSystem.getInstance().findFileByPath(defaultPath);
                FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Component)form.getPanel(), (Project)project, (VirtualFile)defaultFile);
                if (file != null) {
                    form.getKeyStorePathField().setText(FileUtil.toSystemDependentName((String)file.getPath()));
                }
                form.keyStoreSelected();
            }
        });
        form.getCreateKeyStoreButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewKeyStoreDialog dialog2 = new NewKeyStoreDialog(project, form.getKeyStorePathField().getText());
                dialog2.show();
                if (dialog2.getExitCode() == 0) {
                    form.getKeyStorePathField().setText(dialog2.getKeyStorePath());
                    form.getKeyStorePasswordField().setText(String.valueOf(dialog2.getKeyStorePassword()));
                    form.getKeyAliasField().setText(dialog2.getKeyAlias());
                    form.getKeyPasswordField().setText(String.valueOf(dialog2.getKeyPassword()));
                    form.keyStoreCreated();
                }
            }
        });
        form.getKeyAliasField().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> keys = ExportSignedPackageUtil.loadExistingKeys(form);
                if (keys == null) {
                    return;
                }
                ChooseKeyDialog dialog2 = new ChooseKeyDialog(project, form.getKeyStorePathField().getText().trim(), form.getKeyStorePasswordField().getPassword(), new ArrayList<String>(keys), form.getKeyAliasField().getText().trim());
                dialog2.show();
                if (dialog2.getExitCode() == 0) {
                    char[] password;
                    String chosenKey = dialog2.getChosenKey();
                    if (chosenKey != null) {
                        form.getKeyAliasField().setText(chosenKey);
                    }
                    if ((password = dialog2.getChosenKeyPassword()) != null) {
                        form.getKeyPasswordField().setText(String.valueOf(password));
                    }
                    if (dialog2.isNewKeyCreated()) {
                        form.keyAliasCreated();
                    } else {
                        form.keyAliasSelected();
                    }
                }
            }
        });
    }
}

