/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.android.tools.idea.res.psi.ResourceRepositoryToPsiResolver;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0014\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0014J3\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u000f\u001a\u0012\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\u0011\u0018\u00010\u0010H\u0014\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0014J\u0012\u0010\u0016\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0014J'\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/android/dom/converters/AndroidConstraintIdsConverter;", "Lcom/intellij/util/xml/converters/DelimitedListConverter;", "Lcom/android/ide/common/rendering/api/ResourceReference;", "<init>", "()V", "convertString", "string", "", "context", "Lcom/intellij/util/xml/ConvertContext;", "toString", "value", "getReferenceVariants", "", "", "genericDomValue", "Lcom/intellij/util/xml/GenericDomValue;", "", "(Lcom/intellij/util/xml/ConvertContext;Lcom/intellij/util/xml/GenericDomValue;)[Ljava/lang/Object;", "resolveReference", "Lcom/intellij/psi/PsiElement;", "resourceReference", "getUnresolvedMessage", "pickMostRelevantId", "Lcom/intellij/psi/ResolveResult;", "resolveResultList", "([Lcom/intellij/psi/ResolveResult;Lcom/intellij/util/xml/ConvertContext;)Lcom/intellij/psi/ResolveResult;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAndroidConstraintIdsConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidConstraintIdsConverter.kt\norg/jetbrains/android/dom/converters/AndroidConstraintIdsConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class AndroidConstraintIdsConverter
extends DelimitedListConverter<ResourceReference> {
    public AndroidConstraintIdsConverter() {
        super(", ");
    }

    @Nullable
    protected ResourceReference convertString(@Nullable String string, @NotNull ConvertContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (string == null) {
            return null;
        }
        return new ResourceReference(ResourceNamespace.RES_AUTO, ResourceType.ID, string);
    }

    @Nullable
    protected String toString(@Nullable ResourceReference value2) {
        ResourceReference resourceReference = value2;
        return resourceReference != null ? resourceReference.getName() : null;
    }

    @NotNull
    protected Object[] getReferenceVariants(@NotNull ConvertContext context, @Nullable GenericDomValue<? extends List<ResourceReference>> genericDomValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        XmlFile xmlFile = context.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
        XmlFile file = xmlFile;
        Object[] objectArray = IdeResourcesUtil.findIdUrlsInFile((PsiFile)file).stream().map(arg_0 -> AndroidConstraintIdsConverter.getReferenceVariants$lambda$2(AndroidConstraintIdsConverter::getReferenceVariants$lambda$1, arg_0)).toArray();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toArray(...)");
        return objectArray;
    }

    @Nullable
    protected PsiElement resolveReference(@Nullable ResourceReference resourceReference, @NotNull ConvertContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (resourceReference == null || context.getReferenceXmlElement() == null) {
            return null;
        }
        Module module = context.getModule();
        if (module == null || (module = ModuleExtensionsKt.getAndroidFacet((Module)module)) == null) {
            return null;
        }
        Module facet = module;
        AndroidResourceToPsiResolver androidResourceToPsiResolver = AndroidResourceToPsiResolver.getInstance();
        ResourceRepositoryToPsiResolver resourceRepositoryToPsiResolver = androidResourceToPsiResolver instanceof ResourceRepositoryToPsiResolver ? (ResourceRepositoryToPsiResolver)androidResourceToPsiResolver : null;
        if (resourceRepositoryToPsiResolver == null) {
            return null;
        }
        ResourceRepositoryToPsiResolver resourceToPsiResolver = resourceRepositoryToPsiResolver;
        XmlElement xmlElement = context.getReferenceXmlElement();
        Intrinsics.checkNotNull((Object)xmlElement);
        ResolveResult[] resolveResultList = resourceToPsiResolver.resolveReference(resourceReference, (PsiElement)xmlElement, (AndroidFacet)facet, false);
        ResolveResult resolveResult = this.pickMostRelevantId(resolveResultList, context);
        return resolveResult != null ? resolveResult.getElement() : null;
    }

    @NotNull
    protected String getUnresolvedMessage(@Nullable String value2) {
        Object[] objectArray = new Object[]{value2};
        String string = AnalysisBundle.message((String)"error.cannot.resolve.default.message", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final ResolveResult pickMostRelevantId(ResolveResult[] resolveResultList, ConvertContext context) {
        Sequence sequence = ArraysKt.asSequence((Object[])resolveResultList);
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> AndroidConstraintIdsConverter.pickMostRelevantId$lambda$4(arg_0 -> AndroidConstraintIdsConverter.pickMostRelevantId$lambda$3(context, arg_0), arg_0)).thenComparing(Comparator.comparing(arg_0 -> AndroidConstraintIdsConverter.pickMostRelevantId$lambda$6(AndroidConstraintIdsConverter::pickMostRelevantId$lambda$5, arg_0)));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"thenComparing(...)");
        return (ResolveResult)SequencesKt.minWithOrNull((Sequence)sequence, comparator);
    }

    private static final LookupElementBuilder getReferenceVariants$lambda$1(ResourceUrl url) {
        Object object;
        block3: {
            block2: {
                object = url.namespace;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = it + ":";
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        String name2 = (String)object + url.name;
        return LookupElementBuilder.create((String)name2);
    }

    private static final LookupElementBuilder getReferenceVariants$lambda$2(Function1 $tmp0, Object p0) {
        return (LookupElementBuilder)$tmp0.invoke(p0);
    }

    private static final Boolean pickMostRelevantId$lambda$3(ConvertContext $context, ResolveResult it) {
        PsiElement psiElement = it.getElement();
        return !Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getContainingFile() : null), (Object)$context.getFile());
    }

    private static final Boolean pickMostRelevantId$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean pickMostRelevantId$lambda$5(ResolveResult it) {
        PsiElement psiElement = it.getElement();
        XmlAttributeValue xmlAttributeValue = psiElement instanceof XmlAttributeValue ? (XmlAttributeValue)psiElement : null;
        PsiElement psiElement2 = xmlAttributeValue != null ? xmlAttributeValue.getParent() : null;
        XmlAttribute xmlAttribute = psiElement2 instanceof XmlAttribute ? (XmlAttribute)psiElement2 : null;
        return !Intrinsics.areEqual((Object)(xmlAttribute != null ? xmlAttribute.getName() : null), (Object)"android:id");
    }

    private static final Boolean pickMostRelevantId$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

