/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B1\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rB-\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u000e\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\u000fB3\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u000e\u001a\u00020\b\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0010\"\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/android/dom/MultipleKnownRootsResourceDomFileDescription;", "T", "Lcom/intellij/util/xml/DomElement;", "Lorg/jetbrains/android/dom/AndroidResourceDomFileDescription;", "rootElementClass", "Ljava/lang/Class;", "resourceFolderTypes", "Ljava/util/EnumSet;", "Lcom/android/resources/ResourceFolderType;", "tagNames", "", "", "<init>", "(Ljava/lang/Class;Ljava/util/EnumSet;Ljava/util/Set;)V", "resourceFolderType", "(Ljava/lang/Class;Lcom/android/resources/ResourceFolderType;Ljava/util/Set;)V", "", "(Ljava/lang/Class;Lcom/android/resources/ResourceFolderType;[Ljava/lang/String;)V", "acceptsOtherRootTagNames", "", "isMyFile", "file", "Lcom/intellij/psi/xml/XmlFile;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.android.core"})
public abstract class MultipleKnownRootsResourceDomFileDescription<T extends DomElement>
extends AndroidResourceDomFileDescription<T> {
    @NotNull
    private final Set<String> tagNames;

    public MultipleKnownRootsResourceDomFileDescription(@NotNull Class<T> rootElementClass, @NotNull EnumSet<ResourceFolderType> resourceFolderTypes, @NotNull Set<String> tagNames) {
        Intrinsics.checkNotNullParameter(rootElementClass, (String)"rootElementClass");
        Intrinsics.checkNotNullParameter(resourceFolderTypes, (String)"resourceFolderTypes");
        Intrinsics.checkNotNullParameter(tagNames, (String)"tagNames");
        super(rootElementClass, (String)CollectionsKt.first((Iterable)tagNames), resourceFolderTypes, null);
        this.tagNames = tagNames;
    }

    public MultipleKnownRootsResourceDomFileDescription(@NotNull Class<T> rootElementClass, @NotNull ResourceFolderType resourceFolderType, @NotNull Set<String> tagNames) {
        Intrinsics.checkNotNullParameter(rootElementClass, (String)"rootElementClass");
        Intrinsics.checkNotNullParameter((Object)resourceFolderType, (String)"resourceFolderType");
        Intrinsics.checkNotNullParameter(tagNames, (String)"tagNames");
        EnumSet<Enum> enumSet = EnumSet.of((Enum)resourceFolderType);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        this(rootElementClass, enumSet, tagNames);
    }

    public MultipleKnownRootsResourceDomFileDescription(@NotNull Class<T> rootElementClass, @NotNull ResourceFolderType resourceFolderType, String ... tagNames) {
        Intrinsics.checkNotNullParameter(rootElementClass, (String)"rootElementClass");
        Intrinsics.checkNotNullParameter((Object)resourceFolderType, (String)"resourceFolderType");
        Intrinsics.checkNotNullParameter((Object)tagNames, (String)"tagNames");
        Set<String> set2 = Set.of(Arrays.copyOf(tagNames, tagNames.length));
        Intrinsics.checkNotNullExpressionValue(set2, (String)"of(...)");
        this(rootElementClass, resourceFolderType, set2);
    }

    public final boolean acceptsOtherRootTagNames() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!super.isMyFile(file, module)) return false;
        XmlTag xmlTag = file.getRootTag();
        if (!CollectionsKt.contains((Iterable)this.tagNames, (Object)(xmlTag != null ? xmlTag.getName() : null))) return false;
        return true;
    }
}

