/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.dom.attrs.AttributeDefinition;
import com.android.tools.dom.attrs.AttributeDefinitions;
import com.android.tools.dom.attrs.StyleableDefinition;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.psi.TagToClassMapper;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.xml.XmlElementDescriptor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.RequiredImpl;
import org.jetbrains.android.dom.Styleable;
import org.jetbrains.android.dom.animation.InterpolatorElement;
import org.jetbrains.android.dom.animation.fileDescriptions.InterpolatorDomFileDescription;
import org.jetbrains.android.dom.attrs.ToolsAttributeUtil;
import org.jetbrains.android.dom.converters.CompositeConverter;
import org.jetbrains.android.dom.converters.ManifestPlaceholderConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.layout.Data;
import org.jetbrains.android.dom.layout.DataBindingElement;
import org.jetbrains.android.dom.layout.Fragment;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.layout.LayoutViewElementDescriptor;
import org.jetbrains.android.dom.layout.Tag;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestElement;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.android.dom.menu.MenuItem;
import org.jetbrains.android.dom.navigation.NavDestinationElement;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.dom.raw.XmlRawResourceElement;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.PreferenceElementBase;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidClassesForXmlUtilKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.TagFromClassDescriptor;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001PB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0002J8\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0002J\"\u0010\u001e\u001a\u00020\f2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J2\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000e2\b\u0010(\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010 2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J@\u0010*\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0002J9\u0010-\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0082\u0010J\u001a\u00100\u001a\u0004\u0018\u00010/2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00101\u001a\u00020/H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00052\u0006\u00103\u001a\u00020/H\u0002J\u0017\u00104\u001a\t\u0018\u00010/\u00a2\u0006\u0002\b52\u0006\u00101\u001a\u00020/H\u0002J4\u00106\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00107\u001a\u0002082\u0006\u0010\u000f\u001a\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010;\u001a\u0004\u0018\u00010\u00052\u0006\u0010<\u001a\u00020/J\u0010\u0010=\u001a\u0004\u0018\u00010\u00052\u0006\u0010<\u001a\u00020/J6\u0010>\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00103\u001a\u00020/2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0002J.\u0010>\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0002J6\u0010?\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010@\u001a\u00020AH\u0002J6\u0010B\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00107\u001a\u0002082\u0006\u0010\u000f\u001a\u00020C2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J6\u0010D\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00107\u001a\u0002082\u0006\u0010\u000f\u001a\u00020E2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J(\u0010F\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020G2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010H\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0018\u0010I\u001a\u00020\u00162\u0006\u00107\u001a\u0002082\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010J\u001a\u00020\u00162\u0006\u00107\u001a\u0002082\u0006\u0010\u000f\u001a\u00020G2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J.\u0010K\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0L2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010M\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J.\u0010N\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00107\u001a\u0002082\u0006\u0010\u000f\u001a\u00020G2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010O\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lorg/jetbrains/android/dom/AttributeProcessingUtil;", "", "<init>", "()V", "PREFERENCE_TAG_NAME", "", "SIZE_NOT_REQUIRED_TAG_NAMES", "", "SIZE_NOT_REQUIRED_PARENT_TAG_NAMES", "kotlin.jvm.PlatformType", "REQUIRED_LAYOUT_ATTRIBUTE_LOCAL_NAMES", "isLayoutAttributeRequired", "", "attributeName", "Lcom/intellij/util/xml/XmlName;", "element", "Lcom/intellij/util/xml/DomElement;", "getNamespaceUriByResourcePackage", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "resPackage", "registerStyleableAttributes", "", "styleable", "Lcom/android/tools/dom/attrs/StyleableDefinition;", "namespaceUri", "callback", "Lorg/jetbrains/android/dom/AttributeProcessingUtil$AttributeProcessor;", "skippedAttributes", "", "mustBeSoft", "converter", "Lcom/intellij/util/xml/Converter;", "formats", "", "Lcom/android/ide/common/rendering/api/AttributeFormat;", "registerAttribute", "attrDef", "Lcom/android/tools/dom/attrs/AttributeDefinition;", "xmlName", "parentStyleableName", "getSpecificConverter", "registerAttributes", "styleableName", "skipNames", "registerAttributesForClassAndSuperclasses", "clazz", "Lcom/intellij/psi/PsiClass;", "getAdditionalAttributesClass", "c", "getResourcePackage", "psiClass", "getSuperclass", "Lorg/jetbrains/annotations/Nullable;", "processXmlAttributes", "tag", "Lcom/intellij/psi/xml/XmlTag;", "Lorg/jetbrains/android/dom/xml/XmlResourceElement;", "skipAttrNames", "getLayoutStyleablePrimary", "psiLayoutClass", "getLayoutStyleableSecondary", "registerAttributesFromSuffixedStyleables", "registerAttributesFromSuffixedStyleablesForNamespace", "resourceNamespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "processNavAttributes", "Lorg/jetbrains/android/dom/navigation/NavDestinationElement;", "processLayoutAttributes", "Lorg/jetbrains/android/dom/layout/LayoutElement;", "processAttributes", "Lorg/jetbrains/android/dom/AndroidDomElement;", "processAllExistingAttrsFirst", "processRawAttributes", "processManifestAttributes", "processMenuItemAttributes", "", "registerToolsAttribute", "registerExistingAttributes", "getXmlName", "AttributeProcessor", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAttributeProcessingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeProcessingUtil.kt\norg/jetbrains/android/dom/AttributeProcessingUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,916:1\n1#2:917\n11158#3:918\n11493#3,3:919\n25#4:922\n25#4:923\n25#4:924\n25#4:925\n*S KotlinDebug\n*F\n+ 1 AttributeProcessingUtil.kt\norg/jetbrains/android/dom/AttributeProcessingUtil\n*L\n749#1:918\n749#1:919,3\n761#1:922\n778#1:923\n826#1:924\n867#1:925\n*E\n"})
public final class AttributeProcessingUtil {
    @NotNull
    public static final AttributeProcessingUtil INSTANCE = new AttributeProcessingUtil();
    @NotNull
    private static final String PREFERENCE_TAG_NAME = "Preference";
    @NotNull
    private static final Set<String> SIZE_NOT_REQUIRED_TAG_NAMES;
    @NotNull
    private static final Set<String> SIZE_NOT_REQUIRED_PARENT_TAG_NAMES;
    @NotNull
    private static final Set<String> REQUIRED_LAYOUT_ATTRIBUTE_LOCAL_NAMES;

    private AttributeProcessingUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLayoutAttributeRequired(XmlName attributeName, DomElement element) {
        if (!REQUIRED_LAYOUT_ATTRIBUTE_LOCAL_NAMES.contains(attributeName.getLocalName())) {
            return false;
        }
        if (!(element instanceof LayoutViewElement)) {
            if (!(element instanceof Fragment)) return false;
        }
        if (!Intrinsics.areEqual((Object)attributeName.getNamespaceKey(), (Object)"http://schemas.android.com/apk/res/android")) return false;
        XmlElement xmlElement = ((LayoutElement)element).getXmlElement();
        XmlTag tag = xmlElement instanceof XmlTag ? (XmlTag)xmlElement : null;
        XmlTag xmlTag = tag;
        if (CollectionsKt.contains((Iterable)SIZE_NOT_REQUIRED_TAG_NAMES, (Object)(xmlTag != null ? xmlTag.getName() : null))) return false;
        XmlTag xmlTag2 = tag;
        if ((xmlTag2 != null ? xmlTag2.getAttribute("style") : null) != null) return false;
        XmlTag xmlTag3 = tag;
        if (SIZE_NOT_REQUIRED_PARENT_TAG_NAMES.contains(xmlTag3 != null && (xmlTag3 = xmlTag3.getParentTag()) != null ? xmlTag3.getName() : null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getNamespaceUriByResourcePackage(AndroidFacet facet, String resPackage) {
        String string;
        if (Intrinsics.areEqual((Object)resPackage, (Object)"android")) {
            return "http://schemas.android.com/apk/res/android";
        }
        if (resPackage != null) {
            return null;
        }
        if (!((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject()) return "http://schemas.android.com/apk/res-auto";
        if (AndroidModel.Companion.isRequired(facet)) {
            return "http://schemas.android.com/apk/res-auto";
        }
        Manifest manifest = Manifest.getMainManifest(facet);
        if (manifest == null) return null;
        GenericAttributeValue<String> genericAttributeValue = manifest.getPackage();
        if (genericAttributeValue == null) return null;
        String string2 = (String)genericAttributeValue.getValue();
        if (string2 == null) return null;
        String it = string = string2;
        boolean bl = false;
        if (((CharSequence)it).length() == 0) {
            return null;
        }
        boolean bl2 = false;
        if (bl2) return null;
        String string3 = string;
        String string4 = string3;
        if (string4 == null) return null;
        it = string4;
        boolean bl3 = false;
        String string5 = "http://schemas.android.com/apk/res/" + it;
        return string5;
    }

    private final void registerStyleableAttributes(DomElement element, StyleableDefinition styleable, String namespaceUri, AttributeProcessor callback2, Set<XmlName> skippedAttributes) {
        for (AttributeDefinition attrDef : styleable.getAttributes()) {
            Intrinsics.checkNotNull((Object)attrDef);
            XmlName xmlName = this.getXmlName(attrDef, namespaceUri);
            if (!skippedAttributes.add(xmlName)) continue;
            this.registerAttribute(attrDef, xmlName, styleable.getName(), element, callback2);
        }
    }

    private final boolean mustBeSoft(Converter<?> converter, Collection<? extends AttributeFormat> formats) {
        return !(converter instanceof CompositeConverter) && !(converter instanceof ResourceReferenceConverter) && formats.size() > 1;
    }

    private final void registerAttribute(AttributeDefinition attrDef, XmlName xmlName, String parentStyleableName, DomElement element, AttributeProcessor callback2) {
        DomExtension domExtension = callback2.processAttribute(xmlName, attrDef, parentStyleableName);
        if (domExtension == null) {
            return;
        }
        DomExtension extension = domExtension;
        Converter<Object> converter = this.getSpecificConverter(xmlName, attrDef, element);
        if (converter != null) {
            Converter<Object> it = converter;
            boolean bl = false;
            Set<AttributeFormat> set2 = attrDef.getFormats();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"getFormats(...)");
            extension.setConverter(it, INSTANCE.mustBeSoft(it, (Collection<? extends AttributeFormat>)set2));
        }
        if (element instanceof LayoutElement && this.isLayoutAttributeRequired(xmlName, element) || element instanceof ManifestElement && AndroidManifestUtils.isRequiredAttribute(xmlName, element)) {
            extension.addCustomAnnotation((Annotation)((Object)new RequiredImpl()));
        }
    }

    private final Converter<Object> getSpecificConverter(XmlName xmlName, AttributeDefinition attrDef, DomElement element) {
        Converter specificConverter;
        Converter converter = specificConverter = AndroidDomUtil.getSpecificConverter(xmlName, element);
        if (converter != null) {
            return converter;
        }
        if (Intrinsics.areEqual((Object)xmlName.getNamespaceKey(), (Object)"http://schemas.android.com/tools")) {
            return ToolsAttributeUtil.getConverter(attrDef);
        }
        ResolvingConverter attrConverter = AndroidDomUtil.getConverter(attrDef);
        if (attrConverter != null && element.getParentOfType(Manifest.class, true) != null) {
            return (Converter)new ManifestPlaceholderConverter((Converter)attrConverter);
        }
        return (Converter)attrConverter;
    }

    private final void registerAttributes(AndroidFacet facet, DomElement element, String styleableName, String resPackage, AttributeProcessor callback2, Set<XmlName> skipNames) {
        AttributeDefinitions attributeDefinitions;
        ResourceManager resourceManager = ModuleResourceManagers.getInstance(facet).getResourceManager(resPackage);
        if (resourceManager == null || (attributeDefinitions = resourceManager.getAttributeDefinitions()) == null) {
            return;
        }
        AttributeDefinitions attrDefs = attributeDefinitions;
        String namespace = this.getNamespaceUriByResourcePackage(facet, resPackage);
        StyleableDefinition styleableDefinition = attrDefs.getStyleableByName(styleableName);
        if (styleableDefinition == null) {
            return;
        }
        StyleableDefinition styleable = styleableDefinition;
        this.registerStyleableAttributes(element, styleable, namespace, callback2, skipNames);
    }

    private final void registerAttributesForClassAndSuperclasses(AndroidFacet facet, DomElement element, PsiClass clazz2, AttributeProcessor callback2, Set<XmlName> skipNames) {
        AttributeProcessingUtil attributeProcessingUtil = this;
        while (clazz2 != null) {
            String additionalStyleableName;
            PsiClass additional;
            String styleableName = clazz2.getName();
            if (styleableName != null) {
                attributeProcessingUtil.registerAttributes(facet, element, styleableName, attributeProcessingUtil.getResourcePackage(clazz2), callback2, skipNames);
            }
            if ((additional = attributeProcessingUtil.getAdditionalAttributesClass(facet, clazz2)) != null && (additionalStyleableName = additional.getName()) != null) {
                attributeProcessingUtil.registerAttributes(facet, element, additionalStyleableName, attributeProcessingUtil.getResourcePackage(additional), callback2, skipNames);
            }
            AttributeProcessingUtil attributeProcessingUtil2 = attributeProcessingUtil;
            AndroidFacet androidFacet = facet;
            DomElement domElement = element;
            PsiClass psiClass = attributeProcessingUtil.getSuperclass(clazz2);
            AttributeProcessor attributeProcessor = callback2;
            Set<XmlName> set2 = skipNames;
            attributeProcessingUtil = attributeProcessingUtil2;
            facet = androidFacet;
            element = domElement;
            clazz2 = psiClass;
            callback2 = attributeProcessor;
            skipNames = set2;
        }
        return;
    }

    private final PsiClass getAdditionalAttributesClass(AndroidFacet facet, PsiClass c) {
        String string = c.getQualifiedName();
        if (string == null) {
            string = "";
        }
        if (AndroidXConstants.CLASS_NESTED_SCROLL_VIEW.isEquals(string)) {
            return AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet, "ScrollView");
        }
        return null;
    }

    private final String getResourcePackage(PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName != null && StringsKt.startsWith$default((String)qualifiedName, (String)"android.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)qualifiedName, (String)"android.support.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)qualifiedName, (String)"androidx.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)qualifiedName, (String)"android.arch.", (boolean)false, (int)2, null)) {
            return "android";
        }
        return null;
    }

    private final PsiClass getSuperclass(PsiClass c) {
        return (PsiClass)ActionsKt.runReadAction(() -> AttributeProcessingUtil.getSuperclass$lambda$3(c));
    }

    public final void processXmlAttributes(@NotNull AndroidFacet facet, @NotNull XmlTag tag, @NotNull XmlResourceElement element, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback2) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(skipAttrNames, (String)"skipAttrNames");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        String string = tag.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String tagName = string;
        String styleableName = AndroidXmlResourcesUtil.SPECIAL_STYLEABLE_NAMES.get(tagName);
        if (styleableName != null) {
            Set newSkipAttrNames = new LinkedHashSet();
            if (element instanceof PreferenceElementBase.Intent) {
                newSkipAttrNames.add(new XmlName("action", "http://schemas.android.com/apk/res/android"));
            }
            this.registerAttributes(facet, element, styleableName, "android", callback2, newSkipAttrNames);
        }
        AndroidXmlResourcesUtil.PreferenceSource preferenceSource = AndroidXmlResourcesUtil.PreferenceSource.Companion.getPreferencesSource(tag, facet);
        Map<String, PsiClass> map2 = TagToClassMapper.getInstance(facet.getModule()).getClassMap(preferenceSource.getQualifiedBaseClass());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getClassMap(...)");
        Map<String, PsiClass> prefClassMap = map2;
        PsiClass psiClass = prefClassMap.get(tagName);
        if (psiClass == null) {
            return;
        }
        PsiClass psiClass2 = psiClass;
        this.registerAttributesForClassAndSuperclasses(facet, element, psiClass2, callback2, skipAttrNames);
        String string2 = psiClass2.getQualifiedName();
        boolean bl = string2 != null ? StringsKt.startsWith$default((String)string2, (String)"android.preference.", (boolean)false, (int)2, null) : false;
        if (bl) {
            PsiClass widgetClass;
            String widgetClassName;
            String string3;
            String it = string3 = tagName;
            boolean bl2 = false;
            String string4 = StringsKt.endsWith$default((String)it, (String)PREFERENCE_TAG_NAME, (boolean)false, (int)2, null) ? string3 : null;
            String string5 = widgetClassName = string4 != null ? StringsKt.removeSuffix((String)string4, (CharSequence)PREFERENCE_TAG_NAME) : null;
            if (widgetClassName != null && (widgetClass = AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet, widgetClassName)) != null) {
                this.registerAttributesForClassAndSuperclasses(facet, element, widgetClass, callback2, skipAttrNames);
            }
        }
    }

    @Nullable
    public final String getLayoutStyleablePrimary(@NotNull PsiClass psiLayoutClass) {
        Intrinsics.checkNotNullParameter((Object)psiLayoutClass, (String)"psiLayoutClass");
        String string = psiLayoutClass.getName();
        if (string == null) {
            return null;
        }
        String viewName = string;
        String string2 = viewName;
        return Intrinsics.areEqual((Object)string2, (Object)"ViewGroup") ? "ViewGroup_MarginLayout" : (Intrinsics.areEqual((Object)string2, (Object)"TableRow") ? "TableRow_Cell" : viewName + "_Layout");
    }

    @Nullable
    public final String getLayoutStyleableSecondary(@NotNull PsiClass psiLayoutClass) {
        Intrinsics.checkNotNullParameter((Object)psiLayoutClass, (String)"psiLayoutClass");
        String string = psiLayoutClass.getName();
        if (string == null) {
            return null;
        }
        String viewName = string;
        return viewName + "_LayoutParams";
    }

    private final void registerAttributesFromSuffixedStyleables(AndroidFacet facet, DomElement element, PsiClass psiClass, AttributeProcessor callback2, Set<XmlName> skipAttrNames) {
        String secondary;
        String primary = this.getLayoutStyleablePrimary(psiClass);
        if (primary != null) {
            this.registerAttributes(facet, element, primary, this.getResourcePackage(psiClass), callback2, skipAttrNames);
        }
        if ((secondary = this.getLayoutStyleableSecondary(psiClass)) != null) {
            this.registerAttributes(facet, element, secondary, null, callback2, skipAttrNames);
        }
    }

    private final void registerAttributesFromSuffixedStyleables(AndroidFacet facet, DomElement element, AttributeProcessor callback2, Set<XmlName> skipAttrNames) {
        ResourceNamespace resourceNamespace = ResourceNamespace.ANDROID;
        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"ANDROID");
        this.registerAttributesFromSuffixedStyleablesForNamespace(facet, element, callback2, skipAttrNames, resourceNamespace);
        ResourceNamespace resourceNamespace2 = ResourceNamespace.RES_AUTO;
        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace2, (String)"RES_AUTO");
        this.registerAttributesFromSuffixedStyleablesForNamespace(facet, element, callback2, skipAttrNames, resourceNamespace2);
    }

    private final void registerAttributesFromSuffixedStyleablesForNamespace(AndroidFacet facet, DomElement element, AttributeProcessor callback2, Set<XmlName> skipAttrNames, ResourceNamespace resourceNamespace) {
        ResourceRepository resourceRepository = StudioResourceRepositoryManager.getInstance(facet).getResourcesForNamespace(resourceNamespace);
        if (resourceRepository == null) {
            return;
        }
        ResourceRepository repo = resourceRepository;
        List layoutStyleablesPrimary = repo.getResources(resourceNamespace, ResourceType.STYLEABLE, AttributeProcessingUtil::registerAttributesFromSuffixedStyleablesForNamespace$lambda$5);
        for (ResourceItem item : layoutStyleablesPrimary) {
            PsiClass psiClass;
            String viewName;
            String name2 = item.getName();
            Intrinsics.checkNotNull((Object)name2);
            int indexOfLastUnderscore = StringsKt.lastIndexOf$default((CharSequence)name2, (char)'_', (int)0, (boolean)false, (int)6, null);
            Intrinsics.checkNotNullExpressionValue((Object)name2.substring(0, indexOfLastUnderscore), (String)"substring(...)");
            if (AndroidClassesForXmlUtilKt.findViewClassByName(facet, viewName) == null) continue;
            boolean bl = false;
            INSTANCE.registerAttributes(facet, element, name2, INSTANCE.getResourcePackage(psiClass), callback2, skipAttrNames);
        }
    }

    private final void processNavAttributes(AndroidFacet facet, XmlTag tag, NavDestinationElement element, Set<XmlName> skipAttrNames, AttributeProcessor callback2) {
        try {
            NavigationSchema.createIfNecessary(facet.getModule());
        }
        catch (ClassNotFoundException e) {
            return;
        }
        NavigationSchema navigationSchema = NavigationSchema.get(facet.getModule());
        Intrinsics.checkNotNullExpressionValue((Object)navigationSchema, (String)"get(...)");
        NavigationSchema schema = navigationSchema;
        for (PsiClass psiClass : schema.getStyleablesForTag(tag.getName())) {
            this.registerAttributesForClassAndSuperclasses(facet, element, psiClass, callback2, skipAttrNames);
        }
    }

    @JvmStatic
    public static final void processLayoutAttributes(@NotNull AndroidFacet facet, @NotNull XmlTag tag, @NotNull LayoutElement element, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback2) {
        String parentTagName;
        String tagName;
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(skipAttrNames, (String)"skipAttrNames");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        if (!(element instanceof DataBindingElement)) {
            XmlElementDescriptor descriptor2;
            INSTANCE.registerToolsAttribute("targetApi", callback2);
            INSTANCE.registerToolsAttribute("ignore", callback2);
            if (tag.getParentTag() == null) {
                INSTANCE.registerToolsAttribute("context", callback2);
                INSTANCE.registerToolsAttribute("menu", callback2);
                INSTANCE.registerToolsAttribute("actionBarNavMode", callback2);
                INSTANCE.registerToolsAttribute("showIn", callback2);
                INSTANCE.registerToolsAttribute("viewBindingIgnore", callback2);
            }
            if ((descriptor2 = tag.getDescriptor()) instanceof LayoutViewElementDescriptor && ((LayoutViewElementDescriptor)descriptor2).getClazz() != null) {
                String viewClass = ((LayoutViewElementDescriptor)descriptor2).getClazz();
                INSTANCE.registerToolsAttribute("viewBindingType", callback2);
                if (InheritanceUtil.isInheritor((PsiClass)viewClass, (String)"android.widget.AdapterView")) {
                    INSTANCE.registerToolsAttribute("listitem", callback2);
                    INSTANCE.registerToolsAttribute("listheader", callback2);
                    INSTANCE.registerToolsAttribute("listfooter", callback2);
                }
                if (InheritanceUtil.isInheritor((PsiClass)viewClass, (String)AndroidXConstants.CLASS_DRAWER_LAYOUT.newName()) || InheritanceUtil.isInheritor((PsiClass)viewClass, (String)AndroidXConstants.CLASS_DRAWER_LAYOUT.oldName())) {
                    INSTANCE.registerToolsAttribute("openDrawer", callback2);
                }
                if (InheritanceUtil.isInheritor((PsiClass)viewClass, (String)AndroidXConstants.RECYCLER_VIEW.newName()) || InheritanceUtil.isInheritor((PsiClass)viewClass, (String)AndroidXConstants.RECYCLER_VIEW.oldName())) {
                    INSTANCE.registerToolsAttribute("itemCount", callback2);
                    INSTANCE.registerToolsAttribute("listitem", callback2);
                }
                if (InheritanceUtil.isInheritor((PsiClass)viewClass, (String)"androidx.compose.ui.platform.ComposeView")) {
                    INSTANCE.registerToolsAttribute("composableName", callback2);
                }
            }
        }
        if (element instanceof Tag || element instanceof Data) {
            return;
        }
        String string = tag.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        switch (tagName = string) {
            case "fragment": {
                INSTANCE.registerToolsAttribute("layout", callback2);
                break;
            }
            case "view": {
                PsiClass aClass;
                String name2 = tag.getAttributeValue("class");
                if (name2 == null || (aClass = AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet, name2)) == null) break;
                INSTANCE.registerAttributesForClassAndSuperclasses(facet, element, aClass, callback2, skipAttrNames);
                break;
            }
            case "merge": {
                if (tag.getParentTag() == null) {
                    INSTANCE.registerToolsAttribute("parentTag", callback2);
                }
                INSTANCE.registerAttributesForClassAndSuperclasses(facet, element, AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet, "merge"), callback2, skipAttrNames);
                parentTagName = tag.getAttributeValue("parentTag", "http://schemas.android.com/tools");
                if (parentTagName == null) break;
                INSTANCE.registerAttributesForClassAndSuperclasses(facet, element, AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet, parentTagName), callback2, skipAttrNames);
                break;
            }
            default: {
                PsiClass c = AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet, tagName);
                INSTANCE.registerAttributesForClassAndSuperclasses(facet, element, c, callback2, skipAttrNames);
            }
        }
        if (Intrinsics.areEqual((Object)tagName, (Object)"merge")) {
            return;
        }
        XmlTag parentTag = tag.getParentTag();
        if (parentTag != null) {
            PsiClass parentViewClass;
            String string2;
            String it = string2 = parentTag.getName();
            boolean bl = false;
            String string3 = !Intrinsics.areEqual((Object)it, (Object)"merge") ? string2 : null;
            if (string3 == null) {
                string3 = parentTag.getAttributeValue("parentTag", "http://schemas.android.com/tools");
            }
            PsiClass psiClass = (string2 = (parentTagName = string3)) == null ? null : (parentViewClass = Intrinsics.areEqual((Object)string2, (Object)"layout") ? AndroidClassesForXmlUtilKt.findViewClassByName(facet, "android.view.ViewGroup") : AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet, parentTagName));
            if (parentTagName != null) {
                while (parentViewClass != null) {
                    INSTANCE.registerAttributesFromSuffixedStyleables(facet, element, parentViewClass, callback2, skipAttrNames);
                    parentViewClass = INSTANCE.getSuperclass(parentViewClass);
                }
                return;
            }
        }
        INSTANCE.registerAttributesFromSuffixedStyleables(facet, element, callback2, skipAttrNames);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void processAttributes(@NotNull AndroidDomElement element, @NotNull AndroidFacet facet, boolean processAllExistingAttrsFirst, @NotNull AttributeProcessor callback2) {
        String styleableName;
        void $this$mapTo$iv$iv;
        String[] $this$map$iv;
        Object definitions;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Project project = facet.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.getInstance(project).isDumb()) {
            return;
        }
        XmlTag xmlTag = element.getXmlTag();
        if (xmlTag == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        XmlTag tag = xmlTag;
        Set<XmlName> skippedAttributes = processAllExistingAttrsFirst ? INSTANCE.registerExistingAttributes(facet, tag, element, callback2) : (Set<XmlName>)new LinkedHashSet();
        XmlElementDescriptor descriptor2 = tag.getDescriptor();
        if (descriptor2 instanceof TagFromClassDescriptor && ((TagFromClassDescriptor)descriptor2).getClazz() == null) {
            return;
        }
        AndroidDomElement androidDomElement = element;
        if (androidDomElement instanceof ManifestElement) {
            INSTANCE.processManifestAttributes(tag, element, callback2);
        } else if (androidDomElement instanceof LayoutElement) {
            AttributeProcessingUtil.processLayoutAttributes(facet, tag, (LayoutElement)element, skippedAttributes, callback2);
        } else if (androidDomElement instanceof XmlResourceElement) {
            INSTANCE.processXmlAttributes(facet, tag, (XmlResourceElement)element, skippedAttributes, callback2);
        } else if (androidDomElement instanceof XmlRawResourceElement) {
            INSTANCE.processRawAttributes(tag, callback2);
        } else if (androidDomElement instanceof NavDestinationElement) {
            INSTANCE.processNavAttributes(facet, tag, (NavDestinationElement)element, skippedAttributes, callback2);
        }
        Styleable styleable = (Styleable)element.getAnnotation(Styleable.class);
        if (styleable == null) {
            return;
        }
        Styleable styleableAnnotation = styleable;
        boolean isSystem = Intrinsics.areEqual((Object)styleableAnnotation.packageName(), (Object)"android");
        if (isSystem) {
            var10_10 = ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager();
            if (var10_10 == null || (stringArray = ((FrameworkResourceManager)var10_10).getAttributeDefinitions()) == null) return;
            v3 = stringArray;
        } else {
            var10_10 = ModuleResourceManagers.getInstance(facet).getLocalResourceManager().getAttributeDefinitions();
            Intrinsics.checkNotNull((Object)var10_10);
            v3 = definitions = var10_10;
        }
        if (element instanceof MenuItem) {
            INSTANCE.processMenuItemAttributes(facet, element, (Collection<XmlName>)skippedAttributes, callback2);
            return;
        }
        String namespaceUri = isSystem ? "http://schemas.android.com/apk/res/android" : "http://schemas.android.com/apk/res-auto";
        stringArray = styleableAnnotation.skippedAttributes();
        Set<XmlName> set2 = skippedAttributes;
        int $i$f$map = 0;
        void var13_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var19_27 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new XmlName((String)it, namespaceUri));
        }
        set2.addAll((List)destination$iv$iv);
        for (String styleableName2 : styleableAnnotation.value()) {
            StyleableDefinition styleable2 = definitions.getStyleableByName(styleableName2);
            if (styleable2 != null) {
                INSTANCE.registerStyleableAttributes(element, styleable2, namespaceUri, callback2, skippedAttributes);
                continue;
            }
            if (!isSystem) continue;
            AttributeProcessingUtil $this$thisLogger$iv = INSTANCE;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AttributeProcessingUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("@Styleable(" + styleableName2 + ") annotation doesn't point to existing styleable");
        }
        if (!(element instanceof InterpolatorElement) || (styleableName = InterpolatorDomFileDescription.getInterpolatorStyleableByTagName(tag.getName())) == null) return;
        StyleableDefinition styleable3 = definitions.getStyleableByName(styleableName);
        if (styleable3 == null) {
            AttributeProcessingUtil $this$thisLogger$iv = INSTANCE;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AttributeProcessingUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(styleableName + " doesn't point to existing styleable for interpolator");
            return;
        } else {
            INSTANCE.registerStyleableAttributes(element, styleable3, "http://schemas.android.com/apk/res/android", callback2, skippedAttributes);
        }
    }

    private final void processRawAttributes(XmlTag tag, AttributeProcessor callback2) {
        if (Intrinsics.areEqual((Object)tag.getName(), (Object)"resources")) {
            this.registerToolsAttribute("shrinkMode", callback2);
            this.registerToolsAttribute("keep", callback2);
            this.registerToolsAttribute("discard", callback2);
        }
    }

    private final void processManifestAttributes(XmlTag tag, AndroidDomElement element, AttributeProcessor callback2) {
        if (tag.getParentTag() != null) {
            this.registerToolsAttribute("node", callback2);
            this.registerToolsAttribute("strict", callback2);
            this.registerToolsAttribute("remove", callback2);
            this.registerToolsAttribute("replace", callback2);
        }
        if (element instanceof UsesSdk) {
            this.registerToolsAttribute("overrideLibrary", callback2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void processMenuItemAttributes(AndroidFacet facet, DomElement element, Collection<XmlName> skippedAttributes, AttributeProcessor callback) {
        var6_5 = ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager();
        if (var6_5 == null || (var7_6 = var6_5.getAttributeDefinitions()) == null) {
            return;
        }
        styleables = var7_6;
        styleable = styleables.getStyleableByName("MenuItem");
        if (styleable == null) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            v0 = Logger.getInstance(AttributeProcessingUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
            v0.warn("No StyleableDefinition for MenuItem");
            return;
        }
        for (AttributeDefinition attribute : styleable.getAttributes()) {
            block6: {
                Intrinsics.checkNotNullExpressionValue((Object)attribute.getName(), (String)"getName(...)");
                if (!Intrinsics.areEqual((Object)name, (Object)"showAsAction")) break block6;
                v1 = facet.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getModule(...)");
                if (DependencyManagementUtil.dependsOn(v1, GoogleMavenArtifactId.SUPPORT_APPCOMPAT_V7)) ** GOTO lbl-1000
                v2 = facet.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getModule(...)");
                if (DependencyManagementUtil.dependsOn(v2, GoogleMavenArtifactId.ANDROIDX_APPCOMPAT)) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = hasAppCompat = false;
                }
                if (hasAppCompat) {
                    xmlName = new XmlName(name, "http://schemas.android.com/apk/res-auto");
                    if (!skippedAttributes.add(xmlName)) continue;
                    Intrinsics.checkNotNull((Object)attribute);
                    this.registerAttribute(attribute, xmlName, "MenuItem", element, callback);
                    continue;
                }
            }
            if (!skippedAttributes.add(xmlName = new XmlName(name, "http://schemas.android.com/apk/res/android"))) continue;
            Intrinsics.checkNotNull((Object)attribute);
            this.registerAttribute(attribute, xmlName, "MenuItem", element, callback);
        }
    }

    private final void registerToolsAttribute(String attributeName, AttributeProcessor callback2) {
        AttributeDefinition definition = ToolsAttributeUtil.getAttrDefByName(attributeName);
        if (definition != null) {
            XmlName name2 = new XmlName(attributeName, "http://schemas.android.com/tools");
            DomExtension domExtension = callback2.processAttribute(name2, definition, null);
            Converter converter = ToolsAttributeUtil.getConverter(definition);
            if (domExtension != null && converter != null) {
                domExtension.setConverter(converter);
            }
        } else {
            AttributeProcessingUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AttributeProcessingUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("No attribute definition for tools attribute " + attributeName);
        }
    }

    private final Set<XmlName> registerExistingAttributes(AndroidFacet facet, XmlTag tag, AndroidDomElement element, AttributeProcessor callback2) {
        Set result2 = new LinkedHashSet();
        for (XmlAttribute attr : tag.getAttributes()) {
            AttributeDefinition attrDef;
            String localName;
            Intrinsics.checkNotNullExpressionValue((Object)attr.getLocalName(), (String)"getLocalName(...)");
            String string = CompletionUtil.DUMMY_IDENTIFIER_TRIMMED;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DUMMY_IDENTIFIER_TRIMMED");
            if (StringsKt.endsWith$default((String)localName, (String)string, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)attr.getNamespacePrefix(), (Object)"xmlns") || (attrDef = AndroidDomUtil.getAttributeDefinition(facet, attr)) == null) continue;
            XmlName xmlName = this.getXmlName(attrDef, attr.getNamespace());
            result2.add(xmlName);
            this.registerAttribute(attrDef, xmlName, null, element, callback2);
        }
        return result2;
    }

    private final XmlName getXmlName(AttributeDefinition attrDef, String namespaceUri) {
        ResourceReference resourceReference = attrDef.getResourceReference();
        Intrinsics.checkNotNullExpressionValue((Object)resourceReference, (String)"getResourceReference(...)");
        ResourceReference attrReference = resourceReference;
        String attrNamespaceUri = attrReference.getNamespace().getXmlNamespaceUri();
        return new XmlName(attrReference.getName(), Intrinsics.areEqual((Object)namespaceUri, (Object)"http://schemas.android.com/tools") ? "http://schemas.android.com/tools" : attrNamespaceUri);
    }

    private static final PsiClass getSuperclass$lambda$3(PsiClass $c) {
        PsiClass psiClass;
        PsiClass p0 = psiClass = $c;
        boolean bl = false;
        Object object = p0.isValid() ? psiClass : null;
        return object != null ? object.getSuperClass() : null;
    }

    private static final boolean registerAttributesFromSuffixedStyleablesForNamespace$lambda$5(ResourceItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        String name2 = item.getName();
        Intrinsics.checkNotNull((Object)name2);
        return StringsKt.endsWith$default((String)name2, (String)"_Layout", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name2, (String)"_LayoutParams", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name2, (Object)"ViewGroup_MarginLayout") || Intrinsics.areEqual((Object)name2, (Object)"TableRow_Cell");
    }

    static {
        Object[] objectArray = new String[]{"merge", "TableRow", "include", "requestFocus", "layout", "data", "import", "tag"};
        SIZE_NOT_REQUIRED_TAG_NAMES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"TableRow", "TableLayout", "merge", "GridLayout", AndroidXConstants.FQCN_GRID_LAYOUT_V7.oldName(), AndroidXConstants.FQCN_GRID_LAYOUT_V7.newName(), "android.support.percent.PercentRelativeLayout", "android.support.percent.PercentFrameLayout"};
        SIZE_NOT_REQUIRED_PARENT_TAG_NAMES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"layout_width", "layout_height"};
        REQUIRED_LAYOUT_ATTRIBUTE_LOCAL_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lorg/jetbrains/android/dom/AttributeProcessingUtil$AttributeProcessor;", "", "processAttribute", "Lcom/intellij/util/xml/reflect/DomExtension;", "xmlName", "Lcom/intellij/util/xml/XmlName;", "attrDef", "Lcom/android/tools/dom/attrs/AttributeDefinition;", "parentStyleableName", "", "intellij.android.core"})
    public static interface AttributeProcessor {
        @Nullable
        public DomExtension processAttribute(@NotNull XmlName var1, @NotNull AttributeDefinition var2, @Nullable String var3);
    }
}

