/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceItemWithVisibility;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.res.ResourceRepositoryRClass;
import com.android.tools.idea.res.ResourceUpdateTracer;
import com.android.tools.res.CacheableResourceRepository;
import com.android.tools.res.MultiResourceRepository;
import com.android.utils.TraceUtils;
import com.google.common.base.MoreObjects;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.augment.InnerRClassBase;
import org.jetbrains.android.augment.ResourceLightField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/android/augment/ResourceRepositoryInnerRClass;", "Lorg/jetbrains/android/augment/InnerRClassBase;", "resourceType", "Lcom/android/resources/ResourceType;", "resourcesSource", "Lcom/android/tools/idea/res/ResourceRepositoryRClass$ResourcesSource;", "parentClass", "Lorg/jetbrains/android/augment/AndroidLightClassBase;", "<init>", "(Lcom/android/resources/ResourceType;Lcom/android/tools/idea/res/ResourceRepositoryRClass$ResourcesSource;Lorg/jetbrains/android/augment/AndroidLightClassBase;)V", "doGetFields", "", "Lcom/intellij/psi/PsiField;", "()[Lcom/intellij/psi/PsiField;", "findFieldByName", "name", "", "checkBases", "", "fieldsDependencies", "Lcom/intellij/openapi/util/ModificationTracker;", "getFieldsDependencies", "()Lcom/intellij/openapi/util/ModificationTracker;", "scenarioUnsupported", "toString", "Companion", "intellij.android.core"})
public final class ResourceRepositoryInnerRClass
extends InnerRClassBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceRepositoryRClass.ResourcesSource resourcesSource;
    @NotNull
    private final ModificationTracker fieldsDependencies;

    public ResourceRepositoryInnerRClass(@NotNull ResourceType resourceType, @NotNull ResourceRepositoryRClass.ResourcesSource resourcesSource, @NotNull AndroidLightClassBase parentClass) {
        Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
        Intrinsics.checkNotNullParameter((Object)resourcesSource, (String)"resourcesSource");
        Intrinsics.checkNotNullParameter((Object)((Object)parentClass), (String)"parentClass");
        super(parentClass, resourceType);
        this.resourcesSource = resourcesSource;
        this.fieldsDependencies = () -> ResourceRepositoryInnerRClass.fieldsDependencies$lambda$2(this);
    }

    @Override
    @NotNull
    protected PsiField[] doGetFields() {
        PsiField[] fields2 = Companion.buildLocalResourceFields(this.getResourceType(), this.resourcesSource, this);
        if (fields2.length == 0) {
            CacheableResourceRepository cacheableResourceRepository = this.resourcesSource.getResourceRepository();
            Intrinsics.checkNotNullExpressionValue((Object)cacheableResourceRepository, (String)"getResourceRepository(...)");
            CacheableResourceRepository repository2 = cacheableResourceRepository;
            ResourceUpdateTracer.Companion.log((Function0<String>)((Function0)() -> ResourceRepositoryInnerRClass.doGetFields$lambda$1(this, repository2)));
        }
        return fields2;
    }

    @Override
    @Nullable
    public PsiField findFieldByName(@NotNull String name2, boolean checkBases) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (this.scenarioUnsupported(name2)) {
            return super.findFieldByName(name2, checkBases);
        }
        if (!this.resourcesSource.getResourceRepository().hasResources(this.resourcesSource.getResourceNamespace(), this.getResourceType(), name2)) {
            return null;
        }
        PsiClass psiClass = this;
        PsiPrimitiveType psiPrimitiveType = PsiTypes.intType();
        Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"intType(...)");
        return new ResourceLightField(name2, psiClass, (PsiType)psiPrimitiveType, AndroidLightField.FieldModifier.NON_FINAL, null, ResourceVisibility.PUBLIC);
    }

    @Override
    @NotNull
    protected ModificationTracker getFieldsDependencies() {
        return this.fieldsDependencies;
    }

    private final boolean scenarioUnsupported(String name2) {
        return this.getResourceType() == ResourceType.STYLEABLE || this.resourcesSource.getFieldModifier() == AndroidLightField.FieldModifier.FINAL || StringsKt.contains$default((CharSequence)name2, (CharSequence)"_", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public String toString() {
        String string = MoreObjects.toStringHelper((Object)((Object)this)).add("fqn", (Object)this.getQualifiedName()).add("repository", (Object)TraceUtils.getSimpleId((Object)this.resourcesSource.getResourceRepository())).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String doGetFields$lambda$1(ResourceRepositoryInnerRClass this$0, CacheableResourceRepository $repository) {
        StringBuilder stringBuilder;
        StringBuilder $this$doGetFields_u24lambda_u241_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$doGetFields_u24lambda_u241_u24lambda_u240.append(TraceUtils.getSimpleId((Object)((Object)this$0)) + " using repository " + TraceUtils.getSimpleId((Object)$repository) + ")");
        if ($repository instanceof MultiResourceRepository) {
            $this$doGetFields_u24lambda_u241_u24lambda_u240.append(" with children:").append('\n');
            for (ResourceRepository child : ((MultiResourceRepository)$repository).getChildren()) {
                $this$doGetFields_u24lambda_u241_u24lambda_u240.append("\t" + TraceUtils.getSimpleId((Object)child)).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    private static final long fieldsDependencies$lambda$2(ResourceRepositoryInnerRClass this$0) {
        return this$0.resourcesSource.getResourceRepository().getModificationCount();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/android/augment/ResourceRepositoryInnerRClass$Companion;", "", "<init>", "()V", "buildLocalResourceFields", "", "Lcom/intellij/psi/PsiField;", "resourceType", "Lcom/android/resources/ResourceType;", "resourcesSource", "Lcom/android/tools/idea/res/ResourceRepositoryRClass$ResourcesSource;", "context", "Lcom/intellij/psi/PsiClass;", "(Lcom/android/resources/ResourceType;Lcom/android/tools/idea/res/ResourceRepositoryRClass$ResourcesSource;Lcom/intellij/psi/PsiClass;)[Lcom/intellij/psi/PsiField;", "isResourceAccessible", "", "resource", "Lcom/android/ide/common/resources/ResourceItem;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PsiField[] buildLocalResourceFields(@NotNull ResourceType resourceType, @NotNull ResourceRepositoryRClass.ResourcesSource resourcesSource, @NotNull PsiClass context) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)resourcesSource, (String)"resourcesSource");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ResourceRepositoryRClass.ResourcesSource $this$buildLocalResourceFields_u24lambda_u240 = resourcesSource;
            boolean bl = false;
            CacheableResourceRepository cacheableResourceRepository = $this$buildLocalResourceFields_u24lambda_u240.getResourceRepository();
            Intrinsics.checkNotNullExpressionValue((Object)cacheableResourceRepository, (String)"getResourceRepository(...)");
            ResourceRepository resourceRepository = cacheableResourceRepository;
            ResourceNamespace resourceNamespace = $this$buildLocalResourceFields_u24lambda_u240.getResourceNamespace();
            Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"getResourceNamespace(...)");
            AndroidLightField.FieldModifier fieldModifier = $this$buildLocalResourceFields_u24lambda_u240.getFieldModifier();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)fieldModifier), (String)"getFieldModifier(...)");
            return InnerRClassBase.buildResourceFields(resourceRepository, resourceNamespace, fieldModifier, resourceType, context, $this$buildLocalResourceFields_u24lambda_u240.getResourceRepositoryManager(), (Function1<? super ResourceItem, Boolean>)((Function1)new Function1<ResourceItem, Boolean>((Object)Companion){

                public final Boolean invoke(ResourceItem p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.jetbrains.android.augment.ResourceRepositoryInnerRClass$Companion.access$isResourceAccessible((Companion)this.receiver, p0);
                }
            }));
        }

        private final boolean isResourceAccessible(ResourceItem resource) {
            boolean bl;
            if (!Intrinsics.areEqual((Object)resource.getNamespace(), (Object)ResourceNamespace.ANDROID) && resource.getLibraryName() == null) {
                bl = true;
            } else if (resource instanceof ResourceItemWithVisibility) {
                bl = ((ResourceItemWithVisibility)resource).getVisibility() == ResourceVisibility.PUBLIC;
            } else {
                throw new AssertionError((Object)("Library resource " + resource.getType() + "/" + resource.getName() + " of type " + resource.getClass().getSimpleName() + " doesn't implement ResourceItemWithVisibility"));
            }
            return bl;
        }

        public static final /* synthetic */ boolean access$isResourceAccessible(Companion $this, ResourceItem resource) {
            return $this.isResourceAccessible(resource);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

