/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions.widgets;

import com.android.tools.idea.projectsystem.AndroidProjectRootUtil;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/android/actions/widgets/SourceSetItem;", "", "sourceSetName", "", "resDirUrl", "displayableResDir", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getSourceSetName", "()Ljava/lang/String;", "getResDirUrl", "getDisplayableResDir", "toString", "Companion", "intellij.android.core"})
public final class SourceSetItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sourceSetName;
    @NotNull
    private final String resDirUrl;
    @NotNull
    private final String displayableResDir;

    public SourceSetItem(@NotNull String sourceSetName, @NotNull String resDirUrl, @NotNull String displayableResDir) {
        Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
        Intrinsics.checkNotNullParameter((Object)resDirUrl, (String)"resDirUrl");
        Intrinsics.checkNotNullParameter((Object)displayableResDir, (String)"displayableResDir");
        this.sourceSetName = sourceSetName;
        this.resDirUrl = resDirUrl;
        this.displayableResDir = displayableResDir;
    }

    @NotNull
    public final String getSourceSetName() {
        return this.sourceSetName;
    }

    @NotNull
    public final String getResDirUrl() {
        return this.resDirUrl;
    }

    @NotNull
    public final String getDisplayableResDir() {
        return this.displayableResDir;
    }

    @NotNull
    public String toString() {
        return this.sourceSetName + " (" + this.displayableResDir + ")";
    }

    @JvmStatic
    @Nullable
    public static final SourceSetItem create(@NotNull NamedIdeaSourceProvider sourceProvider, @NotNull Module module, @NotNull String resDirUrl) {
        return Companion.create(sourceProvider, module, resDirUrl);
    }

    @JvmStatic
    @Nullable
    public static final SourceSetItem create(@NotNull NamedModuleTemplate template, @NotNull File folder) {
        return Companion.create(template, folder);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/android/actions/widgets/SourceSetItem$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/android/actions/widgets/SourceSetItem;", "sourceProvider", "Lcom/android/tools/idea/projectsystem/NamedIdeaSourceProvider;", "module", "Lcom/intellij/openapi/module/Module;", "resDirUrl", "", "template", "Lcom/android/tools/idea/projectsystem/NamedModuleTemplate;", "folder", "Ljava/io/File;", "name", "modulePath", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final SourceSetItem create(@NotNull NamedIdeaSourceProvider sourceProvider, @NotNull Module module, @NotNull String resDirUrl) {
            Intrinsics.checkNotNullParameter((Object)sourceProvider, (String)"sourceProvider");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)resDirUrl, (String)"resDirUrl");
            return this.create(sourceProvider.getName(), AndroidProjectRootUtil.getModuleDirPath(module), resDirUrl);
        }

        @JvmStatic
        @Nullable
        public final SourceSetItem create(@NotNull NamedModuleTemplate template, @NotNull File folder) {
            Intrinsics.checkNotNullParameter((Object)template, (String)"template");
            Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
            String string = template.getName();
            File file = template.getPaths().getModuleRoot();
            String string2 = file != null ? file.getAbsolutePath() : null;
            String string3 = folder.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
            return this.create(string, string2, string3);
        }

        private final SourceSetItem create(String name2, String modulePath, String resDirUrl) {
            String relativeResourceUrl;
            String string;
            String string2;
            File file = new File(resDirUrl);
            File parent = file.getParentFile();
            if (parent == null || Intrinsics.areEqual((Object)parent.getName(), (Object)"generated")) {
                return null;
            }
            String string3 = FileUtil.toSystemIndependentName((String)PathUtil.toPresentableUrl((String)resDirUrl));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemIndependentName(...)");
            String resDirPath = string3;
            String string4 = modulePath;
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                String string5 = FileUtil.toSystemIndependentName((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toSystemIndependentName(...)");
                String modulePathSystemIndependent = string5;
                String string6 = FileUtil.getRelativePath((String)modulePathSystemIndependent, (String)resDirPath, (char)'/');
                if (string6 != null) {
                    CharSequence charSequence = string6;
                    Regex regex = new Regex("(\\.\\./)+");
                    String string7 = "";
                    string2 = regex.replaceFirst(charSequence, string7);
                } else {
                    string2 = null;
                }
            } else {
                string2 = null;
            }
            if ((string = (relativeResourceUrl = string2)) == null) {
                string = resDirPath;
            }
            String displayableResDir = ((Object)StringUtil.last((CharSequence)string, (int)30, (boolean)true)).toString();
            return new SourceSetItem(name2, resDirUrl, displayableResDir);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

