/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.adtui.font.FontUtil;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.ui.TextFieldWithBooleanBoxKt;
import com.android.tools.idea.ui.TextFieldWithColorPickerKt;
import com.android.tools.res.LocalResourceRepository;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.android.actions.CreateResourceDialogUtils;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.actions.CreateXmlResourcePanel;
import org.jetbrains.android.actions.CreateXmlResourceSubdirPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateXmlResourcePanelImpl
implements CreateXmlResourcePanel,
CreateXmlResourceSubdirPanel.Parent {
    private JPanel myPanel;
    private JTextField myNameField;
    private ModulesComboBox myModuleCombo;
    private JBLabel myModuleLabel;
    private JPanel myValueFieldContainer;
    private JBLabel myValueLabel;
    private JBLabel myNameLabel;
    private JComboBox myFileNameCombo;
    private JBLabel mySourceSetLabel;
    private JComboBox mySourceSetCombo;
    private JBLabel myFileNameLabel;
    @Nullable
    private final Module myModule;
    @NotNull
    private final ResourceType myResourceType;
    @NotNull
    private final ResourceFolderType myFolderType;
    private JPanel myDirectoriesPanel;
    private JBLabel myDirectoriesLabel;
    private JTextComponent myValueField;
    private CreateXmlResourceSubdirPanel mySubdirPanel;
    private IdeResourceNameValidator myResourceNameValidator;

    public CreateXmlResourcePanelImpl(@NotNull Module module, @NotNull ResourceType resourceType, @NotNull ResourceFolderType folderType, @Nullable String resourceName, @Nullable String resourceValue, boolean chooseName, boolean chooseValue, boolean chooseFilename, @Nullable VirtualFile defaultFile, @Nullable VirtualFile contextFile, @NotNull Function<Module, IdeResourceNameValidator> nameValidatorFactory) {
        String defaultFileName;
        this.myResourceType = resourceType;
        this.setupUI();
        this.setChangeNameVisible(false);
        this.setChangeValueVisible(false);
        this.setChangeFileNameVisible(chooseFilename);
        this.myFolderType = folderType;
        if (chooseName) {
            this.setChangeNameVisible(true);
            resourceName = IdeResourcesUtil.prependResourcePrefix(module, resourceName, folderType);
        }
        if (!StringUtil.isEmpty((String)resourceName)) {
            this.myNameField.setText(resourceName);
        }
        if (resourceType == ResourceType.COLOR) {
            Color defaultColor = ResourcesUtil.parseColor((String)resourceValue);
            this.myValueFieldContainer.removeAll();
            this.myValueFieldContainer.add(TextFieldWithColorPickerKt.wrapWithColorPickerIcon((JTextField)this.myValueField, defaultColor));
        } else if (resourceType == ResourceType.BOOL) {
            this.myValueFieldContainer.removeAll();
            this.myValueFieldContainer.add(TextFieldWithBooleanBoxKt.wrapWithBooleanCheckBox((JTextField)this.myValueField, Boolean.parseBoolean(resourceValue)));
        }
        if (chooseValue) {
            this.myValueField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent event) {
                    CreateXmlResourcePanelImpl.this.myValueField.setFont(FontUtil.getFontAbleToDisplay((String)CreateXmlResourcePanelImpl.this.myValueField.getText(), (Font)CreateXmlResourcePanelImpl.this.myValueField.getFont()));
                }
            });
            this.setChangeValueVisible(true);
            if (!StringUtil.isEmpty((String)resourceValue)) {
                this.myValueField.setText(resourceValue);
            }
        }
        HashSet<Module> modulesSet = new HashSet<Module>();
        modulesSet.add(module);
        if (this.includeDependentModules(module, contextFile)) {
            for (AndroidFacet depFacet : AndroidDependenciesCache.getAllAndroidDependencies(module, true)) {
                Module depModule = depFacet.getModule();
                AndroidModuleSystem depModuleSystem = ProjectSystemService.getInstance(module.getProject()).getProjectSystem().getModuleSystem(depModule);
                if (!depModuleSystem.getSupportsAndroidResources()) continue;
                modulesSet.add(depModule);
            }
        }
        assert (!modulesSet.isEmpty());
        this.myModuleCombo.setModules(modulesSet);
        this.myModuleCombo.setSelectedModule(module);
        if (modulesSet.size() == 1) {
            this.myModule = module;
            this.setChangeModuleVisible(false);
        } else {
            this.myModule = null;
        }
        this.myModuleCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CreateResourceDialogUtils.updateSourceSetCombo((JComponent)CreateXmlResourcePanelImpl.this.mySourceSetLabel, CreateXmlResourcePanelImpl.this.mySourceSetCombo, AndroidFacet.getInstance((Module)CreateXmlResourcePanelImpl.this.getModule()), null);
            }
        });
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CreateResourceDialogUtils.updateSourceSetCombo((JComponent)this.mySourceSetLabel, this.mySourceSetCombo, AndroidFacet.getInstance((Module)this.getModule()), null);
        if (defaultFile == null && (defaultFileName = IdeResourcesUtil.getDefaultResourceFileName(this.myResourceType)) != null) {
            this.myFileNameCombo.getEditor().setItem(defaultFileName);
        }
        this.myDirectoriesLabel.setLabelFor((Component)this.myDirectoriesPanel);
        this.mySubdirPanel = new CreateXmlResourceSubdirPanel(module.getProject(), folderType, this.myDirectoriesPanel, this);
        this.myResourceNameValidator = nameValidatorFactory.apply(this.getModule());
        this.myModuleCombo.addActionListener(e -> {
            this.mySubdirPanel.updateDirectories(true, this.getResourceDirectory());
            this.myResourceNameValidator = (IdeResourceNameValidator)nameValidatorFactory.apply(this.getModule());
        });
        if (defaultFile != null) {
            this.resetFromFile(defaultFile, module.getProject());
        }
    }

    private boolean includeDependentModules(Module module, @Nullable VirtualFile contextFile) {
        if (contextFile != null && "xml".equals(contextFile.getExtension())) {
            return true;
        }
        AndroidModuleSystem moduleSystem = ProjectSystemService.getInstance(module.getProject()).getProjectSystem().getModuleSystem(module);
        return moduleSystem.isRClassTransitive();
    }

    private void createUIComponents() {
        this.myValueFieldContainer = new JPanel();
        this.myValueFieldContainer.setFocusable(false);
        this.myValueFieldContainer.setLayout(new BoxLayout(this.myValueFieldContainer, 1));
        this.myValueFieldContainer.setUI(null);
        this.myValueFieldContainer.setOpaque(false);
        if (this.myResourceType == ResourceType.STRING) {
            JTextArea textArea = new JTextArea();
            textArea.setRows(3);
            this.myValueField = textArea;
            JBScrollPane scrollPane2 = new JBScrollPane((Component)textArea);
            textArea.setBorder((Border)JBUI.Borders.empty((int)1, (int)4));
            this.myValueFieldContainer.add((Component)scrollPane2);
        } else {
            this.myValueField = new JTextField();
            this.myValueFieldContainer.setBorder((Border)JBUI.Borders.empty());
            this.myValueFieldContainer.add(this.myValueField);
        }
        this.myValueField.setName("Resource value area");
    }

    @Override
    public void resetToDefault() {
        String defaultFileName;
        if (this.myModule == null) {
            this.myModuleCombo.setSelectedModule(this.getRootModule());
        }
        if ((defaultFileName = IdeResourcesUtil.getDefaultResourceFileName(this.myResourceType)) != null) {
            this.myFileNameCombo.getEditor().setItem(defaultFileName);
        }
        this.mySubdirPanel.resetToDefault();
    }

    @NotNull
    private Module getRootModule() {
        assert (this.myModule == null);
        ComboBoxModel model = this.myModuleCombo.getModel();
        Module root = null;
        int moduleDependencyCount = -1;
        for (int c = 0; c < model.getSize(); ++c) {
            Module otherModule = (Module)model.getElementAt(c);
            int otherModuleDependencyCount = AndroidDependenciesCache.getAllAndroidDependencies(otherModule, true).size();
            if (otherModuleDependencyCount <= moduleDependencyCount) continue;
            moduleDependencyCount = otherModuleDependencyCount;
            root = otherModule;
        }
        assert (root != null);
        return root;
    }

    @Override
    public void resetFromFile(@NotNull VirtualFile file, @NotNull Project project) {
        Module moduleForFile = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (moduleForFile == null) {
            return;
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return;
        }
        if (this.myModule == null) {
            Module prev = this.myModuleCombo.getSelectedModule();
            this.myModuleCombo.setSelectedItem((Object)moduleForFile);
            if (!moduleForFile.equals(this.myModuleCombo.getSelectedItem())) {
                this.myModuleCombo.setSelectedModule(prev);
                return;
            }
        } else if (!this.myModule.equals(moduleForFile)) {
            return;
        }
        this.mySubdirPanel.resetFromFile(parent);
        this.myFileNameCombo.getEditor().setItem(file.getName());
        this.myPanel.repaint();
    }

    @Override
    public ValidationInfo doValidate() {
        List resources;
        String resourceName = this.getResourceName();
        String resourceValue = this.getValue();
        Module selectedModule = this.getModule();
        VirtualFile resourceDir = this.getResourceDirectory();
        List<String> directoryNames = this.getDirNames();
        String fileName = this.getFileName();
        if (this.myNameField.isVisible() && resourceName.isEmpty()) {
            return new ValidationInfo("specify resource name", (JComponent)this.myNameField);
        }
        if (this.myNameField.isVisible() && !IdeResourcesUtil.isCorrectAndroidResourceName(resourceName)) {
            return new ValidationInfo(resourceName + " is not a correct resource name", (JComponent)this.myNameField);
        }
        if (fileName.isEmpty()) {
            return new ValidationInfo("specify file name", (JComponent)this.myFileNameCombo);
        }
        if (selectedModule == null) {
            return new ValidationInfo("specify module", (JComponent)this.myModuleCombo);
        }
        if (resourceDir == null) {
            return new ValidationInfo("specify a module with resources", (JComponent)this.myModuleCombo);
        }
        if (directoryNames.isEmpty()) {
            return new ValidationInfo("choose directories", (JComponent)this.myDirectoriesPanel);
        }
        if (resourceName.equals(IdeResourcesUtil.prependResourcePrefix(this.myModule, null, this.myFolderType))) {
            return new ValidationInfo("specify more than resource prefix", (JComponent)this.myNameField);
        }
        LocalResourceRepository<VirtualFile> moduleResources2 = StudioResourceRepositoryManager.getModuleResources(selectedModule);
        if (moduleResources2 != null && !(resources = moduleResources2.getResources(ResourceNamespace.RES_AUTO, this.myResourceType, resourceName)).isEmpty()) {
            return new ValidationInfo(resourceName + " is a resource that already exists", (JComponent)this.myNameField);
        }
        return CreateXmlResourceDialog.checkIfResourceAlreadyExists(selectedModule.getProject(), resourceDir, resourceName, resourceValue, this.myResourceType, directoryNames, fileName);
    }

    @Override
    @NotNull
    public IdeResourceNameValidator getResourceNameValidator() {
        return this.myResourceNameValidator;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        String name2 = this.myNameField.getText();
        if (name2.isEmpty() || this.myValueField.isVisible() && !this.myValueField.getText().isEmpty() || name2.equals(IdeResourcesUtil.prependResourcePrefix(this.myModule, null, this.myFolderType))) {
            return this.myNameField;
        }
        if (this.myValueField.isVisible()) {
            return this.myValueField;
        }
        if (this.myModuleCombo.isVisible()) {
            return this.myModuleCombo;
        }
        return this.myFileNameCombo;
    }

    @Override
    @NotNull
    public String getResourceName() {
        return this.myNameField.getText().trim();
    }

    @Override
    @NotNull
    public ResourceType getType() {
        return this.myResourceType;
    }

    @Override
    @NotNull
    public List<String> getDirNames() {
        return this.mySubdirPanel.getDirNames();
    }

    @Override
    @NotNull
    public String getFileName() {
        return ((String)this.myFileNameCombo.getEditor().getItem()).trim();
    }

    @Override
    @NotNull
    public String getValue() {
        return this.myValueField.getText();
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.myModule != null ? this.myModule : this.myModuleCombo.getSelectedModule();
    }

    @Override
    @Nullable
    public VirtualFile getResourceDirectory() {
        Module module = this.getModule();
        if (module == null) {
            return null;
        }
        PsiDirectory resDirectory = CreateResourceDialogUtils.getOrCreateResourceDirectory(this.mySourceSetCombo, module);
        return resDirectory != null ? resDirectory.getVirtualFile() : null;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    public void setAllowValueEditing(boolean enabled) {
        this.myValueField.setEnabled(enabled);
    }

    private void setChangeFileNameVisible(boolean isVisible) {
        this.myFileNameLabel.setVisible(isVisible);
        this.myFileNameCombo.setVisible(isVisible);
    }

    private void setChangeValueVisible(boolean isVisible) {
        this.myValueFieldContainer.setVisible(isVisible);
        this.myValueLabel.setVisible(isVisible);
    }

    private void setChangeNameVisible(boolean isVisible) {
        this.myNameField.setVisible(isVisible);
        this.myNameLabel.setVisible(isVisible);
    }

    private void setChangeModuleVisible(boolean isVisible) {
        this.myModuleLabel.setVisible(isVisible);
        this.myModuleCombo.setVisible(isVisible);
    }

    @Override
    public void updateFilesCombo(List<VirtualFile> directories) {
        Object oldItem = this.myFileNameCombo.getEditor().getItem();
        HashSet<String> fileNameSet = new HashSet<String>();
        for (VirtualFile dir : directories) {
            for (VirtualFile file : dir.getChildren()) {
                fileNameSet.add(file.getName());
            }
        }
        ArrayList fileNames = new ArrayList(fileNameSet);
        Collections.sort(fileNames);
        this.myFileNameCombo.setModel(new DefaultComboBoxModel<Object>(fileNames.toArray()));
        this.myFileNameCombo.getEditor().setItem(oldItem);
    }

    private void setupUI() {
        this.createUIComponents();
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 5, 0), -1, -1));
        this.myNameLabel = new JBLabel();
        this.myNameLabel.setText("Resource name:");
        this.myNameLabel.setDisplayedMnemonic('N');
        this.myNameLabel.setDisplayedMnemonicIndex(9);
        this.myPanel.add((Component)this.myNameLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myNameField = new JTextField();
        this.myPanel.add((Component)this.myNameField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.myModuleCombo = new ModulesComboBox();
        this.myPanel.add((Component)this.myModuleCombo, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.myModuleLabel = new JBLabel();
        this.myModuleLabel.setText("Module:");
        this.myModuleLabel.setDisplayedMnemonic('M');
        this.myModuleLabel.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)this.myModuleLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myFileNameLabel = new JBLabel();
        this.myFileNameLabel.setText("File name:");
        this.myFileNameLabel.setDisplayedMnemonic('F');
        this.myFileNameLabel.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)this.myFileNameLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myDirectoriesPanel = new JPanel();
        this.myDirectoriesPanel.setLayout(new BorderLayout(0, 0));
        this.myPanel.add((Component)this.myDirectoriesPanel, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        this.myDirectoriesLabel = new JBLabel();
        this.myDirectoriesLabel.setText("Create the resource in directories:");
        this.myDirectoriesLabel.setDisplayedMnemonic('C');
        this.myDirectoriesLabel.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)this.myDirectoriesLabel, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        this.myValueLabel = new JBLabel();
        this.myValueLabel.setText("Resource value:");
        this.myValueLabel.setDisplayedMnemonic('V');
        this.myValueLabel.setDisplayedMnemonicIndex(9);
        this.myPanel.add((Component)this.myValueLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myFileNameCombo = new JComboBox();
        this.myFileNameCombo.setEditable(true);
        this.myPanel.add((Component)this.myFileNameCombo, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.mySourceSetLabel = new JBLabel();
        this.mySourceSetLabel.setText("Source set:");
        this.mySourceSetLabel.setDisplayedMnemonic('S');
        this.mySourceSetLabel.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)this.mySourceSetLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.mySourceSetCombo = new JComboBox();
        this.myPanel.add((Component)this.mySourceSetCombo, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.myValueFieldContainer.setEnabled(true);
        this.myPanel.add((Component)this.myValueFieldContainer, new GridConstraints(1, 1, 1, 1, 0, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.myNameLabel.setLabelFor((Component)this.myNameField);
        this.myModuleLabel.setLabelFor((Component)this.myModuleCombo);
        this.myFileNameLabel.setLabelFor((Component)this.myFileNameCombo);
        this.mySourceSetLabel.setLabelFor((Component)this.myModuleCombo);
    }
}

