/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login2;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.Slow;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.gct.login2.AndroidUiFacade;
import com.google.gct.login2.CredentialedUser;
import com.google.gct.login2.CredentialedUsersManager;
import com.google.gct.login2.GoogleAccountClient;
import com.google.gct.login2.GoogleAccountClientImpl;
import com.google.gct.login2.GoogleLoginBundle;
import com.google.gct.login2.GoogleLoginService;
import com.google.gct.login2.GoogleLoginServiceImpl;
import com.google.gct.login2.GoogleLoginState;
import com.google.gct.login2.GoogleOAuthServer;
import com.google.gct.login2.Interceptor;
import com.google.gct.login2.LoginCompletedCallback;
import com.google.gct.login2.LoginFeature;
import com.google.gct.login2.OAuthServer;
import com.google.gct.login2.PreferredUser;
import com.google.gct.login2.StudioClientInfoKt;
import com.google.gct.login2.VetoableLogoutListener;
import com.google.gct.login2.common.OAuthDataStore;
import com.google.gct.login2.common.UiFacade;
import com.google.gct.login2.settings.GoogleLoginApplicationSettings;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GoogleLoginPluginEvent;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.jetbrains.rd.util.CollectionExKt;
import io.grpc.ClientInterceptor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010)\u001a\u00020\u00182\u0006\u0010,\u001a\u00020#2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010)\u001a\u00020\u0018H\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010#2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020#H\u0016JB\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u00020+062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u0002042\u0006\u0010:\u001a\u00020\u00182\b\u0010;\u001a\u0004\u0018\u00010<2\b\u0010=\u001a\u0004\u0018\u00010>H\u0016J\u0010\u0010?\u001a\u0002012\u0006\u0010@\u001a\u00020$H\u0016J\b\u0010A\u001a\u000201H\u0016J\b\u0010B\u001a\u00020\u0018H\u0002J\u001e\u0010C\u001a\u00020\u00182\u0006\u0010D\u001a\u00020#2\u0006\u0010E\u001a\u00020#H\u0082@\u00a2\u0006\u0002\u0010FJ\u001e\u0010G\u001a\u0002012\u0006\u00109\u001a\u0002042\u0006\u0010H\u001a\u00020IH\u0082@\u00a2\u0006\u0002\u0010JJB\u0010K\u001a\u000204*\u00020\u00162\f\u00105\u001a\b\u0012\u0004\u0012\u00020+062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u0002042\u0006\u0010:\u001a\u00020\u00182\b\u0010;\u001a\u0004\u0018\u00010<H\u0082@\u00a2\u0006\u0002\u0010LJH\u0010M\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u00020+062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u0002042\u0006\u0010:\u001a\u00020\u00182\b\u0010;\u001a\u0004\u0018\u00010<2\b\u0010=\u001a\u0004\u0018\u00010>H\u0096@\u00a2\u0006\u0002\u0010NJ\u0016\u0010O\u001a\u0002012\u0006\u0010@\u001a\u00020$H\u0096@\u00a2\u0006\u0002\u0010PJ\u000e\u0010Q\u001a\u000201H\u0096@\u00a2\u0006\u0002\u0010RJ\b\u0010S\u001a\u000201H\u0003J\b\u0010T\u001a\u000201H\u0016J&\u0010U\u001a\u0002012\b\u0010V\u001a\u0004\u0018\u00010W2\b\b\u0002\u00107\u001a\u0002082\b\b\u0002\u0010X\u001a\u00020YH\u0002J\u0016\u0010Z\u001a\u00020Y2\f\u00105\u001a\b\u0012\u0004\u0012\u00020+06H\u0002J\b\u0010[\u001a\u00020\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u00020\u00128\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR&\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"0!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001c\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010&\u00a8\u0006\\"}, d2={"Lcom/google/gct/login2/GoogleLoginServiceImpl;", "Lcom/google/gct/login2/GoogleLoginService;", "Lcom/intellij/openapi/Disposable;", "accountClient", "Lcom/google/gct/login2/GoogleAccountClient;", "transport", "Lcom/google/api/client/http/HttpTransport;", "uiFacade", "Lcom/google/gct/login2/common/UiFacade;", "oAuthServer", "Lcom/google/gct/login2/OAuthServer;", "loginApplicationSettings", "Lcom/google/gct/login2/settings/GoogleLoginApplicationSettings;", "<init>", "(Lcom/google/gct/login2/GoogleAccountClient;Lcom/google/api/client/http/HttpTransport;Lcom/google/gct/login2/common/UiFacade;Lcom/google/gct/login2/OAuthServer;Lcom/google/gct/login2/settings/GoogleLoginApplicationSettings;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "userManager", "Lcom/google/gct/login2/CredentialedUsersManager;", "getUserManager$google_login", "()Lcom/google/gct/login2/CredentialedUsersManager;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "value", "", "isInitialized", "()Z", "vetoableLogoutListeners", "", "Lcom/google/gct/login2/VetoableLogoutListener;", "getVetoableLogoutListeners", "()Ljava/util/List;", "allUsersFlow", "Lkotlinx/coroutines/flow/StateFlow;", "", "", "Lcom/google/gct/login2/CredentialedUser;", "getAllUsersFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "activeUserFlow", "getActiveUserFlow", "isLoggedIn", "feature", "Lcom/google/gct/login2/LoginFeature;", "email", "fetchOAuth2Token", "getActiveUserAuthInterceptor", "Lio/grpc/ClientInterceptor;", "setActiveUser", "", "userEmail", "logInBlocking", "Lcom/google/gct/login2/PreferredUser;", "features", "", "loginType", "Lcom/google/wireless/android/sdk/stats/GoogleLoginPluginEvent$LoginType;", "preferredUser", "switchActiveUserIfApplicable", "loginCompletedCallback", "Lcom/google/gct/login2/LoginCompletedCallback;", "parentComponent", "Ljavax/swing/JComponent;", "logOutSingleUserAsync", "user", "logOutAllUsersAsync", "confirmLogOut", "askYesOrNoForSwitchAccountIntent", "fromUser", "toUser", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "maybeSetActiveUser", "newState", "Lcom/google/gct/login2/GoogleLoginState;", "(Lcom/google/gct/login2/PreferredUser;Lcom/google/gct/login2/GoogleLoginState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performLogIn", "(Lkotlinx/coroutines/CoroutineScope;Ljava/util/Set;Lcom/google/wireless/android/sdk/stats/GoogleLoginPluginEvent$LoginType;Lcom/google/gct/login2/PreferredUser;ZLcom/google/gct/login2/LoginCompletedCallback;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logIn", "(Ljava/util/Set;Lcom/google/wireless/android/sdk/stats/GoogleLoginPluginEvent$LoginType;Lcom/google/gct/login2/PreferredUser;ZLcom/google/gct/login2/LoginCompletedCallback;Ljavax/swing/JComponent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logOutSingleUser", "(Lcom/google/gct/login2/CredentialedUser;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logOutAllUsers", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initializeUsers", "dispose", "trackEvent", "eventKind", "Lcom/google/wireless/android/sdk/stats/GoogleLoginPluginEvent$EventKind;", "loginFeatures", "Lcom/google/wireless/android/sdk/stats/GoogleLoginPluginEvent$LoginFeatures;", "buildLoginFeatures", "shouldLogOut", "google-login"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGoogleLoginService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleLoginService.kt\ncom/google/gct/login2/GoogleLoginServiceImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,550:1\n25#2:551\n40#3,3:552\n1#4:555\n1#4:591\n1734#5,3:556\n1734#5,3:559\n1485#5:563\n1510#5,3:564\n1513#5,3:574\n1557#5:587\n1628#5,3:588\n1557#5:595\n1628#5,3:596\n1734#5,3:599\n1863#5,2:602\n216#6:562\n136#6,9:577\n216#6:586\n217#6:592\n145#6:593\n217#6:594\n381#7,7:567\n*S KotlinDebug\n*F\n+ 1 GoogleLoginService.kt\ncom/google/gct/login2/GoogleLoginServiceImpl\n*L\n155#1:551\n152#1:552,3\n459#1:591\n419#1:556,3\n442#1:559,3\n458#1:563\n458#1:564,3\n458#1:574,3\n462#1:587\n462#1:588,3\n523#1:595\n523#1:596,3\n528#1:599,3\n530#1:602,2\n455#1:562\n459#1:577,9\n459#1:586\n459#1:592\n459#1:593\n455#1:594\n458#1:567,7\n*E\n"})
public final class GoogleLoginServiceImpl
implements GoogleLoginService,
Disposable {
    @NotNull
    private final HttpTransport transport;
    @NotNull
    private final UiFacade uiFacade;
    @NotNull
    private final OAuthServer oAuthServer;
    @NotNull
    private final GoogleLoginApplicationSettings loginApplicationSettings;
    @NotNull
    private final Logger logger;
    @VisibleForTesting
    @NotNull
    private final CredentialedUsersManager userManager;
    @NotNull
    private final CoroutineScope scope;
    private boolean isInitialized;
    @NotNull
    private final List<VetoableLogoutListener> vetoableLogoutListeners;
    public static final int $stable = 8;

    public GoogleLoginServiceImpl(@NotNull GoogleAccountClient accountClient, @NotNull HttpTransport transport, @NotNull UiFacade uiFacade, @NotNull OAuthServer oAuthServer, @NotNull GoogleLoginApplicationSettings loginApplicationSettings) {
        Intrinsics.checkNotNullParameter((Object)accountClient, (String)"accountClient");
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)uiFacade, (String)"uiFacade");
        Intrinsics.checkNotNullParameter((Object)oAuthServer, (String)"oAuthServer");
        Intrinsics.checkNotNullParameter((Object)loginApplicationSettings, (String)"loginApplicationSettings");
        this.transport = transport;
        this.uiFacade = uiFacade;
        this.oAuthServer = oAuthServer;
        this.loginApplicationSettings = loginApplicationSettings;
        GoogleLoginServiceImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GoogleLoginServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.userManager = new CredentialedUsersManager(this.loginApplicationSettings, accountClient);
        this.scope = CoroutineUtilsKt.createCoroutineScope$default((Disposable)this, null, null, (int)3, null);
        this.vetoableLogoutListeners = new ArrayList();
        String testModeUser = System.getenv("GOOGLE_LOGIN_USER");
        if (testModeUser != null) {
            this.logger.info("Added fake Google user: " + testModeUser);
            this.userManager.addOrUpdateUser(new GoogleLoginState(this.transport, this.uiFacade, this.oAuthServer, this.loginApplicationSettings, testModeUser));
            this.setActiveUser(testModeUser);
            this.isInitialized = true;
        } else {
            BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ GoogleLoginServiceImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            try {
                                this.this$0.initializeUsers();
                                LoginFeature enforcedFeature = LoginFeature.Companion.getExtensionByKey("User Info");
                                if (enforcedFeature == null) {
                                    String string = "Required value was null.";
                                    throw new IllegalStateException(string.toString());
                                }
                                if (this.this$0.isLoggedIn(enforcedFeature)) {
                                    GoogleLoginServiceImpl.trackEvent$default(this.this$0, GoogleLoginPluginEvent.EventKind.LOGGED_IN_ON_STUDIO_START, null, null, 6, null);
                                }
                            }
                            catch (Exception e) {
                                this.this$0.logger.warn("Error when initializing users: " + e);
                            }
                            finally {
                                this.this$0.isInitialized = true;
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public /* synthetic */ GoogleLoginServiceImpl(GoogleAccountClient googleAccountClient, HttpTransport httpTransport, UiFacade uiFacade, OAuthServer oAuthServer, GoogleLoginApplicationSettings googleLoginApplicationSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            googleAccountClient = new GoogleAccountClientImpl();
        }
        if ((n & 2) != 0) {
            httpTransport = (HttpTransport)new NetHttpTransport();
        }
        if ((n & 4) != 0) {
            String string = StudioClientInfoKt.getStudioClientInfo().getDetails().getClientId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClientId(...)");
            uiFacade = new AndroidUiFacade(string);
        }
        if ((n & 8) != 0) {
            oAuthServer = new GoogleOAuthServer(httpTransport);
        }
        if ((n & 0x10) != 0) {
            boolean $i$f$service = false;
            Class<GoogleLoginApplicationSettings> serviceClass$iv = GoogleLoginApplicationSettings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            googleLoginApplicationSettings = (GoogleLoginApplicationSettings)object;
        }
        this(googleAccountClient, httpTransport, uiFacade, oAuthServer, googleLoginApplicationSettings);
    }

    @NotNull
    public final CredentialedUsersManager getUserManager$google_login() {
        return this.userManager;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    @NotNull
    public List<VetoableLogoutListener> getVetoableLogoutListeners() {
        return this.vetoableLogoutListeners;
    }

    @Override
    @NotNull
    public StateFlow<Map<String, CredentialedUser>> getAllUsersFlow() {
        return this.userManager.getAllUsersFlow();
    }

    @Override
    @NotNull
    public StateFlow<CredentialedUser> getActiveUserFlow() {
        return this.userManager.getActiveUserFlow();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLoggedIn(@NotNull LoginFeature feature) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        CredentialedUser credentialedUser = (CredentialedUser)this.getActiveUserFlow().getValue();
        if (credentialedUser != null) {
            if (credentialedUser.isLoggedIn(feature)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        String string = System.getenv("GOOGLE_LOGIN_USER");
        if (string == null) return false;
        CredentialedUser credentialedUser2 = (CredentialedUser)this.getActiveUserFlow().getValue();
        if (!string.equals(credentialedUser2 != null ? credentialedUser2.getEmail() : null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLoggedIn(@NotNull String email, @NotNull LoginFeature feature) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        CredentialedUser credentialedUser = (CredentialedUser)((Map)this.getAllUsersFlow().getValue()).get(email);
        if (credentialedUser != null) {
            if (credentialedUser.isLoggedIn(feature)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        String string = System.getenv("GOOGLE_LOGIN_USER");
        if (string == null) return false;
        if (!string.equals(email)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLoggedIn() {
        if (this.getActiveUserFlow().getValue() != null) return true;
        String string = System.getenv("GOOGLE_LOGIN_USER");
        if (string == null) return false;
        CredentialedUser credentialedUser = (CredentialedUser)this.getActiveUserFlow().getValue();
        if (!string.equals(credentialedUser != null ? credentialedUser.getEmail() : null)) return false;
        return true;
    }

    @Override
    @Nullable
    public String fetchOAuth2Token(@NotNull LoginFeature feature) {
        String string;
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        CredentialedUser credentialedUser = (CredentialedUser)this.getActiveUserFlow().getValue();
        if (credentialedUser == null) {
            return null;
        }
        CredentialedUser lastActiveUser = credentialedUser;
        try {
            string = lastActiveUser.fetchAccessToken$google_login(feature);
        }
        catch (TokenResponseException e) {
            this.userManager.removeInvalidatedLogins(lastActiveUser.getEmail());
            throw e;
        }
        return string;
    }

    @Override
    @NotNull
    public ClientInterceptor getActiveUserAuthInterceptor(@NotNull LoginFeature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return new Interceptor((Function0<String>)((Function0)() -> GoogleLoginServiceImpl.getActiveUserAuthInterceptor$lambda$0(this, feature)));
    }

    @Override
    public void setActiveUser(@NotNull String userEmail) {
        Intrinsics.checkNotNullParameter((Object)userEmail, (String)"userEmail");
        this.userManager.setActiveUser(userEmail);
    }

    @Override
    @NotNull
    public PreferredUser logInBlocking(@NotNull Set<? extends LoginFeature> features, @NotNull GoogleLoginPluginEvent.LoginType loginType, @NotNull PreferredUser preferredUser, boolean switchActiveUserIfApplicable, @Nullable LoginCompletedCallback loginCompletedCallback, @Nullable JComponent parentComponent) {
        JComponent jComponent;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(features, (String)"features");
                Intrinsics.checkNotNullParameter((Object)loginType, (String)"loginType");
                Intrinsics.checkNotNullParameter((Object)preferredUser, (String)"preferredUser");
                jComponent = parentComponent;
                if (jComponent == null) break block2;
                JComponent it = jComponent;
                boolean bl = false;
                ModalTaskOwner modalTaskOwner = ModalTaskOwner.component((Component)it);
                jComponent = modalTaskOwner;
                if (modalTaskOwner != null) break block3;
            }
            ModalTaskOwner modalTaskOwner = ModalTaskOwner.guess();
            jComponent = modalTaskOwner;
            Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"guess(...)");
        }
        return (PreferredUser)TasksKt.runWithModalProgressBlocking((ModalTaskOwner)jComponent, (String)GoogleLoginBundle.Companion.message("google.sign.in.progress.title", new Object[0]), (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.cancellable()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PreferredUser>, Object>(this, features, loginType, preferredUser, switchActiveUserIfApplicable, loginCompletedCallback, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ GoogleLoginServiceImpl this$0;
            final /* synthetic */ Set<LoginFeature> $features;
            final /* synthetic */ GoogleLoginPluginEvent.LoginType $loginType;
            final /* synthetic */ PreferredUser $preferredUser;
            final /* synthetic */ boolean $switchActiveUserIfApplicable;
            final /* synthetic */ LoginCompletedCallback $loginCompletedCallback;
            {
                this.this$0 = $receiver;
                this.$features = $features;
                this.$loginType = $loginType;
                this.$preferredUser = $preferredUser;
                this.$switchActiveUserIfApplicable = $switchActiveUserIfApplicable;
                this.$loginCompletedCallback = $loginCompletedCallback;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void var2_3;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$runWithModalProgressBlocking = (CoroutineScope)this.L$0;
                        this.label = 1;
                        Object object3 = GoogleLoginServiceImpl.access$performLogIn(this.this$0, (CoroutineScope)var2_3, this.$features, this.$loginType, this.$preferredUser, this.$switchActiveUserIfApplicable, this.$loginCompletedCallback, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super PreferredUser> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    public void logOutSingleUserAsync(@NotNull CredentialedUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (!this.shouldLogOut()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, user, null){
            int label;
            final /* synthetic */ GoogleLoginServiceImpl this$0;
            final /* synthetic */ CredentialedUser $user;
            {
                this.this$0 = $receiver;
                this.$user = $user;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.logOutSingleUser(this.$user, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void logOutAllUsersAsync() {
        if (!this.confirmLogOut() || !this.shouldLogOut()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GoogleLoginServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.logOutAllUsers((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final boolean confirmLogOut() {
        return this.uiFacade.askYesOrNo("Sign out?", "Are you sure you want to sign out? This will sign out all logged in users.");
    }

    private final Object askYesOrNoForSwitchAccountIntent(String fromUser, String toUser, Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, fromUser, toUser, null){
            int label;
            final /* synthetic */ GoogleLoginServiceImpl this$0;
            final /* synthetic */ String $fromUser;
            final /* synthetic */ String $toUser;
            {
                this.this$0 = $receiver;
                this.$fromUser = $fromUser;
                this.$toUser = $toUser;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return Boxing.boxBoolean((boolean)GoogleLoginServiceImpl.access$getUiFacade$p(this.this$0).askYesOrNo("Confirm account switch", "Your currently active account is " + this.$fromUser + ". Would you like to switch to " + this.$toUser + "?"));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object maybeSetActiveUser(PreferredUser var1_1, GoogleLoginState var2_2, Continuation<? super Unit> $completion) {
        if (!($completion instanceof maybeSetActiveUser.1)) ** GOTO lbl-1000
        var10_4 = $completion;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GoogleLoginServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GoogleLoginServiceImpl.access$maybeSetActiveUser(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = PreferredUser.ActiveUser.INSTANCE.getEmail();
                if (v0 == null) {
                    $this$maybeSetActiveUser_u24lambda_u242 = this;
                    $i$a$-run-GoogleLoginServiceImpl$maybeSetActiveUser$currentlyActiveUserEmail$1 = false;
                    $this$maybeSetActiveUser_u24lambda_u242.setActiveUser(newState.getEmail());
                    return Unit.INSTANCE;
                }
                currentlyActiveUserEmail = v0;
                userSwitchDuringTheFlow = preferredUser.getEmail() != null && Intrinsics.areEqual((Object)preferredUser.getEmail(), (Object)newState.getEmail()) == false;
                v1 = shouldAsk = userSwitchDuringTheFlow != false && Intrinsics.areEqual((Object)currentlyActiveUserEmail, (Object)newState.getEmail()) == false;
                if (!shouldAsk) ** GOTO lbl34
                $continuation.L$0 = newState;
                $continuation.label = 1;
                v2 = this.askYesOrNoForSwitchAccountIntent(currentlyActiveUserEmail, newState.getEmail(), (Continuation<? super Boolean>)$continuation);
                if (v2 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                newState = (GoogleLoginState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl32:
                // 2 sources

                if (!((Boolean)v2).booleanValue()) {
                    return Unit.INSTANCE;
                }
lbl34:
                // 3 sources

                this.setActiveUser(newState.getEmail());
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object performLogIn(CoroutineScope var1_1, Set<? extends LoginFeature> var2_2, GoogleLoginPluginEvent.LoginType var3_3, PreferredUser var4_4, boolean var5_5, LoginCompletedCallback var6_6, Continuation<? super PreferredUser> $completion) {
        if (!($completion instanceof performLogIn.1)) ** GOTO lbl-1000
        var12_8 = $completion;
        if ((var12_8.label & -2147483648) != 0) {
            var12_8.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ GoogleLoginServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GoogleLoginServiceImpl.access$performLogIn(this.this$0, null, null, null, null, false, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = features;
                $continuation.L$1 = loginType;
                $continuation.L$2 = preferredUser;
                $continuation.L$3 = loginCompletedCallback;
                $continuation.Z$0 = switchActiveUserIfApplicable;
                $continuation.label = 1;
                v0 = BuildersKt.async$default((CoroutineScope)$this$performLogIn, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GoogleLoginState>, Object>((Set<? extends LoginFeature>)features, preferredUser, this, loginType, null){
                    int label;
                    final /* synthetic */ Set<LoginFeature> $features;
                    final /* synthetic */ PreferredUser $preferredUser;
                    final /* synthetic */ GoogleLoginServiceImpl this$0;
                    final /* synthetic */ GoogleLoginPluginEvent.LoginType $loginType;
                    {
                        this.$features = $features;
                        this.$preferredUser = $preferredUser;
                        this.this$0 = $receiver;
                        this.$loginType = $loginType;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return GoogleLoginState.Companion.loginAndCreate(this.$features, this.$preferredUser.getEmail(), GoogleLoginServiceImpl.access$getTransport$p(this.this$0), GoogleLoginServiceImpl.access$getUiFacade$p(this.this$0), GoogleLoginServiceImpl.access$getOAuthServer$p(this.this$0), GoogleLoginServiceImpl.access$getLoginApplicationSettings$p(this.this$0), this.$loginType);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super GoogleLoginState> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null).await((Continuation)$continuation);
                ** if (v0 != var13_10) goto lbl23
lbl22:
                // 1 sources

                return var13_10;
lbl23:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                switchActiveUserIfApplicable = $continuation.Z$0;
                loginCompletedCallback = (LoginCompletedCallback)$continuation.L$3;
                preferredUser = (PreferredUser)$continuation.L$2;
                loginType = (GoogleLoginPluginEvent.LoginType)$continuation.L$1;
                features = (Set)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl34:
                    // 2 sources

                    var9_11 = (GoogleLoginState)v0;
                }
                catch (CancellationException e) {
                    this.logger.info("Login cancelled.");
                    this.uiFacade.stop();
                    throw e;
                }
                newState = var9_11;
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PreferredUser>, Object>(newState, this, loginType, (Set<? extends LoginFeature>)features, switchActiveUserIfApplicable != false, preferredUser, loginCompletedCallback, null){
                    int label;
                    final /* synthetic */ GoogleLoginState $newState;
                    final /* synthetic */ GoogleLoginServiceImpl this$0;
                    final /* synthetic */ GoogleLoginPluginEvent.LoginType $loginType;
                    final /* synthetic */ Set<LoginFeature> $features;
                    final /* synthetic */ boolean $switchActiveUserIfApplicable;
                    final /* synthetic */ PreferredUser $preferredUser;
                    final /* synthetic */ LoginCompletedCallback $loginCompletedCallback;
                    {
                        this.$newState = $newState;
                        this.this$0 = $receiver;
                        this.$loginType = $loginType;
                        this.$features = $features;
                        this.$switchActiveUserIfApplicable = $switchActiveUserIfApplicable;
                        this.$preferredUser = $preferredUser;
                        this.$loginCompletedCallback = $loginCompletedCallback;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        block7: {
                            var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    if (this.$newState == null) break;
                                    GoogleLoginServiceImpl.access$trackEvent(this.this$0, GoogleLoginPluginEvent.EventKind.LOGIN_WITH_SUCCESS, this.$loginType, GoogleLoginServiceImpl.access$buildLoginFeatures(this.this$0, this.$features));
                                    this.this$0.getUserManager$google_login().addOrUpdateUser(this.$newState);
                                    if (PreferredUser.ActiveUser.INSTANCE.getEmail() == null || Intrinsics.areEqual((Object)this.$newState.getEmail(), (Object)PreferredUser.ActiveUser.INSTANCE.getEmail()) || this.$switchActiveUserIfApplicable) {
                                        this.label = 1;
                                        v0 = GoogleLoginServiceImpl.access$maybeSetActiveUser(this.this$0, this.$preferredUser, this.$newState, (Continuation)this);
                                        if (v0 == var8_2) {
                                            return var8_2;
                                        }
                                    }
                                    ** GOTO lbl17
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl17:
                                    // 2 sources

                                    var2_3 = new PreferredUser.User(this.$newState.getEmail());
                                    var3_4 = this.$loginCompletedCallback;
                                    var4_5 = this.$loginType;
                                    var5_6 = this.this$0;
                                    it = var2_3;
                                    $i$a$-also-GoogleLoginServiceImpl$performLogIn$2$1 = false;
                                    v1 = var3_4;
                                    if (v1 != null) {
                                        v1.onCompleted(it, var4_5);
                                    }
                                    GoogleLoginServiceImpl.access$getLogger$p(var5_6).info("Login succeeded.");
                                    v2 = var2_3;
                                    break block7;
                                }
                            }
                            GoogleLoginServiceImpl.access$trackEvent(this.this$0, GoogleLoginPluginEvent.EventKind.LOGIN_WITH_FAILURE, this.$loginType, GoogleLoginServiceImpl.access$buildLoginFeatures(this.this$0, this.$features));
                            GoogleLoginServiceImpl.access$getLogger$p(this.this$0).info("Login failed.");
                            v2 = PreferredUser.None.INSTANCE;
                        }
                        return v2;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super PreferredUser> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var13_10) {
                    return var13_10;
                }
                ** GOTO lbl53
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl53:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object logIn(@NotNull Set<? extends LoginFeature> features, @NotNull GoogleLoginPluginEvent.LoginType loginType, @NotNull PreferredUser preferredUser, boolean switchActiveUserIfApplicable, @Nullable LoginCompletedCallback loginCompletedCallback, @Nullable JComponent parentComponent, @NotNull Continuation<? super PreferredUser> $completion) {
        JComponent jComponent;
        block3: {
            block2: {
                jComponent = parentComponent;
                if (jComponent == null) break block2;
                JComponent it = jComponent;
                boolean bl = false;
                ModalTaskOwner modalTaskOwner = ModalTaskOwner.component((Component)it);
                jComponent = modalTaskOwner;
                if (modalTaskOwner != null) break block3;
            }
            ModalTaskOwner modalTaskOwner = ModalTaskOwner.guess();
            jComponent = modalTaskOwner;
            Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"guess(...)");
        }
        return TasksKt.withModalProgress((ModalTaskOwner)jComponent, (String)GoogleLoginBundle.Companion.message("google.sign.in.progress.title", new Object[0]), (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.cancellable()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PreferredUser>, Object>(this, features, loginType, preferredUser, switchActiveUserIfApplicable, loginCompletedCallback, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ GoogleLoginServiceImpl this$0;
            final /* synthetic */ Set<LoginFeature> $features;
            final /* synthetic */ GoogleLoginPluginEvent.LoginType $loginType;
            final /* synthetic */ PreferredUser $preferredUser;
            final /* synthetic */ boolean $switchActiveUserIfApplicable;
            final /* synthetic */ LoginCompletedCallback $loginCompletedCallback;
            {
                this.this$0 = $receiver;
                this.$features = $features;
                this.$loginType = $loginType;
                this.$preferredUser = $preferredUser;
                this.$switchActiveUserIfApplicable = $switchActiveUserIfApplicable;
                this.$loginCompletedCallback = $loginCompletedCallback;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void var2_3;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$withModalProgress = (CoroutineScope)this.L$0;
                        this.label = 1;
                        Object object3 = GoogleLoginServiceImpl.access$performLogIn(this.this$0, (CoroutineScope)var2_3, this.$features, this.$loginType, this.$preferredUser, this.$switchActiveUserIfApplicable, this.$loginCompletedCallback, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super PreferredUser> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object logOutSingleUser(@NotNull CredentialedUser var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof logOutSingleUser.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ GoogleLoginServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.logOutSingleUser(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.userManager.removeUser(user.getEmail());
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Boolean>>, Object>((CredentialedUser)user, null){
                    int label;
                    final /* synthetic */ CredentialedUser $user;
                    {
                        this.$user = $user;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$mapTo$iv$iv;
                                ResultKt.throwOnFailure((Object)object);
                                Iterable $this$map$iv = this.$user.getLoginStates$google_login();
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    GoogleLoginState googleLoginState = (GoogleLoginState)item$iv$iv;
                                    Collection collection2 = destination$iv$iv;
                                    boolean bl = false;
                                    collection2.add(Boxing.boxBoolean((boolean)it.logOut()));
                                }
                                return (List)destination$iv$iv;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super List<Boolean>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                allStatus = (List)v0;
                if (this.getActiveUserFlow().getValue() == null) {
                    v1 = CollectionExKt.firstOrNull((Map)((Map)this.getAllUsersFlow().getValue()));
                    if (v1 != null) {
                        it = v1;
                        $i$a$-let-GoogleLoginServiceImpl$logOutSingleUser$2 = false;
                        this.setActiveUser((String)it.getKey());
                    }
                }
                $this$all$iv = allStatus;
                $i$f$all = false;
                if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) ** GOTO lbl34
                v2 = true;
                ** GOTO lbl41
lbl34:
                // 2 sources

                for (T element$iv : $this$all$iv) {
                    it = (Boolean)element$iv;
                    $i$a$-all-GoogleLoginServiceImpl$logOutSingleUser$3 = false;
                    if (it != false) continue;
                    v2 = false;
                    ** GOTO lbl41
                }
                v2 = true;
lbl41:
                // 3 sources

                if (v2) {
                    GoogleLoginServiceImpl.trackEvent$default(this, GoogleLoginPluginEvent.EventKind.LOGOUT_WITH_SUCCESS, null, null, 6, null);
                } else {
                    GoogleLoginServiceImpl.trackEvent$default(this, GoogleLoginPluginEvent.EventKind.LOGOUT_WITH_FAILURE, null, null, 6, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object logOutAllUsers(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof logOutAllUsers.1)) ** GOTO lbl-1000
        var11_2 = $completion;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ GoogleLoginServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.logOutAllUsers((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                lastAllUsers = (Map)this.getAllUsersFlow().getValue();
                this.userManager.removeAllUsers();
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Boolean>>, Object>((Map<String, CredentialedUser>)lastAllUsers, null){
                    int label;
                    final /* synthetic */ Map<String, CredentialedUser> $lastAllUsers;
                    {
                        this.$lastAllUsers = $lastAllUsers;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$mapTo$iv$iv;
                                Object list$iv$iv;
                                CredentialedUser it;
                                Iterable $this$flatMapTo$iv$iv;
                                ResultKt.throwOnFailure((Object)object);
                                Iterable $this$flatMap$iv = this.$lastAllUsers.values();
                                boolean $i$f$flatMap = false;
                                Iterable iterable = $this$flatMap$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$flatMapTo = false;
                                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                                    it = (CredentialedUser)element$iv$iv;
                                    boolean bl = false;
                                    list$iv$iv = it.getLoginStates$google_login();
                                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                                }
                                Iterable $this$map$iv = (List)destination$iv$iv;
                                boolean $i$f$map = false;
                                $this$flatMapTo$iv$iv = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    list$iv$iv = (GoogleLoginState)item$iv$iv;
                                    Collection collection2 = destination$iv$iv;
                                    boolean bl = false;
                                    collection2.add(Boxing.boxBoolean((boolean)((GoogleLoginState)((Object)it)).logOut()));
                                }
                                return (List)destination$iv$iv;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super List<Boolean>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var12_4) {
                    return var12_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                allStatus = (List)v0;
                $this$all$iv = allStatus;
                $i$f$all = false;
                if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) ** GOTO lbl28
                v1 = true;
                ** GOTO lbl35
lbl28:
                // 2 sources

                for (T element$iv : $this$all$iv) {
                    it = (Boolean)element$iv;
                    $i$a$-all-GoogleLoginServiceImpl$logOutAllUsers$2 = false;
                    if (it != false) continue;
                    v1 = false;
                    ** GOTO lbl35
                }
                v1 = true;
lbl35:
                // 3 sources

                if (v1) {
                    GoogleLoginServiceImpl.trackEvent$default(this, GoogleLoginPluginEvent.EventKind.LOGOUT_WITH_SUCCESS, null, null, 6, null);
                } else {
                    GoogleLoginServiceImpl.trackEvent$default(this, GoogleLoginPluginEvent.EventKind.LOGOUT_WITH_FAILURE, null, null, 6, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @Slow
    private final void initializeUsers() {
        Map<String, Map<LoginFeature, OAuthDataStore>> user2OAuthDataStoreMap;
        String string = this.loginApplicationSettings.loadActiveUser();
        if (string == null) {
            return;
        }
        String activeUserString = string;
        Map<String, Map<LoginFeature, OAuthDataStore>> $this$forEach$iv = user2OAuthDataStoreMap = this.loginApplicationSettings.loadOAuthData();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Map<LoginFeature, OAuthDataStore>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object object;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            Map.Entry<String, Map<LoginFeature, OAuthDataStore>> element$iv;
            Map.Entry<String, Map<LoginFeature, OAuthDataStore>> entry = element$iv = iterator2.next();
            boolean bl = false;
            String user = entry.getKey();
            Map<LoginFeature, OAuthDataStore> feature2OAuthData = entry.getValue();
            Iterable iterable = MapsKt.toList(feature2OAuthData);
            boolean $i$f$groupBy = false;
            void var13_14 = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                object = (Pair)element$iv$iv;
                boolean bl2 = false;
                OAuthDataStore oAuthDataStore = (OAuthDataStore)object.component2();
                String key$iv$iv = oAuthDataStore.getRefreshToken();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$groupByTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            object = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (object.hasNext()) {
                Unit unit;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = (Map.Entry)object.next();
                boolean bl4 = false;
                Map.Entry entry2 = element$iv$iv;
                boolean bl5 = false;
                String token = (String)entry2.getKey();
                List feature2OAuthData2 = (List)entry2.getValue();
                if (token == null) {
                    unit = null;
                } else {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = feature2OAuthData2;
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Pair pair = (Pair)item$iv$iv;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl6 = false;
                        collection2.add((LoginFeature)it.getFirst());
                    }
                    Set features = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                    OAuthDataStore oAuthDataStore = new OAuthDataStore(user, token, features);
                    GoogleLoginState state2 = GoogleLoginState.Companion.createFromPersistence(oAuthDataStore, this.transport, this.uiFacade, this.oAuthServer, this.loginApplicationSettings);
                    this.userManager.addOrUpdateUser(state2);
                    this.setActiveUser(state2.getEmail());
                    unit = Unit.INSTANCE;
                }
                if (unit == null) continue;
                Unit it$iv$iv = unit;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
        Map allUsers = (Map)this.userManager.getAllUsersFlow().getValue();
        if (allUsers.containsKey(activeUserString)) {
            this.setActiveUser(activeUserString);
        } else if (!allUsers.isEmpty()) {
            String user = (String)CollectionExKt.first((Map)allUsers).getKey();
            this.setActiveUser(user);
            this.logger.warn("Can't restore to the last active user, so " + user + " becomes active.");
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    private final void trackEvent(GoogleLoginPluginEvent.EventKind eventKind, GoogleLoginPluginEvent.LoginType loginType, GoogleLoginPluginEvent.LoginFeatures loginFeatures) {
        void $this$trackEvent_u24lambda_u2411;
        GoogleLoginPluginEvent.Builder builder;
        GoogleLoginPluginEvent.Builder builder2 = builder = GoogleLoginPluginEvent.newBuilder();
        AndroidStudioEvent.Builder builder3 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.GOOGLE_LOGIN_EVENT);
        boolean bl = false;
        $this$trackEvent_u24lambda_u2411.setEvent(eventKind);
        $this$trackEvent_u24lambda_u2411.setFeatures(loginFeatures);
        $this$trackEvent_u24lambda_u2411.setLoginType(loginType);
        $this$trackEvent_u24lambda_u2411.setTotalUserCount(((Map)this.userManager.getAllUsersFlow().getValue()).size());
        AndroidStudioEvent.Builder builder4 = builder3.setGoogleLoginEvent(builder.build());
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"setGoogleLoginEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder4);
    }

    static /* synthetic */ void trackEvent$default(GoogleLoginServiceImpl googleLoginServiceImpl, GoogleLoginPluginEvent.EventKind eventKind, GoogleLoginPluginEvent.LoginType loginType, GoogleLoginPluginEvent.LoginFeatures loginFeatures, int n, Object object) {
        if ((n & 2) != 0) {
            loginType = GoogleLoginPluginEvent.LoginType.UNKNOWN_TYPE;
        }
        if ((n & 4) != 0) {
            GoogleLoginPluginEvent.LoginFeatures loginFeatures2 = GoogleLoginPluginEvent.LoginFeatures.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)loginFeatures2, (String)"getDefaultInstance(...)");
            loginFeatures = loginFeatures2;
        }
        googleLoginServiceImpl.trackEvent(eventKind, loginType, loginFeatures);
    }

    /*
     * WARNING - void declaration
     */
    private final GoogleLoginPluginEvent.LoginFeatures buildLoginFeatures(Set<? extends LoginFeature> features) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        GoogleLoginPluginEvent.LoginFeatures.Builder builder;
        GoogleLoginPluginEvent.LoginFeatures.Builder $this$buildLoginFeatures_u24lambda_u2413 = builder = GoogleLoginPluginEvent.LoginFeatures.newBuilder();
        boolean bl = false;
        Iterable iterable = features;
        GoogleLoginPluginEvent.LoginFeatures.Builder builder2 = $this$buildLoginFeatures_u24lambda_u2413;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LoginFeature loginFeature = (LoginFeature)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(it.getKey());
        }
        builder2.addAllFeatures((Iterable)((List)destination$iv$iv));
        GoogleLoginPluginEvent.LoginFeatures loginFeatures = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)loginFeatures, (String)"build(...)");
        return loginFeatures;
    }

    private final boolean shouldLogOut() {
        boolean shouldLogOut;
        VetoableLogoutListener it;
        block5: {
            Iterable $this$all$iv = this.getVetoableLogoutListeners();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (VetoableLogoutListener)element$iv;
                    boolean bl = false;
                    if (it.canLogout()) continue;
                    v0 = false;
                    break block5;
                }
                v0 = shouldLogOut = true;
            }
        }
        if (shouldLogOut) {
            Iterable $this$forEach$iv = this.getVetoableLogoutListeners();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (VetoableLogoutListener)element$iv;
                boolean bl = false;
                it.isLoggingOut();
            }
        }
        return shouldLogOut;
    }

    @Override
    @Nullable
    public Credential getCredential(@NotNull LoginFeature feature) {
        return GoogleLoginService.super.getCredential(feature);
    }

    @Override
    @Nullable
    public Credential getCredential(@NotNull LoginFeature feature, @NotNull String userEmail) {
        return GoogleLoginService.super.getCredential(feature, userEmail);
    }

    @Override
    @Nullable
    public String getEmail() {
        return GoogleLoginService.super.getEmail();
    }

    @Override
    public boolean addVetoableLogoutListener(@NotNull VetoableLogoutListener l) {
        return GoogleLoginService.super.addVetoableLogoutListener(l);
    }

    @Override
    public boolean removeVetoableLogoutListener(@NotNull VetoableLogoutListener l) {
        return GoogleLoginService.super.removeVetoableLogoutListener(l);
    }

    private static final String getActiveUserAuthInterceptor$lambda$0(GoogleLoginServiceImpl this$0, LoginFeature $feature) {
        return this$0.fetchOAuth2Token($feature);
    }

    public GoogleLoginServiceImpl() {
        this(null, null, null, null, null, 31, null);
    }

    public static final /* synthetic */ Object access$performLogIn(GoogleLoginServiceImpl $this, CoroutineScope $receiver, Set features, GoogleLoginPluginEvent.LoginType loginType, PreferredUser preferredUser, boolean switchActiveUserIfApplicable, LoginCompletedCallback loginCompletedCallback, Continuation $completion) {
        return $this.performLogIn($receiver, features, loginType, preferredUser, switchActiveUserIfApplicable, loginCompletedCallback, (Continuation<? super PreferredUser>)$completion);
    }

    public static final /* synthetic */ Object access$askYesOrNoForSwitchAccountIntent(GoogleLoginServiceImpl $this, String fromUser, String toUser, Continuation $completion) {
        return $this.askYesOrNoForSwitchAccountIntent(fromUser, toUser, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ UiFacade access$getUiFacade$p(GoogleLoginServiceImpl $this) {
        return $this.uiFacade;
    }

    public static final /* synthetic */ Object access$maybeSetActiveUser(GoogleLoginServiceImpl $this, PreferredUser preferredUser, GoogleLoginState newState2, Continuation $completion) {
        return $this.maybeSetActiveUser(preferredUser, newState2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ HttpTransport access$getTransport$p(GoogleLoginServiceImpl $this) {
        return $this.transport;
    }

    public static final /* synthetic */ OAuthServer access$getOAuthServer$p(GoogleLoginServiceImpl $this) {
        return $this.oAuthServer;
    }

    public static final /* synthetic */ GoogleLoginApplicationSettings access$getLoginApplicationSettings$p(GoogleLoginServiceImpl $this) {
        return $this.loginApplicationSettings;
    }

    public static final /* synthetic */ void access$trackEvent(GoogleLoginServiceImpl $this, GoogleLoginPluginEvent.EventKind eventKind, GoogleLoginPluginEvent.LoginType loginType, GoogleLoginPluginEvent.LoginFeatures loginFeatures) {
        $this.trackEvent(eventKind, loginType, loginFeatures);
    }

    public static final /* synthetic */ GoogleLoginPluginEvent.LoginFeatures access$buildLoginFeatures(GoogleLoginServiceImpl $this, Set features) {
        return $this.buildLoginFeatures(features);
    }
}

