/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login2;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.Slow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.services.oauth2.model.Userinfo;
import com.google.gct.login2.CredentialedUser;
import com.google.gct.login2.GoogleAccountClient;
import com.google.gct.login2.GoogleLoginState;
import com.google.gct.login2.LoginFeature;
import com.google.gct.login2.common.OAuthDataStore;
import com.google.gct.login2.settings.GoogleLoginApplicationSettings;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\u0010J\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0010J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0003J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u001b\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/google/gct/login2/CredentialedUsersManager;", "", "settings", "Lcom/google/gct/login2/settings/GoogleLoginApplicationSettings;", "accountClient", "Lcom/google/gct/login2/GoogleAccountClient;", "<init>", "(Lcom/google/gct/login2/settings/GoogleLoginApplicationSettings;Lcom/google/gct/login2/GoogleAccountClient;)V", "lock", "allUsersFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "", "Lcom/google/gct/login2/CredentialedUser;", "activeUserFlow", "getAllUsersFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getActiveUserFlow", "setActiveUser", "", "userEmail", "addOrUpdateUser", "loginState", "Lcom/google/gct/login2/GoogleLoginState;", "createUser", "removeInvalidatedLogins", "removeUser", "removeAllUsers", "google-login"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCredentialedUsersManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CredentialedUsersManager.kt\ncom/google/gct/login2/CredentialedUsersManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,144:1\n1#2:145\n1#2:167\n1279#3,2:146\n1293#3,4:148\n1611#3,9:157\n1863#3:166\n1864#3:168\n1620#3:169\n1279#3,2:180\n1293#3,4:182\n226#4,5:152\n226#4,5:170\n226#4,5:175\n535#5:186\n520#5,6:187\n*S KotlinDebug\n*F\n+ 1 CredentialedUsersManager.kt\ncom/google/gct/login2/CredentialedUsersManager\n*L\n109#1:167\n84#1:146,2\n84#1:148,4\n109#1:157,9\n109#1:166\n109#1:168\n109#1:169\n61#1:180,2\n61#1:182,4\n97#1:152,5\n125#1:170,5\n126#1:175,5\n102#1:186\n102#1:187,6\n*E\n"})
public final class CredentialedUsersManager {
    @NotNull
    private final GoogleLoginApplicationSettings settings;
    @NotNull
    private final GoogleAccountClient accountClient;
    @NotNull
    private final Object lock;
    @NotNull
    private final MutableStateFlow<Map<String, CredentialedUser>> allUsersFlow;
    @NotNull
    private final MutableStateFlow<CredentialedUser> activeUserFlow;
    public static final int $stable = 8;

    public CredentialedUsersManager(@NotNull GoogleLoginApplicationSettings settings, @NotNull GoogleAccountClient accountClient) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)accountClient, (String)"accountClient");
        this.settings = settings;
        this.accountClient = accountClient;
        this.lock = new Object();
        this.allUsersFlow = StateFlowKt.MutableStateFlow((Object)MapsKt.emptyMap());
        this.activeUserFlow = StateFlowKt.MutableStateFlow(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final StateFlow<Map<String, CredentialedUser>> getAllUsersFlow() {
        MutableStateFlow<Map<String, CredentialedUser>> mutableStateFlow;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            mutableStateFlow = this.allUsersFlow;
        }
        return (StateFlow)mutableStateFlow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final StateFlow<CredentialedUser> getActiveUserFlow() {
        MutableStateFlow<CredentialedUser> mutableStateFlow;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            mutableStateFlow = this.activeUserFlow;
        }
        return (StateFlow)mutableStateFlow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setActiveUser(@NotNull String userEmail) {
        Intrinsics.checkNotNullParameter((Object)userEmail, (String)"userEmail");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            CredentialedUser user = (CredentialedUser)((Map)this.allUsersFlow.getValue()).get(userEmail);
            if (user == null) {
                boolean bl2 = false;
                String string = userEmail + " is not a logged in user.";
                throw new IllegalStateException(string.toString());
            }
            this.activeUserFlow.setValue((Object)user);
            this.settings.saveActiveUser(userEmail);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    public final void addOrUpdateUser(@NotNull GoogleLoginState loginState) {
        Intrinsics.checkNotNullParameter((Object)loginState, (String)"loginState");
        while (true) {
            Map map2;
            Map allUsers = (Map)this.allUsersFlow.getValue();
            Map $this$addOrUpdateUser_u24lambda_u247 = map2 = MapsKt.toMutableMap((Map)allUsers);
            boolean bl = false;
            $this$addOrUpdateUser_u24lambda_u247.compute(loginState.getEmail(), (arg_0, arg_1) -> CredentialedUsersManager.addOrUpdateUser$lambda$7$lambda$6((arg_0, arg_1) -> CredentialedUsersManager.addOrUpdateUser$lambda$7$lambda$5(loginState, this, arg_0, arg_1), arg_0, arg_1));
            Map newAllUsers = map2;
            Object object = this.lock;
            synchronized (object) {
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)this.allUsersFlow.getValue(), (Object)allUsers)) {
                    this.allUsersFlow.setValue((Object)newAllUsers);
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Slow
    private final CredentialedUser createUser(GoogleLoginState loginState) {
        Map map2;
        void $this$associateWith$iv;
        Object object;
        Object object2;
        Object object3;
        Image image;
        Userinfo userInfo;
        Userinfo userinfo;
        Object it;
        Credential credential = loginState.getCredential();
        if (credential != null) {
            it = credential;
            boolean bl = false;
            userinfo = this.accountClient.getUserInfo((Credential)it);
        } else {
            userinfo = null;
        }
        Userinfo userinfo2 = userInfo = userinfo;
        if (userinfo2 != null) {
            it = userinfo2;
            boolean bl = false;
            image = this.accountClient.getUserPicture((Userinfo)it);
        } else {
            image = null;
        }
        Image image2 = image;
        String email = loginState.getEmail();
        Object object4 = userInfo;
        if (object4 == null || (object4 = object4.getName()) == null) {
            object4 = loginState.getEmail();
        }
        if ((object3 = userInfo) != null && (object3 = object3.getGivenName()) != null) {
            void it2;
            Object bl;
            Object object5 = bl = object3;
            object2 = object4;
            boolean bl2 = false;
            boolean bl3 = !StringsKt.isBlank((CharSequence)((CharSequence)it2));
            object4 = object2;
            object = bl3 ? bl : null;
        } else {
            object = null;
        }
        it = loginState.getAllowedFeatures();
        String string = email;
        Image image3 = image2;
        Object object6 = object;
        object2 = object4;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            LoginFeature loginFeature = (LoginFeature)element$iv$iv;
            Object t = element$iv$iv;
            map2 = result$iv;
            boolean bl = false;
            GoogleLoginState googleLoginState = loginState;
            map2.put(t, googleLoginState);
        }
        Map map3 = map2 = (Map)result$iv;
        String string2 = string;
        Image image4 = image3;
        Object object7 = object6;
        Object object8 = object2;
        return new CredentialedUser((String)object8, (String)object7, image4, string2, map3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void removeInvalidatedLogins(@NotNull String userEmail) {
        Intrinsics.checkNotNullParameter((Object)userEmail, (String)"userEmail");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if ((CredentialedUser)((Map)this.allUsersFlow.getValue()).get(userEmail) != null) {
                List list;
                Object $this$removeInvalidatedLogins_u24lambda_u2419_u24lambda_u2417_u24lambda_u2416;
                Map map2;
                Map nextValue$iv;
                Object prevValue$iv;
                MutableStateFlow<Map<String, CredentialedUser>> $this$update$iv = this.allUsersFlow;
                boolean $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    Map it = (Map)prevValue$iv;
                    boolean bl2 = false;
                    map2 = MapsKt.toMutableMap((Map)it);
                    $this$removeInvalidatedLogins_u24lambda_u2419_u24lambda_u2417_u24lambda_u2416 = map2;
                    boolean bl3 = false;
                    $this$removeInvalidatedLogins_u24lambda_u2419_u24lambda_u2417_u24lambda_u2416.computeIfPresent(userEmail, (arg_0, arg_1) -> CredentialedUsersManager.removeInvalidatedLogins$lambda$19$lambda$17$lambda$16$lambda$15(CredentialedUsersManager::removeInvalidatedLogins$lambda$19$lambda$17$lambda$16$lambda$14, arg_0, arg_1));
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = map2)));
                Object object2 = (CredentialedUser)((Map)this.allUsersFlow.getValue()).get(userEmail);
                if (object2 != null && (object2 = ((CredentialedUser)object2).getLoginStates$google_login()) != null) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = (Iterable)object2;
                    boolean $i$f$mapNotNull = false;
                    $this$removeInvalidatedLogins_u24lambda_u2419_u24lambda_u2417_u24lambda_u2416 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        OAuthDataStore it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl4 = false;
                        GoogleLoginState it = (GoogleLoginState)element$iv$iv;
                        boolean bl5 = false;
                        if (it.makeOAuthDataStore() == null) continue;
                        boolean bl6 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List newOAuthData = list;
                GoogleLoginApplicationSettings.saveAllOAuthDataByUser$default(this.settings, userEmail, newOAuthData, false, 4, null);
                this.setActiveUser(userEmail);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeUser(@NotNull String userEmail) {
        Intrinsics.checkNotNullParameter((Object)userEmail, (String)"userEmail");
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            Object it;
            Map map2;
            Object nextValue$iv;
            Object prevValue$iv;
            boolean bl = false;
            Object $this$update$iv = this.allUsersFlow;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                it = (Map)prevValue$iv;
                boolean bl2 = false;
                Map $this$removeUser_u24lambda_u2423_u24lambda_u2421_u24lambda_u2420 = map2 = MapsKt.toMutableMap((Map)it);
                boolean bl3 = false;
                $this$removeUser_u24lambda_u2423_u24lambda_u2421_u24lambda_u2420.remove(userEmail);
            } while (!$this$update$iv.compareAndSet(prevValue$iv, nextValue$iv = map2));
            $this$update$iv = this.activeUserFlow;
            $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                it = (CredentialedUser)prevValue$iv;
                boolean bl4 = false;
                object2 = it;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, nextValue$iv = Intrinsics.areEqual((Object)(object2 != null ? ((CredentialedUser)object2).getEmail() : null), (Object)userEmail) ? null : it));
            this.settings.clearStoredOAuthData(userEmail);
            this.settings.clearActiveUserIfApplicable(userEmail);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAllUsers() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.allUsersFlow.setValue((Object)MapsKt.emptyMap());
            this.activeUserFlow.setValue(null);
            this.settings.clearAllStoredOAuthData();
            this.settings.clearActiveUser();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final CredentialedUser addOrUpdateUser$lambda$7$lambda$5(GoogleLoginState $loginState, CredentialedUsersManager this$0, String string, CredentialedUser old) {
        CredentialedUser credentialedUser;
        block4: {
            block3: {
                Map map2;
                void $this$associateWith$iv;
                Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
                credentialedUser = old;
                if (credentialedUser == null) break block3;
                Iterable iterable = $loginState.getAllowedFeatures();
                Map<LoginFeature, GoogleLoginState> map3 = old.getFeature2LoginStateMap();
                String string2 = null;
                Image image = null;
                String string3 = null;
                String string4 = null;
                CredentialedUser credentialedUser2 = credentialedUser;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                void $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    LoginFeature loginFeature = (LoginFeature)element$iv$iv;
                    Object t = element$iv$iv;
                    map2 = result$iv;
                    boolean bl = false;
                    GoogleLoginState googleLoginState = $loginState;
                    map2.put(t, googleLoginState);
                }
                map2 = result$iv;
                credentialedUser = CredentialedUser.copy$default(credentialedUser2, string4, string3, image, string2, MapsKt.plus(map3, (Map)map2), 15, null);
                if (credentialedUser != null) break block4;
            }
            credentialedUser = this$0.createUser($loginState);
        }
        return credentialedUser;
    }

    private static final CredentialedUser addOrUpdateUser$lambda$7$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        return (CredentialedUser)$tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    private static final CredentialedUser removeInvalidatedLogins$lambda$19$lambda$17$lambda$16$lambda$14(String string, CredentialedUser user) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Map<LoginFeature, GoogleLoginState> map2 = user.getFeature2LoginStateMap();
        String string2 = null;
        Image image = null;
        String string3 = null;
        String string4 = null;
        CredentialedUser credentialedUser = user;
        boolean $i$f$filter = false;
        void var4_9 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator2.next();
            boolean bl = false;
            GoogleLoginState state2 = (GoogleLoginState)entry.getValue();
            if (!state2.isLoggedIn()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map map3 = destination$iv$iv;
        return CredentialedUser.copy$default(credentialedUser, string4, string3, image, string2, map3, 15, null);
    }

    private static final CredentialedUser removeInvalidatedLogins$lambda$19$lambda$17$lambda$16$lambda$15(Function2 $tmp0, Object p0, Object p1) {
        return (CredentialedUser)$tmp0.invoke(p0, p1);
    }
}

