/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.aar.AarResourceRepository;
import com.android.tools.environment.Logger;
import com.android.tools.res.LocalResourceRepository;
import com.android.tools.res.PerConfigResourceMap;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class MultiResourceRepository<T>
extends LocalResourceRepository<T> {
    private static final Logger LOG = Logger.getInstance(MultiResourceRepository.class);
    @NotNull
    private ImmutableList<LocalResourceRepository<T>> myLocalResources = ImmutableList.of();
    @NotNull
    private ImmutableList<ResourceRepository> myChildren = ImmutableList.of();
    @NotNull
    private ImmutableListMultimap<ResourceNamespace, SingleNamespaceResourceRepository> myLeafsByNamespace = ImmutableListMultimap.of();
    @NotNull
    private ImmutableListMultimap<ResourceNamespace, SingleNamespaceResourceRepository> myRepositoriesByNamespace = ImmutableListMultimap.of();
    @NotNull
    private PerConfigResourceMap.ResourceItemComparator myResourceComparator = new PerConfigResourceMap.ResourceItemComparator((Collection<SingleNamespaceResourceRepository>)ImmutableList.of());
    private long[] myModificationCounts;
    private final ResourceTable myCachedMaps = new ResourceTable();
    private final Table<SingleNamespaceResourceRepository, ResourceType, Set<String>> myResourceNames = Tables.newCustomTable(new HashMap(), () -> Maps.newEnumMap(ResourceType.class));
    private final Table<ResourceNamespace, ResourceType, Set<SingleNamespaceResourceRepository>> myUnreconciledResources = Tables.newCustomTable(new HashMap(), () -> Maps.newEnumMap(ResourceType.class));

    protected MultiResourceRepository(@NotNull String displayName) {
        super(displayName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChildren(@NotNull List<? extends LocalResourceRepository<T>> localResources, @NotNull Collection<? extends AarResourceRepository> libraryResources, @NotNull Collection<? extends ResourceRepository> otherResources) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            this.release();
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.myLocalResources = ImmutableList.copyOf(localResources);
            int size = this.myLocalResources.size() + libraryResources.size() + otherResources.size();
            this.myChildren = ImmutableList.builderWithExpectedSize((int)size).addAll(this.myLocalResources).addAll(libraryResources).addAll(otherResources).build();
            ImmutableListMultimap.Builder mapBuilder = ImmutableListMultimap.builder();
            MultiResourceRepository.computeLeafs(this, (ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository>)mapBuilder);
            this.myLeafsByNamespace = mapBuilder.build();
            mapBuilder = ImmutableListMultimap.builder();
            MultiResourceRepository.computeNamespaceMap(this, (ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository>)mapBuilder);
            this.myRepositoriesByNamespace = mapBuilder.build();
            this.myResourceComparator = new PerConfigResourceMap.ResourceItemComparator((Collection<SingleNamespaceResourceRepository>)this.myLeafsByNamespace.values());
            this.myModificationCounts = new long[localResources.size()];
            if (localResources.size() == 1) {
                LocalResourceRepository<T> child = localResources.get(0);
                child.setModificationCount(this.getModificationCount());
            }
            int i = 0;
            for (LocalResourceRepository child : this.myLocalResources) {
                child.addParent(this);
                this.myModificationCounts[i++] = child.getModificationCount();
            }
            this.myCachedMaps.clear();
            this.invalidateParentCaches();
        }
    }

    protected abstract void refreshChildren();

    public void onChildReset() {
        this.refreshChildren();
    }

    private static <T> void computeLeafs(@NotNull ResourceRepository repository2, @NotNull ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository> result2) {
        if (repository2 instanceof MultiResourceRepository) {
            for (ResourceRepository child : ((MultiResourceRepository)repository2).myChildren) {
                MultiResourceRepository.computeLeafs(child, result2);
            }
        } else {
            for (SingleNamespaceResourceRepository resourceRepository : repository2.getLeafResourceRepositories()) {
                result2.put((Object)resourceRepository.getNamespace(), (Object)resourceRepository);
            }
        }
    }

    private static <T> void computeNamespaceMap(@NotNull ResourceRepository repository2, @NotNull ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository> result2) {
        if (repository2 instanceof SingleNamespaceResourceRepository) {
            SingleNamespaceResourceRepository singleNamespaceRepository = (SingleNamespaceResourceRepository)repository2;
            ResourceNamespace namespace = singleNamespaceRepository.getNamespace();
            result2.put((Object)namespace, (Object)singleNamespaceRepository);
        } else if (repository2 instanceof MultiResourceRepository) {
            for (ResourceRepository child : ((MultiResourceRepository)repository2).myChildren) {
                MultiResourceRepository.computeNamespaceMap(child, result2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<LocalResourceRepository<T>> getLocalResources() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myLocalResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ResourceRepository> getChildren() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myChildren;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<SingleNamespaceResourceRepository> getRepositoriesForNamespace(@NotNull ResourceNamespace namespace) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myRepositoriesByNamespace.get((Object)namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getModificationCount() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myLocalResources.size() == 1) {
                return ((LocalResourceRepository)this.myLocalResources.get(0)).getModificationCount();
            }
            boolean changed = false;
            for (int i = 0; i < this.myLocalResources.size(); ++i) {
                LocalResourceRepository child = (LocalResourceRepository)this.myLocalResources.get(i);
                long rev = child.getModificationCount();
                if (rev == this.myModificationCounts[i]) continue;
                this.myModificationCounts[i] = rev;
                changed = true;
            }
            if (changed) {
                this.setModificationCount(ourModificationCounter.incrementAndGet());
            }
            return super.getModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<ResourceNamespace> getNamespaces() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myRepositoriesByNamespace.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor2) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (ResourceNamespace namespace : this.getNamespaces()) {
                if (!visitor2.shouldVisitNamespace(namespace)) continue;
                for (ResourceType type : ResourceType.values()) {
                    ListMultimap<String, ResourceItem> map2;
                    if (!visitor2.shouldVisitResourceType(type) || (map2 = this.getMap(namespace, type)) == null) continue;
                    for (ResourceItem item : map2.values()) {
                        if (visitor2.visit(item) != ResourceVisitor.VisitResult.ABORT) continue;
                        return ResourceVisitor.VisitResult.ABORT;
                    }
                }
            }
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }

    @Override
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        Stopwatch stopwatch;
        ImmutableList repositoriesForNamespace = this.myLeafsByNamespace.get((Object)namespace);
        if (repositoriesForNamespace.size() == 1) {
            SingleNamespaceResourceRepository repository2 = (SingleNamespaceResourceRepository)repositoriesForNamespace.get(0);
            return MultiResourceRepository.getResourcesUnderLock(repository2, namespace, type);
        }
        ListMultimap map2 = (ListMultimap)this.myCachedMaps.get((Object)namespace, (Object)type);
        Set unreconciledRepositories = null;
        if (map2 != null && (unreconciledRepositories = (Set)this.myUnreconciledResources.get((Object)namespace, (Object)type)) == null) {
            return map2;
        }
        Object object = stopwatch = LOG.isDebugEnabled() ? Stopwatch.createStarted() : null;
        if (map2 == null) {
            for (SingleNamespaceResourceRepository repository3 : repositoriesForNamespace) {
                ListMultimap<String, ResourceItem> items = MultiResourceRepository.getResourcesUnderLock(repository3, namespace, type);
                if (items.isEmpty()) continue;
                if (map2 == null) {
                    map2 = type == ResourceType.STYLEABLE || type == ResourceType.ID ? ArrayListMultimap.create() : new PerConfigResourceMap(this.myResourceComparator);
                    this.myCachedMaps.put((Object)namespace, (Object)type, (Object)map2);
                }
                map2.putAll(items);
                if (!(repository3 instanceof LocalResourceRepository)) continue;
                this.myResourceNames.put((Object)repository3, (Object)type, (Object)ImmutableSet.copyOf((Collection)items.keySet()));
            }
        } else {
            for (SingleNamespaceResourceRepository unreconciledRepository : unreconciledRepositories) {
                Predicate<ResourceItem> filter2 = item -> item.getRepository().equals(unreconciledRepository);
                Set names = (Set)this.myResourceNames.get((Object)unreconciledRepository, (Object)type);
                if (names != null) {
                    PerConfigResourceMap perConfigMap = map2 instanceof PerConfigResourceMap ? (PerConfigResourceMap)map2 : null;
                    for (String name2 : names) {
                        if (perConfigMap != null) {
                            perConfigMap.removeIf(name2, filter2);
                            continue;
                        }
                        List items = map2.get((Object)name2);
                        items.removeIf(filter2);
                        if (!items.isEmpty()) continue;
                        map2.removeAll((Object)name2);
                    }
                }
                ListMultimap<String, ResourceItem> unreconciledResources = MultiResourceRepository.getResourcesUnderLock(unreconciledRepository, namespace, type);
                map2.putAll(unreconciledResources);
                assert (unreconciledRepository instanceof LocalResourceRepository);
                this.myResourceNames.put((Object)unreconciledRepository, (Object)type, (Object)ImmutableSet.copyOf((Collection)unreconciledResources.keySet()));
                if (!map2.isEmpty()) continue;
                this.myCachedMaps.remove((Object)namespace, (Object)type);
            }
            this.myUnreconciledResources.remove((Object)namespace, (Object)type);
        }
        if (stopwatch != null) {
            LOG.debug(String.format(Locale.US, "Merged %d resources of type %s in %s for %s.", map2 == null ? 0 : map2.size(), type, stopwatch, this.getClass().getSimpleName()));
        }
        return map2;
    }

    @NotNull
    private static <T> ListMultimap<String, ResourceItem> getResourcesUnderLock(@NotNull SingleNamespaceResourceRepository repository2, @NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (repository2 instanceof LocalResourceRepository) {
            ListMultimap<String, ResourceItem> map2 = ((LocalResourceRepository)repository2).getMapPackageAccessible(namespace, type);
            return map2 == null ? ImmutableListMultimap.of() : map2;
        }
        return repository2.getResources(namespace, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void release() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (LocalResourceRepository child : this.myLocalResources) {
                child.removeParent(this);
            }
        }
    }

    public void invalidateCache() {
        this.clearCachedData();
        this.setModificationCount(ourModificationCounter.incrementAndGet());
        this.invalidateParentCaches();
    }

    private void clearCachedData() {
        this.myCachedMaps.clear();
        this.myResourceNames.clear();
        this.myUnreconciledResources.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onLowMemory() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            this.clearCachedData();
        }
        LOG.warn(this.getDisplayName() + ": Cached data cleared due to low memory");
    }

    public void invalidateCache(@NotNull SingleNamespaceResourceRepository repository2, ResourceType ... types) {
        ResourceNamespace namespace = repository2.getNamespace();
        ImmutableList leafs = this.myLeafsByNamespace.get((Object)namespace);
        if (leafs.contains((Object)repository2)) {
            if (leafs.size() != 1) {
                for (ResourceType type : types) {
                    if (this.myCachedMaps.get((Object)namespace, (Object)type) == null) continue;
                    HashSet<SingleNamespaceResourceRepository> repositories = (HashSet<SingleNamespaceResourceRepository>)this.myUnreconciledResources.get((Object)namespace, (Object)type);
                    if (repositories == null) {
                        repositories = new HashSet<SingleNamespaceResourceRepository>();
                        this.myUnreconciledResources.put((Object)namespace, (Object)type, repositories);
                    }
                    repositories.add(repository2);
                }
                this.setModificationCount(ourModificationCounter.incrementAndGet());
            }
            this.invalidateParentCaches(repository2, types);
        }
    }

    @Override
    public void invokeAfterPendingUpdatesFinish(@NotNull Executor executor, @NotNull Runnable callback2) {
        ImmutableList<LocalResourceRepository<T>> repositories = this.getLocalResources();
        AtomicInteger count = new AtomicInteger(repositories.size());
        for (LocalResourceRepository childRepository : repositories) {
            childRepository.invokeAfterPendingUpdatesFinish(MoreExecutors.directExecutor(), () -> {
                if (count.decrementAndGet() == 0) {
                    executor.execute(callback2);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Set<T> computeResourceDirs() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            HashSet result2 = new HashSet();
            for (LocalResourceRepository resourceRepository : this.myLocalResources) {
                result2.addAll(resourceRepository.computeResourceDirs());
            }
            return result2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myLeafsByNamespace.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public int getFileRescans() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            int count = 0;
            for (LocalResourceRepository resourceRepository : this.myLocalResources) {
                count += resourceRepository.getFileRescans();
            }
            return count;
        }
    }
}

