/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.aar.CachingData;
import com.android.resources.aar.FrameworkResourceRepository;
import com.android.tools.res.CodeVersionAdapter;
import com.android.tools.res.FrameworkOverlay;
import com.android.tools.res.FrameworkResourceRepositoryManager;
import com.android.tools.res.FrameworkWithOverlaysResourceRepository;
import com.google.common.hash.Hashing;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001 B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J4\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0017J8\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/res/FrameworkResourceRepositoryManagerImpl;", "Lcom/android/tools/res/FrameworkResourceRepositoryManager;", "systemCachePath", "", "diskIoExecutor", "Ljava/util/concurrent/Executor;", "<init>", "(Ljava/lang/String;Ljava/util/concurrent/Executor;)V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/android/tools/res/FrameworkResourceRepositoryManagerImpl$CacheKey;", "Lcom/android/resources/aar/FrameworkResourceRepository;", "getFrameworkResources", "Lcom/android/ide/common/resources/ResourceRepository;", "resourceJarFile", "Ljava/nio/file/Path;", "useCompiled9Patches", "", "languages", "", "overlays", "", "Lcom/android/tools/res/FrameworkOverlay;", "getFrameworkRepository", "path", "overlay", "cachingData", "Lcom/android/resources/aar/CachingData;", "createCachingData", "resFolderOrJar", "clearCache", "", "CacheKey", "intellij.android.render-resources"})
@SourceDebugExtension(value={"SMAP\nFrameworkResourceRepositoryManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameworkResourceRepositoryManagerImpl.kt\ncom/android/tools/res/FrameworkResourceRepositoryManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1557#2:129\n1628#2,3:130\n*S KotlinDebug\n*F\n+ 1 FrameworkResourceRepositoryManagerImpl.kt\ncom/android/tools/res/FrameworkResourceRepositoryManagerImpl\n*L\n70#1:129\n70#1:130,3\n*E\n"})
public class FrameworkResourceRepositoryManagerImpl
implements FrameworkResourceRepositoryManager {
    @NotNull
    private final String systemCachePath;
    @NotNull
    private final Executor diskIoExecutor;
    @NotNull
    private final ConcurrentHashMap<CacheKey, FrameworkResourceRepository> cache;

    public FrameworkResourceRepositoryManagerImpl(@NotNull String systemCachePath, @NotNull Executor diskIoExecutor) {
        Intrinsics.checkNotNullParameter((Object)systemCachePath, (String)"systemCachePath");
        Intrinsics.checkNotNullParameter((Object)diskIoExecutor, (String)"diskIoExecutor");
        this.systemCachePath = systemCachePath;
        this.diskIoExecutor = diskIoExecutor;
        this.cache = new ConcurrentHashMap();
    }

    public /* synthetic */ FrameworkResourceRepositoryManagerImpl(String string, Executor executor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string, executor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Slow
    @NotNull
    public ResourceRepository getFrameworkResources(@NotNull Path resourceJarFile, boolean useCompiled9Patches, @NotNull Set<String> languages, @NotNull List<? extends FrameworkOverlay> overlays) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)resourceJarFile, (String)"resourceJarFile");
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        Intrinsics.checkNotNullParameter(overlays, (String)"overlays");
        CachingData cachingData = this.createCachingData(resourceJarFile);
        FrameworkResourceRepository baseRepository = this.getFrameworkRepository(resourceJarFile, "", useCompiled9Patches, languages, cachingData);
        if (overlays.isEmpty()) {
            return (ResourceRepository)baseRepository;
        }
        Iterable $this$map$iv = overlays;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FrameworkOverlay frameworkOverlay = (FrameworkOverlay)((Object)item$iv$iv);
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.getFrameworkRepository(resourceJarFile, it.getOverlayName(), useCompiled9Patches, languages, cachingData));
        }
        List overlayRepositories = (List)destination$iv$iv;
        return (ResourceRepository)new FrameworkWithOverlaysResourceRepository(baseRepository, overlayRepositories);
    }

    private final FrameworkResourceRepository getFrameworkRepository(Path path, String overlay, boolean useCompiled9Patches, Set<String> languages, CachingData cachingData) {
        CacheKey cacheKey = new CacheKey(path, overlay, useCompiled9Patches);
        FrameworkResourceRepository frameworkResourceRepository = this.cache.computeIfAbsent(cacheKey, arg_0 -> FrameworkResourceRepositoryManagerImpl.getFrameworkRepository$lambda$2(arg_0 -> FrameworkResourceRepositoryManagerImpl.getFrameworkRepository$lambda$1(overlay, path, languages, cachingData, useCompiled9Patches, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)frameworkResourceRepository, (String)"computeIfAbsent(...)");
        FrameworkResourceRepository cached = frameworkResourceRepository;
        if (languages.isEmpty()) {
            return cached;
        }
        FrameworkResourceRepository repository2 = cached.loadMissingLanguages(languages, cachingData);
        if (repository2 != cached) {
            ((Map)this.cache).put(cacheKey, repository2);
        }
        Intrinsics.checkNotNull((Object)repository2);
        return repository2;
    }

    private final CachingData createCachingData(Path resFolderOrJar) {
        String string;
        if (StringsKt.endsWith((String)((Object)resFolderOrJar.getFileName()).toString(), (String)".jar", (boolean)true)) {
            return null;
        }
        if (((CharSequence)this.systemCachePath).length() == 0) {
            return null;
        }
        String string2 = CodeVersionAdapter.Companion.getCodeVersion();
        if (string2 == null) {
            return null;
        }
        String codeVersion = string2;
        try {
            string = Files.getLastModifiedTime(resFolderOrJar.resolve("../../package.xml"), new LinkOption[0]).toString();
        }
        catch (NoSuchFileException e) {
            string = "";
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        String contentVersion = string3;
        String string4 = Hashing.farmHashFingerprint64().hashUnencodedChars((CharSequence)((Object)resFolderOrJar).toString()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        String pathHash = string4;
        Object object = resFolderOrJar.getParent();
        if (object == null || (object = object.getParent()) == null || (object = object.getFileName()) == null || (object = object.toString()) == null) {
            object = "framework";
        }
        Object prefix = object;
        String[] stringArray = "%s_%s.dat";
        Object[] objectArray = new Object[]{prefix, pathHash};
        String string5 = String.format((String)stringArray, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        String filename = string5;
        stringArray = new String[]{"caches/resources", filename};
        Path cacheFile = Paths.get(this.systemCachePath, stringArray);
        Intrinsics.checkNotNull((Object)cacheFile);
        return new CachingData(cacheFile, contentVersion, codeVersion, this.diskIoExecutor);
    }

    @TestOnly
    public final void clearCache() {
        this.cache.clear();
    }

    private static final FrameworkResourceRepository getFrameworkRepository$lambda$1(String $overlay, Path $path, Set $languages, CachingData $cachingData, boolean $useCompiled9Patches, CacheKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)$overlay).length() == 0 ? FrameworkResourceRepository.create((Path)$path, (Set)$languages, (CachingData)$cachingData, (boolean)$useCompiled9Patches) : FrameworkResourceRepository.createForOverlay((Path)$path, (String)$overlay, (Set)$languages, (CachingData)$cachingData, (boolean)$useCompiled9Patches);
    }

    private static final FrameworkResourceRepository getFrameworkRepository$lambda$2(Function1 $tmp0, Object p0) {
        return (FrameworkResourceRepository)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/res/FrameworkResourceRepositoryManagerImpl$CacheKey;", "", "path", "Ljava/nio/file/Path;", "overlayName", "", "useCompiled9Patches", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;Z)V", "getPath", "()Ljava/nio/file/Path;", "getOverlayName", "()Ljava/lang/String;", "getUseCompiled9Patches", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.android.render-resources"})
    private static final class CacheKey {
        @NotNull
        private final Path path;
        @NotNull
        private final String overlayName;
        private final boolean useCompiled9Patches;

        public CacheKey(@NotNull Path path, @NotNull String overlayName, boolean useCompiled9Patches) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)overlayName, (String)"overlayName");
            this.path = path;
            this.overlayName = overlayName;
            this.useCompiled9Patches = useCompiled9Patches;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @NotNull
        public final String getOverlayName() {
            return this.overlayName;
        }

        public final boolean getUseCompiled9Patches() {
            return this.useCompiled9Patches;
        }

        @NotNull
        public final Path component1() {
            return this.path;
        }

        @NotNull
        public final String component2() {
            return this.overlayName;
        }

        public final boolean component3() {
            return this.useCompiled9Patches;
        }

        @NotNull
        public final CacheKey copy(@NotNull Path path, @NotNull String overlayName, boolean useCompiled9Patches) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)overlayName, (String)"overlayName");
            return new CacheKey(path, overlayName, useCompiled9Patches);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, Path path, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                path = cacheKey.path;
            }
            if ((n & 2) != 0) {
                string = cacheKey.overlayName;
            }
            if ((n & 4) != 0) {
                bl = cacheKey.useCompiled9Patches;
            }
            return cacheKey.copy(path, string, bl);
        }

        @NotNull
        public String toString() {
            return "CacheKey(path=" + this.path + ", overlayName=" + this.overlayName + ", useCompiled9Patches=" + this.useCompiled9Patches + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.path).hashCode();
            result2 = result2 * 31 + this.overlayName.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.useCompiled9Patches);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)cacheKey.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.overlayName, (Object)cacheKey.overlayName)) {
                return false;
            }
            return this.useCompiled9Patches == cacheKey.useCompiled9Patches;
        }
    }
}

