/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.LayoutDirection;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.analytics.crash.CrashReporter;
import com.android.tools.configurations.Configuration;
import com.android.tools.dom.ActivityAttributesSnapshot;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.LayoutLibraryLoader;
import com.android.tools.idea.layoutlib.RenderParamsFlags;
import com.android.tools.rendering.ActionBarHandler;
import com.android.tools.rendering.CachingImageFactory;
import com.android.tools.rendering.ExecuteCallbacksResult;
import com.android.tools.rendering.IRenderLogger;
import com.android.tools.rendering.InteractionEventResult;
import com.android.tools.rendering.LayoutlibCallbackEx;
import com.android.tools.rendering.LayoutlibCallbackExDelegate;
import com.android.tools.rendering.LayoutlibCallbackImpl;
import com.android.tools.rendering.NoDeviceException;
import com.android.tools.rendering.ProblemSeverity;
import com.android.tools.rendering.RenderAsyncActionExecutor;
import com.android.tools.rendering.RenderContext;
import com.android.tools.rendering.RenderLogger;
import com.android.tools.rendering.RenderProblem;
import com.android.tools.rendering.RenderResult;
import com.android.tools.rendering.RenderResultStats;
import com.android.tools.rendering.RenderService;
import com.android.tools.rendering.RenderSessionCleaner;
import com.android.tools.rendering.api.IncludeReference;
import com.android.tools.rendering.api.RenderModelManifest;
import com.android.tools.rendering.api.RenderModelModule;
import com.android.tools.rendering.classloading.ClassLoaderPreloaderKt;
import com.android.tools.rendering.classloading.ClassTransform;
import com.android.tools.rendering.classloading.ModuleClassLoader;
import com.android.tools.rendering.classloading.ModuleClassLoaderManager;
import com.android.tools.rendering.compose.RenderTaskPatcher;
import com.android.tools.rendering.imagepool.ImagePool;
import com.android.tools.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.rendering.parsers.LayoutFilePullParser;
import com.android.tools.rendering.parsers.LayoutPullParsers;
import com.android.tools.rendering.parsers.LayoutRenderPullParser;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.tools.rendering.parsers.TagSnapshot;
import com.android.tools.rendering.security.RenderSecurityManager;
import com.android.tools.rendering.tracking.RenderTaskAllocationTracker;
import com.android.tools.rendering.tracking.StackTraceCapture;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class RenderTask {
    private boolean isSizeChanged = false;
    public static final TestEventListener NOP_TEST_EVENT_LISTENER = new TestEventListener(){};
    private static final Logger LOG = Logger.getInstance(RenderTask.class);
    private static final int MIN_BITMAP_SIZE_PX = 1;
    private static final IImageFactory SIMPLE_IMAGE_FACTORY = new IImageFactory(){

        @NotNull
        public BufferedImage getImage(int width, int height) {
            BufferedImage image = new BufferedImage(Math.max(1, width), Math.max(1, height), 3);
            image.setAccelerationPriority(1.0f);
            return image;
        }
    };
    private static final int DEFAULT_DOWNSCALED_IMAGE_MAX_BYTES = 2500000;
    private static final long MAX_NATIVE_MEMORY = Math.min(Runtime.getRuntime().maxMemory() / 2L, 0x200000000L);
    private static final ExecutorService ourDisposeService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"RenderTask Dispose Thread", (int)1);
    @NotNull
    RenderTaskAllocationTracker myTracker;
    @NotNull
    private final ImagePool myImagePool;
    @NotNull
    private final RenderContext myContext;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final LayoutlibCallbackEx myLayoutlibCallback;
    @NotNull
    private final LayoutLibrary myLayoutLib;
    @NotNull
    private final HardwareConfigHelper myHardwareConfigHelper;
    private float myTargetQuality = 1.0f;
    private float myCurrentQuality = 1.0f;
    private final long myDownScaledImageMaxBytes;
    @Nullable
    private IncludeReference myIncludedWithin;
    @NotNull
    private SessionParams.RenderingMode myRenderingMode = SessionParams.RenderingMode.NORMAL;
    private boolean mySetTransparentBackground = false;
    private boolean myShowDecorations = true;
    private boolean myEnableLayoutScanner = false;
    private boolean myShowWithToolsVisibilityAndPosition = true;
    private boolean myForceMonochromeIcon = false;
    private Function<Object, List<ViewInfo>> myCustomContentHierarchyParser = null;
    private long myTimeout;
    @NotNull
    private final Locale myLocale;
    @NotNull
    private final Object myCredential;
    @Nullable
    private RenderSession myRenderSession;
    @NotNull
    private IImageFactory myCachingImageFactory = SIMPLE_IMAGE_FACTORY;
    @Nullable
    private IImageFactory myImageFactoryDelegate;
    private final boolean isSecurityManagerEnabled;
    @NotNull
    private CrashReporter myCrashReporter;
    private final List<CompletableFuture<?>> myRunningFutures = new LinkedList();
    @NotNull
    private final AtomicBoolean isDisposed = new AtomicBoolean(false);
    @Nullable
    private RenderXmlFile myXmlFile;
    @NotNull
    private String myDefaultForegroundColor = "#333333";
    @NotNull
    private final ModuleClassLoaderManager.Reference<?> myModuleClassLoaderReference;
    @NotNull
    private final TestEventListener myTestEventListener;
    private final float myAnimatorDurationScale;
    private final boolean reportOutOfDateUserClasses;
    @NotNull
    private final RenderAsyncActionExecutor.RenderingTopic myTopic;

    RenderTask(@NotNull RenderContext renderContext, @NotNull RenderLogger logger, @NotNull LayoutLibrary layoutLib, @NotNull Object credential, @NotNull CrashReporter crashReporter, @NotNull ImagePool imagePool, @Nullable ILayoutPullParserFactory parserFactory, boolean isSecurityManagerEnabled, float quality, @NotNull StackTraceCapture stackTraceCaptureElement, @NotNull RenderTaskAllocationTracker tracker, boolean privateClassLoader, @NotNull ClassTransform additionalProjectTransform, @NotNull ClassTransform additionalNonProjectTransform, @NotNull Runnable onNewModuleClassLoader, @NotNull Collection<String> classesToPreload, boolean reportOutOfDateUserClasses, @NotNull RenderAsyncActionExecutor.RenderingTopic topic, boolean useCustomInflater, @NotNull TestEventListener testEventListener, float animatorDurationScale) throws NoDeviceException {
        this.myTracker = tracker;
        this.myImagePool = imagePool;
        this.myContext = renderContext;
        this.isSecurityManagerEnabled = isSecurityManagerEnabled;
        this.reportOutOfDateUserClasses = reportOutOfDateUserClasses;
        this.myAnimatorDurationScale = animatorDurationScale;
        if (!isSecurityManagerEnabled) {
            LOG.debug("Security manager was disabled");
        }
        this.myTopic = topic;
        this.myLogger = logger;
        this.myCredential = credential;
        this.myCrashReporter = crashReporter;
        this.myTestEventListener = testEventListener;
        Device device2 = renderContext.getConfiguration().getDevice();
        if (device2 == null) {
            throw new NoDeviceException();
        }
        this.myHardwareConfigHelper = new HardwareConfigHelper(device2);
        ScreenOrientation orientation = renderContext.getConfiguration().getFullConfig().getScreenOrientationQualifier() != null ? renderContext.getConfiguration().getFullConfig().getScreenOrientationQualifier().getValue() : ScreenOrientation.PORTRAIT;
        this.myHardwareConfigHelper.setOrientation(orientation);
        this.myLayoutLib = layoutLib;
        ActionBarHandler actionBarHandler = new ActionBarHandler(this, this.myCredential);
        RenderModelModule renderContextModule = renderContext.getModule();
        this.myModuleClassLoaderReference = renderContextModule.getClassLoaderProvider(privateClassLoader).getClassLoader(this.myLayoutLib.getClassLoader(), additionalProjectTransform, additionalNonProjectTransform, onNewModuleClassLoader);
        Object moduleClassLoader = this.myModuleClassLoaderReference.getClassLoader();
        ClassLoaderPreloaderKt.preload(moduleClassLoader, (Function0<Boolean>)((Function0)() -> moduleClassLoader.isDisposed()), classesToPreload);
        try {
            this.myLayoutlibCallback = new LayoutlibCallbackExDelegate(renderContextModule.getParentDisposable(), new LayoutlibCallbackImpl(this, this.myLayoutLib, renderContextModule, this.myLogger, this.myCredential, actionBarHandler, parserFactory, (ModuleClassLoader)moduleClassLoader, useCustomInflater));
            if (renderContextModule.getResourceIdManager().getFinalIdsUsed()) {
                this.myLayoutlibCallback.loadAndParseRClass();
            }
            this.myLocale = renderContext.getConfiguration().getLocale();
            this.myDownScaledImageMaxBytes = "_device_class_desktop".equals(device2.getId()) ? 18000000L : ("_device_class_tablet".equals(device2.getId()) ? 9000000L : 2500000L);
            this.setQuality(quality);
            stackTraceCaptureElement.bind(this);
        }
        catch (Exception ex) {
            this.clearClassLoader();
            throw ex;
        }
    }

    public void setQuality(float quality) {
        if (this.myEnableLayoutScanner) {
            quality = 1.0f;
        }
        if ((quality = Math.max(0.0f, Math.min(quality, 1.0f))) == this.myTargetQuality) {
            return;
        }
        this.myTargetQuality = quality;
        if (quality >= 1.0f) {
            this.myCachingImageFactory = SIMPLE_IMAGE_FACTORY;
            return;
        }
        long maxSize = this.myDownScaledImageMaxBytes;
        double dimensionScale = Math.sqrt(quality);
        this.myCachingImageFactory = new CachingImageFactory((width, height) -> {
            double downscaleWidth = (double)width * dimensionScale;
            double downscaleHeight = (double)height * dimensionScale;
            double size = width * height;
            if (size > (double)maxSize) {
                double newDimensionScale = Math.sqrt((double)maxSize / size);
                downscaleWidth *= newDimensionScale;
                downscaleHeight *= newDimensionScale;
            }
            int w = Math.max(1, (int)downscaleWidth);
            int h = Math.max(1, (int)downscaleHeight);
            return SIMPLE_IMAGE_FACTORY.getImage(w, h);
        });
    }

    public void setXmlFile(@NotNull RenderXmlFile file) {
        this.myXmlFile = file;
        ReadAction.run(() -> this.getContext().setFolderType(file.getFolderType()));
    }

    @Nullable
    public RenderXmlFile getXmlFile() {
        return this.myXmlFile;
    }

    public void setDefaultForegroundColor(@NotNull String defaultForegroundColor) {
        this.myDefaultForegroundColor = defaultForegroundColor;
    }

    @NotNull
    public String getDefaultForegroundColor() {
        return this.myDefaultForegroundColor;
    }

    @NotNull
    public IRenderLogger getLogger() {
        return this.myLogger;
    }

    @NotNull
    public HardwareConfigHelper getHardwareConfigHelper() {
        return this.myHardwareConfigHelper;
    }

    public boolean getShowDecorations() {
        return this.myShowDecorations;
    }

    public boolean getShowWithToolsVisibilityAndPosition() {
        return this.myShowWithToolsVisibilityAndPosition;
    }

    public boolean isDisposed() {
        return this.isDisposed.get();
    }

    private void clearClassLoader() {
        try {
            this.myModuleClassLoaderReference.close();
        }
        catch (AlreadyDisposedException alreadyDisposedException) {
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> dispose() {
        CompletableFuture[] currentRunningFutures;
        if (this.isDisposed.getAndSet(true)) {
            assert (false) : "RenderTask was already disposed";
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("RenderTask was already disposed"));
        }
        this.myTracker.captureDisposeStackTrace().bind(this);
        List<CompletableFuture<?>> list = this.myRunningFutures;
        synchronized (list) {
            currentRunningFutures = this.myRunningFutures.toArray(new CompletableFuture[0]);
            this.myRunningFutures.clear();
        }
        this.myLayoutlibCallback.setLogger(IRenderLogger.NULL_LOGGER);
        RenderSession renderSessionToDispose = this.myRenderSession;
        this.myRenderSession = null;
        if (renderSessionToDispose != null) {
            renderSessionToDispose.releaseRender();
        }
        return ourDisposeService.submit(() -> {
            try {
                CompletableFuture.allOf(currentRunningFutures).get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug((Throwable)e);
            }
            if (renderSessionToDispose != null) {
                try {
                    ((CompletableFuture)this.disposeRenderSession(renderSessionToDispose).whenComplete((result2, ex) -> this.clearClassLoader())).orTimeout(2L, TimeUnit.SECONDS).join();
                }
                catch (Exception exception) {}
            } else {
                this.clearClassLoader();
            }
            this.myImageFactoryDelegate = null;
            this.myContext.getModule().dispose();
            return null;
        });
    }

    @TestOnly
    @Nullable
    public ClassLoader getClassLoader() {
        return this.myModuleClassLoaderReference.getClassLoader();
    }

    public void setOverrideRenderSize(int overrideRenderWidth, int overrideRenderHeight) {
        this.myHardwareConfigHelper.setOverrideRenderSize(overrideRenderWidth, overrideRenderHeight);
        this.updateHardwareConfiguration();
    }

    public void clearOverrideRenderSize() {
        this.myHardwareConfigHelper.clearOverrideRenderSize();
        this.updateHardwareConfiguration();
    }

    private void updateHardwareConfiguration() {
        if (this.myRenderSession != null) {
            this.myRenderSession.updateHardwareConfiguration(this.myHardwareConfigHelper.getConfig());
            this.isSizeChanged = true;
        }
    }

    public boolean isRenderSizeOverridden() {
        return this.myHardwareConfigHelper.isRenderSizeOverridden();
    }

    @NotNull
    public RenderTask setMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
        this.myHardwareConfigHelper.setMaxRenderSize(maxRenderWidth, maxRenderHeight);
        return this;
    }

    @NotNull
    public RenderTask setRenderingMode(@NotNull SessionParams.RenderingMode renderingMode) {
        this.myRenderingMode = renderingMode;
        return this;
    }

    @NotNull
    public RenderTask setTimeout(long timeout) {
        this.myTimeout = timeout;
        return this;
    }

    @NotNull
    public RenderTask setTransparentBackground() {
        this.mySetTransparentBackground = true;
        return this;
    }

    @NotNull
    public RenderTask setDecorations(boolean showDecorations) {
        this.myShowDecorations = showDecorations;
        return this;
    }

    public RenderTask setEnableLayoutScanner(boolean enableLayoutScanner) {
        this.myEnableLayoutScanner = enableLayoutScanner;
        return this;
    }

    @NotNull
    public RenderTask setForceMonochromeIcon(boolean forceMonochromeIcon) {
        this.myForceMonochromeIcon = forceMonochromeIcon;
        return this;
    }

    @NotNull
    public RenderTask setShowWithToolsVisibilityAndPosition(boolean showWithToolsVisibilityAndPosition) {
        this.myShowWithToolsVisibilityAndPosition = showWithToolsVisibilityAndPosition;
        return this;
    }

    @NotNull
    public RenderTask setCustomContentHierarchyParser(@NotNull Function<Object, List<ViewInfo>> parser) {
        this.myCustomContentHierarchyParser = parser;
        return this;
    }

    @Nullable
    private static String getRootTagName(@NotNull RenderXmlFile file) {
        ResourceFolderType folderType = file.getFolderType();
        if (folderType == ResourceFolderType.XML || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.DRAWABLE) {
            RenderXmlTag rootTag = file.getRootTag();
            return rootTag == null ? null : rootTag.getName();
        }
        return null;
    }

    @NotNull
    private ImagePool.Image toPooledImage(@Nullable BufferedImage result2) {
        if (result2 != null && result2.getWidth() > 1 && result2.getHeight() > 1) {
            return this.myImagePool.copyOf(result2);
        }
        return ImagePool.NULL_POOLED_IMAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RenderResult createRenderSession(@NotNull IImageFactory factory2) {
        RenderSecurityManager securityManager;
        IAndroidTarget target2;
        ILayoutPullParser includingParser;
        RenderContext context = this.getContext();
        RenderModelModule module = context.getModule();
        if (module.isDisposed()) {
            return null;
        }
        RenderXmlFile xmlFile = this.getXmlFile();
        if (xmlFile == null) {
            throw new IllegalStateException("createRenderSession shouldn't be called on RenderTask without PsiFile");
        }
        if (this.isDisposed.get()) {
            return null;
        }
        Configuration configuration2 = context.getConfiguration();
        ResourceResolver resolver = ResourceResolver.copy((ResourceResolver)configuration2.getResourceResolver());
        if (resolver == null) {
            return null;
        }
        ILayoutPullParser modelParser = LayoutPullParsers.create(this);
        if (modelParser == null) {
            return null;
        }
        this.myLayoutlibCallback.reset();
        if (modelParser instanceof LayoutRenderPullParser) {
            boolean useSrcCompat = context.getModule().getDependencies().dependsOn(GoogleMavenArtifactId.SUPPORT_APPCOMPAT_V7) || context.getModule().getDependencies().dependsOn(GoogleMavenArtifactId.ANDROIDX_APPCOMPAT);
            ((LayoutRenderPullParser)modelParser).setUseSrcCompat(useSrcCompat);
            this.myLayoutlibCallback.setAaptDeclaredResources((Map<String, TagSnapshot>)((LayoutRenderPullParser)modelParser).getAaptDeclaredAttrs());
        }
        if ((includingParser = this.getIncludingLayoutParser((RenderResources)resolver, modelParser)) != null) {
            modelParser = includingParser;
        }
        int simulatedPlatform = (target2 = configuration2.getTarget()) instanceof CompatibilityRenderTarget ? target2.getVersion().getApiLevel() : 0;
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        SessionParams params2 = new SessionParams(modelParser, this.myRenderingMode, (Object)context.getModule().getModuleKey(), hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, context.getMinSdkVersion().getApiLevel(), context.getTargetSdkVersion().getApiLevel(), (ILayoutLog)this.myLogger, simulatedPlatform);
        params2.setAssetRepository(context.getModule().getAssetRepository());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG, (Object)RenderTask.getRootTagName(xmlFile));
        params2.setFlag(RenderParamsFlags.FLAG_KEY_DISABLE_BITMAP_CACHING, (Object)true);
        params2.setFlag(RenderParamsFlags.FLAG_DO_NOT_RENDER_ON_CREATE, (Object)true);
        params2.setFlag(RenderParamsFlags.FLAG_KEY_RESULT_IMAGE_AUTO_SCALE, (Object)true);
        params2.setFlag(RenderParamsFlags.FLAG_KEY_ADAPTIVE_ICON_MASK_PATH, (Object)configuration2.getAdaptiveShape().getPathDescription());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_USE_THEMED_ICON, (Object)configuration2.getUseThemedIcon());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_FORCE_MONOCHROME_ICON, (Object)this.myForceMonochromeIcon);
        params2.setFlag(RenderParamsFlags.FLAG_KEY_WALLPAPER_PATH, (Object)configuration2.getWallpaperPath());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_USE_GESTURE_NAV, (Object)configuration2.isGestureNav());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_EDGE_TO_EDGE, (Object)configuration2.isEdgeToEdge());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_SHOW_CUTOUT, (Object)true);
        params2.setLayoutValidationChecker(() -> this.myEnableLayoutScanner);
        params2.setCustomContentHierarchyParser(this.myCustomContentHierarchyParser);
        params2.setImageTransformation(configuration2.getImageTransformation());
        params2.setAnimatorDurationScale(this.myAnimatorDurationScale);
        params2.setExtendedViewInfoMode(true);
        LayoutDirectionQualifier qualifier = configuration2.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier != null && qualifier.getValue() == LayoutDirection.RTL && !this.getLayoutLib().isRtl(this.myLocale.toLocaleId())) {
            params2.setLocale("ur");
        } else {
            params2.setLocale(this.myLocale.toLocaleId());
        }
        try {
            @Nullable RenderModelManifest manifestInfo = context.getModule().getManifest();
            params2.setRtlSupport(manifestInfo != null && manifestInfo.isRtlSupported());
        }
        catch (Exception manifestInfo) {
            // empty catch block
        }
        Device device2 = configuration2.getDevice();
        if (!this.myShowDecorations || Device.isWear((Device)device2)) {
            params2.setForceNoDecor();
        } else {
            try {
                ResourceValue resource;
                String activity;
                ResourceValue appLabel;
                @Nullable RenderModelManifest manifestInfo = context.getModule().getManifest();
                Object object = appLabel = manifestInfo != null ? manifestInfo.getApplicationLabel() : new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STRING, "appName", "");
                if (manifestInfo != null) {
                    params2.setAppIcon(manifestInfo.getApplicationIcon());
                }
                if ((activity = configuration2.getActivity()) != null) {
                    ActivityAttributesSnapshot attributes;
                    params2.setActivityName(activity);
                    ActivityAttributesSnapshot activityAttributesSnapshot = attributes = manifestInfo != null ? manifestInfo.getActivityAttributes(activity) : null;
                    if (attributes != null) {
                        if (attributes.getLabel() != null) {
                            appLabel = attributes.getLabel();
                        }
                        if (attributes.getIcon() != null) {
                            params2.setAppIcon(attributes.getIcon());
                        }
                    }
                }
                if ((resource = params2.getResources().resolveResValue(appLabel)) != null) {
                    params2.setAppLabel(resource.getValue());
                }
            }
            catch (Exception manifestInfo) {
                // empty catch block
            }
        }
        if (this.mySetTransparentBackground || this.requiresTransparency()) {
            params2.setTransparentBackground();
        }
        params2.setImageFactory(factory2);
        if (this.myTimeout > 0L) {
            params2.setTimeout(this.myTimeout);
        }
        params2.setFontScale(configuration2.getFontScale());
        params2.setUiMode(configuration2.getUiModeFlagValue());
        this.myLayoutlibCallback.setLogger(this.myLogger);
        RenderSecurityManager renderSecurityManager = securityManager = this.isSecurityManagerEnabled ? this.myContext.getModule().getEnvironment().createRenderSecurityManager(module.getProject().getBasePath(), context.getModule().getAndroidPlatform()) : null;
        if (securityManager != null) {
            securityManager.setActive(true, this.myCredential);
        }
        try {
            RenderSession session2 = this.myLayoutLib.createSession(params2);
            if (session2.getResult().isSuccess()) {
                session2.setSystemBootTimeNanos(0L);
                session2.setSystemTimeNanos(0L);
                session2.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(500L));
            }
            BufferedImage resultImage = session2.getImage();
            RenderResult result2 = RenderResult.create(context, session2, xmlFile, this.myLogger, this.toPooledImage(resultImage), this.myLayoutlibCallback.isUsed());
            RenderSession oldRenderSession = this.myRenderSession;
            this.myRenderSession = session2;
            RenderTaskPatcher.enableComposeHotReloadMode(this.myModuleClassLoaderReference.getClassLoader());
            if (oldRenderSession != null) {
                this.disposeRenderSession(oldRenderSession);
            }
            this.addDiagnostics(result2.getRenderResult());
            RenderResult renderResult = result2;
            if (securityManager != null) {
                securityManager.dispose(this.myCredential);
            }
            return renderResult;
        }
        catch (Throwable throwable) {
            try {
                if (securityManager != null) {
                    securityManager.dispose(this.myCredential);
                }
                throw throwable;
            }
            catch (RuntimeException t) {
                this.myLogger.error(null, t.getLocalizedMessage(), t, null, null);
                throw t;
            }
        }
    }

    @Nullable
    private ILayoutPullParser getIncludingLayoutParser(RenderResources resolver, ILayoutPullParser modelParser) {
        RenderXmlFile xmlFile = this.getXmlFile();
        if (xmlFile == null) {
            throw new IllegalStateException("getIncludingLayoutParser shouldn't be called on RenderTask without PsiFile");
        }
        if (!this.myShowWithToolsVisibilityAndPosition) {
            return null;
        }
        if (this.myIncludedWithin == null) {
            this.myIncludedWithin = this.myContext.getModule().getEnvironment().createIncludeReference(xmlFile, resolver);
        }
        LayoutRenderPullParser topParser = null;
        if (this.myIncludedWithin != IncludeReference.NONE) {
            String queryLayoutName = SdkUtils.fileNameToResourceName((String)xmlFile.getName());
            this.myLayoutlibCallback.setLayoutParser(queryLayoutName, modelParser);
            RenderXmlFile fromXmlFile = this.myIncludedWithin.getFromXmlFile(this.myContext.getModule().getProject());
            if (fromXmlFile != null) {
                LayoutRenderPullParser parser;
                topParser = parser = LayoutRenderPullParser.create(fromXmlFile, this.myLogger, this.myContext.getModule().getResourceRepositoryManager());
            } else {
                topParser = LayoutFilePullParser.create(new PathString(this.myIncludedWithin.getFromPath()), ResourceNamespace.TODO(), this.myContext.getModule().getResourceIdManager());
                if (topParser == null) {
                    this.myLogger.error(null, String.format("Could not read layout file %1$s", this.myIncludedWithin.getFromPath()), null, null, null);
                }
            }
        }
        return topParser;
    }

    private static <T> CompletableFuture<T> immediateFailedFuture(Throwable exception) {
        CompletableFuture future2 = new CompletableFuture();
        future2.completeExceptionally(exception);
        return future2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NotNull
    private <V> CompletableFuture<V> runAsyncRenderAction(@NotNull Callable<V> callable, long timeout, @NotNull TimeUnit unit) {
        if (this.isDisposed.get()) {
            return RenderTask.immediateFailedFuture(new IllegalStateException("RenderTask was already disposed"));
        }
        List<CompletableFuture<?>> list = this.myRunningFutures;
        synchronized (list) {
            CompletableFuture newFuture = timeout < 1L ? RenderService.getRenderAsyncActionExecutor().runAsyncAction(this.myTopic, callable) : RenderService.getRenderAsyncActionExecutor().runAsyncActionWithTimeout(timeout, unit, this.myTopic, callable);
            this.myRunningFutures.add(newFuture);
            newFuture.whenCompleteAsync((result2, ex) -> {
                List<CompletableFuture<?>> list = this.myRunningFutures;
                synchronized (list) {
                    this.myRunningFutures.remove(newFuture);
                }
            });
            return newFuture;
        }
    }

    @VisibleForTesting
    @NotNull
    public <V> CompletableFuture<V> runAsyncRenderAction(@NotNull Callable<V> callable) {
        return this.runAsyncRenderAction(callable, 0L, TimeUnit.SECONDS);
    }

    public @NotNull CompletableFuture<@Nullable RenderResult> inflate() {
        RenderXmlFile xmlFile = this.getXmlFile();
        if (xmlFile == null) {
            return RenderTask.immediateFailedFuture(new IllegalStateException("inflate shouldn't be called on RenderTask without PsiFile"));
        }
        if (xmlFile.getProject().isDisposed()) {
            return CompletableFuture.completedFuture(null);
        }
        long startInflateTimeMs = System.currentTimeMillis();
        return ((CompletableFuture)this.runAsyncRenderAction(() -> this.createRenderSession((width, height) -> {
            this.myTestEventListener.onBeforeInflate();
            if (this.myImageFactoryDelegate != null) {
                return this.myImageFactoryDelegate.getImage(width, height);
            }
            return new BufferedImage(width, height, 3);
        }), RenderAsyncActionExecutor.DEFAULT_RENDER_THREAD_TIMEOUT_MS * 10L, TimeUnit.MILLISECONDS).whenComplete((result2, ex) -> this.myTestEventListener.onAfterInflate())).handle((result2, ex) -> {
            if (ex != null) {
                while (ex instanceof CompletionException) {
                    ex = ex.getCause();
                }
                String message = ex.getMessage();
                if (message == null) {
                    message = ex.toString();
                }
                RenderModelModule module = this.myContext.getModule();
                RenderProblem.ActionFixFactory fixFactory = module.getEnvironment().getActionFixFactory();
                this.myLogger.addMessage(RenderProblem.createHtml(ProblemSeverity.ERROR, message, this.myLogger.getLinkManager(), ex, fixFactory));
            }
            if (result2 != null) {
                return result2.createWithStats(new RenderResultStats(System.currentTimeMillis() - startInflateTimeMs, -1L, ((ModuleClassLoader)this.myModuleClassLoaderReference.getClassLoader()).getStats()));
            }
            if (((Boolean)ActionsKt.runReadAction(xmlFile::isValid)).booleanValue()) {
                return RenderResult.createErrorRenderResult(Result.Status.ERROR_RENDER_TASK, this.myContext.getModule(), xmlFile, ex, this.myLogger);
            }
            LOG.warn("Invalid file " + xmlFile);
            return null;
        });
    }

    @NotNull
    public CompletableFuture<RenderResult> layout() {
        if (this.myRenderSession == null) {
            return CompletableFuture.completedFuture(null);
        }
        assert (this.getXmlFile() != null);
        try {
            RenderSession renderSession = this.myRenderSession;
            RenderXmlFile xmlFile = this.getXmlFile();
            return this.runAsyncRenderAction(() -> {
                this.myRenderSession.measure();
                return RenderResult.create(this.myContext, renderSession, xmlFile, this.myLogger, ImagePool.NULL_POOLED_IMAGE, this.myLayoutlibCallback.isUsed());
            });
        }
        catch (Exception exception) {
            return CompletableFuture.completedFuture(null);
        }
    }

    @NotNull
    public CompletableFuture<ExecuteCallbacksResult> executeCallbacks(long timeNanos) {
        if (this.myRenderSession == null) {
            return CompletableFuture.completedFuture(ExecuteCallbacksResult.EMPTY);
        }
        return this.runAsyncRenderAction(() -> {
            this.myRenderSession.setSystemTimeNanos(timeNanos);
            long start2 = System.currentTimeMillis();
            boolean hasMoreCallbacks = this.myRenderSession.executeCallbacks(timeNanos);
            return ExecuteCallbacksResult.create(hasMoreCallbacks, System.currentTimeMillis() - start2);
        }, 500L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public CompletableFuture<InteractionEventResult> triggerTouchEvent(@NotNull RenderSession.TouchEventType touchEventType, int x, int y, long timeNanos) {
        if (this.myRenderSession == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.runAsyncRenderAction(() -> {
            this.myRenderSession.setSystemTimeNanos(timeNanos);
            long start2 = System.currentTimeMillis();
            this.myRenderSession.triggerTouchEvent(touchEventType, x, y);
            return InteractionEventResult.create(System.currentTimeMillis() - start2);
        });
    }

    @NotNull
    public CompletableFuture<InteractionEventResult> triggerKeyEvent(@NotNull KeyEvent event, long timeNanos) {
        if (this.myRenderSession == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.runAsyncRenderAction(() -> {
            this.myRenderSession.setSystemTimeNanos(timeNanos);
            long start2 = System.currentTimeMillis();
            this.myRenderSession.triggerKeyEvent(event);
            return InteractionEventResult.create(System.currentTimeMillis() - start2);
        });
    }

    private void reportException(@NotNull Throwable e) {
        if (e instanceof CancellationException) {
            return;
        }
        this.myCrashReporter.submit(this.myContext.getModule().getEnvironment().createCrashReport(e));
    }

    @NotNull
    private CompletableFuture<RenderResult> renderInner(boolean forceMeasure) {
        RenderXmlFile xmlFile = this.getXmlFile();
        assert (xmlFile != null);
        CompletionStage<Object> inflateCompletableResult = this.myRenderSession == null ? this.inflate().whenComplete((renderResult, exception) -> {
            Result result2;
            Result result3 = result2 = renderResult != null ? renderResult.getRenderResult() : null;
            if (result2 == null || !result2.isSuccess()) {
                Throwable e;
                Throwable throwable = e = result2 != null ? result2.getException() : exception;
                if (e != null) {
                    this.reportException(e);
                }
                if (result2 != null) {
                    this.myLogger.error(null, result2.getErrorMessage(), e, null, null);
                }
            }
        }) : CompletableFuture.completedFuture(null);
        return inflateCompletableResult.thenCompose(inflateResult -> {
            try {
                long startRenderTimeMs = System.currentTimeMillis();
                return ((CompletableFuture)((CompletableFuture)this.runAsyncRenderAction(() -> {
                    this.myTestEventListener.onBeforeRender();
                    this.myRenderSession.render(forceMeasure);
                    BufferedImage resultImage = this.myRenderSession.getImage();
                    RenderResult result2 = RenderResult.create(this.myContext, this.myRenderSession, xmlFile, this.myLogger, this.toPooledImage(resultImage), this.myLayoutlibCallback.isUsed());
                    Result renderResult = result2.getRenderResult();
                    if (renderResult.getException() != null) {
                        this.reportException(renderResult.getException());
                        this.myLogger.error(null, renderResult.getErrorMessage(), renderResult.getException(), null, null);
                    }
                    if (this.reportOutOfDateUserClasses && !((ModuleClassLoader)this.myModuleClassLoaderReference.getClassLoader()).isUserCodeUpToDate()) {
                        RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                        HtmlBuilder builder = problem.getHtmlBuilder();
                        builder.addLink("The project has been edited more recently than the last build: ", "Build", " the project.", this.myLogger.getLinkManager().createBuildProjectUrl());
                        this.myLogger.addMessage(problem);
                    }
                    return result2;
                }).whenComplete((result2, ex) -> this.myTestEventListener.onAfterRender())).whenComplete((result2, ex) -> {
                    Object moduleClassLoader = this.myModuleClassLoaderReference.getClassLoader();
                    RenderSessionCleaner.clearGapWorkerCache(moduleClassLoader);
                    RenderSessionCleaner.clearFontRequestWorker(moduleClassLoader);
                    RenderSessionCleaner.clearCompositions(moduleClassLoader);
                })).handle((result2, ex) -> {
                    if (ex != null) {
                        while (ex instanceof CompletionException) {
                            ex = ex.getCause();
                        }
                    }
                    if (result2 == null) {
                        result2 = RenderResult.createErrorRenderResult(Result.Status.ERROR_RENDER, this.myContext.getModule(), xmlFile, ex, this.myLogger);
                    }
                    Object moduleClassLoader = this.myModuleClassLoaderReference.getClassLoader();
                    return result2.createWithStats(new RenderResultStats(inflateResult != null ? inflateResult.getStats().getInflateDurationMs() : result2.getStats().getInflateDurationMs(), System.currentTimeMillis() - startRenderTimeMs, ((ModuleClassLoader)moduleClassLoader).getStats().getClassesFound(), ((ModuleClassLoader)moduleClassLoader).getStats().getAccumulatedFindTimeMs(), ((ModuleClassLoader)moduleClassLoader).getStats().getAccumulatedRewriteTimeMs()));
                });
            }
            catch (Exception e) {
                this.reportException(e);
                String message = e.getMessage();
                if (message == null) {
                    message = e.toString();
                }
                RenderModelModule module = this.myContext.getModule();
                RenderProblem.ActionFixFactory fixFactory = module.getEnvironment().getActionFixFactory();
                this.myLogger.addMessage(RenderProblem.createHtml(ProblemSeverity.ERROR, message, this.myLogger.getLinkManager(), e, fixFactory));
                return CompletableFuture.completedFuture(RenderResult.createErrorRenderResult(Result.Status.ERROR_RENDER_TASK, module, xmlFile, e, this.myLogger));
            }
        });
    }

    @NotNull
    public CompletableFuture<RenderResult> render(@NotNull IImageFactory factory2) {
        this.myImageFactoryDelegate = factory2;
        boolean forceMeasure = this.myTargetQuality > this.myCurrentQuality || this.isSizeChanged;
        this.myCurrentQuality = this.myTargetQuality;
        this.isSizeChanged = false;
        return this.renderInner(forceMeasure);
    }

    @NotNull
    public CompletableFuture<RenderResult> render() {
        return this.render(this.myCachingImageFactory);
    }

    public void setElapsedFrameTimeNanos(long nanos) {
        if (this.myRenderSession != null) {
            this.myRenderSession.setElapsedFrameTimeNanos(nanos);
        }
    }

    private void addDiagnostics(@NotNull Result result2) {
        ILayoutPullParser layoutEmbeddedParser;
        if (!this.myLogger.hasProblems() && !result2.isSuccess()) {
            if (result2.getException() != null || result2.getErrorMessage() != null) {
                this.myLogger.error(null, result2.getErrorMessage(), result2.getException(), null, null);
            } else if (result2.getStatus() == Result.Status.ERROR_TIMEOUT) {
                this.myLogger.error(null, "Rendering timed out.", null, null, null);
            } else {
                this.myLogger.error(null, "Unknown render problem: " + result2.getStatus(), null, null, null);
            }
        } else if (this.myIncludedWithin != null && this.myIncludedWithin != IncludeReference.NONE && (layoutEmbeddedParser = this.myLayoutlibCallback.getLayoutEmbeddedParser()) != null) {
            this.myLogger.error(null, String.format("The surrounding layout (%1$s) did not actually include this layout. Remove tools:showIn=... from the root tag.", this.myIncludedWithin.getFromResourceUrl()), null, null, null);
        }
    }

    @NotNull
    public CompletableFuture<BufferedImage> renderDrawable(@NotNull ResourceValue drawableResourceValue) {
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        RenderContext context = this.getContext();
        Configuration configuration2 = context.getConfiguration();
        DrawableParams params2 = new DrawableParams(drawableResourceValue, (Object)context.getModule().getModuleKey(), hardwareConfig, (RenderResources)configuration2.getResourceResolver(), (LayoutlibCallback)this.myLayoutlibCallback, context.getMinSdkVersion().getApiLevel(), context.getTargetSdkVersion().getApiLevel(), (ILayoutLog)this.myLogger);
        params2.setForceNoDecor();
        params2.setAssetRepository(context.getModule().getAssetRepository());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_ADAPTIVE_ICON_MASK_PATH, (Object)configuration2.getAdaptiveShape().getPathDescription());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_USE_THEMED_ICON, (Object)configuration2.getUseThemedIcon());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_FORCE_MONOCHROME_ICON, (Object)this.myForceMonochromeIcon);
        params2.setFlag(RenderParamsFlags.FLAG_KEY_WALLPAPER_PATH, (Object)configuration2.getWallpaperPath());
        return this.runAsyncRenderAction(() -> this.myLayoutLib.renderDrawable(params2)).thenCompose(result2 -> {
            Throwable exception;
            if (result2 != null && result2.isSuccess()) {
                Object data2 = result2.getData();
                if (!(data2 instanceof BufferedImage)) {
                    data2 = null;
                }
                return CompletableFuture.completedFuture((BufferedImage)data2);
            }
            if (result2.getStatus() == Result.Status.ERROR_NOT_A_DRAWABLE) {
                LOG.debug("renderDrawable called with a non-drawable resource" + drawableResourceValue);
                return CompletableFuture.completedFuture(null);
            }
            Throwable throwable = exception = result2 == null ? new RuntimeException("Rendering failed - null result") : result2.getException();
            if (exception == null) {
                String message = result2.getErrorMessage();
                exception = new RuntimeException((String)(message == null ? "Rendering failed" : "Rendering failed - " + message));
            }
            this.reportException(exception);
            return RenderTask.immediateFailedFuture(exception);
        });
    }

    @NotNull
    private LayoutLibrary getLayoutLib() {
        return this.myLayoutLib;
    }

    public void setMenuResource(@NotNull String resourceName) {
        ActionBarHandler actionBarHandler = (ActionBarHandler)this.myLayoutlibCallback.getActionBarCallback();
        if (actionBarHandler != null) {
            ResourceReference menuResource = new ResourceReference(this.myContext.getModule().getResourceRepositoryManager().getNamespace(), ResourceType.MENU, SdkUtils.fileNameToResourceName((String)resourceName));
            actionBarHandler.setMenuIds(Collections.singletonList(menuResource));
        }
    }

    private boolean isNonRectangular() {
        ResourceFolderType folderType = this.getContext().getFolderType();
        return folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MIPMAP;
    }

    private boolean requiresTransparency() {
        return this.isNonRectangular();
    }

    @NotNull
    public CompletableFuture<Map<RenderXmlTag, ViewInfo>> measureChildren(@NotNull RenderXmlTag parent, @Nullable AttributeFilter filter2) {
        LayoutRenderPullParser modelParser = LayoutRenderPullParser.create(filter2, parent, this.myLogger, this.myContext.getModule().getResourceRepositoryManager());
        HashMap map2 = new HashMap();
        return RenderService.getRenderAsyncActionExecutor().runAsyncAction(this.myTopic, () -> this.measure(modelParser)).thenComposeAsync(session2 -> {
            if (session2 != null) {
                try {
                    Result result2 = session2.getResult();
                    if (result2 != null && result2.isSuccess()) {
                        assert (session2.getRootViews().size() == 1);
                        ViewInfo root = (ViewInfo)session2.getRootViews().get(0);
                        List children2 = root.getChildren();
                        for (ViewInfo info : children2) {
                            RenderXmlTag tag = RenderService.getXmlTag(info);
                            if (tag == null) continue;
                            map2.put(tag, info);
                        }
                    }
                    CompletableFuture<Map> completableFuture = CompletableFuture.completedFuture(map2);
                    return completableFuture;
                }
                finally {
                    this.disposeRenderSession((RenderSession)session2);
                }
            }
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }, (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    public CompletableFuture<ViewInfo> measureChild(@NotNull RenderXmlTag tag, @Nullable AttributeFilter filter2) {
        RenderXmlTag parent = tag.getParentTag();
        if (parent == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.measureChildren(parent, filter2).thenApply(map2 -> (ViewInfo)map2.get(tag));
    }

    @Nullable
    private RenderSession measure(ILayoutPullParser parser) {
        RenderContext context = this.getContext();
        Configuration configuration2 = context.getConfiguration();
        ResourceResolver resolver = configuration2.getResourceResolver();
        this.myLayoutlibCallback.reset();
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        SessionParams params2 = new SessionParams(parser, SessionParams.RenderingMode.NORMAL, (Object)context.getModule().getModuleKey(), hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, context.getMinSdkVersion().getApiLevel(), context.getTargetSdkVersion().getApiLevel(), (ILayoutLog)this.myLogger);
        params2.setForceNoDecor();
        params2.setExtendedViewInfoMode(true);
        params2.setLocale(this.myLocale.toLocaleId());
        params2.setAssetRepository(context.getModule().getAssetRepository());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_ADAPTIVE_ICON_MASK_PATH, (Object)configuration2.getAdaptiveShape().getPathDescription());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_USE_THEMED_ICON, (Object)configuration2.getUseThemedIcon());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_WALLPAPER_PATH, (Object)configuration2.getWallpaperPath());
        @Nullable RenderModelManifest manifestInfo = context.getModule().getManifest();
        params2.setRtlSupport(manifestInfo != null && manifestInfo.isRtlSupported());
        try {
            this.myLayoutlibCallback.setLogger(this.myLogger);
            return this.myLayoutLib.createSession(params2);
        }
        catch (RuntimeException t) {
            this.myLogger.error(null, t.getLocalizedMessage(), t, null, null);
            throw t;
        }
    }

    @NotNull
    public CompletableFuture<Void> runAsyncRenderActionWithSession(@NotNull Runnable block, long timeout, @NotNull TimeUnit unit) {
        if (this.isDisposed.get()) {
            return RenderTask.immediateFailedFuture(new IllegalStateException("RenderTask was already disposed"));
        }
        RenderSession renderSession = this.myRenderSession;
        if (renderSession == null) {
            return RenderTask.immediateFailedFuture(new IllegalStateException("No RenderSession available"));
        }
        return this.runAsyncRenderAction(() -> {
            renderSession.execute(block);
            return null;
        }, timeout, unit);
    }

    @VisibleForTesting
    public void setCrashReporter(@NotNull CrashReporter crashReporter) {
        this.myCrashReporter = crashReporter;
    }

    @NotNull
    public RenderContext getContext() {
        return this.myContext;
    }

    @NotNull
    private CompletableFuture<Void> disposeRenderSession(@NotNull RenderSession renderSession) {
        long nativeMemoryUsage = LayoutLibraryLoader.getLayoutLibraryProvider().map(LayoutLibraryLoader.LayoutLibraryProvider::getNativeMemoryUsage).orElse(0L);
        return RenderSessionCleaner.dispose(renderSession, this.myModuleClassLoaderReference.getClassLoader()).thenRun(() -> {
            if (nativeMemoryUsage > MAX_NATIVE_MEMORY) {
                this.myContext.getModule().getEnvironment().cleanLayoutlibNativeMemory();
            }
        });
    }

    @TestOnly
    @NotNull
    public static ExecutorService getDisposeService() {
        return ourDisposeService;
    }

    public static interface TestEventListener {
        default public void onBeforeInflate() {
        }

        default public void onAfterInflate() {
        }

        default public void onBeforeRender() {
        }

        default public void onAfterRender() {
        }
    }

    public static interface AttributeFilter {
        @Nullable
        public String getAttribute(@NotNull RenderXmlTag var1, @Nullable String var2, @NotNull String var3);
    }
}

