/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.KeyBindingKt;
import com.android.tools.adtui.stdui.KeyStrokes;
import com.android.tools.property.panel.api.HelpSupport;
import com.android.tools.property.panel.api.PropertyItem;
import com.android.tools.property.panel.impl.model.TableEditingRequest;
import com.android.tools.property.panel.impl.model.TableLineModelImpl;
import com.android.tools.property.panel.impl.model.TableRowEditListener;
import com.android.tools.property.panel.impl.model.TextFieldPropertyEditorModel;
import com.android.tools.property.panel.impl.support.HelpSupportBinding;
import com.android.tools.property.panel.impl.ui.PropertyTextField;
import com.android.tools.property.ptable.ColumnFraction;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableCellEditorProvider;
import com.android.tools.property.ptable.PTableCellRendererProvider;
import com.android.tools.property.ptable.PTableColumn;
import com.android.tools.property.ptable.PTableGroupItem;
import com.android.tools.property.ptable.PTableItem;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0000J\u0010\u0010\u001c\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0000J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\u001a\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0012\u0010$\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u00020*2\b\u0010,\u001a\u0004\u0018\u00010#H\u0002J\b\u0010-\u001a\u00020*H\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u00102\u001a\u00020/2\u0006\u0010\"\u001a\u00020#2\b\u00103\u001a\u0004\u0018\u00010#H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00064"}, d2={"Lcom/android/tools/property/panel/impl/ui/TableEditor;", "", "lineModel", "Lcom/android/tools/property/panel/impl/model/TableLineModelImpl;", "rendererProvider", "Lcom/android/tools/property/ptable/PTableCellRendererProvider;", "editorProvider", "Lcom/android/tools/property/ptable/PTableCellEditorProvider;", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "nameColumnFraction", "Lcom/android/tools/property/ptable/ColumnFraction;", "<init>", "(Lcom/android/tools/property/panel/impl/model/TableLineModelImpl;Lcom/android/tools/property/ptable/PTableCellRendererProvider;Lcom/android/tools/property/ptable/PTableCellEditorProvider;Ljava/util/List;Lcom/android/tools/property/ptable/ColumnFraction;)V", "getLineModel", "()Lcom/android/tools/property/panel/impl/model/TableLineModelImpl;", "getActions", "()Ljava/util/List;", "table", "Lcom/android/tools/property/ptable/PTable;", "component", "Ljavax/swing/JTable;", "getComponent", "()Ljavax/swing/JTable;", "setPreviousTableEditor", "", "editor", "setNextTableEditor", "updateUI", "handleValueChanged", "handleEditRequest", "request", "Lcom/android/tools/property/panel/impl/model/TableEditingRequest;", "item", "Lcom/android/tools/property/ptable/PTableItem;", "selectItem", "getToolTipText", "", "event", "Ljava/awt/event/MouseEvent;", "computeRowHeight", "", "findRowOf", "itemToEdit", "findRowOfBestMatch", "isMatch", "", "matcher", "Lcom/intellij/util/text/Matcher;", "isBetter", "best", "intellij.android.layout-ui"})
@SourceDebugExtension(value={"SMAP\nTableEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableEditor.kt\ncom/android/tools/property/panel/impl/ui/TableEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1863#2:240\n774#2:252\n865#2,2:253\n1863#2,2:255\n1864#2:257\n4135#3,11:241\n1#4:258\n*S KotlinDebug\n*F\n+ 1 TableEditor.kt\ncom/android/tools/property/panel/impl/ui/TableEditor\n*L\n108#1:240\n111#1:252\n111#1:253,2\n112#1:255,2\n108#1:257\n110#1:241,11\n*E\n"})
public final class TableEditor {
    @NotNull
    private final TableLineModelImpl lineModel;
    @NotNull
    private final List<AnAction> actions;
    @NotNull
    private final PTable table;
    @NotNull
    private final JTable component;

    /*
     * WARNING - void declaration
     */
    public TableEditor(@NotNull TableLineModelImpl lineModel, @NotNull PTableCellRendererProvider rendererProvider, @NotNull PTableCellEditorProvider editorProvider, @NotNull List<? extends AnAction> actions2, @NotNull ColumnFraction nameColumnFraction) {
        Intrinsics.checkNotNullParameter((Object)lineModel, (String)"lineModel");
        Intrinsics.checkNotNullParameter((Object)rendererProvider, (String)"rendererProvider");
        Intrinsics.checkNotNullParameter((Object)editorProvider, (String)"editorProvider");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)nameColumnFraction, (String)"nameColumnFraction");
        this.lineModel = lineModel;
        this.actions = actions2;
        this.table = PTable.Companion.create(this.lineModel.getTableModel(), this.lineModel, rendererProvider, editorProvider, (Function1<? super MouseEvent, String>)((Function1)arg_0 -> TableEditor.table$lambda$0(this, arg_0)), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                TableEditor.access$updateUI((TableEditor)this.receiver);
            }
        }), nameColumnFraction);
        JComponent jComponent = this.table.getComponent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type javax.swing.JTable");
        this.component = (JTable)jComponent;
        this.component.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.component.setRowHeight(this.computeRowHeight());
        this.lineModel.addValueChangedListener(new TableRowEditListener(){

            public void valueChanged() {
                this.handleValueChanged();
            }

            @Override
            public void editRequest(TableEditingRequest type, PTableItem item) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                this.handleEditRequest(type, item);
            }
        });
        this.component.getSelectionModel().addListSelectionListener(arg_0 -> TableEditor._init_$lambda$1(this, arg_0));
        HelpSupportBinding.registerHelpKeyActions$default(HelpSupportBinding.INSTANCE, this.component, () -> TableEditor._init_$lambda$2(this), 0, 4, null);
        KeyBindingKt.registerActionKey$default((JComponent)this.component, TableEditor::_init_$lambda$3, (KeyStroke)KeyStrokes.INSTANCE.getPAGE_UP(), (String)"pageUp", TableEditor::_init_$lambda$4, (int)0, (int)16, null);
        KeyBindingKt.registerActionKey$default((JComponent)this.component, TableEditor::_init_$lambda$5, (KeyStroke)KeyStrokes.INSTANCE.getPAGE_DOWN(), (String)"pageDown", TableEditor::_init_$lambda$6, (int)0, (int)16, null);
        Iterable $this$forEach$iv = this.actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            AnAction action2 = (AnAction)element$iv;
            boolean bl = false;
            Shortcut[] shortcutArray = action2.getShortcutSet().getShortcuts();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            Object[] objectArray = shortcutArray;
            boolean $i$f$filterIsInstance = false;
            Iterator iterator2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KeyboardShortcut)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KeyboardShortcut it = (KeyboardShortcut)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getSecondKeyStroke() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KeyboardShortcut it = (KeyboardShortcut)element$iv2;
                boolean bl3 = false;
                JComponent jComponent2 = this.component;
                Function0 function0 = () -> TableEditor.lambda$10$lambda$9$lambda$8(action2);
                KeyStroke keyStroke = it.getFirstKeyStroke();
                Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getFirstKeyStroke(...)");
                String string = action2.getTemplatePresentation().getDescription();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
                KeyBindingKt.registerAnActionKey$default((JComponent)jComponent2, (Function0)function0, (KeyStroke)keyStroke, (String)string, (int)0, (int)8, null);
            }
        }
        DataManager.registerDataProvider((JComponent)this.component, arg_0 -> TableEditor._init_$lambda$11(this, arg_0));
    }

    public /* synthetic */ TableEditor(TableLineModelImpl tableLineModelImpl, PTableCellRendererProvider pTableCellRendererProvider, PTableCellEditorProvider pTableCellEditorProvider, List list, ColumnFraction columnFraction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            columnFraction = new ColumnFraction(0.0f, false, 3, null);
        }
        this(tableLineModelImpl, pTableCellRendererProvider, pTableCellEditorProvider, list, columnFraction);
    }

    @NotNull
    public final TableLineModelImpl getLineModel() {
        return this.lineModel;
    }

    @NotNull
    public final List<AnAction> getActions() {
        return this.actions;
    }

    @NotNull
    public final JTable getComponent() {
        return this.component;
    }

    public final void setPreviousTableEditor(@Nullable TableEditor editor) {
        TableEditor tableEditor = editor;
        this.table.setPreviousTable(tableEditor != null ? tableEditor.table : null);
    }

    public final void setNextTableEditor(@Nullable TableEditor editor) {
        TableEditor tableEditor = editor;
        this.table.setNextTable(tableEditor != null ? tableEditor.table : null);
    }

    private final void updateUI() {
        this.component.setRowHeight(this.computeRowHeight());
    }

    private final void handleValueChanged() {
        this.component.setVisible(this.lineModel.getVisible());
        this.table.setFilter(this.lineModel.getFilter());
        this.lineModel.setItemCount(this.table.getItemCount());
    }

    private final void handleEditRequest(TableEditingRequest request, PTableItem item) {
        this.handleValueChanged();
        switch (WhenMappings.$EnumSwitchMapping$0[request.ordinal()]) {
            case 1: {
                this.table.startEditing(this.findRowOf(item));
                break;
            }
            case 2: {
                this.table.startEditing(-1);
                break;
            }
            case 3: {
                this.table.startEditing(this.findRowOfBestMatch());
                break;
            }
            case 4: {
                this.selectItem(item);
            }
        }
    }

    private final void selectItem(PTableItem item) {
        if (item != null) {
            int n = this.component.getRowCount();
            for (int row = 0; row < n; ++row) {
                if (!Intrinsics.areEqual((Object)this.component.getValueAt(row, 0), (Object)item)) continue;
                this.component.setRowSelectionInterval(row, row);
                return;
            }
        }
        this.component.transferFocusBackward();
    }

    private final String getToolTipText(MouseEvent event) {
        JComponent control;
        int tableRow = this.component.rowAtPoint(event.getPoint());
        int tableColumn = this.component.columnAtPoint(event.getPoint());
        if (tableRow < 0 || tableColumn < 0) {
            return null;
        }
        Object item = this.component.getValueAt(tableRow, tableColumn);
        TableCellRenderer renderer2 = this.component.getCellRenderer(tableRow, tableColumn);
        Component component = renderer2.getTableCellRendererComponent(this.component, item, false, false, tableRow, tableColumn);
        if (component == null) {
            return null;
        }
        Component cell = component;
        Rectangle rect = this.component.getCellRect(tableRow, tableColumn, true);
        cell.setBounds(0, 0, rect.width, rect.height);
        Component component2 = SwingUtilities.getDeepestComponentAt(cell, event.getX() - rect.x, event.getY() - rect.y);
        JComponent jComponent = control = component2 instanceof JComponent ? (JComponent)component2 : null;
        return jComponent != null ? jComponent.getToolTipText(event) : null;
    }

    private final int computeRowHeight() {
        Object v0;
        block2: {
            Iterable iterable = this.lineModel.getTableModel().getItems();
            for (Object t : iterable) {
                PTableItem it = (PTableItem)t;
                boolean bl = false;
                if (!(it instanceof PropertyItem)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Object var3_6 = v0;
        PropertyItem propertyItem = var3_6 instanceof PropertyItem ? (PropertyItem)var3_6 : null;
        if (propertyItem == null) {
            return JBUI.scale((int)24);
        }
        PropertyItem property2 = propertyItem;
        PropertyTextField textField2 = new PropertyTextField(new TextFieldPropertyEditorModel(property2, true));
        return Integer.max(textField2.getPreferredSize().height, JBUI.scale((int)20));
    }

    private final int findRowOf(PTableItem itemToEdit) {
        int count = this.table.getItemCount();
        for (int i = 0; i < count; ++i) {
            PTableItem item = this.table.item(i);
            if (!Intrinsics.areEqual((Object)item, (Object)itemToEdit)) continue;
            return i;
        }
        return -1;
    }

    private final int findRowOfBestMatch() {
        if (((CharSequence)this.lineModel.getFilter()).length() == 0) {
            return -1;
        }
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + this.lineModel.getFilter())).build();
        int count = this.table.getItemCount();
        PTableItem best = null;
        int bestRow = -1;
        for (int row = 0; row < count; ++row) {
            PTableItem item = this.table.item(row);
            Intrinsics.checkNotNull((Object)matcher);
            if (!this.isMatch((Matcher)matcher, item) || !this.isBetter(item, best)) continue;
            best = item;
            bestRow = row;
        }
        return bestRow;
    }

    private final boolean isMatch(Matcher matcher, PTableItem item) {
        return item instanceof PTableGroupItem ? matcher.matches(item.getName()) : true;
    }

    private final boolean isBetter(PTableItem item, PTableItem best) {
        return !this.lineModel.getTableModel().isCellEditable(item, PTableColumn.VALUE) ? false : (best == null ? true : item.getName().length() < best.getName().length());
    }

    private static final String table$lambda$0(TableEditor this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getToolTipText(it);
    }

    private static final void _init_$lambda$1(TableEditor this$0, ListSelectionEvent it) {
        Object object;
        int index = this$0.component.getSelectedRow();
        PTableItem item = index >= 0 && index < this$0.component.getRowCount() ? ((object = this$0.component.getValueAt(index, 1)) instanceof PTableItem ? (PTableItem)object : null) : null;
        this$0.lineModel.setSelectedItem(item);
    }

    private static final PropertyItem _init_$lambda$2(TableEditor this$0) {
        PTableItem pTableItem = this$0.lineModel.getSelectedItem();
        return pTableItem instanceof PropertyItem ? (PropertyItem)pTableItem : null;
    }

    private static final Unit _init_$lambda$3() {
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$4() {
        return false;
    }

    private static final Unit _init_$lambda$5() {
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$6() {
        return false;
    }

    private static final AnAction lambda$10$lambda$9$lambda$8(AnAction $action) {
        return $action;
    }

    private static final Object _init_$lambda$11(TableEditor this$0, String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return HelpSupport.Companion.getPROPERTY_ITEM().is(dataId) ? this$0.lineModel.getSelectedItem() : null;
    }

    public static final /* synthetic */ void access$updateUI(TableEditor $this) {
        $this.updateUI();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TableEditingRequest.values().length];
            try {
                nArray[TableEditingRequest.SPECIFIED_ITEM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TableEditingRequest.STOP_EDITING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TableEditingRequest.BEST_MATCH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TableEditingRequest.SELECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

