/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.api;

import com.android.tools.adtui.stdui.CommonTabbedPane;
import com.android.tools.property.panel.api.HelpSupport;
import com.android.tools.property.panel.api.PropertiesModel;
import com.android.tools.property.panel.api.PropertiesModelListener;
import com.android.tools.property.panel.api.PropertiesView;
import com.android.tools.property.panel.api.PropertiesViewTab;
import com.android.tools.property.panel.api.PropertyItem;
import com.android.tools.property.panel.impl.ui.PropertiesPage;
import com.android.tools.property.panel.impl.ui.WatermarkPanel;
import com.android.tools.property.ptable.PTableItem;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bJ\u0016\u00106\u001a\u0002042\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016J\u0016\u00108\u001a\u0002042\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016J\u0006\u00109\u001a\u00020\u0015J\u0014\u0010:\u001a\u0002042\n\u00107\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\b\u0010;\u001a\u000204H\u0002J\n\u0010<\u001a\u0004\u0018\u00010&H\u0007J\u0014\u0010=\u001a\u0002042\n\b\u0002\u0010>\u001a\u0004\u0018\u00010&H\u0002J\b\u0010?\u001a\u00020@H\u0002J\u0018\u0010A\u001a\u0002042\u0006\u0010B\u001a\u00020&2\u0006\u0010C\u001a\u00020&H\u0002J\u0010\u0010D\u001a\u00020\u00182\u0006\u0010E\u001a\u00020@H\u0002J\b\u0010F\u001a\u000204H\u0016R\u0014\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u00020\u00188\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u001a\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R+\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020&8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0019\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001000/8F\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006G"}, d2={"Lcom/android/tools/property/panel/api/PropertiesPanel;", "P", "Lcom/android/tools/property/panel/api/PropertyItem;", "Lcom/intellij/openapi/Disposable;", "Lcom/android/tools/property/panel/api/PropertiesModelListener;", "parentDisposable", "<init>", "(Lcom/intellij/openapi/Disposable;)V", "activeModel", "Lcom/android/tools/property/panel/api/PropertiesModel;", "activeView", "Lcom/android/tools/property/panel/api/PropertiesView;", "views", "Ljava/util/IdentityHashMap;", "tabbedPanel", "Lcom/android/tools/adtui/stdui/CommonTabbedPane;", "watermark", "Lcom/android/tools/property/panel/impl/ui/WatermarkPanel;", "hidden", "Ljavax/swing/JPanel;", "updatingPageVisibility", "", "isDisposed", "mainPage", "Lcom/android/tools/property/panel/impl/ui/PropertiesPage;", "getMainPage$annotations", "()V", "getMainPage", "()Lcom/android/tools/property/panel/impl/ui/PropertiesPage;", "pages", "", "getPages$annotations", "getPages", "()Ljava/util/List;", "component", "getComponent", "()Ljavax/swing/JPanel;", "<set-?>", "", "filter", "getFilter", "()Ljava/lang/String;", "setFilter", "(Ljava/lang/String;)V", "filter$delegate", "Lkotlin/properties/ReadWriteProperty;", "selectedItem", "Lorg/jetbrains/concurrency/Promise;", "Lcom/android/tools/property/ptable/PTableItem;", "getSelectedItem", "()Lorg/jetbrains/concurrency/Promise;", "addView", "", "view", "propertiesGenerated", "model", "propertyValuesChanged", "enterInFilter", "populateInspector", "saveMostRecentTabPage", "selectedTab", "updatePageVisibility", "preferredTabName", "findVisibleTabCount", "", "filterChanged", "oldValue", "newValue", "lookupPage", "pageIndex", "dispose", "intellij.android.layout-ui"})
@SourceDebugExtension(value={"SMAP\nPropertiesPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertiesPanel.kt\ncom/android/tools/property/panel/api/PropertiesPanel\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,260:1\n33#2,3:261\n1863#3,2:264\n295#3,2:266\n1863#3,2:268\n1782#3,4:270\n1863#3,2:274\n1863#3,2:276\n*S KotlinDebug\n*F\n+ 1 PropertiesPanel.kt\ncom/android/tools/property/panel/api/PropertiesPanel\n*L\n68#1:261,3\n105#1:264,2\n113#1:266,2\n133#1:268,2\n233#1:270,4\n256#1:274,2\n257#1:276,2\n*E\n"})
public final class PropertiesPanel<P extends PropertyItem>
implements Disposable,
PropertiesModelListener<P> {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @Nullable
    private PropertiesModel<?> activeModel;
    @Nullable
    private PropertiesView<?> activeView;
    @NotNull
    private final IdentityHashMap<PropertiesModel<P>, PropertiesView<P>> views;
    @NotNull
    private final CommonTabbedPane tabbedPanel;
    @NotNull
    private final WatermarkPanel watermark;
    @NotNull
    private final JPanel hidden;
    private boolean updatingPageVisibility;
    private boolean isDisposed;
    @NotNull
    private final PropertiesPage mainPage;
    @NotNull
    private final List<PropertiesPage> pages;
    @NotNull
    private final JPanel component;
    @NotNull
    private final ReadWriteProperty filter$delegate;

    public PropertiesPanel(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.views = new IdentityHashMap();
        this.tabbedPanel = new CommonTabbedPane();
        this.watermark = new WatermarkPanel();
        this.hidden = new JPanel();
        this.mainPage = new PropertiesPage(this);
        this.pages = new ArrayList();
        this.component = new JPanel(new BorderLayout());
        Delegates delegates = Delegates.INSTANCE;
        String initialValue$iv = "";
        boolean $i$f$observable = false;
        this.filter$delegate = (ReadWriteProperty)new ObservableProperty<String>((Object)initialValue$iv, this){
            final /* synthetic */ PropertiesPanel this$0;
            {
                this.this$0 = propertiesPanel;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property2, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                String string = (String)newValue;
                String oldValue2 = (String)oldValue;
                boolean bl = false;
                PropertiesPanel.access$filterChanged(this.this$0, oldValue2, (String)newValue2);
            }
        };
        this.component.setName("properties.panel");
        this.component.putClientProperty("properties.panel", this);
        this.hidden.setVisible(false);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.tabbedPanel.addChangeListener(arg_0 -> PropertiesPanel._init_$lambda$3(this, arg_0));
    }

    @NotNull
    public final PropertiesPage getMainPage() {
        return this.mainPage;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMainPage$annotations() {
    }

    @NotNull
    public final List<PropertiesPage> getPages() {
        return this.pages;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPages$annotations() {
    }

    @NotNull
    public final JPanel getComponent() {
        return this.component;
    }

    @NotNull
    public final String getFilter() {
        return (String)this.filter$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setFilter(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.filter$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
    }

    @NotNull
    public final Promise<PTableItem> getSelectedItem() {
        AsyncPromise result2 = new AsyncPromise();
        DataManager.getInstance().getDataContextFromFocusAsync().then(arg_0 -> PropertiesPanel._get_selectedItem_$lambda$2(arg_0 -> PropertiesPanel._get_selectedItem_$lambda$1(result2, arg_0), arg_0));
        return (Promise)result2;
    }

    public final void addView(@NotNull PropertiesView<P> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        ((Map)this.views).put(view.getModel(), view);
        view.getModel().addListener(this);
    }

    @Override
    public void propertiesGenerated(@NotNull PropertiesModel<P> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        if (this.isDisposed) {
            return;
        }
        this.populateInspector(model);
        if (((CharSequence)this.getFilter()).length() > 0) {
            this.filterChanged("", this.getFilter());
        }
    }

    @Override
    public void propertyValuesChanged(@NotNull PropertiesModel<P> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        if (Intrinsics.areEqual(model, this.activeModel)) {
            this.mainPage.propertyValuesChanged();
            Iterable $this$forEach$iv = this.pages;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PropertiesPage it = (PropertiesPage)element$iv;
                boolean bl = false;
                it.propertyValuesChanged();
            }
        }
    }

    public final boolean enterInFilter() {
        Object v0;
        block2: {
            if (this.mainPage.enterInFilter()) {
                return true;
            }
            Iterable $this$firstOrNull$iv = this.pages;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PropertiesPage it = (PropertiesPage)element$iv;
                boolean bl = false;
                if (!it.getComponent().isVisible()) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        PropertiesPage propertiesPage = v0;
        return propertiesPage != null ? propertiesPage.enterInFilter() : false;
    }

    private final void populateInspector(PropertiesModel<?> model) {
        PropertiesView propertiesView = (PropertiesView)((Map)this.views).get(model);
        if (propertiesView == null) {
            return;
        }
        PropertiesView view = propertiesView;
        if (!Intrinsics.areEqual(this.activeModel, model)) {
            PropertiesModel<?> propertiesModel = this.activeModel;
            if (propertiesModel != null) {
                propertiesModel.deactivate();
            }
            this.activeModel = model;
            this.activeView = view;
        }
        this.mainPage.clear();
        view.getMain().attachToInspector(this.mainPage);
        if (!((Collection)view.getTabs()).isEmpty()) {
            this.mainPage.addSeparatorBeforeTabs();
        }
        Iterable $this$forEach$iv = this.pages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PropertiesPage it = (PropertiesPage)element$iv;
            boolean bl = false;
            it.clear();
        }
        int n = ((Collection)view.getTabs()).size();
        for (int index = 0; index < n; ++index) {
            PropertiesViewTab tab = view.getTabs().get(index);
            PropertiesPage page = this.lookupPage(index);
            tab.attachToInspector(page);
            page.getComponent().putClientProperty("tab.name", tab.getName());
        }
        this.pages.subList(view.getTabs().size(), this.pages.size()).clear();
        String preferredTab = PropertiesComponent.getInstance().getValue("android.last.property.tab." + StringUtil.escapeProperty((String)view.getId(), (boolean)true));
        this.watermark.setModel(view.getWatermark());
        this.updatePageVisibility(preferredTab);
    }

    private final void saveMostRecentTabPage() {
        if (this.updatingPageVisibility) {
            return;
        }
        String tabName = this.selectedTab();
        PropertiesView<?> propertiesView = this.activeView;
        if (propertiesView == null) {
            return;
        }
        PropertiesView<?> view = propertiesView;
        PropertiesComponent.getInstance().setValue("android.last.property.tab." + StringUtil.escapeProperty((String)view.getId(), (boolean)true), tabName);
    }

    @VisibleForTesting
    @Nullable
    public final String selectedTab() {
        Component component;
        Object object = this.component.getLayout();
        BorderLayout borderLayout = object instanceof BorderLayout ? (BorderLayout)object : null;
        if (borderLayout == null) {
            return null;
        }
        BorderLayout layout = borderLayout;
        Component component2 = layout.getLayoutComponent("Center");
        if (component2 == null) {
            return null;
        }
        Component component3 = component2;
        if (Intrinsics.areEqual((Object)component3, (Object)this.tabbedPanel)) {
            Component component4 = this.tabbedPanel.getSelectedComponent();
            Intrinsics.checkNotNullExpressionValue((Object)component4, (String)"getSelectedComponent(...)");
            component3 = component4;
        }
        JComponent jComponent = (component = component3) instanceof JComponent ? (JComponent)component : null;
        object = jComponent != null ? jComponent.getClientProperty("tab.name") : null;
        return object instanceof String ? (String)object : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updatePageVisibility(String preferredTabName) {
        boolean bl;
        PropertiesView<?> propertiesView = this.activeView;
        if (propertiesView == null) {
            return;
        }
        PropertiesView<?> view = propertiesView;
        int visibleTabCount = this.findVisibleTabCount();
        int preferredTabIndex = -1;
        boolean bl2 = bl = view.getTabs().size() == this.pages.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.updatingPageVisibility = true;
        try {
            this.component.removeAll();
            this.tabbedPanel.removeAll();
            if ((((CharSequence)this.getFilter()).length() == 0 || view.getMain().getSearchable()) && !this.mainPage.isEmpty()) {
                this.component.add((Component)this.mainPage.getComponent(), "North");
            } else {
                this.hidden.add(this.mainPage.getComponent());
            }
            int n = ((Collection)view.getTabs()).size();
            for (int index = 0; index < n; ++index) {
                PropertiesViewTab<?> tab = view.getTabs().get(index);
                PropertiesPage page = this.pages.get(index);
                boolean tabVisible = (((CharSequence)this.getFilter()).length() == 0 || tab.getSearchable()) && !page.isEmpty();
                page.getComponent().setVisible(tabVisible);
                if (!tabVisible) {
                    this.hidden.add(page.getComponent());
                    continue;
                }
                if (visibleTabCount == 1) {
                    this.component.add((Component)page.getComponent(), "Center");
                    continue;
                }
                this.tabbedPanel.add((Component)page.getComponent(), (Object)tab.getName());
                if (!Intrinsics.areEqual((Object)tab.getName(), (Object)preferredTabName)) continue;
                preferredTabIndex = this.tabbedPanel.getComponentCount() - 1;
            }
            if (visibleTabCount < 2) {
                this.hidden.add((Component)this.tabbedPanel);
            } else {
                this.component.add((Component)this.tabbedPanel, "Center");
                if (preferredTabIndex >= 0) {
                    this.tabbedPanel.setSelectedIndex(preferredTabIndex);
                }
            }
            if (this.component.getComponentCount() == 0) {
                this.component.add((Component)((Object)this.watermark), "Center");
            } else {
                this.hidden.add((Component)((Object)this.watermark));
            }
            this.component.add((Component)this.hidden, "South");
            this.component.revalidate();
            this.component.repaint();
        }
        finally {
            this.updatingPageVisibility = false;
        }
    }

    static /* synthetic */ void updatePageVisibility$default(PropertiesPanel propertiesPanel, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        propertiesPanel.updatePageVisibility(string);
    }

    private final int findVisibleTabCount() {
        int n;
        PropertiesView<?> propertiesView = this.activeView;
        if (propertiesView == null) {
            return 0;
        }
        PropertiesView<?> view = propertiesView;
        Iterable $this$count$iv = (Iterable)CollectionsKt.getIndices((Collection)view.getTabs());
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            Iterator iterator2 = $this$count$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                if (!((((CharSequence)this.getFilter()).length() == 0 || view.getTabs().get(it).getSearchable()) && !this.pages.get(it).isEmpty()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    private final void filterChanged(String oldValue, String newValue) {
        for (PropertiesPage page : this.pages) {
            page.setFilter(newValue);
        }
        if (((CharSequence)oldValue).length() == 0 ^ ((CharSequence)newValue).length() == 0) {
            PropertiesPanel.updatePageVisibility$default(this, null, 1, null);
        }
    }

    private final PropertiesPage lookupPage(int pageIndex) {
        while (pageIndex >= this.pages.size()) {
            this.pages.add(new PropertiesPage(this));
        }
        return this.pages.get(pageIndex);
    }

    public void dispose() {
        Object it;
        this.isDisposed = true;
        Set<PropertiesModel<P>> set2 = this.views.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PropertiesModel)element$iv;
            boolean bl = false;
            it.removeListener(this);
        }
        $this$forEach$iv = this.pages;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PropertiesPage)element$iv;
            boolean bl = false;
            ((PropertiesPage)it).clear();
        }
    }

    private static final Unit _get_selectedItem_$lambda$1(AsyncPromise $result, DataContext it) {
        $result.setResult(it.getData(HelpSupport.Companion.getPROPERTY_ITEM()));
        return Unit.INSTANCE;
    }

    private static final Unit _get_selectedItem_$lambda$2(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$3(PropertiesPanel this$0, ChangeEvent it) {
        this$0.saveMostRecentTabPage();
    }

    public static final /* synthetic */ void access$filterChanged(PropertiesPanel $this, String oldValue, String newValue) {
        $this.filterChanged(oldValue, newValue);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(PropertiesPanel.class, "filter", "getFilter()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

