/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.nativeSymbolizer;

import com.android.sdklib.devices.Abi;
import com.android.tools.nativeSymbolizer.NativeSymbolizerKt;
import com.android.tools.nativeSymbolizer.SymbolSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/nativeSymbolizer/SymbolFilesLocator;", "", "source", "Lcom/android/tools/nativeSymbolizer/SymbolSource;", "<init>", "(Lcom/android/tools/nativeSymbolizer/SymbolSource;)V", "getDirectories", "", "Ljava/io/File;", "cpuArch", "", "getFiles", "", "containsSymbolFiles", "", "dir", "Companion", "native-symbolizer"})
@SourceDebugExtension(value={"SMAP\nSymbolFilesLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolFilesLocator.kt\ncom/android/tools/nativeSymbolizer/SymbolFilesLocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,78:1\n774#2:79\n865#2,2:80\n774#2:82\n865#2,2:83\n774#2:85\n865#2,2:86\n12567#3,2:88\n*S KotlinDebug\n*F\n+ 1 SymbolFilesLocator.kt\ncom/android/tools/nativeSymbolizer/SymbolFilesLocator\n*L\n37#1:79\n37#1:80,2\n41#1:82\n41#1:83,2\n54#1:85\n54#1:86,2\n76#1:88,2\n*E\n"})
public final class SymbolFilesLocator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SymbolSource source;
    @NotNull
    private static final Set<Abi> abis;

    public SymbolFilesLocator(@NotNull SymbolSource source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        this.source = source2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<File> getDirectories(@NotNull String cpuArch) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)cpuArch, (String)"cpuArch");
        Set dirs = new LinkedHashSet();
        Iterable $this$filter$iv = abis;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Abi it = (Abi)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getCpuArch(), (Object)cpuArch)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Abi abi : (List)destination$iv$iv) {
            dirs.addAll(this.source.getDirsFor(abi));
        }
        Iterable $this$filter$iv2 = dirs;
        boolean $i$f$filter = false;
        Iterable $i$f$filter22 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!this.containsSymbolFiles(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getFiles(@NotNull String cpuArch) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cpuArch, (String)"cpuArch");
        Object[] objectArray = new String[]{"so", "dwo"};
        Set extensions = SetsKt.setOf((Object[])objectArray);
        Set files2 = new LinkedHashSet();
        for (File dir : this.getDirectories(cpuArch)) {
            Collection collection2 = files2;
            Object[] objectArray2 = dir.listFiles();
            if (objectArray2 == null) {
                objectArray2 = new File[]{};
            }
            CollectionsKt.addAll((Collection)collection2, (Object[])objectArray2);
        }
        Iterable $this$filter$iv = files2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!extensions.contains(FilesKt.getExtension((File)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean containsSymbolFiles(File dir) {
        boolean bl;
        block4: {
            boolean bl2;
            boolean bl3 = bl2 = dir != null;
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (!dir.isDirectory()) {
                return false;
            }
            Object[] objectArray = new String[]{"so", "dwo"};
            Set extensions = SetsKt.setOf((Object[])objectArray);
            File[] files2 = dir.listFiles();
            if (files2 == null) {
                NativeSymbolizerKt.getLogger().warn("Failed to list directory " + dir + " for native symbols. Will ignore it.");
                return false;
            }
            File[] $this$any$iv = files2;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$any$iv[i];
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!extensions.contains(FilesKt.getExtension((File)it))) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    static {
        Object[] objectArray = new Abi[]{Abi.X86, Abi.X86_64, Abi.ARM64_V8A, Abi.ARMEABI, Abi.ARMEABI_V7A};
        abis = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/nativeSymbolizer/SymbolFilesLocator$Companion;", "", "<init>", "()V", "abis", "", "Lcom/android/sdklib/devices/Abi;", "getAbis", "()Ljava/util/Set;", "native-symbolizer"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Abi> getAbis() {
            return abis;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

