/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.ui;

import com.intellij.ide.GeneralLocalSettings;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public final class WizardUtils {
    @NotNull
    public static File getProjectLocationParent() {
        String defaultProjectLocation = GeneralLocalSettings.getInstance().getDefaultProjectDirectory();
        if (!defaultProjectLocation.isEmpty()) {
            return new File(defaultProjectLocation);
        }
        String parent = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (parent != null) {
            return new File(PathUtil.toSystemDependentName((String)parent));
        }
        if (PlatformUtils.isIntelliJ()) {
            return new File(ProjectUtil.getUserHomeProjectDir());
        }
        return new File(SystemProperties.getUserHome(), PlatformUtils.getPlatformPrefix() + "Projects");
    }

    @NotNull
    public static String toHtmlString(@NotNull String text2) {
        if (!StringUtil.isEmpty((String)text2) && !text2.startsWith("<html>")) {
            text2 = text2.trim().replaceAll("\n", "<br>");
            return String.format("<html>%1$s</html>", text2);
        }
        return text2;
    }

    @NotNull
    public static JBScrollPane wrapWithVScroll(@NotNull JPanel innerPanel) {
        return WizardUtils.wrapWithVScroll(innerPanel, WIZARD_BORDER.LARGE);
    }

    @NotNull
    public static JBScrollPane wrapWithVScroll(@NotNull JPanel innerPanel, WIZARD_BORDER wizardBorder) {
        JBScrollPane sp = new JBScrollPane((Component)innerPanel, 20, 31);
        sp.setBorder(WIZARD_BORDER.EMPTY.border);
        innerPanel.setBorder(wizardBorder.border);
        return sp;
    }

    public static enum WIZARD_BORDER {
        EMPTY((Border)JBUI.Borders.empty()),
        SMALL(JBUI.Borders.empty((int)16)),
        LARGE((Border)JBUI.Borders.empty((int)0, (int)72));

        public final Border border;

        private WIZARD_BORDER(Border border) {
            this.border = border;
        }
    }
}

