/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.model;

import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.expressions.bool.BooleanExpressions;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogEarthquakeShaker;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelWizardDialog
extends DialogWrapper
implements ModelWizard.WizardListener {
    private CancellationPolicy myCancellationPolicy = CancellationPolicy.ALWAYS_CAN_CANCEL;
    @NotNull
    private ModelWizard myActiveWizard;
    private final BindingsManager myDialogBindings = new BindingsManager();
    private final BindingsManager myActiveWizardBindings = new BindingsManager();
    private final ListenerManager myListeners = new ListenerManager();
    private final BoolProperty myCanGoBack = new BoolValueProperty();
    private final BoolProperty myCanGoForward = new BoolValueProperty();
    private final BoolProperty myOnFirstStep = new BoolValueProperty();
    private final BoolProperty myOnLastStep = new BoolValueProperty();
    private final OptionalProperty<Action> myExtraAction = new OptionalValueProperty<Action>();
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    @Nullable
    private CustomLayout myCustomLayout;
    @Nullable
    private URL myHelpUrl;

    @NotNull
    protected Action[] createLeftSideActions() {
        return new Action[]{new StepActionWrapper()};
    }

    public ModelWizardDialog(@NotNull ModelWizard wizard2, @NotNull String title2, @Nullable CustomLayout customLayout, @Nullable Project project, @Nullable URL helpUrl, @NotNull DialogWrapper.IdeModalityType modalityType, @NotNull CancellationPolicy cancellationPolicy, boolean undecorated) {
        super(project, true, modalityType);
        this.init(wizard2, title2, customLayout, helpUrl, cancellationPolicy, undecorated);
    }

    public ModelWizardDialog(@NotNull ModelWizard wizard2, @NotNull String title2, @NotNull Component parent, @Nullable CustomLayout customLayout, @Nullable URL helpUrl, @NotNull CancellationPolicy cancellationPolicy, boolean undecorated) {
        super(parent, true);
        this.init(wizard2, title2, customLayout, helpUrl, cancellationPolicy, undecorated);
    }

    private void init(@NotNull ModelWizard wizard2, @NotNull String title2, @Nullable CustomLayout customLayout, @Nullable URL helpUrl, @NotNull CancellationPolicy cancellationPolicy, boolean undecorated) {
        this.myCustomLayout = customLayout;
        this.myHelpUrl = helpUrl;
        this.myCancellationPolicy = cancellationPolicy;
        this.setTitle(title2);
        this.setModelWizard(wizard2);
        this.setUndecorated(undecorated);
        this.init();
        if (customLayout != null) {
            Disposer.register((Disposable)wizard2, (Disposable)customLayout);
        }
    }

    private void clearActiveWizard() {
        if (this.myActiveWizard != null) {
            this.myActiveWizardBindings.releaseAll();
            this.myActiveWizard.removeResultListener(this);
            Disposer.dispose((Disposable)this.myActiveWizard);
        }
    }

    public void setModelWizard(@NotNull ModelWizard wizard2) {
        this.clearActiveWizard();
        this.myActiveWizard = wizard2;
        this.myActiveWizard.addResultListener(this);
        this.myActiveWizardBindings.bind(this.myCanGoBack, this.myActiveWizard.canGoBack());
        this.myActiveWizardBindings.bind(this.myCanGoForward, this.myActiveWizard.canGoForward());
        this.myActiveWizardBindings.bind(this.myOnFirstStep, this.myActiveWizard.onFirstStep());
        this.myActiveWizardBindings.bind(this.myOnLastStep, this.myActiveWizard.onLastStep());
        this.myActiveWizardBindings.bind(this.myExtraAction, this.myActiveWizard.getExtraAction());
        this.mainPanel.removeAll();
        this.mainPanel.add((Component)this.myActiveWizard.getContentPanel(), "Center");
    }

    protected void dispose() {
        super.dispose();
        this.myDialogBindings.releaseAll();
        this.myListeners.releaseAll();
        this.clearActiveWizard();
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        return DialogWrapper.DialogStyle.COMPACT;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.myCustomLayout == null ? this.mainPanel : this.myCustomLayout.decorate(this.myActiveWizard.getTitleHeader(), this.mainPanel);
    }

    protected void doHelpAction() {
        if (this.getHelpAction().isEnabled()) {
            assert (this.myHelpUrl != null);
            BrowserUtil.browse((URL)this.myHelpUrl);
        }
    }

    public void doCancelAction() {
        this.myActiveWizard.cancel();
    }

    public void doOKAction() {
    }

    @Override
    public void onWizardFinished(@NotNull ModelWizard.WizardResult result2) {
        if (result2.isFinished()) {
            super.doOKAction();
        } else {
            super.doCancelAction();
        }
    }

    @Override
    public void onWizardAdvanceError(@NotNull Exception e) {
        DialogEarthquakeShaker.shake((Window)this.getWindow());
    }

    @NotNull
    protected Action[] createActions() {
        NextAction nextAction2 = new NextAction();
        PreviousAction prevAction2 = new PreviousAction();
        FinishAction finishAction = new FinishAction();
        CancelAction cancelAction = new CancelAction(this.myCancellationPolicy);
        this.getHelpAction().setEnabled(this.myHelpUrl != null);
        if (this.myHelpUrl == null) {
            if (SystemInfo.isMac) {
                return new Action[]{cancelAction, prevAction2, nextAction2, finishAction};
            }
            return new Action[]{prevAction2, nextAction2, cancelAction, finishAction};
        }
        if (SystemInfo.isMac) {
            return new Action[]{this.getHelpAction(), cancelAction, prevAction2, nextAction2, finishAction};
        }
        return new Action[]{prevAction2, nextAction2, cancelAction, finishAction, this.getHelpAction()};
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myActiveWizard.getPreferredFocusComponent();
    }

    protected JButton createJButtonForAction(Action action2) {
        JButton button = super.createJButtonForAction(action2);
        if (action2 instanceof ModelWizardDialogAction) {
            ModelWizardDialogAction wizardAction2 = (ModelWizardDialogAction)((Object)action2);
            this.myDialogBindings.bind(new EnabledProperty(button), wizardAction2.shouldBeEnabled());
            this.myDialogBindings.bind(new VisibleProperty(button), wizardAction2.shouldBeVisible());
            this.myListeners.listenAndFire(wizardAction2.shouldBeDefault(), isDefault -> {
                JRootPane rootPane = this.getRootPane();
                if (rootPane != null && isDefault.booleanValue()) {
                    rootPane.setDefaultButton(button);
                }
            });
        }
        return button;
    }

    private final class StepActionWrapper
    extends ModelWizardDialogAction {
        private final BoolValueProperty myEnabled;
        private PropertyChangeListener myActionListener;

        @Override
        @NotNull
        public ObservableBool shouldBeVisible() {
            return ModelWizardDialog.this.myExtraAction.isPresent();
        }

        private StepActionWrapper() {
            super("");
            this.myEnabled = new BoolValueProperty(false);
            InvalidationListener extraActionChangedListener = new InvalidationListener(){
                Action myActiveAction = null;

                @Override
                public void onInvalidated() {
                    if (this.myActiveAction != null && StepActionWrapper.this.myActionListener != null) {
                        this.myActiveAction.removePropertyChangeListener(StepActionWrapper.this.myActionListener);
                    }
                    this.myActiveAction = ModelWizardDialog.this.myExtraAction.getValueOrNull();
                    if (this.myActiveAction != null) {
                        StepActionWrapper.this.putValue("Name", this.myActiveAction.getValue("Name"));
                        StepActionWrapper.this.myActionListener = evt -> {
                            if ("enabled".equals(evt.getPropertyName())) {
                                StepActionWrapper.this.myEnabled.set((Boolean)evt.getNewValue());
                            }
                        };
                        this.myActiveAction.addPropertyChangeListener(StepActionWrapper.this.myActionListener);
                        StepActionWrapper.this.myEnabled.set(this.myActiveAction.isEnabled());
                    } else {
                        StepActionWrapper.this.myActionListener = null;
                    }
                }
            };
            ModelWizardDialog.this.myExtraAction.addListener(extraActionChangedListener);
            extraActionChangedListener.onInvalidated();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            return this.myEnabled;
        }

        protected void doAction(ActionEvent e) {
            assert (((Optional)ModelWizardDialog.this.myExtraAction.get()).isPresent());
            ModelWizardDialog.this.myExtraAction.getValue().actionPerformed(e);
        }
    }

    public static enum CancellationPolicy {
        ALWAYS_CAN_CANCEL,
        CAN_CANCEL_UNTIL_CAN_FINISH;

    }

    public static interface CustomLayout
    extends Disposable {
        @NotNull
        public JPanel decorate(@NotNull ModelWizard.TitleHeader var1, @NotNull JPanel var2);

        public Dimension getDefaultPreferredSize();

        public Dimension getDefaultMinSize();
    }

    private final class NextAction
    extends ModelWizardDialogAction {
        NextAction() {
            super(IdeBundle.message((String)"button.wizard.next", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            ModelWizardDialog.this.myActiveWizard.goForward();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            return ModelWizardDialog.this.myCanGoForward.and(BooleanExpressions.not(ModelWizardDialog.this.myOnLastStep));
        }

        @Override
        @NotNull
        public ObservableBool shouldBeDefault() {
            return BooleanExpressions.not(ModelWizardDialog.this.myOnLastStep);
        }

        @Override
        @NotNull
        public ObservableBool shouldBeVisible() {
            return BooleanExpressions.not(ModelWizardDialog.this.myOnFirstStep.and(ModelWizardDialog.this.myOnLastStep));
        }
    }

    private final class PreviousAction
    extends ModelWizardDialogAction {
        PreviousAction() {
            super(IdeBundle.message((String)"button.wizard.previous", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            ModelWizardDialog.this.myActiveWizard.goBack();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            return ModelWizardDialog.this.myCanGoBack;
        }

        @Override
        @NotNull
        public ObservableBool shouldBeVisible() {
            return BooleanExpressions.not(ModelWizardDialog.this.myOnFirstStep.and(ModelWizardDialog.this.myOnLastStep));
        }
    }

    private final class FinishAction
    extends ModelWizardDialogAction {
        FinishAction() {
            super(IdeBundle.message((String)"button.finish", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            ModelWizardDialog.this.myActiveWizard.goForward();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            return ModelWizardDialog.this.myOnLastStep.and(ModelWizardDialog.this.myCanGoForward);
        }

        @Override
        @NotNull
        public ObservableBool shouldBeDefault() {
            return ModelWizardDialog.this.myOnLastStep;
        }
    }

    private final class CancelAction
    extends ModelWizardDialogAction {
        private final CancellationPolicy myCancellationPolicy;

        private CancelAction(CancellationPolicy cancellationPolicy) {
            super(IdeBundle.message((String)"button.cancel", (Object[])new Object[0]));
            this.myCancellationPolicy = cancellationPolicy;
        }

        protected void doAction(ActionEvent e) {
            ModelWizardDialog.this.doCancelAction();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            switch (this.myCancellationPolicy) {
                case CAN_CANCEL_UNTIL_CAN_FINISH: {
                    return BooleanExpressions.not(ModelWizardDialog.this.myOnLastStep.and(ModelWizardDialog.this.myCanGoForward));
                }
            }
            return ObservableBool.TRUE;
        }
    }

    private abstract class ModelWizardDialogAction
    extends DialogWrapper.DialogWrapperAction {
        private ModelWizardDialogAction(String name2) {
            super((DialogWrapper)ModelWizardDialog.this, name2);
        }

        @NotNull
        public abstract ObservableBool shouldBeEnabled();

        @NotNull
        public ObservableBool shouldBeVisible() {
            return ObservableBool.TRUE;
        }

        @NotNull
        public ObservableBool shouldBeDefault() {
            return ObservableBool.FALSE;
        }
    }
}

