/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard.deprecated;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.SdkComponentInstaller;
import com.android.tools.idea.welcome.wizard.FirstRunWizardTracker;
import com.android.tools.idea.welcome.wizard.deprecated.CancelableWelcomeWizard;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizard;
import com.android.tools.idea.welcome.wizard.deprecated.WelcomeScreenWindowListener;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Atomics;
import com.google.wireless.android.sdk.stats.SetupWizardEvent;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class FirstRunWizardHost
extends JPanel
implements WelcomeScreen,
DynamicWizardHost,
CancelableWelcomeWizard {
    private static final Insets BUTTON_MARGINS = new Insets(2, 16, 2, 16);
    @NotNull
    private final FirstRunWizardMode myMode;
    @NotNull
    private final SdkComponentInstaller mySdkComponentInstaller;
    @NotNull
    private final FirstRunWizardTracker myTracker;
    private Action myCancelAction = new CancelAction();
    private Action myPreviousAction = new PreviousAction();
    private Action myNextAction = new NextAction();
    private FinishAction myFinishAction = new FinishAction();
    private FirstRunWizard myWizard;
    private JFrame myFrame;
    private Dimension myFrameSize;
    private String myFrameTitle;
    private String myTitle;
    private Dimension myPreferredWindowSize = JBUI.size((int)800, (int)600);
    private final Dimension myMinimumWindowSize = JBUI.size((int)500, (int)350);
    private Map<Action, JButton> myActionToButtonMap = Maps.newHashMap();
    private AtomicReference<ProgressIndicator> myCurrentProgressIndicator = Atomics.newReference();
    private boolean myIsActive;

    public FirstRunWizardHost(@NotNull FirstRunWizardMode mode, @NotNull SdkComponentInstaller sdkComponentInstaller, @NotNull FirstRunWizardTracker tracker) {
        super(new BorderLayout());
        this.myMode = mode;
        this.mySdkComponentInstaller = sdkComponentInstaller;
        this.myTracker = tracker;
        this.add((Component)this.createSouthPanel(), "South");
    }

    private static void setMargin(JButton button) {
        if (!SystemInfo.isMac && BUTTON_MARGINS != null) {
            button.setMargin(BUTTON_MARGINS);
        }
    }

    public JComponent getWelcomePanel() {
        this.myTracker.trackWizardStarted();
        if (this.myWizard == null) {
            this.setupWizard();
        }
        assert (this.myWizard != null);
        return this;
    }

    private void setupWizard() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            FirstRunWizard wizard2 = new FirstRunWizard(this, this.myMode, this.mySdkComponentInstaller, this.myTracker);
            ((DynamicWizard)wizard2).init();
            this.add(wizard2.getContentPane(), "Center");
        }, ModalityState.any());
    }

    public void setupFrame(JFrame frame) {
        this.myFrame = frame;
        this.myFrameSize = frame.getSize();
        this.myFrameTitle = frame.getTitle();
        if (this.myTitle != null) {
            frame.setTitle(this.myTitle);
        }
        frame.setSize(this.myPreferredWindowSize);
        frame.setMinimumSize(this.myMinimumWindowSize);
        frame.setLocationRelativeTo(null);
        JButton defaultButton = this.myActionToButtonMap.get(this.myFinishAction);
        if (!defaultButton.isEnabled()) {
            defaultButton = this.myActionToButtonMap.get(this.myNextAction);
        }
        this.setDefaultButton(defaultButton);
        this.myIsActive = true;
        WelcomeScreenWindowListener.install(frame, this);
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public Disposable getDisposable() {
        return this;
    }

    @Override
    public void init(@NotNull DynamicWizard wizard2) {
        this.myWizard = (FirstRunWizard)wizard2;
    }

    @Override
    public boolean showAndGet() {
        return false;
    }

    @Override
    public void close(@NotNull DynamicWizardHost.CloseAction action2) {
        this.myIsActive = false;
        if (this.myFrame != null) {
            this.myFrame.setVisible(false);
            this.myFrame.dispose();
        }
        this.myTracker.trackWizardFinished(action2 == DynamicWizardHost.CloseAction.FINISH ? SetupWizardEvent.CompletionStatus.FINISHED : SetupWizardEvent.CompletionStatus.CANCELED);
        if (action2 == DynamicWizardHost.CloseAction.FINISH || action2 == DynamicWizardHost.CloseAction.CANCEL) {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                LafManager.getInstance().updateUI();
                WelcomeFrame.showNow();
            }
        } else if (action2 == DynamicWizardHost.CloseAction.EXIT) {
            ApplicationManager.getApplication().exit();
        }
    }

    @Override
    public void shakeWindow() {
    }

    @Override
    public void updateButtons(boolean canGoPrev, boolean canGoNext, boolean canCancel, boolean canFinish) {
        this.setButtonEnabled(this.myCancelAction, canCancel);
        this.setButtonEnabled(this.myPreviousAction, canGoPrev);
        this.setButtonEnabled(this.myNextAction, canGoNext);
        this.setButtonEnabled(this.myFinishAction, canFinish);
        if (this.myFrame != null) {
            this.setDefaultButton(this.myActionToButtonMap.get(canFinish ? this.myFinishAction : this.myNextAction));
        }
    }

    private void setButtonEnabled(Action action2, boolean enabled) {
        JButton button = this.myActionToButtonMap.get(action2);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    @Override
    public void setTitle(String title2) {
        this.myTitle = title2;
        if (this.myFrame != null) {
            this.myFrame.setTitle(title2);
        }
    }

    @Override
    public void setIcon(@Nullable Icon icon) {
    }

    @Override
    public void runSensitiveOperation(@NotNull ProgressIndicator progressIndicator, boolean cancellable, @NotNull Runnable operation) {
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (!this.myCurrentProgressIndicator.compareAndSet(null, progressIndicator)) {
            throw new IllegalStateException("Submitting an operation while another is in progress.");
        }
        JButton defaultButton = null;
        if (this.myFrame != null) {
            JRootPane rootPane = this.myFrame.getRootPane();
            defaultButton = rootPane.getDefaultButton();
            rootPane.setDefaultButton(null);
        }
        this.updateButtons(false, false, true, false);
        LongRunningOperationWrapper task2 = new LongRunningOperationWrapper(operation, cancellable, defaultButton);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task2, progressIndicator);
    }

    @NotNull
    private JComponent createSouthPanel() {
        JBInsets insets;
        Action[] actions2 = this.createActions();
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel lrButtonsPanel = new JPanel(new GridBagLayout());
        JBInsets jBInsets = insets = SystemInfo.isMac ? JBInsets.emptyInsets() : JBUI.insetsTop((int)8);
        if (actions2.length > 0) {
            int gridX = 0;
            lrButtonsPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridX++, 0, 1, 1, 1.0, 0.0, 10, 2, (Insets)insets, 0, 0));
            if (actions2.length > 0) {
                JPanel buttonsPanel = this.createButtons(actions2, buttons);
                lrButtonsPanel.add((Component)buttonsPanel, new GridBagConstraints(gridX, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)insets, 0, 0));
            }
        }
        panel2.add((Component)lrButtonsPanel, "Center");
        panel2.setBorder(IdeBorderFactory.createEmptyBorder((Insets)WizardConstants.STUDIO_WIZARD_INSETS));
        return panel2;
    }

    private Action[] createActions() {
        if (SystemInfo.isMac) {
            return new Action[]{this.myCancelAction, this.myPreviousAction, this.myNextAction, this.myFinishAction};
        }
        return new Action[]{this.myPreviousAction, this.myNextAction, this.myCancelAction, this.myFinishAction};
    }

    @NotNull
    private JPanel createButtons(@NotNull Action[] actions2, @NotNull List<JButton> buttons) {
        if (!UISettings.getShadowInstance().getAllowMergeButtons()) {
            ArrayList<Action> actionList = new ArrayList<Action>();
            for (Action action2 : actions2) {
                actionList.add(action2);
                if (!(action2 instanceof OptionAction)) continue;
                Action[] options = ((OptionAction)action2).getOptions();
                actionList.addAll(Arrays.asList(options));
            }
            if (actionList.size() != actions2.length) {
                actions2 = actionList.toArray(new Action[0]);
            }
        }
        JPanel buttonsPanel = new JPanel(new GridLayout(1, actions2.length, SystemInfo.isMac ? 0 : 5, 0));
        for (Action action2 : actions2) {
            JButton button = this.createJButtonForAction(action2);
            Object value2 = action2.getValue("MnemonicKey");
            if (value2 instanceof Integer) {
                int mnemonic = (Integer)value2;
                button.setMnemonic(mnemonic);
            }
            buttons.add(button);
            buttonsPanel.add(button);
        }
        return buttonsPanel;
    }

    protected JButton createJButtonForAction(Action action2) {
        JButton button = new JButton(action2);
        String text2 = button.getText();
        if (SystemInfo.isMac) {
            button.putClientProperty("JButton.buttonType", "text");
        }
        if (text2 != null) {
            int mnemonic = 0;
            StringBuilder plainText = new StringBuilder();
            for (int i = 0; i < text2.length(); ++i) {
                int ch = text2.charAt(i);
                if (ch == 95 || ch == 38) {
                    if (i >= text2.length()) break;
                    ch = text2.charAt(i);
                    if (ch != 95 && ch != 38) {
                        int vk = ch;
                        if (vk >= 97 && vk <= 122) {
                            vk -= 32;
                        }
                        mnemonic = vk;
                    }
                }
                plainText.append((char)ch);
            }
            button.setText(plainText.toString());
            button.setMnemonic(mnemonic);
            FirstRunWizardHost.setMargin(button);
        }
        this.myActionToButtonMap.put(action2, button);
        return button;
    }

    @Override
    public void setPreferredWindowSize(Dimension preferredWindowSize) {
        this.myPreferredWindowSize = preferredWindowSize;
        if (this.myFrame != null) {
            this.myFrame.setSize(preferredWindowSize);
        }
    }

    private void setDefaultButton(@Nullable JButton button) {
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            rootPane.setDefaultButton(button);
        }
    }

    @Override
    @UiThread
    public boolean isActive() {
        return this.myIsActive;
    }

    @Override
    @UiThread
    public void cancel() {
        ProgressIndicator indicator = this.myCurrentProgressIndicator.get();
        if (indicator == null) {
            this.myWizard.doCancelAction();
        } else {
            indicator.cancel();
            JButton button = this.myActionToButtonMap.get(this.myCancelAction);
            if (button != null) {
                button.setEnabled(false);
            }
        }
    }

    protected class CancelAction
    extends AbstractAction {
        protected CancelAction() {
            this.putValue("Name", IdeBundle.message((String)"button.cancel", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FirstRunWizardHost.this.cancel();
        }
    }

    protected class PreviousAction
    extends AbstractAction {
        protected PreviousAction() {
            this.putValue("Name", IdeBundle.message((String)"button.wizard.previous", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FirstRunWizardHost.this.myWizard.doPreviousAction();
        }
    }

    protected class NextAction
    extends AbstractAction {
        protected NextAction() {
            this.putValue("Name", IdeBundle.message((String)"button.wizard.next", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FirstRunWizardHost.this.myWizard.doNextAction();
        }
    }

    protected class FinishAction
    extends AbstractAction {
        protected FinishAction() {
            this.putValue("Name", IdeBundle.message((String)"button.finish", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FirstRunWizardHost.this.myWizard.doFinishAction();
        }
    }

    private class LongRunningOperationWrapper
    extends Task.Backgroundable {
        private final Runnable myOperation;
        @Nullable
        private final JButton myDefaultButton;

        public LongRunningOperationWrapper(Runnable operation, @Nullable boolean cancellable, JButton defaultButton) {
            super(null, FirstRunWizardHost.this.myWizard.getWizardActionDescription(), cancellable);
            this.myOperation = operation;
            this.myDefaultButton = defaultButton;
        }

        public void onSuccess() {
            FirstRunWizardHost.this.myCurrentProgressIndicator.set(null);
            FirstRunWizardHost.this.updateButtons(false, false, false, true);
            if (FirstRunWizardHost.this.myFrame != null && this.myDefaultButton != null) {
                FirstRunWizardHost.this.myFrame.getRootPane().setDefaultButton(this.myDefaultButton);
            }
        }

        public void run(@NotNull ProgressIndicator indicator) {
            this.myOperation.run();
        }

        public void onCancel() {
            this.onSuccess();
        }
    }
}

