/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.idea.welcome.install.SdkComponentTreeNode;
import com.android.tools.idea.welcome.wizard.SdkComponentsTableModel;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class SdkComponentsRenderer
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    private final RendererPanel myPanel;
    private final RendererCheckBox myCheckBox;
    private Border myEmptyBorder;
    private final SdkComponentsTableModel myTableModel;
    private final JBTable myComponentsTable;

    public SdkComponentsRenderer(SdkComponentsTableModel tableModel2, JBTable componentsTable) {
        this.myTableModel = tableModel2;
        this.myComponentsTable = componentsTable;
        this.myPanel = new RendererPanel();
        this.myCheckBox = new RendererCheckBox();
        this.myCheckBox.setOpaque(false);
        this.myCheckBox.addActionListener(e -> {
            if (this.myComponentsTable.isEditing()) {
                this.stopCellEditing();
            } else {
                this.myTableModel.setValueAt(this.myCheckBox.isSelected(), this.myCheckBox.getRow(), 0);
            }
            this.onCheckboxUpdated();
        });
    }

    public abstract void onCheckboxUpdated();

    @Override
    public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column2) {
        this.setupControl(table2, value2, row, isSelected, hasFocus);
        return this.myPanel;
    }

    private void setupControl(JTable table2, Object value2, int row, boolean isSelected, boolean hasFocus) {
        Color foreground;
        Color background;
        this.myCheckBox.setRow(row);
        this.myPanel.setBorder(this.getCellBorder(table2, isSelected && hasFocus));
        if (isSelected) {
            background = table2.getSelectionBackground();
            foreground = table2.getSelectionForeground();
        } else {
            background = table2.getBackground();
            foreground = table2.getForeground();
        }
        this.myPanel.setBackground(background);
        this.myCheckBox.setForeground(foreground);
        this.myPanel.remove(this.myCheckBox);
        Pair pair = (Pair)value2;
        int indent = 0;
        if (pair != null) {
            SdkComponentTreeNode node = (SdkComponentTreeNode)pair.getFirst();
            this.myCheckBox.setEnabled(node.isEnabled());
            this.myCheckBox.setText(node.getLabel());
            this.myCheckBox.setSelected(node.isChecked());
            indent = (Integer)pair.getSecond();
        }
        this.myPanel.add((Component)this.myCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, indent * 2));
    }

    private Border getCellBorder(JTable table2, boolean isSelectedFocus) {
        Border border;
        Border focusedBorder = UIUtil.getTableFocusCellHighlightBorder();
        if (isSelectedFocus) {
            border = focusedBorder;
        } else {
            if (this.myEmptyBorder == null) {
                this.myEmptyBorder = new EmptyBorder(focusedBorder.getBorderInsets(table2));
            }
            border = this.myEmptyBorder;
        }
        return border;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row, int column2) {
        this.setupControl(table2, value2, row, true, true);
        return this.myPanel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.myCheckBox.isSelected();
    }

    protected class RendererPanel
    extends JPanel {
        public RendererPanel() {
            super((LayoutManager)new GridLayoutManager(1, 1));
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (SdkComponentsRenderer.this.myComponentsTable.isEditing()) {
                SdkComponentsRenderer.this.myCheckBox._processKeyEvent(e);
            } else {
                super.processKeyEvent(e);
            }
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (SdkComponentsRenderer.this.myComponentsTable.isEditing()) {
                return SdkComponentsRenderer.this.myCheckBox._processKeyBinding(ks, e, condition, pressed);
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleRendererPanel();
            }
            return this.accessibleContext;
        }

        protected class AccessibleRendererPanel
        extends AccessibleContextDelegate {
            public AccessibleRendererPanel() {
                super(SdkComponentsRenderer.this.myCheckBox.getAccessibleContext());
            }

            protected Container getDelegateParent() {
                return RendererPanel.this.getParent();
            }

            public String getAccessibleDescription() {
                return SdkComponentsRenderer.this.myTableModel.getComponentDescription(SdkComponentsRenderer.this.myCheckBox.getRow());
            }

            public Accessible getAccessibleParent() {
                return (Accessible)((Object)RendererPanel.this.getParent());
            }
        }
    }

    protected class RendererCheckBox
    extends JCheckBox {
        private int myRow;

        protected RendererCheckBox() {
        }

        public int getRow() {
            return this.myRow;
        }

        public void setRow(int row) {
            this.myRow = row;
        }

        public boolean _processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }

        public void _processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        @Override
        public void requestFocus() {
            if (SdkComponentsRenderer.this.myComponentsTable.isEditing()) {
                return;
            }
            super.requestFocus();
        }
    }
}

