/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.SettingsController;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.HardwareAccelerationCheck;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.AehdSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.AndroidPlatformSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.AndroidSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.AndroidVirtualDeviceSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.SdkComponentCategoryTreeNode;
import com.android.tools.idea.welcome.install.SdkComponentInstaller;
import com.android.tools.idea.welcome.install.SdkComponentTreeNode;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.FirstRunWizardTracker;
import com.android.tools.idea.welcome.wizard.InstallComponentsProgressStep;
import com.android.tools.idea.welcome.wizard.StudioFirstRunWelcomeScreen;
import com.android.tools.idea.welcome.wizard.deprecated.InstallComponentsPath;
import com.android.tools.idea.wizard.model.WizardModel;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.UtilKt;
import java.awt.Component;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001:B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010-\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u000200\u0018\u00010/0.J\u0018\u00101\u001a\u00020*2\u0006\u00102\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u000206J\b\u00107\u001a\u000208H\u0002J\b\u00109\u001a\u000204H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0019\u0010\u001d\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001d\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050#0\"\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010&\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006;"}, d2={"Lcom/android/tools/idea/welcome/wizard/FirstRunWizardModel;", "Lcom/android/tools/idea/wizard/model/WizardModel;", "mode", "Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;", "initialSdkLocation", "Ljava/nio/file/Path;", "installUpdates", "", "sdkComponentInstaller", "Lcom/android/tools/idea/welcome/install/SdkComponentInstaller;", "tracker", "Lcom/android/tools/idea/welcome/wizard/FirstRunWizardTracker;", "<init>", "(Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;Ljava/nio/file/Path;ZLcom/android/tools/idea/welcome/install/SdkComponentInstaller;Lcom/android/tools/idea/welcome/wizard/FirstRunWizardTracker;)V", "isStandardInstallSupported", "()Z", "installationType", "Lcom/android/tools/idea/welcome/wizard/FirstRunWizardModel$InstallationType;", "getInstallationType", "()Lcom/android/tools/idea/welcome/wizard/FirstRunWizardModel$InstallationType;", "setInstallationType", "(Lcom/android/tools/idea/welcome/wizard/FirstRunWizardModel$InstallationType;)V", "initialSdkExists", "getInitialSdkExists", "localHandlerProperty", "Lcom/android/tools/idea/observable/core/ObjectValueProperty;", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "getLocalHandlerProperty", "()Lcom/android/tools/idea/observable/core/ObjectValueProperty;", "localHandler", "Lorg/jetbrains/annotations/NotNull;", "getLocalHandler", "()Lcom/android/sdklib/repository/AndroidSdkHandler;", "sdkInstallLocationProperty", "Lcom/android/tools/idea/observable/ObservableValue;", "Ljava/util/Optional;", "getSdkInstallLocationProperty", "()Lcom/android/tools/idea/observable/ObservableValue;", "sdkInstallLocation", "getSdkInstallLocation", "()Ljava/nio/file/Path;", "componentTree", "Lcom/android/tools/idea/welcome/install/SdkComponentTreeNode;", "getComponentTree", "()Lcom/android/tools/idea/welcome/install/SdkComponentTreeNode;", "getPackagesToInstallSupplier", "Ljava/util/function/Supplier;", "", "Lcom/android/repository/api/RemotePackage;", "createComponentTree", "createAvd", "installComponents", "", "progressStep", "Lcom/android/tools/idea/welcome/wizard/InstallComponentsProgressStep;", "getDestination", "Ljava/io/File;", "handleFinished", "InstallationType", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nFirstRunWizardModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirstRunWizardModel.kt\ncom/android/tools/idea/welcome/wizard/FirstRunWizardModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,189:1\n1557#2:190\n1628#2,3:191\n15#3:194\n*S KotlinDebug\n*F\n+ 1 FirstRunWizardModel.kt\ncom/android/tools/idea/welcome/wizard/FirstRunWizardModel\n*L\n163#1:190\n163#1:191,3\n105#1:194\n*E\n"})
public final class FirstRunWizardModel
extends WizardModel {
    @NotNull
    private final FirstRunWizardMode mode;
    @NotNull
    private final SdkComponentInstaller sdkComponentInstaller;
    @NotNull
    private final FirstRunWizardTracker tracker;
    private final boolean isStandardInstallSupported;
    @Nullable
    private InstallationType installationType;
    private final boolean initialSdkExists;
    @NotNull
    private final ObjectValueProperty<AndroidSdkHandler> localHandlerProperty;
    @NotNull
    private final ObservableValue<Optional<Path>> sdkInstallLocationProperty;
    @NotNull
    private final SdkComponentTreeNode componentTree;

    public FirstRunWizardModel(@NotNull FirstRunWizardMode mode, @NotNull Path initialSdkLocation, boolean installUpdates, @NotNull SdkComponentInstaller sdkComponentInstaller, @NotNull FirstRunWizardTracker tracker) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)initialSdkLocation, (String)"initialSdkLocation");
        Intrinsics.checkNotNullParameter((Object)sdkComponentInstaller, (String)"sdkComponentInstaller");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        this.mode = mode;
        this.sdkComponentInstaller = sdkComponentInstaller;
        this.tracker = tracker;
        this.isStandardInstallSupported = ((CharSequence)((Object)initialSdkLocation).toString()).length() > 0;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(initialSdkLocation, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            AndroidSdkHandler sdkHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE), (Path)initialSdkLocation);
            StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(this.getClass());
            Map map2 = sdkHandler.getRepoManagerAndLoadSynchronously((ProgressIndicator)progress2).getPackages().getLocalPackages();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getLocalPackages(...)");
            bl = !map2.isEmpty();
        } else {
            bl = false;
        }
        this.initialSdkExists = bl;
        this.localHandlerProperty = new ObjectValueProperty<AndroidSdkHandler>(AndroidSdkHandler.getInstance((AndroidLocationsProvider)((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE), (Path)initialSdkLocation));
        Expression<Optional> expression = this.localHandlerProperty.transform(FirstRunWizardModel::sdkInstallLocationProperty$lambda$0);
        Intrinsics.checkNotNullExpressionValue(expression, (String)"transform(...)");
        this.sdkInstallLocationProperty = expression;
        this.componentTree = this.createComponentTree(!HardwareAccelerationCheck.isChromeOSAndIsNotHWAccelerated() && this.mode.shouldCreateAvd(), installUpdates);
        this.componentTree.updateState(this.getLocalHandler());
    }

    public final boolean isStandardInstallSupported() {
        return this.isStandardInstallSupported;
    }

    @Nullable
    public final InstallationType getInstallationType() {
        return this.installationType;
    }

    public final void setInstallationType(@Nullable InstallationType installationType) {
        this.installationType = installationType;
    }

    public final boolean getInitialSdkExists() {
        return this.initialSdkExists;
    }

    @NotNull
    public final ObjectValueProperty<AndroidSdkHandler> getLocalHandlerProperty() {
        return this.localHandlerProperty;
    }

    private final AndroidSdkHandler getLocalHandler() {
        AndroidSdkHandler androidSdkHandler = this.localHandlerProperty.get();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"get(...)");
        return androidSdkHandler;
    }

    @NotNull
    public final ObservableValue<Optional<Path>> getSdkInstallLocationProperty() {
        return this.sdkInstallLocationProperty;
    }

    @Nullable
    public final Path getSdkInstallLocation() {
        Optional<Path> optional = this.sdkInstallLocationProperty.get();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"get(...)");
        return (Path)UtilKt.orNull(optional);
    }

    @NotNull
    public final SdkComponentTreeNode getComponentTree() {
        return this.componentTree;
    }

    @NotNull
    public final Supplier<Collection<RemotePackage>> getPackagesToInstallSupplier() {
        return () -> FirstRunWizardModel.getPackagesToInstallSupplier$lambda$1(this);
    }

    private final SdkComponentTreeNode createComponentTree(boolean createAvd2, boolean installUpdates) {
        AndroidVirtualDeviceSdkComponentTreeNode avdSdkComponent;
        AehdSdkComponentTreeNode.InstallationIntention installationIntention;
        RepoManager repoManager;
        Object[] objectArray = new SdkComponentTreeNode[]{new AndroidSdkComponentTreeNode(installUpdates)};
        List components = CollectionsKt.mutableListOf((Object[])objectArray);
        RepoManager $this$createComponentTree_u24lambda_u242 = repoManager = this.getLocalHandler().getRepoManager((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
        boolean bl = false;
        RepoManager.loadSynchronously$default((RepoManager)$this$createComponentTree_u24lambda_u242, (long)RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, null, null, (ProgressRunner)((ProgressRunner)new StudioProgressRunner(false, "Finding Available SDK Components", null, null, 8, null)), (Downloader)new StudioDownloader(), (SettingsController)StudioSettingsController.getInstance(), (int)14, null);
        RepoManager sdkManager = repoManager;
        Collection remotePackages = sdkManager.getPackages().getRemotePackages().values();
        components.add(AndroidPlatformSdkComponentTreeNode.Companion.createSubtree$default(AndroidPlatformSdkComponentTreeNode.Companion, remotePackages, installUpdates, 0, 4, null));
        AehdSdkComponentTreeNode.InstallationIntention installationIntention2 = installationIntention = installUpdates ? AehdSdkComponentTreeNode.InstallationIntention.INSTALL_WITH_UPDATES : AehdSdkComponentTreeNode.InstallationIntention.INSTALL_WITHOUT_UPDATES;
        if (this.mode == FirstRunWizardMode.NEW_INSTALL && AehdSdkComponentTreeNode.InstallerInfo.canRun()) {
            components.add(new AehdSdkComponentTreeNode(installationIntention));
        }
        if (createAvd2 && (avdSdkComponent = new AndroidVirtualDeviceSdkComponentTreeNode(remotePackages, installUpdates)).isAvdCreationNeeded(this.getLocalHandler())) {
            components.add(avdSdkComponent);
        }
        return new SdkComponentCategoryTreeNode("Root", "Root node that is not supposed to appear in the UI", components);
    }

    /*
     * WARNING - void declaration
     */
    public final void installComponents(@NotNull InstallComponentsProgressStep progressStep2) throws WizardException {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)progressStep2, (String)"progressStep");
        AndroidSdkHandler sdkHandler = this.getLocalHandler();
        Iterable iterable = this.componentTree.getChildrenToInstall();
        FirstRunWizardTracker firstRunWizardTracker = this.tracker;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            InstallableSdkComponentTreeNode installableSdkComponentTreeNode = (InstallableSdkComponentTreeNode)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.sdkComponentsMetricKind());
        }
        firstRunWizardTracker.trackSdkComponentsToInstall((List)destination$iv$iv);
        Collection<InstallableSdkComponentTreeNode> collection3 = this.componentTree.getChildrenToInstall();
        InstallContext installContext = new InstallContext(InstallComponentsPath.createTempDir(), progressStep2);
        String string = this.mode.getInstallerTimestamp();
        ModalityState modalityState = ModalityState.stateForComponent((Component)progressStep2.getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
        this.sdkComponentInstaller.installComponents(collection3, installContext, string, modalityState, sdkHandler, this.getDestination());
    }

    private final File getDestination() throws WizardException {
        Path path = this.getSdkInstallLocation();
        if (path == null) {
            throw new WizardException("SDK install path is null");
        }
        Path destinationPath = path;
        File destination = destinationPath.toFile();
        if (destination.isFile()) {
            throw new WizardException("Path " + destinationPath + " does not point to a directory");
        }
        Intrinsics.checkNotNull((Object)destination);
        return destination;
    }

    @Override
    protected void handleFinished() {
    }

    private static final Optional sdkInstallLocationProperty$lambda$0(AndroidSdkHandler it) {
        return Optional.ofNullable(it.getLocation());
    }

    private static final Collection getPackagesToInstallSupplier$lambda$1(FirstRunWizardModel this$0) {
        List<RemotePackage> list;
        Iterable components = this$0.componentTree.getChildrenToInstall();
        try {
            list = this$0.sdkComponentInstaller.getPackagesToInstall(this$0.getLocalHandler(), components);
        }
        catch (SdkQuickfixUtils.PackageResolutionException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(StudioFirstRunWelcomeScreen.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
            list = null;
        }
        return list;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/welcome/wizard/FirstRunWizardModel$InstallationType;", "", "<init>", "(Ljava/lang/String;I)V", "STANDARD", "CUSTOM", "intellij.android.core"})
    public static final class InstallationType
    extends Enum<InstallationType> {
        public static final /* enum */ InstallationType STANDARD = new InstallationType();
        public static final /* enum */ InstallationType CUSTOM = new InstallationType();
        private static final /* synthetic */ InstallationType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static InstallationType[] values() {
            return (InstallationType[])$VALUES.clone();
        }

        public static InstallationType valueOf(String value2) {
            return Enum.valueOf(InstallationType.class, value2);
        }

        @NotNull
        public static EnumEntries<InstallationType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = installationTypeArray = new InstallationType[]{InstallationType.STANDARD, InstallationType.CUSTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

