/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.util.FormatUtil;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallableSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.SdkComponentInstaller;
import com.android.tools.idea.welcome.install.SdkManagerProgressIndicatorIntegration;
import com.android.tools.idea.welcome.install.WizardException;
import com.intellij.execution.ui.ConsoleViewContentType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/welcome/install/InstallSdkComponentsOperation;", "Lcom/android/tools/idea/welcome/install/InstallOperation;", "Ljava/io/File;", "context", "Lcom/android/tools/idea/welcome/install/InstallContext;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "components", "", "Lcom/android/tools/idea/welcome/install/InstallableSdkComponentTreeNode;", "sdkComponentInstaller", "Lcom/android/tools/idea/welcome/install/SdkComponentInstaller;", "progressRatio", "", "<init>", "(Lcom/android/tools/idea/welcome/install/InstallContext;Lcom/android/sdklib/repository/AndroidSdkHandler;Ljava/util/Collection;Lcom/android/tools/idea/welcome/install/SdkComponentInstaller;D)V", "perform", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "argument", "cleanup", "", "result", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nInstallSdkComponentsOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallSdkComponentsOperation.kt\ncom/android/tools/idea/welcome/install/InstallSdkComponentsOperation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class InstallSdkComponentsOperation
extends InstallOperation<File, File> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidSdkHandler sdkHandler;
    @NotNull
    private final Collection<InstallableSdkComponentTreeNode> components;
    @NotNull
    private final SdkComponentInstaller sdkComponentInstaller;

    public InstallSdkComponentsOperation(@NotNull InstallContext context, @NotNull AndroidSdkHandler sdkHandler, @NotNull Collection<? extends InstallableSdkComponentTreeNode> components, @NotNull SdkComponentInstaller sdkComponentInstaller, double progressRatio) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)sdkComponentInstaller, (String)"sdkComponentInstaller");
        super(context, progressRatio);
        this.sdkHandler = sdkHandler;
        this.components = components;
        this.sdkComponentInstaller = sdkComponentInstaller;
    }

    @Override
    @NotNull
    protected File perform(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator, @NotNull File argument) throws WizardException {
        List<RemotePackage> list;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        indicator.setText("Checking for updated SDK components");
        try {
            list = this.sdkComponentInstaller.getPackagesToInstall(this.sdkHandler, (Iterable<? extends InstallableSdkComponentTreeNode>)this.components);
        }
        catch (SdkQuickfixUtils.PackageResolutionException e) {
            throw new WizardException("Failed to determine required packages", e);
        }
        List<RemotePackage> packages = list;
        while (!((Collection)packages).isEmpty()) {
            String message;
            List<RemotePackage> list2;
            indicator.setFraction(0.0);
            SdkManagerProgressIndicatorIntegration logger = new SdkManagerProgressIndicatorIntegration(indicator, this.getContext());
            this.sdkComponentInstaller.installPackages(this.sdkHandler, packages, new StudioDownloader(), (ProgressIndicator)logger);
            try {
                list2 = this.sdkComponentInstaller.getPackagesToInstall(this.sdkHandler, (Iterable<? extends InstallableSdkComponentTreeNode>)this.components);
            }
            catch (SdkQuickfixUtils.PackageResolutionException e) {
                throw new WizardException("Failed to determine required packages", e);
            }
            packages = list2;
            if (InstallSdkComponentsOperation.Companion.getRetryMessage(packages) == null) continue;
            boolean bl = false;
            String string = logger.getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrors(...)");
            this.promptToRetry(message, string, null);
        }
        this.getContext().print("Android SDK is up to date.\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        indicator.setFraction(1.0);
        return argument;
    }

    @Override
    public void cleanup(@NotNull File result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/welcome/install/InstallSdkComponentsOperation$Companion;", "", "<init>", "()V", "getRetryMessage", "", "packages", "", "Lcom/android/repository/api/RemotePackage;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nInstallSdkComponentsOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallSdkComponentsOperation.kt\ncom/android/tools/idea/welcome/install/InstallSdkComponentsOperation$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1557#2:83\n1628#2,3:84\n*S KotlinDebug\n*F\n+ 1 InstallSdkComponentsOperation.kt\ncom/android/tools/idea/welcome/install/InstallSdkComponentsOperation$Companion\n*L\n74#1:83\n74#1:84,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final String getRetryMessage(Collection<? extends RemotePackage> packages) {
            void $this$mapTo$iv$iv;
            if (packages.isEmpty()) {
                return null;
            }
            Iterable $this$map$iv = packages;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RemotePackage remotePackage = (RemotePackage)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getDisplayName());
            }
            return FormatUtil.formatElementListString((List)destination$iv$iv, "The following SDK component was not installed: %s", "The following SDK components were not installed: %1$s and %2$s", "%1$s and %2$s more SDK components were not installed");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

