/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 $*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0003\"#$B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0012J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u000e\u0010\u0018\u001a\n\u0018\u00010\u0019j\u0004\u0018\u0001`\u001aH\u0004J\u0015\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001dJ,\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u00028\u00010\u0000\"\u0004\b\u0002\u0010\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u00028\u00000\u0000J,\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u00028\u00010\u0000\"\u0004\b\u0002\u0010\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u001f0!R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/welcome/install/InstallOperation;", "Return", "Argument", "", "context", "Lcom/android/tools/idea/welcome/install/InstallContext;", "progressRatio", "", "<init>", "(Lcom/android/tools/idea/welcome/install/InstallContext;D)V", "getContext", "()Lcom/android/tools/idea/welcome/install/InstallContext;", "perform", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "argument", "(Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/lang/Object;)Ljava/lang/Object;", "execute", "(Ljava/lang/Object;)Ljava/lang/Object;", "promptToRetry", "", "prompt", "", "failureDescription", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "cleanup", "result", "(Ljava/lang/Object;)V", "then", "FinalResult", "next", "Lcom/google/common/base/Function;", "OperationChain", "FunctionWrapper", "Companion", "intellij.android.core"})
public abstract class InstallOperation<Return, Argument> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InstallContext context;
    private final double progressRatio;

    public InstallOperation(@NotNull InstallContext context, double progressRatio) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.progressRatio = progressRatio;
    }

    @NotNull
    protected final InstallContext getContext() {
        return this.context;
    }

    protected abstract Return perform(@NotNull ProgressIndicator var1, Argument var2) throws WizardException, InstallationCancelledException;

    public final Return execute(Argument argument) throws WizardException, InstallationCancelledException {
        Object object;
        this.context.checkCanceled();
        if (this.progressRatio == 0.0) {
            object = this.perform((ProgressIndicator)new EmptyProgressIndicator(), argument);
        } else {
            Object r;
            try {
                r = this.context.run(() -> InstallOperation.execute$lambda$0(this, argument), this.progressRatio);
            }
            catch (ProcessCanceledException e) {
                throw new InstallationCancelledException();
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, WizardException.class, InstallationCancelledException.class);
                throw new RuntimeException(e);
            }
            object = r;
        }
        return object;
    }

    protected final void promptToRetry(@NotNull String prompt, @NotNull String failureDescription, @Nullable Exception e) throws InstallationCancelledException {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)failureDescription, (String)"failureDescription");
        AtomicBoolean response2 = new AtomicBoolean(false);
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> InstallOperation.promptToRetry$lambda$1(prompt, failureDescription, response2), ModalityState.any());
        if (!response2.get()) {
            if (e != null) {
                Throwables.throwIfInstanceOf((Throwable)e, WizardException.class);
            }
            throw new InstallationCancelledException();
        }
        this.context.print(failureDescription + "\n", ConsoleViewContentType.ERROR_OUTPUT);
    }

    public abstract void cleanup(Return var1);

    @NotNull
    public final <FinalResult> InstallOperation<FinalResult, Argument> then(@NotNull InstallOperation<FinalResult, Return> next) {
        Intrinsics.checkNotNullParameter(next, (String)"next");
        return new OperationChain(this, next);
    }

    @NotNull
    public final <FinalResult> InstallOperation<FinalResult, Argument> then(@NotNull Function<Return, FinalResult> next) {
        Intrinsics.checkNotNullParameter(next, (String)"next");
        return this.then(Companion.wrap(this.context, next, 0.0));
    }

    private static final Object execute$lambda$0(InstallOperation this$0, Object $argument) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator indicator = progressIndicator;
        return this$0.perform(indicator, $argument);
    }

    private static final void promptToRetry$lambda$1(String $prompt, String $failureDescription, AtomicBoolean $response) {
        CharSequence charSequence = $prompt;
        Object object = new Regex("(\\p{Print}{30,50}([\\h\\n]|$))");
        String[] stringArray = "$1\n";
        String wrappedPrompt = object.replace(charSequence, (String)stringArray);
        object = $failureDescription;
        stringArray = new Regex("(\\p{Print}{30,50}([\\h\\n]|$))");
        String string = "$1\n";
        object = stringArray.replace((CharSequence)object, string);
        stringArray = new Regex("(\\p{Print}{30,50}/)");
        string = "$1\n";
        String wrappedFailure = stringArray.replace((CharSequence)object, string);
        stringArray = new String[]{"Retry", "Cancel"};
        int i = Messages.showDialog(null, (String)wrappedPrompt, (String)"Android Studio Setup", (String)wrappedFailure, (String[])stringArray, (int)0, (int)0, (Icon)Messages.getErrorIcon());
        $response.set(i == 0);
    }

    @JvmStatic
    @NotNull
    public static final <Return, Argument> InstallOperation<Return, Argument> wrap(@NotNull InstallContext context, @NotNull Function<Argument, Return> function, double progressShare) {
        return Companion.wrap(context, function, progressShare);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0002\u0010\u0006\"\u0004\b\u0003\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\u00060\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/welcome/install/InstallOperation$Companion;", "", "<init>", "()V", "wrap", "Lcom/android/tools/idea/welcome/install/InstallOperation;", "Return", "Argument", "context", "Lcom/android/tools/idea/welcome/install/InstallContext;", "function", "Lcom/google/common/base/Function;", "progressShare", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <Return, Argument> InstallOperation<Return, Argument> wrap(@NotNull InstallContext context, @NotNull Function<Argument, Return> function, double progressShare) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(function, (String)"function");
            return new FunctionWrapper<Return, Argument>(context, function, progressShare);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\f\u001a\u00028\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0014R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/welcome/install/InstallOperation$FunctionWrapper;", "Return", "Argument", "Lcom/android/tools/idea/welcome/install/InstallOperation;", "context", "Lcom/android/tools/idea/welcome/install/InstallContext;", "runnable", "Lcom/google/common/base/Function;", "progressShare", "", "<init>", "(Lcom/android/tools/idea/welcome/install/InstallContext;Lcom/google/common/base/Function;D)V", "perform", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "argument", "(Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/lang/Object;)Ljava/lang/Object;", "cleanup", "", "result", "(Ljava/lang/Object;)V", "intellij.android.core"})
    private static final class FunctionWrapper<Return, Argument>
    extends InstallOperation<Return, Argument> {
        @NotNull
        private final Function<Argument, Return> runnable;

        public FunctionWrapper(@NotNull InstallContext context, @NotNull Function<Argument, Return> runnable2, double progressShare) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(runnable2, (String)"runnable");
            super(context, progressShare);
            this.runnable = runnable2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Return perform(@NotNull ProgressIndicator indicator, Argument argument) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            indicator.start();
            try {
                Object object2 = this.runnable.apply(argument);
                Intrinsics.checkNotNull((Object)object2);
                object = object2;
            }
            finally {
                indicator.setFraction(1.0);
            }
            return (Return)object;
        }

        @Override
        public void cleanup(Return result2) {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u0002*\u0004\b\u0004\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B/\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00030\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00040\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\t\u001a\u00028\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/welcome/install/InstallOperation$OperationChain;", "FinalResult", "Argument", "Return", "Lcom/android/tools/idea/welcome/install/InstallOperation;", "first", "second", "<init>", "(Lcom/android/tools/idea/welcome/install/InstallOperation;Lcom/android/tools/idea/welcome/install/InstallOperation;)V", "perform", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "argument", "(Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/lang/Object;)Ljava/lang/Object;", "cleanup", "", "result", "(Ljava/lang/Object;)V", "intellij.android.core"})
    private static final class OperationChain<FinalResult, Argument, Return>
    extends InstallOperation<FinalResult, Argument> {
        @NotNull
        private final InstallOperation<Return, Argument> first;
        @NotNull
        private final InstallOperation<FinalResult, Return> second;

        public OperationChain(@NotNull InstallOperation<Return, Argument> first, @NotNull InstallOperation<FinalResult, Return> second) {
            Intrinsics.checkNotNullParameter(first, (String)"first");
            Intrinsics.checkNotNullParameter(second, (String)"second");
            super(first.getContext(), 0.0);
            this.first = first;
            this.second = second;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected FinalResult perform(@NotNull ProgressIndicator indicator, Argument argument) throws WizardException, InstallationCancelledException {
            FinalResult FinalResult;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Return firstResult = this.first.execute(argument);
            try {
                FinalResult = this.second.execute(firstResult);
            }
            finally {
                this.first.cleanup(firstResult);
            }
            return FinalResult;
        }

        @Override
        public void cleanup(FinalResult result2) {
            this.second.cleanup(result2);
        }
    }
}

