/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenshot;

import com.android.tools.idea.ui.screenshot.DisplayDeviceInfo;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/ui/screenshot/DumpsysDisplayDeviceInfoParser;", "", "<init>", "()V", "getActiveDisplays", "", "Lcom/android/tools/idea/ui/screenshot/DisplayDeviceInfo;", "dumpsysOutput", "", "intellij.android.adb.ui"})
@SourceDebugExtension(value={"SMAP\nDumpsysDisplayDeviceInfoParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpsysDisplayDeviceInfoParser.kt\ncom/android/tools/idea/ui/screenshot/DumpsysDisplayDeviceInfoParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class DumpsysDisplayDeviceInfoParser {
    @NotNull
    public static final DumpsysDisplayDeviceInfoParser INSTANCE = new DumpsysDisplayDeviceInfoParser();

    private DumpsysDisplayDeviceInfoParser() {
    }

    @NotNull
    public final List<DisplayDeviceInfo> getActiveDisplays(@NotNull String dumpsysOutput) {
        Intrinsics.checkNotNullParameter((Object)dumpsysOutput, (String)"dumpsysOutput");
        MatchResult match = Regex.find$default((Regex)new Regex("\\s+DisplayDeviceInfo\\{", RegexOption.MULTILINE), (CharSequence)dumpsysOutput, (int)0, (int)2, null);
        List result2 = new ArrayList();
        Regex stateOnRegex = new Regex("\\Wstate ON\\W");
        Regex logicalIdRegex = new Regex("\\WmCurrentLayerStack=(\\d+)");
        Regex physicalIdRegex = new Regex("\\WmPhysicalDisplayId=(\\d+)");
        Regex sizeRegex = new Regex("\\W(\\d+) x (\\d+)\\W");
        Regex orientationRegex = new Regex("\\WmCurrentOrientation=(\\d+)");
        Regex densityRegex = new Regex("\\Wdensity (\\d+)\\W");
        Regex isRoundRegex = new Regex("\\WFLAG_ROUND\\W");
        while (match != null) {
            CharSequence section;
            int endOffset;
            int startOffset = match.getRange().getFirst();
            int endOfMatch = match.getRange().getLast() + 1;
            MatchResult matchResult = match = match.next();
            int n = matchResult != null && (matchResult = matchResult.getRange()) != null ? matchResult.getFirst() : (endOffset = StringsKt.indexOf$default((CharSequence)dumpsysOutput, (String)"\n\n", (int)endOfMatch, (boolean)false, (int)4, null));
            if (endOffset < 0) {
                endOffset = dumpsysOutput.length();
            }
            if (!stateOnRegex.containsMatchIn(section = dumpsysOutput.subSequence(startOffset, endOffset))) continue;
            try {
                Dimension dimension2;
                Object object = Regex.find$default((Regex)logicalIdRegex, (CharSequence)section, (int)0, (int)2, null);
                if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
                    continue;
                }
                int logicalId = Integer.parseInt((String)object);
                Object object2 = Regex.find$default((Regex)physicalIdRegex, (CharSequence)section, (int)0, (int)2, null);
                if (object2 == null || (object2 = object2.getGroupValues()) == null || (object2 = (String)object2.get(1)) == null) {
                    continue;
                }
                long physicalId = Long.parseLong((String)object2);
                MatchResult matchResult2 = Regex.find$default((Regex)sizeRegex, (CharSequence)section, (int)0, (int)2, null);
                if (matchResult2 != null && (matchResult2 = matchResult2.getDestructured()) != null) {
                    MatchResult matchResult3 = matchResult2;
                    boolean bl = false;
                    String width = (String)matchResult3.getMatch().getGroupValues().get(1);
                    String height = (String)matchResult3.getMatch().getGroupValues().get(2);
                    dimension2 = new Dimension(Integer.parseInt(width), Integer.parseInt(height));
                } else {
                    dimension2 = new Dimension();
                }
                Dimension size = dimension2;
                Object object3 = Regex.find$default((Regex)orientationRegex, (CharSequence)section, (int)0, (int)2, null);
                int orientationQuadrants = object3 != null && (object3 = object3.getGroupValues()) != null && (object3 = (String)object3.get(1)) != null ? Integer.parseInt((String)object3) : 0;
                Object object4 = Regex.find$default((Regex)densityRegex, (CharSequence)section, (int)0, (int)2, null);
                int density = object4 != null && (object4 = object4.getGroupValues()) != null && (object4 = (String)object4.get(1)) != null ? Integer.parseInt((String)object4) : 0;
                boolean isRound = isRoundRegex.containsMatchIn(section);
                result2.add(new DisplayDeviceInfo(logicalId, physicalId, size, orientationQuadrants, density, isRound));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result2;
    }
}

