/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.BorderModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.FillModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.GradientModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.TransparentModel;
import java.awt.Color;
import java.awt.Shape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleModel
implements TransparentModel {
    @Nullable
    private FillModel myFillModel;
    @Nullable
    private BorderModel myBorderModel;
    private double myOpacity;

    public StyleModel(@Nullable FillModel fillModel, @Nullable BorderModel borderModel, double opacity) {
        this.myBorderModel = borderModel;
        this.myFillModel = fillModel;
        this.myOpacity = opacity;
    }

    @Nullable
    public FillModel getFill() {
        return this.myFillModel;
    }

    @Nullable
    public BorderModel getBorder() {
        return this.myBorderModel;
    }

    @Override
    public double getOpacity() {
        return this.myOpacity;
    }

    public void makeGradientRelative(@NotNull Shape shape) {
        GradientModel shapeGradient;
        GradientModel gradientModel = shapeGradient = this.myFillModel != null ? this.myFillModel.getGradientModel() : null;
        if (shapeGradient != null) {
            shapeGradient.toRelativeGradient(shape.getBounds2D());
        }
    }

    @Override
    public void applyOpacity(double parentOpacity) {
        this.myOpacity *= parentOpacity;
        if (this.myFillModel != null) {
            this.myFillModel.applyOpacity(this.myOpacity);
        }
        if (this.myBorderModel != null) {
            this.myBorderModel.applyOpacity(this.myOpacity);
        }
    }

    @NotNull
    protected static Color addAlphaToColor(@NotNull Color color, double opacity) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((double)color.getAlpha() * opacity));
    }
}

