/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.rendering;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.ui.resourcemanager.ResourceExplorerKt;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\u001a \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\u001a \u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u001a0\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002\u001a\"\u0010\u001e\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0000\u001a*\u0010\"\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0002\u001a,\u0010#\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00110%H\u0002\u001a\u001c\u0010&\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u001a\u0014\u0010'\u001a\u00020\u0001*\u00020(2\u0006\u0010)\u001a\u00020\u000eH\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020!X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"EMPTY_IMAGE", "Ljava/awt/image/BufferedImage;", "getEMPTY_IMAGE", "()Ljava/awt/image/BufferedImage;", "ERROR_IMAGE", "getERROR_IMAGE", "createIcon", "color", "Ljava/awt/Color;", "createFailedIcon", "dimension", "Ljava/awt/Dimension;", "createDrawablePlaceholderImage", "width", "", "height", "paintDrawablePlaceholderImage", "", "g", "Ljava/awt/Graphics2D;", "createLayoutPlaceholderImage", "LAYOUT_PH_BAR_BACKGROUND", "LAYOUT_PH_BAR_BACKGROUND_ALT", "LAYOUT_PH_BACKGROUND", "LAYOUT_PH_BORDER_COLOR", "LAYOUT_PH_FOREGROUND", "paintLayoutPlaceHolderImage", "paintFakeLayout", "x", "y", "createNavigationPlaceHolder", "layoutImage", "SIZE_TO_HEIGHT_CONSTANT", "", "paintNavigationPlaceHolder", "createImageAndPaint", "doPaint", "Lkotlin/Function1;", "scaleTo", "toScaledImage", "Ljavax/swing/Icon;", "size", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nResourceRenderingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceRenderingUtils.kt\ncom/android/tools/idea/ui/resourcemanager/rendering/ResourceRenderingUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n11158#2:249\n11493#2,3:250\n11158#2:253\n11493#2,3:254\n1#3:257\n*S KotlinDebug\n*F\n+ 1 ResourceRenderingUtils.kt\ncom/android/tools/idea/ui/resourcemanager/rendering/ResourceRenderingUtilsKt\n*L\n192#1:249\n192#1:250,3\n193#1:253\n193#1:254,3\n*E\n"})
public final class ResourceRenderingUtilsKt {
    @NotNull
    private static final BufferedImage EMPTY_IMAGE = ResourceRenderingUtilsKt.createIcon(ResourceExplorerKt.getRESOURCE_DEBUG() ? (Color)JBColor.GREEN : new Color(0, 0, 0, 0));
    @NotNull
    private static final BufferedImage ERROR_IMAGE = ResourceRenderingUtilsKt.createIcon(ResourceExplorerKt.getRESOURCE_DEBUG() ? (Color)JBColor.RED : new Color(10, 10, 10, 10));
    @NotNull
    private static final Color LAYOUT_PH_BAR_BACKGROUND = new Color(-1082097536, true);
    @NotNull
    private static final Color LAYOUT_PH_BAR_BACKGROUND_ALT = new Color(-1078676300, true);
    @NotNull
    private static final Color LAYOUT_PH_BACKGROUND = new Color(-1073741825, true);
    @NotNull
    private static final Color LAYOUT_PH_BORDER_COLOR = new Color(-1085255600, true);
    @NotNull
    private static final Color LAYOUT_PH_FOREGROUND = new Color(-1073741825, true);
    private static final float SIZE_TO_HEIGHT_CONSTANT = 0.866f;

    @NotNull
    public static final BufferedImage getEMPTY_IMAGE() {
        return EMPTY_IMAGE;
    }

    @NotNull
    public static final BufferedImage getERROR_IMAGE() {
        return ERROR_IMAGE;
    }

    @NotNull
    public static final BufferedImage createIcon(@Nullable Color color) {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = ImageUtil.createImage((int)80, (int)80, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"createImage(...)");
        BufferedImage $this$createIcon_u24lambda_u241 = bufferedImage = bufferedImage2;
        boolean bl = false;
        Graphics2D $this$createIcon_u24lambda_u241_u24lambda_u240 = $this$createIcon_u24lambda_u241.createGraphics();
        boolean bl2 = false;
        $this$createIcon_u24lambda_u241_u24lambda_u240.setColor(color);
        $this$createIcon_u24lambda_u241_u24lambda_u240.fillRect(0, 0, 80, 80);
        $this$createIcon_u24lambda_u241_u24lambda_u240.dispose();
        return bufferedImage;
    }

    @NotNull
    public static final BufferedImage createFailedIcon(@NotNull Dimension dimension2) {
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)dimension2, (String)"dimension");
        BufferedImage image = new BufferedImage(dimension2.width, dimension2.height, 2);
        JBLabel $this$createFailedIcon_u24lambda_u242 = jBLabel = new JBLabel("Failed preview", StudioIcons.Common.WARNING, 0);
        boolean bl = false;
        $this$createFailedIcon_u24lambda_u242.setVerticalTextPosition(3);
        $this$createFailedIcon_u24lambda_u242.setHorizontalTextPosition(0);
        $this$createFailedIcon_u24lambda_u242.setForeground(AdtUiUtils.DEFAULT_FONT_COLOR);
        $this$createFailedIcon_u24lambda_u242.setBounds(new Rectangle(0, 0, dimension2.width, dimension2.height));
        $this$createFailedIcon_u24lambda_u242.validate();
        JBLabel label2 = jBLabel;
        Graphics2D g = image.createGraphics();
        boolean bl2 = false;
        JBFont jBFont = JBUI.Fonts.label((float)10.0f);
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"label(...)");
        JBFont labelFont = jBFont;
        double stringWidth = labelFont.getStringBounds(label2.getText(), g.getFontRenderContext()).getWidth();
        int targetWidth = dimension2.width - JBUI.scale((int)4);
        float scale = Math.min((float)targetWidth / (float)stringWidth, 1.0f);
        label2.setFont((Font)labelFont.deriveFont(scale * (float)labelFont.getSize()));
        label2.paint((Graphics)g);
        g.dispose();
        return image;
    }

    @NotNull
    public static final BufferedImage createDrawablePlaceholderImage(int width, int height) {
        return ResourceRenderingUtilsKt.createImageAndPaint(width, height, (Function1<? super Graphics2D, Unit>)((Function1)arg_0 -> ResourceRenderingUtilsKt.createDrawablePlaceholderImage$lambda$4(width, height, arg_0)));
    }

    private static final void paintDrawablePlaceholderImage(Graphics2D g, int width, int height) {
        JBLabel jBLabel;
        JBLabel $this$paintDrawablePlaceholderImage_u24lambda_u245 = jBLabel = new JBLabel(StudioIcons.Shell.ToolWindows.VISUAL_ASSETS, 0);
        boolean bl = false;
        $this$paintDrawablePlaceholderImage_u24lambda_u245.setBounds(new Rectangle(0, 0, width, height));
        $this$paintDrawablePlaceholderImage_u24lambda_u245.validate();
        JBLabel label2 = jBLabel;
        label2.paint((Graphics)g);
    }

    @NotNull
    public static final BufferedImage createLayoutPlaceholderImage(int width, int height) {
        return ResourceRenderingUtilsKt.createImageAndPaint(width, height, (Function1<? super Graphics2D, Unit>)((Function1)arg_0 -> ResourceRenderingUtilsKt.createLayoutPlaceholderImage$lambda$6(width, height, arg_0)));
    }

    private static final void paintLayoutPlaceHolderImage(Graphics2D g, int width, int height) {
        float ratio = 0.75f;
        if (height < 10 || width < (int)((float)height * ratio)) {
            return;
        }
        int screenHeight = RangesKt.coerceAtLeast((int)10, (int)((int)((float)height * 0.9f)));
        int screenWidth = (int)((float)screenHeight * ratio);
        int screenX = (int)((float)width * 0.5f + 0.5f) - (int)((float)screenWidth * 0.5f + 0.5f);
        int screenY = (int)((float)height * 0.5f + 0.5f) - (int)((float)screenHeight * 0.5f + 0.5f);
        ResourceRenderingUtilsKt.paintFakeLayout(g, screenWidth, screenHeight, screenX, screenY);
    }

    private static final void paintFakeLayout(Graphics2D g, int width, int height, int x, int y) {
        int barHeight = (int)((float)width * 0.18f + 0.5f);
        int bottomBarY = height - barHeight + y;
        int bottomBarSegmentSize = (int)((float)width * 0.33f + 0.5f);
        int iconSize = (int)((float)barHeight * 0.6f + 0.5f);
        int iconXOffset = (int)((float)width * 0.04f + 0.5f);
        int iconY = (int)((float)barHeight * 0.2f + 0.5f) + y;
        Icon icon = StudioIcons.Common.BACK_ARROW;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BACK_ARROW");
        BufferedImage arrow = ResourceRenderingUtilsKt.toScaledImage(icon, iconSize);
        int arrowX = x + iconXOffset;
        Icon icon2 = StudioIcons.Common.OVERFLOW;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"OVERFLOW");
        BufferedImage overflow = ResourceRenderingUtilsKt.toScaledImage(icon2, iconSize);
        int overflowX = x + width - iconXOffset - iconSize;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(LAYOUT_PH_BACKGROUND);
        g.fillRect(x, y, width, height);
        g.setColor(LAYOUT_PH_BAR_BACKGROUND);
        g.fillRect(x, y, width, barHeight);
        g.setColor(LAYOUT_PH_FOREGROUND);
        g.drawImage(arrow, null, arrowX, iconY);
        g.drawImage(overflow, null, overflowX, iconY);
        g.setColor(LAYOUT_PH_BAR_BACKGROUND_ALT);
        g.fillRect(x, bottomBarY, width, barHeight);
        g.setColor(LAYOUT_PH_BAR_BACKGROUND);
        g.fillRect(x, bottomBarY, bottomBarSegmentSize, barHeight);
        g.fillRect(x + width - bottomBarSegmentSize, bottomBarY, bottomBarSegmentSize, barHeight);
        g.setColor(LAYOUT_PH_BORDER_COLOR);
        g.setStroke(new BasicStroke(JBUIScale.scale((float)2.0f)));
        g.drawRect(x, y, width, height);
    }

    @NotNull
    public static final BufferedImage createNavigationPlaceHolder(int width, int height, @Nullable BufferedImage layoutImage) {
        return ResourceRenderingUtilsKt.createImageAndPaint(width, height, (Function1<? super Graphics2D, Unit>)((Function1)arg_0 -> ResourceRenderingUtilsKt.createNavigationPlaceHolder$lambda$7(width, height, layoutImage, arg_0)));
    }

    private static final void paintNavigationPlaceHolder(Graphics2D g, int width, int height, BufferedImage layoutImage) {
        int p0;
        Object object;
        Integer[] $this$mapTo$iv$iv;
        float ratio = 0.75f;
        if (height < 10 || width < (int)((float)height * ratio)) {
            return;
        }
        Color arrowColor = new Color(-1085255600, true);
        int layoutHeight = RangesKt.coerceAtLeast((int)((int)((float)height * 0.8f)), (int)10);
        int layoutWidth = (int)((float)layoutHeight * ratio);
        int layoutX = (int)((float)width * 0.05f + 0.5f);
        int layoutY = (int)((float)height * 0.5f + 0.5f) - (int)((float)layoutHeight * 0.5f + 0.5f);
        BufferedImage bufferedImage = layoutImage;
        BufferedImage image = bufferedImage != null ? ResourceRenderingUtilsKt.scaleTo(bufferedImage, layoutWidth, layoutHeight) : null;
        int arrowMargin = (int)((float)width * 0.1f + 0.5f);
        int arrowSeparation = (int)((float)height * 0.18f + 0.5f);
        int arrowTipUnscaledSize = RangesKt.coerceAtLeast((int)((int)((float)arrowSeparation * 0.3f + 0.5f)), (int)6);
        int arrowTipHeight = (int)((float)arrowTipUnscaledSize * 0.866f + 0.5f);
        int arrow1LineStartY = layoutY + (int)((float)layoutHeight * 0.5f + 0.5f);
        int arrow1LineStartX = layoutX + layoutWidth;
        int arrowLineEndX = RangesKt.coerceAtMost((int)(width - JBUIScale.scale((int)arrowTipHeight)), (int)(arrow1LineStartX + (int)((float)layoutWidth * 0.6f + 0.2f)));
        int arrow2LineStartX = (int)((float)(arrow1LineStartX + arrowLineEndX) * 0.5f + 0.5f);
        int arrow2LineStartY = arrow1LineStartY + arrowSeparation;
        int arrowEndX = width - arrowMargin;
        int arrow1X = arrowLineEndX;
        int arrow1Y = arrow1LineStartY - (int)((float)JBUIScale.scale((int)arrowTipUnscaledSize) * 0.5f + 0.5f);
        int arrow2X = arrowLineEndX;
        int arrow2Y = arrow1Y + arrowSeparation;
        Integer[] integerArray = new Integer[]{0, arrowTipHeight, 0};
        Integer[] $this$map$iv = integerArray;
        boolean $i$f$map = false;
        Integer[] integerArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (Integer item$iv$iv : $this$mapTo$iv$iv) {
            int n = ((Number)item$iv$iv).intValue();
            object = destination$iv$iv;
            boolean bl = false;
            object.add(JBUIScale.scale((int)p0));
        }
        $this$map$iv = new Integer[]{0, (int)((float)arrowTipUnscaledSize * 0.5f + 0.5f), arrowTipUnscaledSize};
        object = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        for (Integer item$iv$iv : $this$mapTo$iv$iv) {
            p0 = ((Number)item$iv$iv).intValue();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(JBUIScale.scale((int)p0));
        }
        int n = 3;
        int[] nArray = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
        Object object2 = object;
        Polygon arrowPoly = new Polygon((int[])object2, nArray, n);
        float p02 = RangesKt.coerceAtLeast((int)((int)((float)arrowSeparation * 0.1f + 0.5f)), (int)2);
        boolean bl = false;
        float connectionStrokeSize = JBUIScale.scale((float)p02);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(arrowColor);
        g.setStroke(new BasicStroke(connectionStrokeSize, 0, 0));
        g.drawLine(arrow1LineStartX, arrow1LineStartY, arrowLineEndX, arrow1LineStartY);
        arrowPoly.translate(arrow1X, arrow1Y);
        g.fillPolygon(arrowPoly);
        arrowPoly.translate(-arrow1X, -arrow1Y);
        g.setStroke(new BasicStroke(connectionStrokeSize, 1, 0));
        g.drawLine(arrow2LineStartX, arrow1LineStartY, arrow2LineStartX, arrow2LineStartY);
        g.setStroke(new BasicStroke(connectionStrokeSize, 0, 0));
        g.drawLine(arrow2LineStartX, arrow2LineStartY, arrowLineEndX, arrow2LineStartY);
        arrowPoly.translate(arrow2X, arrow2Y);
        g.fillPolygon(arrowPoly);
        arrowPoly.translate(-arrow2X, -arrow2Y);
        if (image == null) {
            ResourceRenderingUtilsKt.paintFakeLayout(g, layoutWidth, layoutHeight, layoutX, layoutY);
        } else {
            g.drawImage(image, null, layoutX, layoutY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final BufferedImage createImageAndPaint(int width, int height, Function1<? super Graphics2D, Unit> doPaint) {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = ImageUtil.createImage((int)width, (int)height, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"createImage(...)");
        BufferedImage $this$createImageAndPaint_u24lambda_u2410 = bufferedImage = bufferedImage2;
        boolean bl = false;
        Graphics2D g = $this$createImageAndPaint_u24lambda_u2410.createGraphics();
        try {
            Intrinsics.checkNotNull((Object)g);
            doPaint.invoke((Object)g);
        }
        finally {
            g.dispose();
        }
        return bufferedImage;
    }

    private static final BufferedImage scaleTo(BufferedImage $this$scaleTo, int width, int height) {
        BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)ImageUtil.scaleImage((Image)$this$scaleTo, (int)width, (int)height));
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"toBufferedImage(...)");
        return bufferedImage;
    }

    private static final BufferedImage toScaledImage(Icon $this$toScaledImage, int size) {
        double scale = (double)size / (double)Math.max($this$toScaledImage.getIconWidth(), $this$toScaledImage.getIconHeight());
        BufferedImage bufferedImage = ImageUtils.scale((BufferedImage)ImageUtils.iconToImage((Icon)$this$toScaledImage), (double)scale);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"scale(...)");
        return bufferedImage;
    }

    private static final Unit createDrawablePlaceholderImage$lambda$4(int $width, int $height, Graphics2D it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ResourceRenderingUtilsKt.paintDrawablePlaceholderImage(it, $width, $height);
        return Unit.INSTANCE;
    }

    private static final Unit createLayoutPlaceholderImage$lambda$6(int $width, int $height, Graphics2D it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ResourceRenderingUtilsKt.paintLayoutPlaceHolderImage(it, $width, $height);
        return Unit.INSTANCE;
    }

    private static final Unit createNavigationPlaceHolder$lambda$7(int $width, int $height, BufferedImage $layoutImage, Graphics2D it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ResourceRenderingUtilsKt.paintNavigationPlaceHolder(it, $width, $height, $layoutImage);
        return Unit.INSTANCE;
    }
}

