/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.importer;

import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.tools.idea.ui.resourcemanager.importer.ImportersProvider;
import com.android.tools.idea.ui.resourcemanager.importer.ResourceImportManagerKt;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.model.ResourceAssetSet;
import com.android.tools.idea.ui.resourcemanager.plugin.ResourceImporter;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0006\u001a\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0005*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\b\u0012\u0004\u0012\u00020\b0\u0005\u001a4\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0004\u0012\u00020\u00100\u0014\u001a\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"PREFERENCE_LAST_SELECTED_DIRECTORY", "", "MAX_FILE_DEPTH", "", "getAllLeafFiles", "Lkotlin/sequences/Sequence;", "Ljava/io/File;", "toDesignAsset", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "importersProvider", "Lcom/android/tools/idea/ui/resourcemanager/importer/ImportersProvider;", "findAllDesignAssets", "groupIntoDesignAssetSet", "", "Lcom/android/tools/idea/ui/resourcemanager/model/ResourceAssetSet;", "chooseDesignAssets", "", "parent", "Ljavax/swing/JComponent;", "fileChosenCallback", "Lkotlin/Function1;", "createFileDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nResourceImportManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceImportManager.kt\ncom/android/tools/idea/ui/resourcemanager/importer/ResourceImportManagerKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,122:1\n992#2:123\n1021#2,3:124\n1024#2,3:134\n381#3,7:127\n126#4:137\n153#4,3:138\n*S KotlinDebug\n*F\n+ 1 ResourceImportManager.kt\ncom/android/tools/idea/ui/resourcemanager/importer/ResourceImportManagerKt\n*L\n79#1:123\n79#1:124,3\n79#1:134,3\n79#1:127,7\n80#1:137\n80#1:138,3\n*E\n"})
public final class ResourceImportManagerKt {
    @NotNull
    private static final String PREFERENCE_LAST_SELECTED_DIRECTORY = "resourceExplorer.lastChosenDirectory";
    private static final int MAX_FILE_DEPTH = 10;

    @NotNull
    public static final Sequence<File> getAllLeafFiles(@NotNull File $this$getAllLeafFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllLeafFiles, (String)"<this>");
        FileVisitOption[] fileVisitOptionArray = new FileVisitOption[]{FileVisitOption.FOLLOW_LINKS};
        Stream<Path> stream = Files.walk($this$getAllLeafFiles.toPath(), 10, fileVisitOptionArray);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"walk(...)");
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence(stream), ResourceImportManagerKt::getAllLeafFiles$lambda$0), ResourceImportManagerKt::getAllLeafFiles$lambda$1);
    }

    @NotNull
    public static final Sequence<DesignAsset> toDesignAsset(@NotNull Sequence<? extends File> $this$toDesignAsset, @NotNull ImportersProvider importersProvider) {
        Intrinsics.checkNotNullParameter($this$toDesignAsset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)importersProvider, (String)"importersProvider");
        return SequencesKt.mapNotNull($this$toDesignAsset, arg_0 -> ResourceImportManagerKt.toDesignAsset$lambda$2(importersProvider, arg_0));
    }

    @NotNull
    public static final Sequence<DesignAsset> findAllDesignAssets(@NotNull Sequence<? extends File> $this$findAllDesignAssets, @NotNull ImportersProvider importersProvider) {
        Intrinsics.checkNotNullParameter($this$findAllDesignAssets, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)importersProvider, (String)"importersProvider");
        return ResourceImportManagerKt.toDesignAsset((Sequence<? extends File>)SequencesKt.flatMap($this$findAllDesignAssets, (Function1)findAllDesignAssets.1.INSTANCE), importersProvider);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ResourceAssetSet> groupIntoDesignAssetSet(@NotNull Sequence<DesignAsset> $this$groupIntoDesignAssetSet) {
        void $this$mapTo$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$groupIntoDesignAssetSet, (String)"<this>");
        Sequence<DesignAsset> $this$groupBy$iv = $this$groupIntoDesignAssetSet;
        boolean $i$f$groupBy = false;
        Sequence<DesignAsset> sequence = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            DesignAsset it = (DesignAsset)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            String name2 = (String)entry.getKey();
            List assets = (List)entry.getValue();
            String string = FileResourceNameValidator.getValidResourceFileName((String)name2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValidResourceFileName(...)");
            object.add(new ResourceAssetSet(string, assets));
        }
        return (List)destination$iv$iv;
    }

    public static final void chooseDesignAssets(@NotNull ImportersProvider importersProvider, @Nullable JComponent parent, @NotNull Function1<? super Sequence<DesignAsset>, Unit> fileChosenCallback) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)importersProvider, (String)"importersProvider");
        Intrinsics.checkNotNullParameter(fileChosenCallback, (String)"fileChosenCallback");
        String string = PropertiesComponent.getInstance().getValue(PREFERENCE_LAST_SELECTED_DIRECTORY);
        if (string != null) {
            VirtualFile virtualFile2;
            String it = string;
            boolean bl = false;
            try {
                virtualFile2 = VfsUtil.findFile((Path)new File(it).toPath(), (boolean)true);
            }
            catch (InvalidPathException ex) {
                virtualFile2 = null;
            }
            virtualFile = virtualFile2;
        } else {
            virtualFile = null;
        }
        VirtualFile lastChosenDirFile = virtualFile;
        FileChooserDescriptor fileChooserDescriptor = ResourceImportManagerKt.createFileDescriptor(importersProvider);
        FileChooserFactory.getInstance().createPathChooser(fileChooserDescriptor, null, (Component)parent).choose(lastChosenDirFile, arg_0 -> ResourceImportManagerKt.chooseDesignAssets$lambda$8(arg_0 -> ResourceImportManagerKt.chooseDesignAssets$lambda$7(importersProvider, fileChosenCallback, arg_0), arg_0));
    }

    public static /* synthetic */ void chooseDesignAssets$default(ImportersProvider importersProvider, JComponent jComponent, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            jComponent = null;
        }
        ResourceImportManagerKt.chooseDesignAssets(importersProvider, jComponent, (Function1<? super Sequence<DesignAsset>, Unit>)function1);
    }

    private static final FileChooserDescriptor createFileDescriptor(ImportersProvider importersProvider) {
        Set<String> supportedFileTypes = importersProvider.getSupportedFileTypes();
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, true, false, false, false, true).withFileFilter(arg_0 -> ResourceImportManagerKt.createFileDescriptor$lambda$10(arg_0 -> ResourceImportManagerKt.createFileDescriptor$lambda$9(supportedFileTypes, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withFileFilter(...)");
        return fileChooserDescriptor;
    }

    private static final boolean getAllLeafFiles$lambda$0(Path file) {
        return Files.isRegularFile(file, new LinkOption[0]);
    }

    private static final File getAllLeafFiles$lambda$1(Path it) {
        return it.toFile();
    }

    private static final DesignAsset toDesignAsset$lambda$2(ImportersProvider $importersProvider, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ResourceImporter resourceImporter = (ResourceImporter)CollectionsKt.firstOrNull($importersProvider.getImportersForExtension(FilesKt.getExtension((File)it)));
        return resourceImporter != null ? resourceImporter.processFile(it) : null;
    }

    private static final File chooseDesignAssets$lambda$7$lambda$6(VirtualFile it) {
        Intrinsics.checkNotNull((Object)it);
        return FileExtensions.toIoFile(it);
    }

    private static final Unit chooseDesignAssets$lambda$7(ImportersProvider $importersProvider, Function1 $fileChosenCallback, List selectedFiles) {
        Intrinsics.checkNotNull((Object)selectedFiles);
        Sequence<DesignAsset> allDesignAssets = ResourceImportManagerKt.findAllDesignAssets((Sequence<? extends File>)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)selectedFiles), ResourceImportManagerKt::chooseDesignAssets$lambda$7$lambda$6), $importersProvider);
        $fileChosenCallback.invoke(allDesignAssets);
        VirtualFile virtualFile = (VirtualFile)CollectionsKt.firstOrNull((List)selectedFiles);
        PropertiesComponent.getInstance().setValue(PREFERENCE_LAST_SELECTED_DIRECTORY, virtualFile != null ? virtualFile.getPath() : null);
        return Unit.INSTANCE;
    }

    private static final void chooseDesignAssets$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean createFileDescriptor$lambda$9(Set $supportedFileTypes, VirtualFile it) {
        return CollectionsKt.contains((Iterable)$supportedFileTypes, (Object)it.getExtension());
    }

    private static final boolean createFileDescriptor$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

