/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.importer;

import com.android.tools.idea.ui.resourcemanager.ResourceManagerTracking;
import com.android.tools.idea.ui.resourcemanager.explorer.ImportResourceDelegate;
import com.android.tools.idea.ui.resourcemanager.importer.ImportersProvider;
import com.android.tools.idea.ui.resourcemanager.importer.ResourceImportDialog;
import com.android.tools.idea.ui.resourcemanager.importer.ResourceImportDragTargetKt;
import com.android.tools.idea.ui.resourcemanager.importer.ResourceImportManagerKt;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.util.SystemInfo;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0016\u0010\u001b\u001a\u00020\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/importer/ResourceImportDragTarget;", "Lcom/intellij/ide/dnd/DnDNativeTarget;", "Lcom/android/tools/idea/ui/resourcemanager/explorer/ImportResourceDelegate;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "importersProvider", "Lcom/android/tools/idea/ui/resourcemanager/importer/ImportersProvider;", "<init>", "(Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/tools/idea/ui/resourcemanager/importer/ImportersProvider;)V", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "setFacet", "(Lorg/jetbrains/android/facet/AndroidFacet;)V", "update", "", "event", "Lcom/intellij/ide/dnd/DnDEvent;", "drop", "", "doImport", "transferable", "Ljava/awt/datatransfer/Transferable;", "canImport", "fileListFlavorAvailable", "filesToImport", "Lkotlin/sequences/Sequence;", "Ljava/io/File;", "anyFileCanBeImported", "files", "hasImporterForFile", "file", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nResourceImportDragTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceImportDragTarget.kt\ncom/android/tools/idea/ui/resourcemanager/importer/ResourceImportDragTarget\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,93:1\n1251#2,2:94\n*S KotlinDebug\n*F\n+ 1 ResourceImportDragTarget.kt\ncom/android/tools/idea/ui/resourcemanager/importer/ResourceImportDragTarget\n*L\n73#1:94,2\n*E\n"})
public final class ResourceImportDragTarget
implements DnDNativeTarget,
ImportResourceDelegate {
    @NotNull
    private AndroidFacet facet;
    @NotNull
    private final ImportersProvider importersProvider;

    public ResourceImportDragTarget(@NotNull AndroidFacet facet, @NotNull ImportersProvider importersProvider) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)importersProvider, (String)"importersProvider");
        this.facet = facet;
        this.importersProvider = importersProvider;
    }

    @NotNull
    public final AndroidFacet getFacet() {
        return this.facet;
    }

    public final void setFacet(@NotNull AndroidFacet androidFacet) {
        Intrinsics.checkNotNullParameter((Object)androidFacet, (String)"<set-?>");
        this.facet = androidFacet;
    }

    public boolean update(@NotNull DnDEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.canImport(FileCopyPasteUtil.isFileListFlavorAvailable((DnDEvent)event), (Sequence<? extends File>)ResourceImportDragTargetKt.access$getFilesFromEvent(event))) {
            event.setDropPossible(true, "Import Files in project resources");
            return false;
        }
        return true;
    }

    public void drop(@NotNull DnDEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.drop((Sequence<? extends File>)ResourceImportDragTargetKt.access$getFilesFromEvent(event));
    }

    @Override
    public boolean doImport(@NotNull Transferable transferable) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        Sequence files2 = ResourceImportDragTargetKt.access$getFilesFromTransferable(transferable);
        boolean canBeImported = bl = this.canImport(FileCopyPasteUtil.isFileListFlavorAvailable((DataFlavor[])transferable.getTransferDataFlavors()), (Sequence<? extends File>)files2);
        boolean bl2 = false;
        if (canBeImported) {
            this.drop((Sequence<? extends File>)files2);
        }
        return bl;
    }

    private final boolean canImport(boolean fileListFlavorAvailable, Sequence<? extends File> filesToImport) {
        return fileListFlavorAvailable && (SystemInfo.isMac || this.anyFileCanBeImported(filesToImport));
    }

    private final boolean anyFileCanBeImported(Sequence<? extends File> files2) {
        boolean bl;
        block1: {
            Sequence<? extends File> $this$any$iv = files2;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                File file = (File)element$iv;
                boolean bl2 = false;
                if (!this.hasImporterForFile(file)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean hasImporterForFile(File file) {
        return !((Collection)this.importersProvider.getImportersForExtension(FilesKt.getExtension((File)file))).isEmpty();
    }

    private final void drop(Sequence<? extends File> files2) {
        Sequence<DesignAsset> assetSets = ResourceImportManagerKt.findAllDesignAssets(files2, this.importersProvider);
        ResourceManagerTracking.INSTANCE.logAssetAddedViaDnd(this.facet);
        new ResourceImportDialog(this.facet, assetSets).show();
    }
}

