/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.importer;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.ui.resourcemanager.importer.DesignAssetImporter;
import com.android.tools.idea.ui.resourcemanager.importer.DesignAssetImporterKt;
import com.android.tools.idea.ui.resourcemanager.importer.FileImportRowViewModel;
import com.android.tools.idea.ui.resourcemanager.importer.ImportersProvider;
import com.android.tools.idea.ui.resourcemanager.importer.ResourceImportManagerKt;
import com.android.tools.idea.ui.resourcemanager.importer.SummaryScreenViewModel;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.model.DesignAssetKt;
import com.android.tools.idea.ui.resourcemanager.model.ResourceAssetSet;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRendererManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0010\"\u0004\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u0014H\u0002J\u0018\u0010/\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u000101002\u0006\u00102\u001a\u00020\u0006J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0011J\u000e\u00106\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0006J&\u00107\u001a\u00020$2\u001e\u00108\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060:\u0012\u0004\u0012\u00020$09J&\u0010;\u001a\u00020$2\u001e\u00108\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060:\u0012\u0004\u0012\u00020$09JD\u0010<\u001a\u00020$2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u00110>2\u0006\u00105\u001a\u00020\u00112\u001e\u00108\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060:\u0012\u0004\u0012\u00020$09H\u0002J9\u0010?\u001a\u00020$2\u0006\u00105\u001a\u00020\u00112\u0006\u0010@\u001a\u0002042!\u0010A\u001a\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\bC\u0012\b\bD\u0012\u0004\b\b(E\u0012\u0004\u0012\u00020$0BJ\"\u0010F\u001a\u00020+2\u0006\u00102\u001a\u00020\u00062\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020$0BJ\u001c\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010@\u001a\u0002042\n\b\u0002\u0010J\u001a\u0004\u0018\u00010KJ\u0010\u0010L\u001a\u00020M2\u0006\u0010@\u001a\u000204H\u0002J\u001a\u0010N\u001a\n O*\u0004\u0018\u00010I0I2\b\u0010J\u001a\u0004\u0018\u00010KH\u0002J\u001a\u0010P\u001a\n O*\u0004\u0018\u00010I0I2\b\u0010J\u001a\u0004\u0018\u00010KH\u0002J\u0012\u0010Q\u001a\u00020M2\b\u0010@\u001a\u0004\u0018\u000104H\u0002J\b\u0010R\u001a\u0004\u0018\u00010IJ\u0006\u0010S\u001a\u00020$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R \u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020+0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/importer/ResourceImportDialogViewModel;", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "assets", "Lkotlin/sequences/Sequence;", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "designAssetImporter", "Lcom/android/tools/idea/ui/resourcemanager/importer/DesignAssetImporter;", "importersProvider", "Lcom/android/tools/idea/ui/resourcemanager/importer/ImportersProvider;", "<init>", "(Lorg/jetbrains/android/facet/AndroidFacet;Lkotlin/sequences/Sequence;Lcom/android/tools/idea/ui/resourcemanager/importer/DesignAssetImporter;Lcom/android/tools/idea/ui/resourcemanager/importer/ImportersProvider;)V", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "assetSetsToImport", "", "Lcom/android/tools/idea/ui/resourcemanager/model/ResourceAssetSet;", "toIdentitySet", "T", "", "assetSets", "getAssetSets", "()Ljava/util/Set;", "rendererManager", "Lcom/android/tools/idea/ui/resourcemanager/plugin/DesignAssetRendererManager;", "summaryScreenViewModel", "Lcom/android/tools/idea/ui/resourcemanager/importer/SummaryScreenViewModel;", "getSummaryScreenViewModel", "()Lcom/android/tools/idea/ui/resourcemanager/importer/SummaryScreenViewModel;", "fileCount", "", "getFileCount", "()I", "updateCallback", "Lkotlin/Function0;", "", "getUpdateCallback", "()Lkotlin/jvm/functions/Function0;", "setUpdateCallback", "(Lkotlin/jvm/functions/Function0;)V", "fileViewModels", "", "Lcom/android/tools/idea/ui/resourcemanager/importer/FileImportRowViewModel;", "resourceDuplicateValidator", "Lcom/android/tools/idea/res/IdeResourceNameValidator;", "resourceNameValidator", "getAssetPreview", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/Image;", "asset", "getItemNumberString", "", "assetSet", "removeAsset", "importMoreAssets", "assetAddedCallback", "Lkotlin/Function2;", "", "importMoreAssetIfEmpty", "addAssetSet", "existingAssets", "", "rename", "newName", "assetRenamedCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "newAssetSet", "createFileViewModel", "removeCallback", "validateName", "Lcom/intellij/openapi/ui/ValidationInfo;", "field", "Ljavax/swing/JTextField;", "hasDuplicate", "", "createDuplicateValidationInfo", "kotlin.jvm.PlatformType", "getSameNameIsImportedValidationInfo", "checkIfNameUnique", "getValidationInfo", "commit", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nResourceImportDialogViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceImportDialogViewModel.kt\ncom/android/tools/idea/ui/resourcemanager/importer/ResourceImportDialogViewModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n1#2:276\n230#3,2:277\n1202#3,2:279\n1230#3,4:281\n1557#3:285\n1628#3,3:286\n774#3:289\n865#3,2:290\n1755#3,3:292\n1863#3,2:295\n*S KotlinDebug\n*F\n+ 1 ResourceImportDialogViewModel.kt\ncom/android/tools/idea/ui/resourcemanager/importer/ResourceImportDialogViewModel\n*L\n116#1:277,2\n136#1:279,2\n136#1:281,4\n172#1:285\n172#1:286,3\n173#1:289\n173#1:290,2\n249#1:292,3\n141#1:295,2\n*E\n"})
public final class ResourceImportDialogViewModel {
    @NotNull
    private final AndroidFacet facet;
    @NotNull
    private final ImportersProvider importersProvider;
    @NotNull
    private final Set<ResourceAssetSet> assetSetsToImport;
    @NotNull
    private final DesignAssetRendererManager rendererManager;
    @NotNull
    private final SummaryScreenViewModel summaryScreenViewModel;
    @NotNull
    private Function0<Unit> updateCallback;
    @NotNull
    private final Map<DesignAsset, FileImportRowViewModel> fileViewModels;
    @NotNull
    private final IdeResourceNameValidator resourceDuplicateValidator;
    @NotNull
    private final IdeResourceNameValidator resourceNameValidator;

    public ResourceImportDialogViewModel(@NotNull AndroidFacet facet, @NotNull Sequence<DesignAsset> assets, @NotNull DesignAssetImporter designAssetImporter, @NotNull ImportersProvider importersProvider) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter(assets, (String)"assets");
        Intrinsics.checkNotNullParameter((Object)designAssetImporter, (String)"designAssetImporter");
        Intrinsics.checkNotNullParameter((Object)importersProvider, (String)"importersProvider");
        this.facet = facet;
        this.importersProvider = importersProvider;
        this.assetSetsToImport = this.toIdentitySet((Collection)ResourceImportManagerKt.groupIntoDesignAssetSet((Sequence<DesignAsset>)SequencesKt.take(assets, (int)400)));
        this.rendererManager = DesignAssetRendererManager.Companion.getInstance();
        this.summaryScreenViewModel = new SummaryScreenViewModel(designAssetImporter, this.rendererManager, this.facet, DesignAssetImporterKt.getSourceSetsResDirs(this.facet));
        this.updateCallback = ResourceImportDialogViewModel::updateCallback$lambda$1;
        this.fileViewModels = new LinkedHashMap();
        this.resourceDuplicateValidator = IdeResourceNameValidator.Companion.forFilename(ResourceFolderType.DRAWABLE, null, StudioResourceRepositoryManager.getAppResources(this.facet));
        this.resourceNameValidator = IdeResourceNameValidator.Companion.forFilename$default(IdeResourceNameValidator.Companion, ResourceFolderType.DRAWABLE, null, null, 4, null);
    }

    public /* synthetic */ ResourceImportDialogViewModel(AndroidFacet androidFacet, Sequence sequence, DesignAssetImporter designAssetImporter, ImportersProvider importersProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            designAssetImporter = new DesignAssetImporter();
        }
        if ((n & 8) != 0) {
            importersProvider = new ImportersProvider(null, 1, null);
        }
        this(androidFacet, (Sequence<DesignAsset>)sequence, designAssetImporter, importersProvider);
    }

    @NotNull
    public final AndroidFacet getFacet() {
        return this.facet;
    }

    private final <T> Set<T> toIdentitySet(Collection<? extends T> $this$toIdentitySet) {
        Set<T> result2 = Collections.newSetFromMap(new IdentityHashMap());
        for (T element : $this$toIdentitySet) {
            result2.add(element);
        }
        Intrinsics.checkNotNull(result2);
        return result2;
    }

    @NotNull
    public final Set<ResourceAssetSet> getAssetSets() {
        return this.assetSetsToImport;
    }

    @NotNull
    public final SummaryScreenViewModel getSummaryScreenViewModel() {
        return this.summaryScreenViewModel;
    }

    /*
     * WARNING - void declaration
     */
    public final int getFileCount() {
        Iterable iterable = this.getAssetSets();
        int n = 0;
        for (Object t : iterable) {
            void it;
            ResourceAssetSet resourceAssetSet = (ResourceAssetSet)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getAssets().size();
            n = n2 + n3;
        }
        return n;
    }

    @NotNull
    public final Function0<Unit> getUpdateCallback() {
        return this.updateCallback;
    }

    public final void setUpdateCallback(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.updateCallback = function0;
    }

    @NotNull
    public final CompletableFuture<? extends Image> getAssetPreview(@NotNull DesignAsset asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        DesignAssetRenderer designAssetRenderer = this.rendererManager.getViewer(asset.getFile());
        VirtualFile virtualFile = asset.getFile();
        Module module = this.facet.getModule();
        JBDimension jBDimension = JBUI.size((int)50);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(...)");
        return DesignAssetRenderer.getImage$default(designAssetRenderer, virtualFile, module, (Dimension)jBDimension, null, 8, null);
    }

    @NotNull
    public final String getItemNumberString(@NotNull ResourceAssetSet assetSet) {
        Intrinsics.checkNotNullParameter((Object)assetSet, (String)"assetSet");
        return "(" + assetSet.getAssets().size() + " " + StringUtil.pluralize((String)"item", (int)assetSet.getAssets().size()) + ")";
    }

    @NotNull
    public final ResourceAssetSet removeAsset(@NotNull DesignAsset asset) {
        Object element$iv2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
            Iterable $this$first$iv = this.assetSetsToImport;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                ResourceAssetSet it = (ResourceAssetSet)element$iv2;
                boolean bl = false;
                if (!it.getAssets().contains(asset)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        ResourceAssetSet designAssetSet = (ResourceAssetSet)element$iv2;
        designAssetSet.setAssets(CollectionsKt.minus((Iterable)designAssetSet.getAssets(), (Object)asset));
        if (designAssetSet.getAssets().isEmpty()) {
            this.assetSetsToImport.remove(designAssetSet);
        }
        this.updateCallback.invoke();
        return designAssetSet;
    }

    /*
     * WARNING - void declaration
     */
    public final void importMoreAssets(@NotNull Function2<? super ResourceAssetSet, ? super List<DesignAsset>, Unit> assetAddedCallback) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(assetAddedCallback, (String)"assetAddedCallback");
        Iterable $this$associateBy$iv = this.assetSetsToImport;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ResourceAssetSet resourceAssetSet = (ResourceAssetSet)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getName(), element$iv$iv);
        }
        Map assetByName = destination$iv$iv;
        ResourceImportManagerKt.chooseDesignAssets$default(this.importersProvider, null, arg_0 -> ResourceImportDialogViewModel.importMoreAssets$lambda$5(this, assetByName, assetAddedCallback, arg_0), 2, null);
    }

    public final void importMoreAssetIfEmpty(@NotNull Function2<? super ResourceAssetSet, ? super List<DesignAsset>, Unit> assetAddedCallback) {
        Intrinsics.checkNotNullParameter(assetAddedCallback, (String)"assetAddedCallback");
        if (this.getAssetSets().isEmpty()) {
            this.importMoreAssets(assetAddedCallback);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addAssetSet(Map<String, ResourceAssetSet> existingAssets, ResourceAssetSet assetSet, Function2<? super ResourceAssetSet, ? super List<DesignAsset>, Unit> assetAddedCallback) {
        ResourceAssetSet existingAssetSet = existingAssets.get(assetSet.getName());
        if (existingAssetSet != null) {
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = DesignAssetKt.getDesignAssets(existingAssetSet);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void designAsset;
                DesignAsset designAsset2 = (DesignAsset)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(designAsset.getFile().getPath());
            }
            Set existingPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$filter$iv = DesignAssetKt.getDesignAssets(assetSet);
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DesignAsset designAsset = (DesignAsset)element$iv$iv;
                boolean bl = false;
                if (!(!existingPaths.contains(designAsset.getFile().getPath()))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List onlyNewFiles = (List)destination$iv$iv2;
            if (!((Collection)onlyNewFiles).isEmpty()) {
                existingAssetSet.setAssets(CollectionsKt.plus((Collection)existingAssetSet.getAssets(), (Iterable)onlyNewFiles));
                assetAddedCallback.invoke((Object)existingAssetSet, (Object)onlyNewFiles);
                this.updateCallback.invoke();
            }
        } else {
            this.assetSetsToImport.add(assetSet);
            assetAddedCallback.invoke((Object)assetSet, DesignAssetKt.getDesignAssets(assetSet));
            this.updateCallback.invoke();
        }
    }

    public final void rename(@NotNull ResourceAssetSet assetSet, @NotNull String newName, @NotNull Function1<? super ResourceAssetSet, Unit> assetRenamedCallback) {
        Intrinsics.checkNotNullParameter((Object)assetSet, (String)"assetSet");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(assetRenamedCallback, (String)"assetRenamedCallback");
        if (!this.assetSetsToImport.contains(assetSet)) {
            boolean bl = false;
            String string = "The assetSet \"" + assetSet.getName() + "\" should already exist";
            throw new IllegalArgumentException(string.toString());
        }
        ResourceAssetSet renamedAssetSet = new ResourceAssetSet(newName, assetSet.getAssets());
        this.assetSetsToImport.remove(assetSet);
        this.assetSetsToImport.add(renamedAssetSet);
        assetRenamedCallback.invoke((Object)renamedAssetSet);
    }

    @NotNull
    public final FileImportRowViewModel createFileViewModel(@NotNull DesignAsset asset, @NotNull Function1<? super DesignAsset, Unit> removeCallback) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter(removeCallback, (String)"removeCallback");
        Function1 viewModelRemoveCallback = arg_0 -> ResourceImportDialogViewModel.createFileViewModel$lambda$9(removeCallback, asset, this, arg_0);
        FileImportRowViewModel fileImportRowViewModel = new FileImportRowViewModel(asset, ResourceFolderType.DRAWABLE, null, viewModelRemoveCallback, 4, null);
        this.fileViewModels.put(asset, fileImportRowViewModel);
        return fileImportRowViewModel;
    }

    @Nullable
    public final ValidationInfo validateName(@NotNull String newName, @Nullable JTextField field2) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        String errorText = this.resourceNameValidator.getErrorText(newName);
        if (errorText != null) {
            return new ValidationInfo(errorText, (JComponent)field2);
        }
        if (this.hasDuplicate(newName)) {
            return this.createDuplicateValidationInfo(field2);
        }
        if (this.checkIfNameUnique(newName)) {
            return this.getSameNameIsImportedValidationInfo(field2);
        }
        return null;
    }

    public static /* synthetic */ ValidationInfo validateName$default(ResourceImportDialogViewModel resourceImportDialogViewModel, String string, JTextField jTextField, int n, Object object) {
        if ((n & 2) != 0) {
            jTextField = null;
        }
        return resourceImportDialogViewModel.validateName(string, jTextField);
    }

    private final boolean hasDuplicate(String newName) {
        return this.resourceDuplicateValidator.doesResourceExist(newName);
    }

    private final ValidationInfo createDuplicateValidationInfo(JTextField field2) {
        return new ValidationInfo("A resource with this name already exists and might be overridden if the qualifiers are the same.", (JComponent)field2).asWarning();
    }

    private final ValidationInfo getSameNameIsImportedValidationInfo(JTextField field2) {
        return new ValidationInfo("A resource with the same name is also being imported.", (JComponent)field2).asWarning();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkIfNameUnique(String newName) {
        boolean bl;
        boolean nameSeen = false;
        Iterable $this$any$iv = this.assetSetsToImport;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            ResourceAssetSet it = (ResourceAssetSet)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it.getName(), (Object)newName)) {
                if (nameSeen) {
                    return true;
                }
                nameSeen = true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @Nullable
    public final ValidationInfo getValidationInfo() {
        return (ValidationInfo)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.assetSetsToImport), arg_0 -> ResourceImportDialogViewModel.getValidationInfo$lambda$12(this, arg_0)), ResourceImportDialogViewModel::getValidationInfo$lambda$13), ResourceImportDialogViewModel::getValidationInfo$lambda$14));
    }

    public final void commit() {
        this.summaryScreenViewModel.setAssetSetsToImport(this.assetSetsToImport);
    }

    private static final Unit updateCallback$lambda$1() {
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit importMoreAssets$lambda$5(ResourceImportDialogViewModel this$0, Map $assetByName, Function2 $assetAddedCallback, Sequence newAssetSets) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)newAssetSets, (String)"newAssetSets");
        Iterable iterable = ResourceImportManagerKt.groupIntoDesignAssetSet((Sequence<DesignAsset>)SequencesKt.take((Sequence)newAssetSets, (int)400));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceAssetSet it = (ResourceAssetSet)element$iv;
            boolean bl = false;
            this$0.addAssetSet($assetByName, it, (Function2<? super ResourceAssetSet, ? super List<DesignAsset>, Unit>)$assetAddedCallback);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createFileViewModel$lambda$9(Function1 $removeCallback, DesignAsset $asset, ResourceImportDialogViewModel this$0, DesignAsset it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $removeCallback.invoke((Object)$asset);
        this$0.fileViewModels.remove($asset);
        return Unit.INSTANCE;
    }

    private static final Pair getValidationInfo$lambda$12(ResourceImportDialogViewModel this$0, ResourceAssetSet asset) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        ValidationInfo validationInfo = ResourceImportDialogViewModel.validateName$default(this$0, asset.getName(), null, 2, null);
        if (validationInfo != null) {
            ValidationInfo validationInfo2 = validationInfo;
            boolean bl = false;
            pair = TuplesKt.to((Object)asset, (Object)validationInfo2);
        } else {
            pair = null;
        }
        return pair;
    }

    private static final boolean getValidationInfo$lambda$13(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        ValidationInfo info = (ValidationInfo)pair.component2();
        return !info.warning;
    }

    private static final ValidationInfo getValidationInfo$lambda$14(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ResourceAssetSet asset = (ResourceAssetSet)it.component1();
        ValidationInfo error = (ValidationInfo)it.component2();
        return new ValidationInfo(asset.getName() + ": " + error.message);
    }
}

